#!/bin/ksh
#
#	MKCMS.KSH
#	All Rights Reserved 1992,99 (C)
#

export PATH=".:$PATH:${CMSPATH}/bin"

MainDir=${CMSPATH}/siten
SourceDir=${CMSPATH}/src
DiffDir=${CMSPATH}/diff
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
Mrdir=${CMSPATH}/diff/mr
UserDir=${CMSPATH}/fusr
Version=${KEIVER}
Username=${CMS_USERNAME}

if [ x${Tabfile} = x"" -o x${SYSNAME} = x"" -o x${KEIVER} = x"" ]
then
	errmsg "CMS Environ for TABFILE SYSNAME KEIVER not found"
	exit
fi
BaseDir=`basename ${PWD}`
if [ x${BaseDir} != x${SYSNAME} ]
then
	errmsg "CMS のディレクトリがありません"
	exit
fi
if [ ! -f ${Tabfile} ]
then
	errmsg "CMS のテーブルファイルがカレントディレクトリに有りません"
	exit
fi

if [ ! -d ${Mrdir}/ver_${KEIVER}/${SYSNAME} ]
then
	mkdir2 ${Mrdir}/ver_${KEIVER}/${SYSNAME}
	echo >> ${Mrdir}/ver_${KEIVER}/${SYSNAME}/mrfiles
fi

if [ ! -d ${DiffDir}/lock/${SYSNAME} ]
then
	mkdir2 ${DiffDir}/lock/${SYSNAME}
fi
for i in `cat -s "${Tabfile}" | sed -f ${CMSPATH}/bin/suffixes.sed | sort -u`
do
	if [ ! -d ${DiffDir}/ver_${KEIVER}/${SYSNAME} ]
	then
		mkdir2 ${DiffDir}/ver_${KEIVER}/${SYSNAME}
	fi
	if [ ! -d ${DiffDir}/ver_${KEIVER}/${SYSNAME}/${i} ]
	then
		mkdir2 ${DiffDir}/ver_${KEIVER}/${SYSNAME}/${i}
	#	if [ ! -d ${MainDir}/${SYSNAME}/${i} ]
	#	then
	#		if [ ! -d ${MainDir}/${SYSNAME} ]
	#		then
	#			mkdir2 ${MainDir}/${SYSNAME}
	#		fi
	#		mkdir2 ${MainDir}/${SYSNAME}/${i}
	#	fi
	fi
done

#if [ ! -f ${UserDir}/${SYSNAME}/.profile ]
#then
#	cat ${DiffDir}/.profile | sed -e 's/XXX/${SYSNAME}/g' > ${UserDir}/${SYSNAME}/.profile
#	cp ${DiffDir}/.exrc ${UserDir}/${SYSNAME}
#fi

if [ ! -d ${DiffDir}/log ]
then
	mkdir ${DiffDir}/log
fi

for i in `cat -s "${Tabfile}" | sed -e 's/^..*\///' -e 's/\/$//' | sort -u`
do
	newfile.ksh ${i} ${Username} ${Version}
done

