#!/bin/ksh
#
#	TRCSVOUT.KSH
#	All Rights Reserved 1999 (C)
#
#    TRCSVOUT(21)        ソフトウェア故障記録のレポート
#    
#    
#    名前
#    
#    
#    使用法
#    
#    
#    概要
#    
#    
#    関連項目
#    
#
#
#	著作
#		 Shigeki Ono 1999/7/8
#

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
4) ;;
*) errmsg "$# Usage: trcsvout [ -a -s ] MR-number(00 - 99) user-name Version(1 - 9)"
exit ;;
esac

MainDir=${CMSPATH}
DiffDir=${CMSPATH}/diff
MrDir=${CMSPATH}/diff/mr
TrFile=tr
SysName=${SYSNAME}
EditCommand=${EDITOR}
CurentDir=`basename ${PWD}`

Opt=$1
MrNumber=$2
UserName=$3
Version=$4

case $Opt in
"-a"|"all") MrNumber="*" ;;
"-s") MrNumber=$2 ;;
no) ;;
esac

case $Opt in
"-s")
	grep -l "${MrNumber}" ${MrDir}/ver_${Version}/${SysName}/mrfiles > /dev/null
	if [ $? = 0 ]
	then
		for j in `sed -n -f ${DiffDir}/trcsv.sed ${MrDir}/ver_${Version}/${SysName}/${TrFile}.${MrNumber} | sed 's/^\[.*//' | sed '/^$/d'`
		do
			echo -e "${j},\c" >> ${MrDir}/ver_${Version}/${SysName}/${TrFile}_${MrNumber}.csv
		done
		echo >> ${MrDir}/ver_${Version}/${SysName}/${TrFile}_${MrNumber}.csv
		#sed -f ${MrDir}/ver_${Version}/${SysName}/${TrFile}.${MrNumber}
	else
		errmsg "${MrNumber} 番のMＲは見つかりません．"
		exit
	fi
	;;
"-a")
	for i in `cat ${MrDir}/ver_${Version}/${SysName}/mrfiles`
	do
		#pg ${MrDir}/ver_${Version}/${SysName}/${TrFile}.${i}
		for j in `sed -n -f ${DiffDir}/trcsv.sed ${MrDir}/ver_${Version}/${SysName}/${TrFile}.${i} | sed 's/^\[.*//' | sed '/^$/d'`
		do
			echo -e "${j},\c" >> ${MrDir}/ver_${Version}/${SysName}/${TrFile}_${MrNumber}.csv
		done
		echo >> ${MrDir}/ver_${Version}/${SysName}/${TrFile}_${i}.csv
	done
	#less ${MrDir}/ver_${Version}/${SysName}/${TrFile}.*
	;;
*) exit ;;
esac


