#pragma ident "@(#) cmsfiler.cc 1.3.2 2012.12.06,10:20"
/*

	All Rights Reserved Shigeki.Ono (C)2009
*/
#include "../../ftx/ftx.h"
#include "../../ftx/filer.h"
#include <sys/wait.h>

#define		BUFSIZE			256

#define ON 1
#define OFF 0
#define MAX_WINDOW 1

//以下のインスタンス名は本ライブラリで固定されている。
//ファイラーのためのリストボックスクラス
extern ListBox *pFilerListBox;
//ホスト、ユーザ、パスワードを管理するリストボックスクラス
extern ListBox *pListBox;
//FTPとの応答を記録するリストボックスクラス（詳細情報）
extern ListBox *ImmLog;
//FTPのLIST受信ファイルを読み取るクラス
extern OpenFileListBox *ftp;

//ASEのためのクラスと各フラグ
extern AseEditor *aseeditor;
extern int ConnectASE(int argc, char *argv[]);
extern int fulldisplay;
extern int readflg;
extern int nonopt;
extern int dbtitle;

static DIR *dir;

//ファイラーのためのクラス
CMSLocalFiler *cms;

//ウインドウ１と２のカラム位置
static int line1[] = {0,33,44,56,68,79,89};
//ウインドウ３と４のカラム位置
static int line2[] = {0,12,24,36,48,52,54,54,54,54};

static char helpbuff[22][128] =
	{" H  このヘルプを表示                i  ひとつ上へ",
	" v  ファイルを表示                   選択ファイル移動",
	" e  ファイルを編集                  C  画面の更新",
	"  SHIFT-JISに変換                  vi の実行",
	" x  実行ファイルを実行              @  CMS の起動",
	" p  ファイルをコピー                t  画面の先頭へ",
	"  選択ファイルコピー              g  最後尾に",
	" m  ディレクトリを作成              !  シェルモードに",
	" r  ディレクトリを削除              2  アクセス時刻表示",
	"^R  ファイルを削除                  9  作成年月表示",
	" c  ディレクトリを移動              0  作成時刻表示",
	"  移動ディレクトリ入力            1  メニュー表示切替",
	" F  UTF-8に変換                     u  半画面上に",
	" M  ファイル移動/名前変更           d  半画面下に",
	" 選択ファイルを削除             j  一行下に  k 一行上に",
	"  属性を変更                       tar -czf  T tar -xzf  =複数選択",
	"  cw を起動した場所に             ~  ブックマークの選択",
	"^H  $HOME に戻る                    ^ .ファイルの表示非表示",
	" -  以前に移動した場所に移動        \\ カレントツリーに変身",
	" +  以前に移動した場所から移動       ブックマーク位置を保存",
	" n  検索を開始。入力は '/' で       ~  ブックマークメニューを開く",
	" f  EUCに変換                       TAB ファイルを複数選択する"
	};

static char cmsmenu[22][128] = {
	"                               CMS for CF v1.0         ",
	"     'A' get.ksh (GETの実行)                           ",
	"     'B' put.ksh (PUTの実行)                           ",
	"     'C' putlog.ksh (PUT修正記録の編集)                ",
	"     'D' vget.ksh (リビジョンの呼び出し)               ",
	"     'E' mredit.ksh (ＭＲの編集)                       ",
	"     'F' mr.ksh (ＭＲの登録)                           ",
	"     'G' unget.ksh (GETの取り消し)                     ",
	"     'H' showget.ksh (GET履歴の表示)                   ",
	"     'I' showput.ksh (PUT履歴の表示)                   ",
	"     'J' MAKE file-name                                ",
	"     'K'                                               ",
	"     'L' tredit.ksh (ＴＲの編集)                       ",
	"     'M' tr.ksh (ＴＲの登録)                           ",
	"     'N' newfile.ksh (CMSへファイルの登録)             ",
	"     'O' tabedit.ksh (CMSテーブルファイルの編集)       ",
	"     'P' mrreport.ksh (ＭＲ記録のレポート)             ",
	"     'Q' rejectmr.ksh (ＭＲの削除)                     ",
	"     'R' reject.ksh (リビジョンの削除)                 ",
	"     'S' submit.ksh (SUBMITの実行)                     "};

 /*
 static char ehelpbuff[22][128] =
	{" H  Display this help               i  Go to Parent directory",
	" v  Display a file                   Choice file move",
	" e  Vi edit-file                    C  Refresh screen",
	" f  Convert into SHIFT-JIS           Edit a vi new-file",
	" x  Execute of file                 @  Enter the CMS",
	" p  File copy                       t  Go to top line",
	"  Copy of choice files            g  Go to bottom line",
	" m  Make directory                  !  Go to shell mode",
	" r  Remove directory                2  Update Time",
	"  Remove file                     9  Create date",
	" c  Change directory                0  Create time",
	"  Jump directory                  1  Change of the menubar",
	" F  Convert into UTF-8              u  Half screen up",
	" M  Move file(rename)               d  Half screen down",
	" Choice remove                  j  1 line down",
	"  Change attribute                k  1 line up",
	"  Back to start directory         ~  Choice to Bookmark",
	"  Back to $HOME directory         ^  Display to all file",
	" -  Previus directory               \\ Change to Tree-Filer",
	" +  Next directory                   Save of the curennt directory",
	" /  Find file or directory(and n)   TAB Plural choice",
	" f  Convert into EUC"
	};
	*/

/************************************************************************/
/* NAME      :void helpmsg()*/ 
/* FUNCTION  :ヘルプを表示する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
static void helpmsg(int x,int y)
{
	WINDOW *pvs;
	int ch;
	int i;
	pvs = newwin(23,78,y,x);

	wattron(pvs,A_REVERSE);
	box(pvs,ACS_VLINE,ACS_HLINE);
	mvwprintw(pvs,0,0,"+");
	mvwprintw(pvs,0,77,"+");
	mvwprintw(pvs,22,0,"+");
	mvwprintw(pvs,22,77,"+");

	noecho();
	for(i=0;i<22;i++)
	{
		mvwprintw(pvs,i+0,1,"%-78s"," ");
		mvwprintw(pvs,i+0,1,"%s",helpbuff[i]);
	}
	wattroff(pvs,A_REVERSE);
	wrefresh(pvs);
	wgetch(pvs);
	delwin(pvs);
}

static void helpmsg2(int x,int y)
{
	WINDOW *pvs;
	int ch;
	int i;
	pvs = newwin(23,78,y,x);

	wattron(pvs,A_REVERSE);
	box(pvs,ACS_VLINE,ACS_HLINE);
	mvwprintw(pvs,0,0,"+");
	mvwprintw(pvs,0,77,"+");
	mvwprintw(pvs,22,0,"+");
	mvwprintw(pvs,22,77,"+");

	noecho();
	for(i=0;i<22;i++)
	{
		mvwprintw(pvs,i+0,1,"%-78s"," ");
		mvwprintw(pvs,i+0,1,"%s",cmsmenu[i]);
	}
	wattroff(pvs,A_REVERSE);
	wrefresh(pvs);
	wgetch(pvs);
	delwin(pvs);
}

int LocalFiler::RemoveTmpDir(void)
{
	//FTPファイラー情報を保存したファイルを削除する。
	unlink(pFilerListBox->txtTmpDirListFile);
	//FTPファイラー情報を保存したディレクトリを削除する。
	rmdir(pFilerListBox->txtEditDir);
	endwin();
	return(0);
}

/************************************************************************/
/* NAME      :void displaymenuCMS()*/
/* FUNCTION  :キーメニューを表示する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void displaymenuCMS(WINDOW *evs,int flag)
{
	int i,j,k;

	mvwprintw(evs,0,1,"S +  get  put  putlog  vget  mr  unget  make  newfile  tabedit  reject  submit");
	wattron(evs,A_REVERSE);
	mvwprintw(evs,0,5,"%c",'A');
	mvwprintw(evs,0,10,"%c",'B');
	mvwprintw(evs,0,15,"%c",'C');
	mvwprintw(evs,0,23,"%c",'D');
	mvwprintw(evs,0,29,"%c",'F');
	mvwprintw(evs,0,33,"%c",'G');
	mvwprintw(evs,0,40,"%c",'J');
	mvwprintw(evs,0,46,"%c",'N');
	mvwprintw(evs,0,55,"%c",'O');
	mvwprintw(evs,0,64,"%c",'R');
	mvwprintw(evs,0,72,"%c",'S');
	wrefresh(evs);
	werase(evs);
	wattroff(evs,A_REVERSE);
}

void LocalFiler::FTPConnect(void)
{
	u_int intServerReplyCode;
	char *strCommand;
	char *result;
	int intResultLocation;
	
	int ret;

	//ファイラー階層初期化のためのクラス
	pFilerListBox = new ListBox();

	//FTPファイラーの情報（LIST -aL）を保存するディレクトリを設定
	pFilerListBox->setTmpDir();

	//ホスト接続用リストボックス作成
	pListBox = new ListBox();

	pListBox->height = 5;
	pListBox->width = 90;
	pListBox->sx = 0;
	pListBox->sy = 4;
	sprintf(pListBox->title,"%s","Hostname");

	pListBox->line = 0;
	pListBox->cursol = 0;

	//接続情報監視のためのリストボックス作成（詳細情報）
	ImmLog = new ListBox();

	ImmLog->height = 5;
	ImmLog->width = 90;
	ImmLog->sx = 0;
	ImmLog->sy = 4;
	ImmLog->line = -1;
	ImmLog->cursol = -1;

	//FTPファイラーのためのリストボックス作成
	ftp = new OpenFileListBox();

	ftp->height = LINES-10;
	ftp->width = 90;
	ftp->sx = 0;
	ftp->sy = 9;

	while((pListBox->popmsg(1,0,"ホストコンピュータと接続を開始します")))
	{
		pListBox->Clear();
		// /home/cms/etc/hosts.ftx ファイルよりホスト設定情報を読み取る。
		pFilerListBox->readHostSetFile();
		//リストボックスで選択した結果はホスト名とユーザID
		result = pListBox->Listbox();
        //結果がNULLの場合は終了する。Listbox()で'q'で終了の場合。2010.03.29追加
		if(!result)
			return;
		// : で区切られた結果からホスト名だけを抜き取る。
		intResultLocation = pFilerListBox->InStr(1,result,':');
		sprintf(pFilerListBox->txtHostName,"%s",pFilerListBox->Left(result,intResultLocation));
		//FTP接続経過情報リストボックスのタイトルにホスト名を入れる。
		sprintf(ImmLog->title,"%s",pFilerListBox->txtHostName);
		if (strlen(pFilerListBox->txtHostName) == 0)
		{
			pListBox->MsgBox("ホストコンピュータ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		//残りのホスト情報（userID,Password,HomeDir,LISTコマンド,転送イメージ、Active/Passiveモード,サーバ切断時間）をリストボックスクラスのメンバ変数に保存する。
		sprintf(pFilerListBox->txtUserID,"%s",pFilerListBox->pf[pListBox->index].userid);
		sprintf(pFilerListBox->txtPassword,"%s",pFilerListBox->pf[pListBox->index].passwd);
		sprintf(pFilerListBox->txtHomeDir,"%s",pFilerListBox->pf[pListBox->index].homedir);
		sprintf(pFilerListBox->txtOPTL,"%s",pFilerListBox->pf[pListBox->index].OPTL);
		pFilerListBox->intTYPE = pFilerListBox->pf[pListBox->index].TYPE;
		pFilerListBox->intPASV = pFilerListBox->pf[pListBox->index].PASV;
		pFilerListBox->intWAIT = pFilerListBox->pf[pListBox->index].WAIT;
		sprintf(pFilerListBox->txtEditor,"%s",pFilerListBox->pf[pListBox->index].editor);
		sprintf(pFilerListBox->txtViewer,"%s",pFilerListBox->pf[pListBox->index].viewer);
		sprintf(pFilerListBox->txtBrowser,"%s",pFilerListBox->pf[pListBox->index].browser);


		if (strlen(pFilerListBox->txtUserID) == 0)
		{
			pListBox->MsgBox("ログオンユーザ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtPassword) == 0)
		{
			pListBox->MsgBox("パスワードの入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtHomeDir) == 0)
		{
			pListBox->MsgBox("初期ディレクトリの入力がありません");
			RemoveTmpDir();
			return;
		}
		//ホストへ最初の接続
		pFilerListBox->intDoFirstConnect();

		//ファイラーリストボックスの初期化（ディレクトリの階層化情報）
		pFilerListBox->InitCursol(0);
		pFilerListBox->deep = 0;

		//FTPファイラーを実行する。
		pFilerListBox->ftx();
	}

	//FTPファイラー情報を保存したファイルを削除する。
	unlink(pFilerListBox->txtTmpDirListFile);
	//FTPファイラー情報を保存したディレクトリを削除する。
	rmdir(pFilerListBox->txtEditDir);

	//全てのメモリを開放する。
	delete pFilerListBox;
	delete pListBox;
	delete ImmLog;

	//終了する。
	return;
}

void LocalFiler::FTPSelect(void)
{
	u_int intServerReplyCode;
	char *strCommand;
	char *result;
	int intResultLocation;
	
	int ret;

	while((pListBox->popmsg(1,0,"ホストコンピュータと接続を開始します")))
	{
		pListBox->Clear();
		// /home/cms/etc/hosts.ftx ファイルよりホスト設定情報を読み取る。
		pFilerListBox->readHostSetFile();
		//リストボックスで選択した結果はホスト名とユーザID
		result = pListBox->Listbox();
		// : で区切られた結果からホスト名だけを抜き取る。
		intResultLocation = pFilerListBox->InStr(1,result,':');
		sprintf(pFilerListBox->txtHostName,"%s",pFilerListBox->Left(result,intResultLocation));
		//FTP接続経過情報リストボックスのタイトルにホスト名を入れる。
		sprintf(ImmLog->title,"%s",pFilerListBox->txtHostName);
		if (strlen(pFilerListBox->txtHostName) == 0)
		{
			pListBox->MsgBox("ホストコンピュータ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		//残りのホスト情報（userID,Password,HomeDir）をリストボックスクラスのメンバ変数に保存する。
		sprintf(pFilerListBox->txtUserID,"%s",pFilerListBox->pf[pListBox->index].userid);
		sprintf(pFilerListBox->txtPassword,"%s",pFilerListBox->pf[pListBox->index].passwd);
		sprintf(pFilerListBox->txtHomeDir,"%s",pFilerListBox->pf[pListBox->index].homedir);
		sprintf(pFilerListBox->txtOPTL,"%s",pFilerListBox->pf[pListBox->index].OPTL);
		pFilerListBox->intTYPE = pFilerListBox->pf[pListBox->index].TYPE;
		pFilerListBox->intPASV = pFilerListBox->pf[pListBox->index].PASV;
		pFilerListBox->intWAIT = pFilerListBox->pf[pListBox->index].WAIT;

		if (strlen(pFilerListBox->txtUserID) == 0)
		{
			pListBox->MsgBox("ログオンユーザ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtPassword) == 0)
		{
			pListBox->MsgBox("パスワードの入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtHomeDir) == 0)
		{
			pListBox->MsgBox("初期ディレクトリの入力がありません");
			RemoveTmpDir();
			return;
		}
		//ホストへ最初の接続
		pFilerListBox->intDoFirstConnect();

		//ファイラーリストボックスの初期化（ディレクトリの階層化情報）
		pFilerListBox->InitCursol(0);
		pFilerListBox->deep = 0;

		//FTPファイラーを実行する。
		pFilerListBox->ftx();
	}

	//FTPファイラー情報を保存したファイルを削除する。
	unlink(pFilerListBox->txtTmpDirListFile);
	//FTPファイラー情報を保存したディレクトリを削除する。
	rmdir(pFilerListBox->txtEditDir);

	//全てのメモリを開放する。
	delete pFilerListBox;
	delete pListBox;
	delete ImmLog;
	delete ftp;

	//終了する。
	return;
}

char *CMSLocalFiler::popmenu2(int x,int y,const std::string Message,int xwidth,int ylen)
{
	WINDOW *pvs;
	int ch;
	int item = 1;
	int x2;
	int i;
	int j = 0;
	char rbuff[64];
	int yy = 0;
	char *rp;

	pvs = newwin(ylen,xwidth,y,x);
	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');
	mvwprintw(pvs,0,0,"- %s -",Message.c_str());
	wattroff(pvs,A_REVERSE);
	for(;;)
	{
		for(i=0;i<10;i++)
		{
			mvwprintw(pvs,i+1,1,"                      ");
			mvwprintw(pvs,i+1,1,"%s",list[i+yy]);
		}
		wmove(pvs,j+1,2);
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,j+1,1,"%s",list[j+yy]);
		wattroff(pvs,A_REVERSE);

		wrefresh(pvs);
		ch = wgetch(pvs);
		getyx(pvs,item,x2);

		switch(ch)
		{
		case 'j': case 0x42:
			if (j+yy >= N)
				break;
			if(j > ylen - 4)
			{
				yy++;
				break;
			}
			if(j <= ylen - 4)
			{
				j++;
			}
			break;
		case 'k': case 0x41:
            if(j == 0 &&  yy > 0)
            {
                yy--;
                break;
            }
			if(j > 0)
				j--;
			if(j < 1)
				j = 0;
			break;
		case 't': case 'T':
			j =0;
			yy = 0;
			break;
		case 'g': case 'G':
			if(N < ylen)
			{
				j = N;
				break;
			}
			if(j + yy > N)
				break;
			j = ylen - 3;
			yy = (N - ylen)+3;
			break;

		case 0x0d: case 0x0a: case 'Z':
			delwin(pvs);
			sprintf(rbuff,"%s",list[j+yy]);
			rp = rbuff;
			return (rp);

		case 'q':
			delwin(pvs);
			return ((char *)"");

		defualt:
			break;
		}
	}
}


char *CMSLocalFiler::popmenu3(int x,int y,const std::string Message,int xwidth,int ylen)
{
	WINDOW *pvs;
	int ch;
	int item = 1;
	int x2;
	int i;
	int j = 0;
	char rbuff[64];
	int yy = 0;
	char *rp;

	pvs = newwin(ylen,xwidth,y,x);
	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');
	mvwprintw(pvs,0,1,"%s",Message.c_str());
	wattroff(pvs,A_REVERSE);
	for(;;)
	{
		for(i=0;i<10;i++)
		{
			mvwprintw(pvs,i+1,1,"  ");
			mvwprintw(pvs,i+1,1,"%s",list2[i+yy]);
		}

		wmove(pvs,j+1,2);
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,j+1,1,"%s",list2[j+yy]);
		wattroff(pvs,A_REVERSE);

		wrefresh(pvs);
		ch = wgetch(pvs);
		getyx(pvs,item,x2);

		switch(ch)
		{
		case ' ':
			if(j <=ylen)
				j++;
			else
				j = 0;
			break;
		case 'j': case 0x42:
			if (j+yy >= N2)
				break;
			if(j > ylen - 4)
			{
				yy++;
				break;
			}
			if(j <= ylen - 4)
			{
				j++;
			}
			break;
		case 'k': case 0x41:
            if(j == 0 &&  yy > 0)
            {
                yy--;
                break;
            }
			if(j > 0)
				j--;
			if(j < 1)
				j = 0;
			break;
		case 't': case 'T':
			j =0;
			yy = 0;
			break;
		case 'g': case 'G':
			if(N2 < ylen)
			{
				j = N2;
				break;
			}
			if(j + yy > N2)
				break;
			j = ylen - 3;
			yy = (N2 - ylen)+3;
			break;

		case 0x0d: case 0x0a: case 'Z':
			delwin(pvs);
			sprintf(rbuff,"%s",list2[j+yy]);
			rp = rbuff;
			return (rp);

		case 'q':
			delwin(pvs);
			return ((char *)"");

		defualt:
			break;
		}
	}
}

char *CMSLocalFiler::popmenu4(int x,int y,const std::string Message,int xwidth,int ylen)
{
	WINDOW *pvs;
	int ch;
	int item = 1;
	int x2;
	int i;
	int j = 0;
	char rbuff[64];
	int yy = 0;
	char *rp;

	pvs = newwin(ylen,xwidth,y,x);
	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');
	mvwprintw(pvs,0,1,"%s",Message.c_str());
	wattroff(pvs,A_REVERSE);
	for(;;)
	{
		for(i=0;i<20;i++)
		{
			mvwprintw(pvs,i+1,1,"  ");
			mvwprintw(pvs,i+1,1,"%s",mrlist[i+yy]);
		}

		wmove(pvs,j+1,2);
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,j+1,1,"%s",mrlist[j+yy]);
		wattroff(pvs,A_REVERSE);

		wrefresh(pvs);
		ch = wgetch(pvs);
		getyx(pvs,item,x2);

		switch(ch)
		{
		case ' ':
			if(j <=ylen)
				j++;
			else
				j = 0;
		case 'j': case 0x42:
			if(j > ylen - 4)
			{
				yy++;
				break;
			}
			if(j <= ylen - 4)
			{
				j++;
			}
			break;
		case 'k': case 0x41:
            if(j == 0 &&  yy > 0)
            {
                yy--;
                break;
            }
			if(j > 0)
				j--;
			if(j < 1)
				j = 0;
			break;
		case 't': case 'T':
			j =0;
			yy = 0;
			break;
		case 'g': case 'G':
			if(N < ylen)
			{
				j = N;
				break;
			}
			if(j + yy > N)
				break;
			j = ylen - 3;
			yy = (N - ylen)+3;
			break;

		case 0x0d: case 0x0a: case 'Z':
			delwin(pvs);
			sprintf(rbuff,"%s",mrlist[j+yy]);
			rp =rbuff;
			return (rp);

		case 'q':
			delwin(pvs);
			return ((char *)"");

		defualt:
			break;
		}
	}
}
 
char *CMSLocalFiler::popmenu5(int x,int y,const std::string Message,int xwidth,int ylen)
{
	WINDOW *pvs;
	int ch;
	int item = 1;
	int x2;
	int i;
	int j = 0;
	char rbuff[64];
	int yy = 0;
	char *rp;

	pvs = newwin(ylen,xwidth,y,x);
	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');
	mvwprintw(pvs,0,1,"%s",Message.c_str());
	wattroff(pvs,A_REVERSE);
	for(;;)
	{
		for(i=0;i<20;i++)
		{
			mvwprintw(pvs,i+1,1,"  ");
			mvwprintw(pvs,i+1,1,"%s",mrlist2[i+yy]);
		}

		wmove(pvs,j+1,2);
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,j+1,1,"%s",mrlist2[j+yy]);
		wattroff(pvs,A_REVERSE);

		wrefresh(pvs);
		ch = wgetch(pvs);
		getyx(pvs,item,x2);

		switch(ch)
		{
		case ' ':
			if(j <=ylen)
				j++;
			else
				j = 0;
		case 'j': case 0x42:
			if (j+yy >= M2)
				break;
			if(j > ylen - 4)
			{
				yy++;
				break;
			}
			if(j <= ylen - 4)
			{
				j++;
			}
			break;
		case 'k': case 0x41:
            if(j == 0 &&  yy > 0)
            {
                yy--;
                break;
            }
			if(j > 0)
				j--;
			if(j < 1)
				j = 0;
			break;
		case 't': case 'T':
			j =0;
			yy = 0;
			break;
		case 'g': case 'G':
			if(M2< ylen)
			{
				j = M2;
				break;
			}
			if(j + yy > M2)
				break;
			j = ylen - 3;
			yy = (M2 - ylen)+3;
			break;

		case 0x0d: case 0x0a: case 'Z':
			delwin(pvs);
			sprintf(rbuff,"%s",mrlist2[j+yy]);
			rp = rbuff;
			return (rp);

		case 'q':
			delwin(pvs);
			return ((char *)"");

		defualt:
			break;
		}
	}
}


/************************************************************************/
/* NAME      :int input_window3()*/ 
/* FUNCTION  :ユーザに入力を促すポップアップウインドウを表示する*/ 
/*            */ 
/*int x;	表示桁位置*/
/*int y;	表示行位置*/
/*char *buff;	入力する文字*/
/*char *msg;	表示するメッセージ*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void CMSLocalFiler::input_window3(int x,int y,char *buff,const std::string Message)
{
	WINDOW *mvs;

	mvs = newwin(4,32,y,x);
	wattroff(mvs,A_REVERSE);
	box(mvs,ACS_VLINE,ACS_HLINE);
	mvwprintw(mvs,3,0,"+");
	mvwprintw(mvs,3,31,"+");
	mvwprintw(mvs,1,4,Message.c_str());
	wattron(mvs,A_REVERSE);
	mvwprintw(mvs,0,0,"         Input  Window3        ");

	mvwprintw(mvs,2,14,"   ");
	wrefresh(mvs);

	mvwprintw(mvs,2,14,"    ");
	echo();
	nocbreak();
	nl();

	mvwgetstr(mvs,2,14,buff);

	noecho();
	cbreak();

	wrefresh(mvs);

	wattroff(mvs,A_REVERSE);
	noecho();
	delwin(mvs);
}

void CMSLocalFiler::errmsg(char *buff)
{
	int i;
	int ch;
	WINDOW *pvs;

	if(strlen(buff) < (size_t)1)
		sprintf(buff,"何かキーに触って下さい");

	echo();

	pvs = newwin(5,64,LINES/2,8);
	box(pvs,ACS_VLINE,ACS_HLINE);

	wattron(pvs,A_REVERSE);
	mvwprintw(pvs,0,1,"----------------------CMS-ERROR-MESSAGE-----------------------");
	wattroff(pvs,A_REVERSE);
	mvwprintw(pvs,0,0,"+");
	mvwprintw(pvs,0,63,"+");
	mvwprintw(pvs,4,0,"+");
	mvwprintw(pvs,4,63,"+");

	mvwprintw(pvs,2,4,"%s",buff);
	wrefresh(pvs);
	wgetch(pvs);
	box(pvs,' ',' ');
	wclear(pvs);
	wrefresh(pvs);
	delwin(pvs);
}


/************************************************************************/
/* NAME      :int popmsg()*/ 
/* FUNCTION  :ユーザに選択を促すポップアップウインドウを表示する*/ 
/*            未使用*/ 
/*            */ 
/*            */ 
/* RETURN    :１　Ｙｅｓ　０　Ｎｏ*/
/************************************************************************/
int CMSLocalFiler::popmsg(int x,int y,const std::string Message)
{
	WINDOW *pvs;
	int i;
	int ch;
	pvs = newwin(6,40,y,x);
	box(pvs,ACS_VLINE,ACS_HLINE);
	noecho();
	for(;;)
	{
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,0,1,"----------CMS Pop Up Message----------");
		wattroff(pvs,A_REVERSE);
		mvwprintw(pvs,0,0,"+");
		mvwprintw(pvs,0,39,"+");
		mvwprintw(pvs,5,0,"+");
		mvwprintw(pvs,5,39,"+");

		mvwprintw(pvs,2,4,"[%s]",Message.c_str());
		mvwprintw(pvs,4,27,"Y or N :");
		wrefresh(pvs);
		ch = wgetch(pvs);
		switch(ch)
		{
		case 'y': case 'Y':
			delwin(pvs);
			return(1);
		case 'n': case 'N':
			delwin(pvs);
			return(0);
		}
	}
}

void CMSLocalFiler::update_revision(void)
{
	int i;

	for (i=0;i < 100;i++)
	{
		memset(list2[i],'\0',12);
	}
}

void CMSLocalFiler::update_mr(void)
{
	int i;

	for (i=0;i < 1000;i++)
	{
		memset(mrlist2[i],'\0',12);
	}
}

void CMSLocalFiler::cleanbuff(void)
{
	int i;

	memset(filename2,'\0',sizeof(filename2));

	memset(systembuff,'\0',sizeof(systembuff));
	memset(revisionbuff,'\0',sizeof(revisionbuff));
	memset(mr_revisionfile,'\0',sizeof(mr_revisionfile));
	memset(mr_editfile,'\0',sizeof(mr_editfile));
	memset(tr_revisionfile,'\0',sizeof(tr_revisionfile));
	memset(tr_editfile,'\0',sizeof(tr_editfile));
}


void CMSLocalFiler::tabopen(void)
{
	FILE *fp;
	char *newline;
	char buff[64];
	int n;

	if ((fp = fopen(filebuff, "r")) == NULL)
	{
		errmsg((char *)"table-file(tabfile) open error");
		return;
	}
	tabclean();
	n = 0;
	while((fgets(buff, 64, fp)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			sprintf(list[n],"%s",buff);
			n++;
		}
	}
	N = n - 1;
	fclose(fp);
}

void CMSLocalFiler::envset(void)
{
	char *envbuff;
	char envbuff2[64];

	if ((envbuff = getenv("CMS_VERSION")) == (char *)NULL)
		strcpy(version, "0");
	else
		strcpy(version, envbuff);

	if ((envbuff = getenv("CMSPATH")) == (char *)NULL)
	{
		strcpy(cmspathname, "/cms");
		strcpy(lockdir, "/cms/diff/lock");
		strcpy(mrdir, "/cms/diff/mr/ver_0");
		strcpy(trdir, "/cms/diff/tr/ver_0");
	}
	else
	{
		strcpy(cmspathname, envbuff);
		sprintf(lockdir,"%s/diff/lock", cmspathname);
		sprintf(mrdir,"%s/diff/mr/ver_%s", cmspathname,version);
		sprintf(trdir,"%s/diff/tr/ver_%s", cmspathname,version);
	}

	if ((envbuff = getenv("CMS_USERNAME")) == (char *)NULL)
		strcpy(username, "cms");
	else
		strcpy(username, envbuff);

	if ((envbuff = getenv("CMS_TABFILE")) == (char *)NULL)
	{
		strcpy(tabfile, "sampletab");
		sprintf(filebuff,"%s/diff/tabs/%s",cmspathname,tabfile);
	}
	else
	{
		strcpy(tabfile, envbuff);
		sprintf(filebuff,"%s/diff/tabs/%s",cmspathname,tabfile);
	}

	if ((envbuff = getenv("CMS_EDITOR")) == (char *)NULL)
		strcpy(editor, "vi");
	else
		strcpy(editor, envbuff);
	strcat(cmseditor, editor);

}

void CMSLocalFiler::envset2(void)
{
	char *envbuff;

	if ((envbuff = getenv("CMS_SYSNAME")) == (char *)NULL)
		strcpy(sysname, "cms");
	else
		strcpy(sysname, envbuff);

}

void CMSLocalFiler::tabclean(void)
{
	int i;
	for (i=0;i<64;i++)
		table_filename[i] = '\0';
	for (i=0;i<128;i++)
		memset(list[i],'\0',64);
}

void CMSLocalFiler::cmsset(void)
{
	FILE *fp;
	char *newline, *comenv;
	char buff[64], commandbuff[256];
	int i, n, status, number;
	int ret = 0;

	tabclean();
	envset();
	envset2();

	if ((fp = fopen(filebuff, "r")) == NULL) {
		echo();
		cbreak();
		endwin();
		exit(2);
	}
	n = 0;
	while((fgets(buff, 64, fp)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			sprintf(list[n],"%s",buff);
			n++;
		}
	}
	N = n - 1;
	fclose(fp);
}

int CMSLocalFiler::make(char *filename)
{
	int ret;
	char *dot;

	tabopen();
	if(strlen(filename) < (size_t)1)
		return(0);
	if ((dot = strchr(filename, '.')) != NULL)
	{
		*dot = '\0';
	}

	sprintf(systembuff,"make %s | less",filename);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::showget(char *filename)
{
	tabopen();
	if(strlen(filename) < (size_t)1)
		return(0);

	sprintf(systembuff,"showget.ksh %s %s",filename,version);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::showput(char *filename)
{
	tabopen();
	if(strlen(filename) < (size_t)1)
		return(0);

	sprintf(systembuff,"showput.ksh %s %s",filename,version);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::compile(char *filename)
{
	char *dot;

	tabopen();
	if(strlen(filename) < (size_t)1)
		return(0);
	if ((dot = strchr(filename, '.')) != NULL)
	{
		*dot = '_';
	}
	strcat(filename, ".c");
	sprintf(systembuff,"cc %s",filename);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::get(int x, int y)
{
	char *vp;
	char filename[64];

	tabopen();
	strcpy(filename, popmenu2(x,y,"GET",78,12));

	if(strlen(filename) < (size_t)1)
		return(0);
	sprintf(systembuff,"get.ksh %s %s %s 2> /dev/null",filename,username,version);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::put(char *filename)
{
	tabopen();
	if(strlen(filename) < (size_t)1)
		return(0);
	sprintf(systembuff,"put.ksh %s %s %s 2> /dev/null",filename,username,version);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::submit(char *filename)
{
	char *vp;

	tabopen();
	if(strlen(filename) < (size_t)1)
		return(0);
	sprintf(systembuff,"submit.ksh %s %s %s 2> dev/null",filename,username,version);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}


int CMSLocalFiler::cms_editor(char *filename)
{
	tabopen();
	if(strlen(filename) < (size_t)1)
		return(0);

	sprintf(systembuff,"%s %s",editor,filename);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::unget(char *filename)
{
	tabopen();
	if(strlen(filename) < (size_t)1)
		return(0);
	sprintf(systembuff,"unget.ksh %s %s %s 2> /dev/null",filename,username,version);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::vget(int x, int y)
{
	FILE *fp2;
	int i, n, ret;
	char revision[3];
	char buff[64], cutbuff[3];
	char filename[64];
	char *newline;
	size_t len;

	ret = 0;

	tabopen();
	strcpy(filename, popmenu2(x,y,"VGET",78,12));
	if(strlen(filename) < (size_t)1)
		return(0);
	sprintf(filename2,"%s",filename);
	if ((newline = strchr(filename, ' ')) != NULL)
	{
		*newline = '\0';
	}
	/*
	if ((newline = strchr(filename2, '.')) != NULL)
	{
		*newline = '_';
	}
	*/
	sprintf(revisionbuff,"%s/%s/%s/verfile.%s",lockdir,sysname,filename,version);

	if ((fp2 = fopen(revisionbuff, "r")) == NULL)
	{
		errmsg(revisionbuff);
		cleanbuff();
		return(0);
	}
	n = 0;
	while((fgets(buff, 64, fp2)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		len = (size_t)strlen(buff) - 2;
		for (i=0;i < len;i++)
		{
			cutbuff[i] = buff[i+len];
		}
		cutbuff[i] = '\0';
		sprintf(list2[n],"%s",cutbuff);
		n++;
	}
	N2 = n -1;
	fclose(fp2);

	cleanbuff();

	strcpy(revision, popmenu3(x,y,"",4,12));
	if(strlen(revision) < (size_t)1)
		return(0);
	sprintf(systembuff,"vget.ksh %s %s %s %s 2> /dev/null",filename,username,version,revision);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::putlog(int x,int y,char *filename)
{
	FILE *fp2;
	int i, n, ret;
	char revision[3];
	char buff[64], cutbuff[3];
	char *newline;

	ret = 0;
	if(strlen(filename) < (size_t)1)
		return(0);
	sprintf(filename2,"%s",filename);
	if ((newline = strchr(filename, ' ')) != NULL)
	{
		*newline = '\0';
	}
	if ((newline = strchr(filename2, '.')) != NULL)
	{
		*newline = '_';
	}
	sprintf(revisionbuff,"%s/%s/%s/verfile.%s",lockdir,sysname,filename2,version);

	if ((fp2 = fopen(revisionbuff, "r")) == NULL) {
		cleanbuff();
		return(0);
	}
	n = 0;
	while((fgets(buff, 64, fp2)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		for (i=0;i < 2;i++)
		{
			cutbuff[i] = buff[i+2];
		}
		cutbuff[i] = '\0';
		sprintf(list2[n],"%s",cutbuff);
		n++;
	}
	N2 = n - 1;
	fclose(fp2);

	cleanbuff();

	strcpy(revision, popmenu3(x,y,"",4,12));
	if(strlen(revision) < (size_t)1)
	{
		update_revision();
		return(0);
	}
	sprintf(systembuff,"putlog.ksh %s %s %s %s",filename,username,version,revision);
	if(system(systembuff) == 0)
		return(0);
	update_revision();
	return(1);
}


int CMSLocalFiler::mredit(int x, int y)
{
	FILE *fp3;
	int i,j, n, ret;
	char *newline;
	char revision[4];
	char mrfiles[64];
	char cutbuff[64];
	char buff[33];

	sprintf(mr_revisionfile,"%s/%s/mrfiles",mrdir,sysname);

	if ((fp3 = fopen(mr_revisionfile, "r")) == NULL)
	{
		errmsg(mr_revisionfile);
		return(0);
	}
//popmsg(1,2,"1");
	update_mr();
	n = 0;
	while((fgets(buff, 31 + 1, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

	strcpy(revision, popmenu5(x,y,"MR",5,22));
//	strcpy(revision, popmenu5(((90/2)/2) - 4,((LINES/2)/2) - 4,"",5,22));

	if(strlen(revision) < (size_t)1)
		return(0);

	sprintf(systembuff,"mredit.ksh %s %s %s",revision,username,version);

	if (popmsg(((90)/2)/2 + 7,LINES/2 - 4,"ＭＲの編集開始") == 1)
	{
		if(system(systembuff) == 0)
			return(0);
		return(1);
	}
	else
	{
		goto skip1;
	}
skip1:
	cleanbuff();
	return(1);
		
}

int CMSLocalFiler::tredit(int x, int y)
{
	FILE *fp3;
	int i,j, n, ret;
	char *newline;
	char revision[4];
	char trfiles[64];
	char cutbuff[64];
	char buff[33];

	sprintf(tr_revisionfile,"%s/%s/trfiles",trdir,sysname);

	if ((fp3 = fopen(tr_revisionfile, "r")) == NULL)
	{
		errmsg(tr_revisionfile);
		return(0);
	}
	update_mr();
	n = 0;
	while((fgets(buff, 31 + 1, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

	strcpy(revision, popmenu5(x,y,"TR",5,22));
//	strcpy(revision, popmenu5(((90/2)/2) - 4,((LINES/2)/2) - 4,"",5,22));

	if(strlen(revision) < (size_t)1)
		return(0);

	sprintf(systembuff,"tredit.ksh %s %s %s",revision,username,version);

	if (popmsg(((90)/2)/2 + 7,LINES/2 - 4,"TRの編集開始") == 1)
	{
		if(system(systembuff) == 0)
			return(0);
		return(1);
	}
	else
	{
		goto skip1;
	}
skip1:
	cleanbuff();
	return(1);
		
}

int CMSLocalFiler::rejectmr(int x, int y)
{
	FILE *fp3;
	int i, n, ret;
	char *newline;
	char filename[64];
	char revision[4];
	char mrfiles[64];
	char cutbuff[64];
	char buff[64];

	sprintf(mr_revisionfile,"%s/%s/mrfiles",mrdir,sysname);


	if ((fp3 = fopen(mr_revisionfile, "r")) == NULL)
	{
		errmsg(mr_revisionfile);
		return(1);
	}
	update_mr();
	n = 0;
	while((fgets(buff, 64, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

	strcpy(filename, popmenu5(x,y,"RJM",5,22));
	if(strlen(filename) < (size_t)1)
		return(0);
	if (popmsg(((90)/2)/2 + 7,LINES/2 - 4,"ＭＲを削除します") == 1)
	{
		sprintf(systembuff,"rejectmr.ksh %s %s %s 2> /dev/null",filename,username,version);
		if(system(systembuff) == 0)
			return(0);
		update_mr();
		return(1);
	}
	else
	{
		return(0);
	}
}

int CMSLocalFiler::mr(int x, int y)
{
	int ret;
	char revision[4];
	char mrnum[8];

//	printf("\033[>1h");

	input_window3(x,y,mrnum,"新しい MR [001 - 999]を入力");
	if(strlen(mrnum) < (size_t)1)
		return(0);

	sprintf(systembuff,"mr.ksh %s %s %s",mrnum,username,version);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::tr(int x, int y)
{
	int ret;
	char revision[4];
	char trnum[8];

//	printf("\033[>1h");

	input_window3(x,y,trnum,"新しい MR [001 - 999]を入力");
	if(strlen(trnum) < (size_t)1)
		return(1);

	sprintf(systembuff,"tr.ksh %s %s %s",trnum,username,version);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::mrcsvout(void)
{
	FILE *fp3;
	int i, n, ret, ret2;
	char *newline;
	char filename[64];
	char revision[4];
	char mrfiles[64];
	char cutbuff[64];
	char buff[64];


	sprintf(mr_revisionfile,"%s/%s/mrfiles",mrdir,sysname);

	if ((fp3 = fopen(mr_revisionfile, "r")) == NULL)
	{
		errmsg(mr_revisionfile);
		return(0);
	}
	n = 0;
	while((fgets(buff, 64, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

	strcpy(revision, popmenu5(((90/2)/2) - 4,((LINES/2)/2) - 4,"",5,22));

	if(strlen(revision) < (size_t)1)
		return(0);

	sprintf(mr_editfile,"mrcsvout.ksh -s %s %s %s",revision,sysname,version);
	if(system(mr_editfile) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::trcsvout(void)
{
	FILE *fp3;
	int i, n, ret, ret2;
	char *newline;
	char filename[64];
	char revision[4];
	char mrfiles[64];
	char cutbuff[64];
	char buff[64];


	sprintf(mr_revisionfile,"%s/%s/mrfiles",mrdir,sysname);

	if ((fp3 = fopen(mr_revisionfile, "r")) == NULL)
	{
		errmsg(mr_revisionfile);
		return(0);
	}
	n = 0;
	while((fgets(buff, 64, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

	strcpy(revision, popmenu5(((90/2)/2) - 4,((LINES/2)/2) - 4,"",5,22));

	if(strlen(revision) < (size_t)1)
		return(0);

	sprintf(tr_editfile,"trreport.ksh -s %s %s %s",revision,sysname,version);
	if(system(tr_editfile) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::mrreport(int x, int y)
{
	FILE *fp3;
	int i, n, ret, ret2;
	char *newline;
	char filename[64];
	char revision[4];
	char mrfiles[64];
	char cutbuff[64];
	char buff[64];


	sprintf(mr_revisionfile,"%s/%s/mrfiles",mrdir,sysname);

	if ((fp3 = fopen(mr_revisionfile, "r")) == NULL)
	{
		errmsg(mr_revisionfile);
		return(0);
	}
	n = 0;
	while((fgets(buff, 64, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

	strcpy(revision, popmenu5(x,y,"",5,22));
//	strcpy(revision, popmenu5(((90/2)/2) - 4,((LINES/2)/2) - 4,"",5,22));

	if(strlen(revision) < (size_t)1)
		return(0);

	sprintf(mr_editfile,"mrreport.ksh -s %s %s %s",revision,sysname,version);
	if(system(mr_editfile) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::newfile(int x,int y)
{
	char filename[256];

	tabopen();
	strcpy(filename, popmenu2(x,y,"NEWFILE",78,12));
	if(strlen(filename) < (size_t)1)
		return(0);
	sprintf(systembuff,"newfile.ksh %s %s %s 2> /dev/null",filename,username,version);
	if(system(systembuff) == 0)
		return(0);
	return(1);
}

int CMSLocalFiler::reject(int x, int y,char *filename)
{
	FILE *fp2;
	int i, n, ret;
	char revision[3];
	char buff[64], cutbuff[3];
	char *newline;

	tabopen();
	if(strlen(filename) < (size_t)1)
		return(0);
	sprintf(filename2,"%s",filename);

	if ((newline = strchr(filename, ' ')) != NULL)
	{
		*newline = '\0';
	}
	if ((newline = strchr(filename2, '.')) != NULL)
	{
		*newline = '_';
	}

	sprintf(revisionbuff,"%s/%s/%s/verfile.%s",lockdir,sysname,filename2,version);

	if ((fp2 = fopen(revisionbuff, "r")) == NULL) {
		cleanbuff();
		return(0);
	}
	n = 0;
	while((fgets(buff, 64, fp2)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		for (i=0;i < 2;i++)
		{
			cutbuff[i] = buff[i+2];
		}
		cutbuff[i] = '\0';
		sprintf(list2[n],"%s",cutbuff);
		n++;
	}
	N2 = n - 1;
	fclose(fp2);

	strcpy(revision, popmenu3(x,y,"",4,12));
	if(strlen(revision) < (size_t)1)
		return(0);

	if (popmsg(((90)/2)/2 + 7,LINES/2 - 4,"リビジョンを削除します") == 1)
	{
		cleanbuff();
		sprintf(systembuff,"reject.ksh %s %s %s %s 2> /dev/null",filename,username,version,revision);
		if(system(systembuff) == 0)
			return(0);
		update_revision();
		return(1);
	}
	else
	{
		return(0);
	}
}

void CMSLocalFiler::tabedit(void)
{
	FILE *fp4, *fp5;

	int i, n, len, maxlen;
	int ret;
	int color = 7;
	char buff[256];
	char *newline;

	tabclean();
	sprintf(table_filename,"%s",tabfile);

	sprintf(buff,"echo [m;vi %s",table_filename);

	noraw();
	echo();
	nl();
	nocbreak();
	if(system("/bin/stty echo onlcr icrnl") == 0)
		return;
	if(system(buff) == 0)
		return;
	if(system("tabchg.ksh") == 0)
		return;
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

char *CMSLocalFiler::getCMSFile(char *filename)
{
	char *cvp, *hvp;
	char cmsgetcwd[256];
	int cmspathlen;
	int getpathlen;
	int getbaselen;
	static char cmsfilename[256];

	//put.kshのための設定
	cvp = getenv("CMSPATH");
	cmspathlen = strlen(cvp);
	if(getcwd(cmsgetcwd,256) == NULL)
		return((char *)NULL);

	hvp = getenv("HOME");
	getpathlen = strlen(cmsgetcwd);
	getbaselen = strlen(basename(hvp));

	if(!strcmp(hvp,cmsgetcwd))
	{
		sprintf(cmsfilename,"%s",filename);
		return(cmsfilename);
	}
	else
	{
		sprintf(cmsfilename,"%s/%s",right2(cmsgetcwd,(getpathlen - (cmspathlen + 6 + getbaselen + 1))),filename);
		return(cmsfilename);
	}
}

int CMSLocalFiler::chkCMSTree(void)
{
	char *cvp;
	char cmsgetcwd[256];
	int cmspathlen;
	char cmstree[256];
	char cmspath[256];

	//cmsツリーのための設定
	cvp = getenv("CMSPATH");
	cmspathlen = strlen(cvp);
	if(getcwd(cmsgetcwd,256) == NULL)
		return(2);
//2012.5.6
//	sprintf(cmstree,"%s",left2(cmsgetcwd,cmspathlen));
	sprintf(cmstree,"%s",cmsgetcwd);
//	sprintf(cmspath,"%s",left2(cvp,cmspathlen));
	sprintf(cmspath,"%s",cvp);
	if(strcmp(cmstree,cmspath) == 0)
	{
		return(1);
	}
	else
	{
		return(0);
	}
		
}

int CMSLocalFiler::cmsfiler(int start,int end)
{
	int i,j;
	int ch,ch2;
	int x,y;
	int xx = 1,yy = 5;
	char buff[BUFSIZE],cwdpath[BUFSIZE],cwdpath2[BUFSIZE],copybuff[BUFSIZE],editbuff[BUFSIZE];
	char tmpbuff[BUFSIZE];
	char execbuff[BUFSIZE];
	WINDOW *evs;
	char *vp,*dp, *sp;
	char filebuff[BUFSIZE];
	uid_t fuid;
	gid_t fgid;
	char findstr[BUFSIZE];
	int findf = 0;
	int fcount = 0;
	int dflag = 1;

	int ret;

	char *nln;
	int xcol,xrow;	//for ase

	unsigned int swptmp;
	char buffx[256];
	char buffy[256];
	char buffz[256];

	char ftmp[256];
	char ftmp2[256];

	static int deep = 0;	//ディレクトリの深さ（階層）

	char strCommand[256];	//FTXのためのコマンド
	char attrbuff[256];

	//ASE エディタのための変数
	FILE *fp;
	char *nlline;
	int len;
	char chgbuff[256];

	char *hp;	//サブティレクトリでもput可能なように

	pid_t pid;

	//cmsのための変数
	char cmsgetcwd[256];
	char cmsfilename[256];

//	signal(SIGCHLD, SIGCHLD_handler2);
	signal(SIGQUIT, SIG_IGN);

	fmode = 'm';	//日付表示はファイルの作成日に
	dmode = 'h';	// 'v'と 'h' .の付いたファイルの表示非表示を切替える
	pathisto = 0;	//ディレクトリ移動履歴はまずゼロから
	pathcnt = 0;	//パス名のカウント
	botom = 2;		//ファイル最下行を設定（LINESより2行上になる）

	//複数選択コピー、移動、削除用のバッファとマークをクリア
	intCPnum = 0;
	for(j=0;j<256;j++)
		cpflag[j] = 0;
	for(j=0;j<MAX_FILES;j++)
		regline[j] = 0;

	noecho();
	cbreak();

	evs = newwin(1,90,LINES-1,0);

	max_lines = LINES;
	pt[2].vs = newwin(max_lines - (botom),90,1,0);

	set_screen(2);
	displaymenuCMS(evs,dflag);

	x = 1;
	y = 0;

	y = 0;
	yy = 5;

	dirlocateclear();

	if(getcwd(cwdpath,BUFSIZE) == NULL)
		return(2);
	sprintf(dirstack[0],"%s",cwdpath);
	pathisto++;
	pathcnt++;
	if (COLS > 89)
	{
		if(strlen(cwdpath) > (size_t)72)
		{
			sprintf(cwdpath2,"Path=...%-69s%4d files",right2(cwdpath,69),file_num);
			sprintf(tmpbuff,"%s",cwdpath2);
		}
		else
		{
			sprintf(tmpbuff,"Path=%-62s%4d files",cwdpath,file_num);
		}
	}
	else
	{
		if(strlen(cwdpath) > (size_t)62)
		{
			sprintf(cwdpath2,"Path=...%-59s%4d files",right2(cwdpath,59),file_num);
			sprintf(tmpbuff,"%s",cwdpath2);
		}
		else
		{
			sprintf(tmpbuff,"Path=%-62s%4d files",cwdpath,file_num);
		}
	}
	vs_print(tmpbuff,pt[2].vs,line1[0]+1,1);
	initbuff();

    //2012.10.25 サブディレクトリでputが出来なくなったのを修正（chkCMSTree()追加が原因）
    if((hp = getenv("HOME")) != NULL)
    {
        sprintf(cmsuserhomedir,"%s",hp);
    }

	while(1)
	{
		//cmsのため
		if(chkCMSTree())
			dirprint_cms(".",fmode);
		else
			dirprint_all(".",fmode);

		set_screen_line2(2);

		datadisp(2,x,y,5);

		/*
		ウインドウの枠を表示する
		*/
		box(pt[2].vs,ACS_VLINE,ACS_HLINE);
		if((vp = getenv("CMS_USERNAME")) == NULL)
		{
			sprintf(tmpbuff,"%-44s-(v%s) CMS-Filer v1.00 2009(c)S.Ono#",getenv("LOGNAME"),getenv("CMS_VERSION"));
		}
		else
		{
			if((sp = getenv("LOGNAME")) == NULL)
				sprintf(tmpbuff,"%-16s(v%s)- %-26s CMS-Filer v1.00 2009(c)S.Ono#",vp,getenv("CMS_VERSION"),"no-login");
			else
				sprintf(tmpbuff,"%-16s(v%s)- %-26s CMS-Filer v1.00 2009(c)S.Ono#",vp,getenv("CMS_VERSION"),sp);
		}
		wattron(pt[2].vs,A_REVERSE);
		mvwprintw(pt[2].vs,0,1,tmpbuff);
		wattroff(pt[2].vs,A_REVERSE);

		if(getcwd(cwdpath,BUFSIZE) == NULL)
			return(2);

		if (COLS > 89)
		{
			if(strlen(cwdpath) > (size_t)72)
			{
				sprintf(cwdpath2,"Path=...%-59s%4d files",right2(cwdpath,59),file_num);
				sprintf(tmpbuff,"%s",cwdpath2);
			}
			else
			{
				sprintf(tmpbuff,"Path=%-62s%4d files",cwdpath,file_num);
			}
		}
		else
		{
			if(strlen(cwdpath) > (size_t)62)
			{
				sprintf(cwdpath2,"Path=...%-59s%4d files",right2(cwdpath,59),file_num);
				sprintf(tmpbuff,"%s",cwdpath2);
			}
			else
			{
				sprintf(tmpbuff,"Path=%-62s%4d files",cwdpath,file_num);
			}
		}
		vs_print(tmpbuff,pt[2].vs,line1[0]+1,1);

		wmove(pt[2].vs,y,1);
		wattron(pt[2].vs,A_REVERSE);
		sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
		vs_print(filebuff,pt[2].vs,line1[0]+2,yy);

		sprintf(filebuff,"-30s"," ");
		wattroff(pt[2].vs,A_REVERSE);

		if (regline[y+(yy-5)] == 1)
			vs_print("*",pt[2].vs,line1[0]+1,yy);

		wrefresh(pt[2].vs);

		/*
		シンボリックリンクを表示 2009/03/16
		*/
		memset(ftmp,'\0',256);
		if((readlink(fs[y+(yy-5)].buff1, ftmp, 256)) != -1)
		{
			sprintf(ftmp2,"%s->%s",fs[y+(yy-5)].buff1,ftmp);
			if(yy < 10)
				dialogmsg2(30, yy + 2,ftmp2,"シンボリックリンクされています。");
			else
				dialogmsg2(30, yy - 4,ftmp2,"シンボリックリンクされています。");
		}

		/*
		コマンド操作
		*/
		ch = wgetch(pt[2].vs);

		wattroff(pt[2].vs,A_REVERSE);
		sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
		vs_print(filebuff,pt[2].vs,line1[0]+2,yy);

		if (regline[y+(yy-5)] == 1)
			vs_print("*",pt[2].vs,line1[0]+1,yy);

		displaymenuCMS(evs,dflag);

		switch(ch)
		{
		case '6':
sprintf(tmpbuff,"%d",chkCMSTree());
popmsg(1,1,tmpbuff);
			break;

		case KEY_F(1):
			break;
		case 'E': case 0x0a: case 0x0d:
		//	readflg = 1;
		//	nonopt = 1;
			stat(fs[y+(yy-5)].buff1,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
				break;
			sprintf(buff,"%s",cutspace(fs[y+(yy-5)].buff1));
			len = strlen(buff);
		//	if(((!strcmp(right2(buff,4),".def")) && (!strcmp(Mid1(buff,1,1),"_")))  || (!strcmp(right2(buff,4),".sql")) ||  (!strcmp(right2(buff,4),".pgc")))
			if(((!strcmp(right2(buff,4),".def")) && (!strcmp(Mid1(buff,1,1),"_")))  || (!strcmp(right2(buff,4),".sql")) ||  (!strcmp(right2(buff,4),".pgc")) || (!strcmp(right2(buff,6),".def.c")) )
			{
				sprintf(buff,"/bin/stty echo onlcr icrnl;vi %s",fs[y+(yy-5)].buff1);
				wattroff(pt[2].vs,A_REVERSE);
				wrefresh(pt[2].vs);
				if(system(buff) == 0)
					return(0);
				wclear(pt[2].vs);
				set_screen(2);
				noecho();
				cbreak();

				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);
				box(pt[2].vs,ACS_VLINE,ACS_HLINE);
				break;
			}
			if(strcmp(Mid1(buff,len-3,4),".def") != 0)
			{
				break;
			}
			j=0;
			if((fp =fopen(buff,"r")) == (FILE *)NULL)
			{
				exit(1);
			}
			while(fgets(buff,256,fp) != (char *)NULL)
			{
				if((nlline = strchr(buff,'\n')) != (char *)NULL)
				{
					*nlline = '\0';
					j++;
				}
			}
			fclose(fp);
		//BUG 2009.08.03 modifyed. strlen() ???
		//	xcol = strlen(buff)-1;
			xcol = strlen(buff);
			xrow = j;
			if(xcol > 226)
			{
				sprintf(tmpbuff,"Over colums 226\n");
				if(popmsg(2+8,(LINES/2)-4,tmpbuff) == 1)
				{
					break;
				}
			}
			if(xrow > 78)
			{
				sprintf(tmpbuff,"%s","Over rows 78\n");
				if(popmsg(2+8,(LINES/2)-4,tmpbuff) == 1)
				{
					break;
				}
			}
			clear();
			//ASE editor
		//	aseeditor = new AseEditor();
		//	sprintf(chgbuff,"%s",fs[y+(yy-5)].buff1);
		//	aseeditor->ase(xcol,xrow,fs[y+(yy-5)].buff1,0);
		//	delete aseeditor;
		//	clear();
		//	goto allCLS;

			cls_all(2);

			initbuff();
			wclear(pt[2].vs);
			set_screen(2);

			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			wrefresh(pt[2].vs);
			break;

		/*
		FTPファイラーの操作
		*/
		case 'X':
			ch2 = wgetch(pt[2].vs);
			switch(ch2)
			{
			/*
			FTPファイラーの起動と接続
			*/
			case 'X':
				FTPConnect();

				cls_all(2);
				initbuff();

				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);
				y = 0;
				yy = 5;
				break;
			}
			break;
		/*
		現在のパスをブックマークとして保存
		*/
		case '':
			if(popmsg2(2+8,(LINES/2)-4,"カレントディレクトリをブックマークに保存しますか？") == 1)
			{
				sprintf(bookmarks[bookline],"%s",cwdpath);
				if(bookmarksave() == -1)
				{
					popmsg(2+8,(LINES/2)-4,"ブックマークを保存出来ません。");
				}
			}
			break;
		/*
		ファイル・ディレクトリを作成した日付で表示
		*/
		case '7':
			break;

		/*
		case 'E':
			stat(fs[y+(yy-5)].buff1,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
				break;
			if(system("clear") == 0)
				return(0);
			noraw();
			echo();
			nl();
			nocbreak();
			sprintf(buff,"/bin/stty echo onlcr;ase %s",fs[y+(yy-5)].buff1);
			if(system(buff) == 0)
				return(0);
			raw();
			noecho();
			nonl();
			cbreak();

			cls_all(2);

			initbuff();
			wclear(pt[2].vs);
			set_screen(2);

			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			wrefresh(pt[2].vs);
			break;
		*/
		/*
		ＣＭＳの起動
		*/
		case '@':
			noraw();
			echo();
			nl();
			nocbreak();
			if(system("/bin/stty echo onlcr icrnl;cmsmenu") == 0)
				return(0);
			raw();
			noecho();
			nonl();
			cbreak();

			cls_all(2);
			initbuff();
			wclear(pt[2].vs);
			set_screen(2);

			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			wrefresh(pt[2].vs);
			break;
		/*
		ＣＭＳコマンドの実行
		*/
		case 'S':
			ch2 = wgetch(pt[2].vs);
			switch(ch2)
			{
			//GET
			case 'A':
				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(chdir(cmsuserhomedir) != 0)
					return(2);
				if(yy > (LINES-13))
				{
					if(get(2,yy-11) == 0)
					{
						if(chdir(tmpbuff) != 0)
							return(2);
						refresh();
						break;
					}
				}
				else
				{
					if(get(2,yy+2) == 0)
					{
						if(chdir(tmpbuff) != 0)
							return(2);
						refresh();
						break;
					}
				}
				if(chdir(tmpbuff) != 0)
					return(2);
				refresh();
				cls_all(2);
				initbuff();
				break;

			//PUT
			case 'B':
				sprintf(cmsfilename,"%s",getCMSFile(fs[y+(yy-5)].buff1));

				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(chdir(cmsuserhomedir) != 0)
					return(2);
				if(put(cmsfilename) == 0)
				{
					if(chdir(tmpbuff) != 0)
						return(2);
					clear();
					refresh();
					break;
				}
				if(chdir(tmpbuff) != 0)
					return(2);
				clear();
				refresh();
				cls_all(2);
				initbuff();
				break;

			//PUTLOG
			case 'C':
				sprintf(cmsfilename,"%s",getCMSFile(fs[y+(yy-5)].buff1));

				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(chdir(cmsuserhomedir) != 0)
					return(2);
				if(yy > (LINES-13))
				{
					if(putlog(2,yy-11,cmsfilename) == 0)
					{
						if(chdir(tmpbuff) != 0)
							return(2);
						clear();
						refresh();
						break;
					}
				}
				else
				{
					if(putlog(2,yy+2,cmsfilename) == 0)
					{
						if(chdir(tmpbuff) != 0)
							return(2);
						clear();
						refresh();
						break;
					}
				}
				if(chdir(tmpbuff) != 0)
					return(2);
				clear();
				refresh();
				cls_all(2);
				initbuff();
				break;

			//VGET
			case 'D':
				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(chdir(cmsuserhomedir) != 0)
					return(2);
				if(yy > (LINES-13))
				{
					if(vget(2,yy-11) == 0)
					{
						if(chdir(tmpbuff) != 0)
							return(2);
						clear();
						refresh();
						break;
					}
				}
				else
				{
					if(vget(2,yy+2) == 0)
					{
						if(chdir(tmpbuff) != 0)
							return(2);
						clear();
						refresh();
						break;
					}
				}
				if(chdir(tmpbuff) != 0)
					return(2);
				clear();
				refresh();
				cls_all(2);
				initbuff();
				break;

			//MREDIT
			case 'E':
				if(yy > (LINES-13))
				{
					if(mredit(2,yy-11) == 0)
						break;
				}
				else
				{
					if(mredit(2,yy+2) == 0)
						break;
				}
				refresh();
				break;

			//MR
			case 'F':
				if(yy > (LINES-13))
				{
					if(mr(2,yy-11) == 0)
						break;
				}
				else
				{
					if(mr(2,yy+2) == 0)
						break;
				}
				cls_all(2);
				clear();
				refresh();
				break;

			//UNGET
			case 'G':
				sprintf(cmsfilename,"%s",getCMSFile(fs[y+(yy-5)].buff1));

				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(chdir(cmsuserhomedir) != 0)
					return(2);
				if(unget(cmsfilename) == 0)
				{
					if(chdir(tmpbuff) != 0)
						return(2);
					clear();
					refresh();
					break;
				}
				if(chdir(tmpbuff) != 0)
					return(2);
				clear();
				refresh();
				cls_all(2);
				initbuff();
				break;

			//SHOWGET
			case 'H':
				sprintf(cmsfilename,"%s",getCMSFile(fs[y+(yy-5)].buff1));
				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(chdir(cmsuserhomedir) != 0)
					return(2);
				if(showget(cmsfilename) == 0)
				{
					if(chdir(tmpbuff) != 0)
						return(2);
					break;
				}
				if(chdir(tmpbuff) != 0)
					return(2);
				clear();
				refresh();
				break;

			//SHOWPUT
			case 'I':
				sprintf(cmsfilename,"%s",getCMSFile(fs[y+(yy-5)].buff1));
				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(chdir(cmsuserhomedir) != 0)
					return(2);
				if(showput(cmsfilename) == 0)
				{
					if(chdir(tmpbuff) != 0)
						return(2);
					clear();
					break;
				}
				if(chdir(tmpbuff) != 0)
					return(2);
				clear();
				refresh();
				break;

			//MAKE
			case 'J':
				if(make(fs[y+(yy-5)].buff1) == 0)
					break;
				clear();
				refresh();
				break;

			case 'K':
				break;

			//TREDIT
			case 'L':
				if(yy > (LINES-13))
				{
					if(tredit(2,yy-11) == 0)
						break;
				}
				else
				{
					if(tredit(2,yy+2) == 0)
						break;
				}
				clear();
				refresh();
				break;

			//TR
			case 'M':
				if(yy > (LINES-13))
				{
					if(tr(2,yy-11) == 0)
						break;
				}
				else
				{
					if(tr(2,yy+2) == 0)
						break;
				}
				cls_all(2);
				clear();
				refresh();
				break;

			//NEWFILE
			case 'N':
				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(chdir(cmsuserhomedir) != 0)
					return(2);
				if(yy > (LINES-13))
				{
					if(newfile(2,yy-11) == 0)
					{
						if(chdir(tmpbuff) != 0)
							return(2);
						clear();
						refresh();
						break;
					}
				}
				else
				{
					if(newfile(2,yy+2) == 0)
					{
						if(chdir(tmpbuff) != 0)
							return(2);
						clear();
						refresh();
						break;
					}
				}
				if(chdir(tmpbuff) != 0)
					return(2);
				clear();
				refresh();
				break;

			//TABEDIT
			case 'O':
				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(chdir(cmsuserhomedir) != 0)
					return(2);
				tabedit();
				if(chdir(tmpbuff) != 0)
					return(2);
				clear();
				refresh();
				break;

			//MRREPORT
			case 'P':
				if(yy > (LINES-13))
				{
					if(mrreport(2,yy-11) == 0)
						break;
				}
				else
				{
					if(mrreport(2,yy+2) == 0)
						break;
				}
				clear();
				refresh();
				break;

			//REJECTMR
			case 'Q':
				if(yy > (LINES-13))
				{
					if(rejectmr(2,yy-11) == 0)
						break;
				}
				else
				{
					if(rejectmr(2,yy+2) == 0)
						break;
				}
				clear();
				refresh();
				break;

			//REJECT
			case 'R':
				sprintf(cmsfilename,"%s",getCMSFile(fs[y+(yy-5)].buff1));
				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(chdir(cmsuserhomedir) != 0)
					return(2);
				if(yy > (LINES-13))
				{
					if(reject(2,yy-11,cmsfilename) == 0)
					{
						if(chdir(tmpbuff) != 0)
							return(2);
						clear();
						refresh();
						break;
					}
				}
				else
				{
					if(reject(2,yy+2,cmsfilename) == 0)
					{
						if(chdir(tmpbuff) != 0)
							return(2);
						clear();
						refresh();
						break;
					}
				}
				if(chdir(tmpbuff) != 0)
					return(2);
				clear();
				refresh();
				break;

			//SUBMIT
			case 'S':
				sprintf(cmsfilename,"%s",getCMSFile(fs[y+(yy-5)].buff1));

				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(chdir(cmsuserhomedir) != 0)
					return(2);
				if(submit(cmsfilename) == 0)
				{
					if(chdir(tmpbuff) != 0)
						return(2);
					clear();
					refresh();
					break;
				}
				if(chdir(tmpbuff) != 0)
					return(2);
				clear();
				refresh();
				cls_all(2);
				initbuff();
				break;

			case 'T':
				break;

			case 'U':
				break;
			}

			break;

		case '^':
		/*
		Hiddenファイル・ディレクトリを表示／非表示の切替え（デフォルト）
		*/
			command01(2,y,yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			break;

		case '~':
		/*
		ブックマークのディレクトリに移動する。
		*/
			command02(2,y,yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			dirlocateclear();
			y = 0;
			yy = 5;
			break;

		case '0':
		/*
		ファイル・ディレクトリを作成した日付と時間で表示（デフォルト）
		*/
			command03(2);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			break;

		case '2':
		/*
		ファイル・ディレクトリを最新アクセスした日付で表示
		*/
			command04(2);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			break;

		case '9':
		/*
		ファイル・ディレクトリを作成した日付で表示
		*/
			command05(2);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			break;

		case '\t':
		/*
		ファイルの選択（マーク）
		*/
			command06(2,y,yy);
			break;

		case '':
		/*
		複数選択表示（less）
		*/
			command07(2);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			box(pt[2].vs,ACS_VLINE,ACS_HLINE);
			goto allCLS2;

		/*
		複数選択移動
		*/
		case '':
			command29(2,y,yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			goto allCLS2;

		/*
		複数選択コピー
		*/
		case '':
			command30(2,y,yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			goto allCLS2;

		/*
		複数選択削除（ファイルのみ）
		*/
		case '':
			ch2 = wgetch(pt[2].vs);
			switch(ch2)
			{
			case '':
				command08(2);
				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);
				y = 0;
				yy = 5;
				goto allCLS2;

			default:
				break;
			}

		case 'T':
		/*
		tar -xzf fine-name を実行
		*/
			command09(2,y,yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			break;

		case '':
		/*
		tar -czf fine-name を実行
		*/
			command10(2,y,yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			break;

		case '':
		/*
		複数選択の tar -czf fine-name を実行
		*/
			command31(2,y,yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			break;

		case '/':
		/*
		ファイルを文字列で検索
		*/
			input_window(4,2,findstr,"検索名を入力");
			if(strlen(findstr) < (size_t)0)
				strcpy(findstr," ");

		case 'n':
		/*
		ファイルを文字列で再び検索
		*/
			fcount = 0;
			if(strlen(findstr) < (size_t)1)
				break;
			y++;
			for(;y+(yy-5)<file_num;y++)
			{
				if(fcount > MAX_FILES)
					break;
				if((findf = findex(fs[y+(yy-5)].buff1, findstr)) != -1)
				{
					fcount = 0;
					sprintf(buff,"[%s] が見つかりました",findstr);
					dialogmsg(33,6,buff);
					break;
				}
				fcount++;
				if(y+(yy-5) < file_num)
				{
					if(y >= MAX_FILES - max_lines)
					{
						y = MAX_FILES - max_lines;
					}
				}
				else
				{
					break;
				}
			}
			cls_all(2);

			//見つからなければ前にいた位置に戻る
			if(y > MAX_FILES || y >= file_num || strlen(fs[y+(yy-5)].buff1) < (size_t)1)
			{
				dialogmsg(2,(LINES/2),"見つかりません");

				y = 0;
				yy = 5;
				cls_all(2);
				datadisp(2,x,y,5);
				wattroff(pt[2].vs,A_REVERSE);
				sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
				vs_print(filebuff,pt[2].vs,line1[0]+2,yy);
				break;
			}
			break;

		 case 'N':
			fcount = 0;
			if(strlen(findstr) < (size_t)1)
				break;
			y--;
			for(;y+(yy-5)>0;y--)
			{
				if(fcount > MAX_FILES)
					break;
				if((findf = findex(fs[y+(yy-5)].buff1, findstr)) != -1)
				{
					fcount = 0;
					sprintf(buff,"[%s] が見つかりました。y = %d,yy= %d",findstr,y,yy);
					dialogmsg(33,6,buff);
					break;
				}
				fcount++;
			}
			datadisp(2,x,y,5);
			cls_all(2);
			set_screen(2);

			if(y < 1 || strlen(fs[y+(yy-5)].buff1) < (size_t)1)
			{
				y = 0;
				yy = 5;
				cls_all(2);
				set_screen(2);
				datadisp(2,x,y,5);
				wattroff(pt[2].vs,A_REVERSE);
				sprintf(filebuff,"%-42s",fs[y+(yy-5)].buff1);
				vs_print(filebuff,pt[2].vs,line1[0]+2,yy);
				break;
			}
			break;

		case '':
		/*
		ファイルの属性（モード）を変更
		*/
			command11(2,y,yy);
			/*
          		S_IRUSR        所有者による読出し
           		S_IWUSR        所有者による書込み
           		S_IXUSR        所有者による実行(検索)
           		S_IRGRP        グループによる読出し
           		S_IWGRP        グループによる書込み
           		S_IXGRP        グループによる実行(検索)
           		S_IROTH        他人(つまり、誰でも)による読出し
		   */
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			break;

		case '':
		/*
		cmsfilerを起動したディレクトリに戻る
		*/
			command12(2);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			dirlocateclear();
			break;

		case '':
		/*
		環境変数 HOME に定義されたディレクトリに移動する
		*/
			command12(2);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			dirlocateclear();
			break;

		case 'H':
		/*
		cmsfilerのヘルプメッセージを表示
		*/
			helpmsg(1,1);
			break;

		case '?':
		/*
		英語のcmsfilerヘルプメッセージを表示する
		*/
			helpmsg2(1,1);
			break;

		case 'f':
		/*
		ファイルのコードをＥＵＣコードに変換する
		*/
			command14(y,yy);
			break;

		case 'F':
		/*
		ファイルのコードをUTF-8コードに変換する
		*/
			command15(y,yy);
			break;

		case '':
		/*
		ファイルのコードをシフトJISコードに変換する
		*/
			command16(y,yy);
			break;

		case 'r':
		/*
		ディレクトリの削除
		*/
			if(command17(2, y, yy) != 0)
			{
				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);
			}
			break;

		case '':
		/*
		ファイル指定なしでｖｉエディタを起動する。
		*/
			command18(2);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			box(pt[2].vs,ACS_VLINE,ACS_HLINE);
			break;

		case 'e':
		/*
		ファイル指定でｖｉエディタを起動する。
		*/
			command19(2,y,yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			wattron(pt[0].vs,A_REVERSE);
			box(pt[2].vs,ACS_VLINE,ACS_HLINE);
			wattroff(pt[0].vs,A_REVERSE);
			break;

#ifdef CYGWIN

		/*
		ファイル指定でWindows版 vimエディタを起動する。
		*/
		/*
		case 'E':
			stat(fs[y+(yy-5)].buff1,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
				break;
			if(system("clear") == 0)
				return(0);
			noraw();
			echo();
			nl();
			nocbreak();

			sprintf(buff,"/cygdrive/c/vim/VIM32 %s",fs[y+(yy-5)].buff1);
			wattroff(pt[2].vs,A_REVERSE);
			wrefresh(pt[2].vs);
			system(buff);
			if(system(buff) == 0)
				return(0);

			wclear(pt[2].vs);
			set_screen(2);
			noecho();
			cbreak();

			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			box(pt[2].vs,ACS_VLINE,ACS_HLINE);
			break;
		*/
#endif

		case '-':
		/*
		ディレクトリ移動の履歴を遡る
		*/
			command21(2,y,yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			break;

		case '+':
		/*
		ディレクトリ移動の履歴を戻る
		*/
			command22(2,y,yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			break;

		case 'c':
		/*
		ディレクトリを移動する。
		*/
		//	execchdir:

			set_screen_line1(2);
			set_screen(2);


			stat(fs[y+(yy-5)].buff1,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				if(getcwd(tmpbuff,256) == NULL)
					return(2);
				if(1 == 1)
				{
					memset(ftmp,'\0',256);
					
					if(deep < 0 || (readlink(fs[y+(yy-5)].buff1, ftmp, 256)) != -1)
					{
						deep = 0;
						goto skipdir;
					}
				}
				skipdir:

				if(chdir(fs[y+(yy-5)].buff1) == -1)
					break;
				sprintf(dirlocate[dirlocateyy[deep]], "%s",fs[y+(yy-5)].buff1);
				dirlocatey[deep] = y;
				dirlocateyy[deep] = yy;
				deep++;
				if(getcwd(dirstack[pathcnt],BUFSIZE) == NULL)
					return(2);
				if(pathcnt < 128)
					pathcnt++;
				if(pathisto < 128)
					pathisto++;
				checkhisto();

				cls_all(2);
				initbuff();

				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);
				y = 0;
				yy = 5;
			}
			break;
		case 'i':
		/*
		ディレクトリを上に移動する。
		*/
			set_screen(2);

			stat("..",fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				if(chdir("..") == -1)
					break;
				if(getcwd(dirstack[pathcnt],BUFSIZE) == NULL)
					return(2);
				if(pathcnt < 128)
					pathcnt++;
				if(pathisto < 128)
					pathisto++;
				checkhisto();

				for(j=0;j<MAX_FILES;j++)
					regline[j] = 0;
				for(j=0;j<MAX_FILES;j++)
					cpflag[j] = 0;

				cls_all(2);
				initbuff();
		
				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);

				if(deep > 0)
				{
					deep--;
					y = dirlocatey[deep];
					yy = dirlocateyy[deep];
				}
				else
				{
					y = 0;
					yy = 5;
				}
			}
			break;

		case 'v':
		/*
		ファイルビューアを起動する。
		*/
			command25(2,y,yy);
			break;

		case '':
		/*
		ファイルを削除する。
		*/
			if(command26(2, y, yy) != 0)
			{
				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);
			}
			break;

		case 'M':
		/*
		ファイルを移動または名前を変更する。
		*/
			if(command27(2, y, yy) != 0)
			{
				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);
			}
			break;

		case 'p':
		/*
		ファイルをコピーする。
		*/
			command28(y,yy);
			break;

		case '!':
		/*
		シェルモードへ移行
		*/
			command32(2);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			break;

		case 'm':
		/*
		ディレクトリを作成する
		*/
			if(command33(2) != 0)
			{
				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);
			}
			break;
		case 'O':
		/*
		入力でディレクトリを移動する
		*/
			if(command34(2) != 0)
			{
				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);
				y = 0;
				yy = 0;
			}
			break;

		case '':
		/*
		ファイルをプログラムとして実行
		*/
			command35(2);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			break;

		case 'x':
		/*
		ファイルを実行する（コマンド実行）。
		*/
			if(command36(2, y, yy) != 0)
			{
				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);
			}
			break;

		case 's':
		/*
		シンボリックリンクの作成
		*/
			if(command37(2, y, yy) != 0)
			{
				if(chkCMSTree())
					dirprint_cms(".",fmode);
				else
					dirprint_all(".",fmode);
			}
			break;

		/*
		ＭＡＫＥコマンドを実行
		*/
		case '':
			command38(2, y, yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			wclear(pt[2].vs);
			set_screen(2);
			break;

		/*
		ＭＡＫＥコマンド（引数付き）を実行
		*/
		case ']':
			command39(2, y, yy);
			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			wclear(pt[2].vs);
			set_screen(2);
			break;

		case '1':
		/*
		メニューバーを切り替える
		*/
		//	if(dflag == 1)
		//		dflag = 0;
		//	else
		//		dflag = 1;
		//	displaymenu1(evs,dflag);
			break;

		case 'g':
		/*
		ファイル列の最後を表示
		*/
			if(y > (file_num - (max_lines - 7)))
			{
				yy = max_lines - ((max_lines - 4) - (file_num));
			}
			if(file_num > (max_lines - 8))
			{
				y = file_num - (max_lines - 8);
				yy = max_lines - 4;
			}
			cls_all(2);
			break;

		case 'G':
		/*
		ファイル列の最後を表示
		*/
			if(y > (file_num - (max_lines - 7)))
				break;
			if(file_num > (max_lines - 7))
				y = file_num - (max_lines - 8);
			cls_all(2);
			break;
		/*
		ファイル画面トップに
		*/
		case 't':
			y = 0;
			yy = 5;
			cls_all(2);

			datadisp(2,x,y,5);
			wattroff(pt[2].vs,A_REVERSE);
			sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
			vs_print(filebuff,pt[2].vs,line1[0]+2,yy);
			break;

		case 'U':
			if(yy > 5)
			{
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				break;
			}

			y -= 5;
			if(y < 1)
				y = 0;
			cls_all(2);
			break;
		case '': case 'u':
		/*
		半ページ上へ
		*/
			for(i=0;i<(LINES/2) - botom;i++)
			{
				y -= 1;
				if(y < 1)
				{
					y = 0;
					break;
				}
			}
			cls_all(2);
			break;
 
		case 'D':
		/*
		５行ダウン
		*/

			if(y+yy > MAX_FILES || y+yy > file_num + 3 || strlen(fs[y+(yy-5)].buff1) < (size_t)1)
			{
				break;
			}
			if(yy < max_lines - (botom + 2))
			{
				if(yy >  max_lines - (botom + 7))
				{
					yy = max_lines - (botom + 7);
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				break;
			}

			y += 5;
			if(y >= MAX_FILES - max_lines)
				y = MAX_FILES - max_lines;
			
			if(yy < (max_lines - (botom + 2)))
				yy = file_num - 5;

			cls_all(2);
			break;

		case '': case 'd':
		/*
		半ページ下へ
		*/
			if(y > (file_num - (max_lines - 7)))
				break;
			if(y > MAX_FILES || y+(yy-5) > (file_num + 4) - (max_lines - botom) + 7)
				break;
			for(i=0;i<(LINES/2)-3;i++)
			{
				y += 1;
				if(y >= MAX_FILES - max_lines)
				{
					y = MAX_FILES - max_lines;
					break;
				}
			}
			if(y > file_num - max_lines)
				y = file_num - (max_lines - 8);
			cls_all(2);
			break;

			case 'k': case 'K': case 0x41:
		/*
		上スクロール
		*/

			if(yy > 5)
			{
				yy--;
				break;
			}

			y -= 1;
			if(y < 1)
				y = 0;
			cls_all(2);
			break;

		 case 'j': case 'J': case 0x42:
		/*
		下スクロール
		*/
			if(y+yy > MAX_FILES || y+yy > file_num + 3)
				break;
			if(yy > file_num + 5)
			{
				break;
			}
			/*
			if(yy < (max_lines - 8) && yy <= file_num + 5)
			*/
			if(yy < (max_lines - (botom + 2)) && yy <= file_num + 5)
			{
				yy++;
				break;
			}

			y += 1;
			if(y >= MAX_FILES - max_lines)
				y = MAX_FILES - max_lines;

			cls_all(2);
			break;

		case '':
		/*
		カレントディレクトリ全ファイルの画面出力
		*/
			if(yy > (LINES-13))
			{
				if(get(2,yy-11) == 0)
					break;
			}
			else
			{
				if(get(2,yy+2) == 0)
					break;
			}
			refresh();
			break;

		case 'P':
		/*
		カレントディレクトリ全ファイルの画面出力
		*/
			if(yy > (LINES-13))
			{
				if(putlog(2,yy-11,fs[y+(yy-5)].buff1) == 0)
					break;
			}
			else
			{
				if(putlog(2,yy+2,fs[y+(yy-5)].buff1) == 0)
					break;
			}
			refresh();
			break;

		case 'C':
		/*
		全ウインドウの再描画
		*/
		allCLS:
			wclear(pt[2].vs);
			max_lines = LINES;
			delwin(pt[2].vs);
			pt[2].vs = newwin(max_lines - botom,90,1,0);
			set_screen(2);
			box(pt[2].vs,ACS_VLINE,ACS_HLINE);
			wrefresh(pt[2].vs);
			delwin(evs);
			evs = newwin(3,90,LINES-1,0);
			displaymenuCMS(evs,dflag);
			for(j=0;j<256;j++)
			{
				memset(selcp[j],'\0',BUFSIZE);
			}
			for(j=0;j<MAX_FILES;j++)
				regline[j] = 0;
			for(j=0;j<MAX_FILES;j++)
				cpflag[j] = 0;
			intCPnum = 0;
			wclrtoeol(pt[2].vs);
			cls_all(2);
			initbuff();

			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			break;

		 case 'Z':
		allCLS2:
			for(j=0;j<256;j++)
			{
				memset(selcp[j],'\0',BUFSIZE);
			}
			for(j=0;j<MAX_FILES;j++)
				regline[j] = 0;
			for(j=0;j<MAX_FILES;j++)
				cpflag[j] = 0;
			for(j=5;j < (file_num - (max_lines - 8));j++)
				vs_print(" ",pt[2].vs,line1[0]+1,j);
			intCPnum = 0;

			if(chkCMSTree())
				dirprint_cms(".",fmode);
			else
				dirprint_all(".",fmode);
			break;
		/*
		検索実行
		*/
		 case 'q': case 'Q':
		/*
		終了
		*/
			if(popmsg(30,LINES - 11,"終了します") == 1)
				goto filerend;
			break;
		}
	}

filerend:
	endwin();
	printf("\033[5>l");
	for(i=0;i<MAX_WINDOW;i++)
		delwin(pt[i].vs);
	delwin(evs);
	initbuff();
	printf("\033[2J");
	return(0);
}

/************************************************************************/
/* NAME      :char *basename()*/
/* FUNCTION  :パス名の最後の名前だけを抜き取る*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :char ポインタ*/
/************************************************************************/
char *CMSLocalFiler::basename(char *s)
{
	char p[BUFSIZE];
	char ss[BUFSIZE];
	char *sr;
	int i;
	int j;
	int k;
	int flg = 0;

	j=k=0;
	for(i=strlen(s);i > 0;i--)
	{
		if(s[i] == '/' || i < 0)
		{
			p[j] = '\0';
			flg = 1;
			break;
		}
		else
		{
			p[j] = s[i];
			j++;
		}
	}
	if(flg == 1)
	{
		k = j-1;
	}
	else
	{
		p[j] = s[i];
		k = j;
	}
	for(i=0;i < j;i++)
	{
		ss[i] = p[k];
		k--;
	}
	ss[i] ='\0';
	strcpy(p,ss);
	sr = p;
	return(sr);
}

void CMSLocalFiler::initcmsbuff(void)
{
	int i;
	for(i=0;i<256;i++)
		memset(cmshomefilename[i],'\0',sizeof(cmshomefilename[i]));
}

int CMSLocalFiler::cmsfile(char *cwdpath,char *filename)
{
	int i;
	char *nl;
	char tmpbuff[256];
	char tmpbuff2[256];

	sprintf(tmpbuff,"%s/%s",cwdpath,filename);
	for(i=0;i<cms_file_num;i++)
	{
		if(strcmp(cmshomefilename[i],tmpbuff) == 0)
		{
			return(1);
		}
	}
	return(0);
}

int CMSLocalFiler::readcmstab(void)
{
	FILE *fp;
	char buff[256];
	char *up, *hp;
	char *nl;
	char cmstablefile[256];
	int j=0;
	char cwdpath[256];
	char tmpbuff[256];

//	cms = new CMSLocalFiler();

	if((hp = getenv("HOME")) == NULL)
	{
		return(0);
	}
	else
	{
		sprintf(cmsuserhomedir,"%s",hp);

		if((up = getenv("CMS_USERNAME")) == NULL)
		{
			return(0);
		}
		else
		{
			sprintf(tmpbuff,"%s",up);
		}
		sprintf(cmstablefile,"%s/%stab",hp,up);
	}

	initcmsbuff();

	if((fp =fopen(cmstablefile,"r")) == (FILE *)NULL)
	{
		return(0);
	}
	while(fgets(buff,256,fp) != (char *)NULL)
	{
		if((nl = strchr(buff,'\n')) != (char *)NULL)
		{
			*nl = '\0';
			sprintf(cmshomefilename[j],"%s/%s",hp,buff);
			j++;
		}
	}
	fclose(fp);
	cms_file_num = j;
	return(cms_file_num);
}

/*
char * Left(char *s, size_t n)
{
	int i;
	char s1[MAX_DATA_BUFF];
	static char s2[MAX_DATA_BUFF];
	char *sr;
	for(i=0; s[i] == '\0'|| i < n;i++)
	{
		s1[i] = s[i];
	}
	s1[i] = '\0';
	strcpy(s2,s1);
	sr = s2;
	return(sr);
}
*/

/************************************************************************/
/* NAME      :int dirprint_cms(char *)*/ 
/* FUNCTION  :ディレクトリを配列に記録する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void CMSLocalFiler::dirprint_cms(const std::string Dname,int type)
{
	struct dirent *dp;
	int i=0;
	int j=0;
	int k=0;
	struct tm *ftm;
	char cwdpath[256];
	char attrbuff[128];

	char cmstree[256];
	char *vp;
	int cmspathlen;
	char tmpbuff[256];

	if((dir = opendir(Dname.c_str())) == (DIR *)NULL)
		exit(1);

//	vp = getenv("CMSPATH");
//	cmspathlen = strlen(vp);
//	cmspathlen = strlen(vp);
//	sprintf(tmpbuff,"%s/fusr",vp);
//	cmspathlen = strlen(tmpbuff);
//	cmspathlen = strlen(tmpbuff);
	if(getcwd(cwdpath,256) == NULL)
		return;
//popmsg(1,1,left2(cmstree,cmspathlen));
//popmsg(1,5,left2(vp,cmspathlen));
	readcmstab();
	/*
	if(!strcmp(left2(cmstree,cmspathlen),left2(vp,cmspathlen)))
	{
		flag = 1;
	}
	*/
	while((dp = readdir(dir)) != (struct dirent *)NULL)
	{
		stat(dp->d_name,fptr);
		if(!S_ISDIR(fptr->st_mode))
		{
			if(dmode == 'v')
			{
				if(cmsfile(cwdpath,dp->d_name))
				{
				sprintf(fs[i].buff1,"%s",dp->d_name);
				sprintf(fs[i].buff2,"%10lu",fptr->st_size);
				switch(type)
				{
				case 'm':
					ftm = localtime(&fptr->st_mtime);
					sprintf(fs[i].buff3,"%2d/%2d-%.2d:%.2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_hour,ftm->tm_min);
					break;
				case 'u':
					ftm = localtime(&fptr->st_atime);
					sprintf(fs[i].buff3,"%2d/%2d-%.2d:%.2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_hour,ftm->tm_min);
					break;
				case 'y':
					ftm = localtime(&fptr->st_mtime);
					if(ftm->tm_year <= 99 && ftm->tm_year > 69)
						sprintf(fs[i].buff3,"%2d/%2d-19%2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year);
					else
						sprintf(fs[i].buff3,"%2d/%2d-%4d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year+1900);
					break;
				default:
					ftm = localtime(&fptr->st_mtime);
					break;
				}
				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(fs[i].buff4,"%-10s",attrbuff);
				sprintf(fs[i].buff5," %s",cmpuid(fptr->st_uid));
				sprintf(fs[i].buff6," %s",cmpgid(fptr->st_gid));
				j++;
				i++;
				}
			}

			if(dp->d_name[0] != '.' && dmode == 'h')
			{
				if(cmsfile(cwdpath,dp->d_name))
				{
				sprintf(fs[i].buff1,"%s",dp->d_name);
				sprintf(fs[i].buff2,"%10lu",fptr->st_size);
				switch(type)
				{
				case 'm':
					ftm = localtime(&fptr->st_mtime);
					sprintf(fs[i].buff3,"%2d/%2d-%.2d:%.2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_hour,ftm->tm_min);
					break;
				case 'u':
					ftm = localtime(&fptr->st_atime);
					sprintf(fs[i].buff3,"%2d/%2d-%.2d:%.2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_hour,ftm->tm_min);
					break;
				case 'y':
					ftm = localtime(&fptr->st_mtime);
					if(ftm->tm_year <= 99 && ftm->tm_year > 69)
						sprintf(fs[i].buff3,"%2d/%2d-19%2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year);
					else
						sprintf(fs[i].buff3,"%2d/%2d-%4d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year+1900);
					break;
				default:
					ftm = localtime(&fptr->st_mtime);
					break;
				}
				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(fs[i].buff4,"%-10s",attrbuff);
				sprintf(fs[i].buff5," %s",cmpuid(fptr->st_uid));
				sprintf(fs[i].buff6," %s",cmpgid(fptr->st_gid));
				j++;
				i++;
				}
			}

		}
		else
		{
			if(getcwd(cwdpath,BUFSIZE) == NULL)
				return;
			if(!strcmp(cutspace(cwdpath),"/"))
			{
				if(dp->d_name[0] == '.')
					continue;
			}
			if(dmode == 'v')
			{
				sprintf(fs[i].buff1,"%s",dp->d_name);
				sprintf(fs[i].buff2,"   %s","<DIR>");
				switch(type)
				{
				case 'm':
					ftm = localtime(&fptr->st_mtime);
					break;
				case 'u':
					ftm = localtime(&fptr->st_atime);
					break;
				default:
					ftm = localtime(&fptr->st_mtime);
					break;
				}
				if(ftm->tm_year <= 99 && ftm->tm_year > 69)
					sprintf(fs[i].buff3,"%2d/%2d-19%2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year);
				else
					sprintf(fs[i].buff3,"%2d/%2d-%4d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year+1900);

				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(fs[i].buff4,"%-10s",attrbuff,1);
				sprintf(fs[i].buff5," %s",cmpuid(fptr->st_uid));
				sprintf(fs[i].buff6," %s",cmpgid(fptr->st_gid));
				k++;
				i++;
			}
			if(dp->d_name[0] != '.' && dmode == 'h')
			{
				sprintf(fs[i].buff1,"%s",dp->d_name);
				sprintf(fs[i].buff2,"   %s","<DIR>");
				switch(type)
				{
				case 'm':
					ftm = localtime(&fptr->st_mtime);
					break;
				case 'u':
					ftm = localtime(&fptr->st_atime);
					break;
				default:
					ftm = localtime(&fptr->st_mtime);
					break;
				}
				if(ftm->tm_year <= 99 && ftm->tm_year > 69)
					sprintf(fs[i].buff3,"%2d/%2d-19%2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year);
				else
					sprintf(fs[i].buff3,"%2d/%2d-%4d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year+1900);

				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(fs[i].buff4,"%-10s",attrbuff,1);
				sprintf(fs[i].buff5," %s",cmpuid(fptr->st_uid));
				sprintf(fs[i].buff6," %s",cmpgid(fptr->st_gid));
				k++;
				i++;
			}

		}
		if(i > MAX_FILES - 1)
		{
			file_num = j+k;
			closedir(dir);
			return;
		}
	}
	file_num = j+k;
	closedir(dir);
	for(i=29;i>0;i--)
	{
		fsort(file_num,i);
	}
	fsort(file_num,0);
}

/************************************************************************/
/* NAME      :int main()*/ 
/* FUNCTION  :ファイラーのメインルーチン*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
int main(void)
{
	int i,j,k;
	int ret;
	char *vp;

	CMSLocalFiler *cms;

	setlocale(LC_ALL,"");

	cms = new CMSLocalFiler();

	initscr();
	cbreak();
	noecho();

	cms->bookmark();

	if((vp = getenv("HOME")) == NULL)
	{
		cms->sys_errmsg(4,10,"環境変数 HOME が設定されていません /home を使用します");
		sprintf(cms->homedirname,"/home");
	}
	else
	{
		sprintf(cms->homedirname,"%s",vp);
	}
	cms->max_lines = LINES;

	cms->readowner();
	cms->readgroup();
	if(getcwd(cms->startdirname,256) == NULL)
		exit(2);

	cms->cmsset();

	i = j = k= 0;
	while(1)
	{
		ret = cms->cmsfiler(1,cms->max_lines);
	//	ret = cms->filer(1,max_lines);
		switch(ret)
		{
		case 0:
			goto end;
		default:
			break;
		}
	}
	end:
	endwin();
	printf("\n");
	return(0);
}
