#pragma ident "@(#) cmsmenu.c 1.0.6 2012.12.10,15:01"
/*
	
  名称
      cmsmenu.c
      
  概要
	  ＣＭＳ（チェンジマネージメントシステム）
      
  構文
      cmsmenu
      
  説明
	Korn-Shellプログラムのコマンドラインを簡略化するためのメニューです。
	但し、commit.ksh だけはコマンドラインのみの実行になります。
      
  多言語化対応
     UTF-8 にて記述保存されています。 

  診断
      

  例
	commit.ksh filename username version
      

  参照
      sh(1), ksh(1), sed(1), diff(1), ed(1), ncurses(3x)
      
  バグ
      CMS for MS-DOS は1991年に開発終了しています。
      CMS for NetWare は1992年に開発終了しています。
      CMS for Sun-OS は1996/4/5 現在未完成です
      
  著者
	  1990,1991,1992,1996,1999,2009(C)
      CMS は AT&T によって提案され、Shigeki Ono によって再現改良されました。
      
  標準準拠
      


  作者後書
	この cmsmmenu から実行されるプログラムだけが CMS ではありません。
	CMS は /home 配下に作成される cms というディレクトリツリーが本体です。
	CMS はLinux のシステムになるべく影響を与えないよう設計しました。
	そのため、Linux 間の CMS システムの移動は非常に簡単です。

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <memory.h>
#include <malloc.h>
#include <locale.h>
/*
#include "console.h"
#include "unistd.h"
#include <sys/inode.h>
#include "userdir.h"
*/
#include <time.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#ifndef CYGWIN
#include <curses.h>
#else
#include <ncurses/curses.h>
#endif
#include <signal.h>

#define		BUFSIZE			512
#define		TABSTOP			4
#define		CR				0x0d
#define		TAB				0x09
#define		ESC				0x1b

#ifdef MSDOS
#define		CLEAR_LINE		"\033[0K"
#define		CLS				printf("\033[2J")
#define		LINE_CLEAR		printf("%c\033[0K", CR)
#define		CUR_ON			printf("\033[>5l")
#define		CUR_OFF			printf("\033[>5h")

#define		xmalloc(x, s)	((x)malloc(s))
#define		xfree(p)		free((char *)p)
#define		locate(a, b)	printf("\033[%d;%dH", b, a)
#define		clear_line() 	printf("%c%s", CR, CLEAR_LINE)
#define		bell()			putchar(0x07)
#endif

int N = 1;

int main();
void update_revision();
void update_mr();
void cleanbuff();
void cms_editor();
void cmsmore();
void compile();
void envset();
void envset2();
void get();
void *input_window();
void listfile();
void make();
int menu_display();
int menu_display_sel();
void mr();
void tr();
void mredit();
void tredit();
void mrcsvout();
void trcsvout();
void mrreport();
void newfile();
int popmenu();
char *popmenu2();
char *popmenu3();
char *popmenu4();
char *popmenu5();
void errmsg();
int popmsg();
void put();
void submit();
void putprint();
void reject();
void rejectmr();
void showget();
void showput();
void tabclean();
void tabedit();
void unget();
void vget();
void putlog();
char *vs_ieee_c();
int vs_print();
int vs_status();

int menuline = 1;

extern int menu_display();
extern int menu_display_sel();

static char lockdir[512];
static char mrdir[512];
static char trdir[512];
char cmspathname[256];

char table_filename[512];
char table_buff[128][64];
char filebuff[1024];
char depath[512];
char revisionbuff[512];
char mr_revisionfile[512];
char mr_editfile[512];
char tr_revisionfile[512];
char tr_editfile[512];
char sysname[64];
char tabfile[64];
char editor[9];
char cmseditor[64];
char filename2[64];
char username[64];
char version[12];

char systembuff[512];

char list[100][64];	/*ファイル名のリスト用*/
char list2[100][12];	/*リビジョン番号のリスト用*/
char mrlist[1000][64];	/*ＭＲのリスト用*/
char mrlist2[1000][12];	/*ＭＲ番号のリスト用*/

int N;
int N2;
int M2;

char cmsmenu[20][128] = {
	"                            CMS for CWRA v1.1  ",
	"     a. GETの実行                              ",
	"     b. PUTの実行                              ",
	"     c. PUT修正記録の編集                      ",
	"     d. リビジョンの呼び出し                   ",
	"     e. ＭＲの編集                             ",
	"     f. ＭＲの登録                             ",
	"     g. GETの取り消し                          ",
	"     h. GET履歴の表示                          ",
	"     i. PUT履歴の表示                          ",
	"     j. MAKE                                   ",
	"     k. ソースの編集                           ",
	"     l. ＴＲの編集                             ",
	"     m. ＴＲの登録                             ",
	"     n. CMSへファイルの登録                    ",
	"     o. CMSテーブルファイルの編集              ",
	"     p. ＭＲ記録のレポート                     ",
	"     q. ＭＲの削除                             ",
	"     r. リビジョンの削除                       ",
	"     s. SUBMITの実行                           "};

void tabopen(void)
{
	FILE *fp;
	char *newline;
	char buff[64];
	int n;

	if ((fp = fopen(filebuff, "r")) == NULL)
	{
		errmsg("tabopen eroor");
		return;
	}
	tabclean();
	n = 0;
	while((fgets(buff, 64, fp)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			sprintf(list[n],"%s",buff);
			n++;
		}
	}
	N = n - 1;
	fclose(fp);
}

int main(void)
{
	FILE *fp;
	char *newline, *comenv;
	char buff[64], commandbuff[256];
	int i, n, status, number;
	int ret = 0;

 	setlocale(LC_ALL,"");

	initscr();
	cbreak();
	noecho();

	tabclean();
	envset();
	envset2();

	if ((fp = fopen(filebuff, "r")) == NULL) {
		echo();
		cbreak();
		endwin();
		exit(2);
	}
	n = 0;
	while((fgets(buff, 64, fp)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			sprintf(list[n],"%s",buff);
			n++;
		}
	}
	N = n - 1;
	fclose(fp);

	ret = 0;
	while(ret != 20)
	{
		number = popmenu((((80 / 2) / 2) - 4),((LINES / 2) / 2) - 4, "CMS for SunOS");
		menuline = number;
		switch(number)
		{
		case -1:	/*q*/
			goto end;
		case 1:		/*a*/
			get();
			break;
		case 2:		/*b*/
			put();
			break;
		case 3:		/*c*/
			putlog();
			break;
		case 4:		/*d*/
			vget();
			break;
		case 5:		/*e*/
			mredit();
			break;
		case 6:		/*f*/
			noraw();
			echo();
			nonl();
			nocbreak();
			mr();
			raw();
			noecho();
			nl();
			cbreak();
			break;
		case 7:		/*g*/
			unget();
			break;
		case 8:		/*h*/
			showget();
			break;
		case 9:		/*i*/
			showput();
			break;
		case 10:	/*j*/
			make();
			break;
		case 11:	/*k*/
			cms_editor();
			break;
		case 12:	/*l*/
			tredit();
			break;
		case 13:	/*m*/
			tr();
			break;
		case 14:	/*n*/
			newfile();
			break;
		case 15:	/*o*/
			tabedit();
			break;
		case 16:	/*p*/
			mrreport();
			break;
		case 17:	/*q*/
			rejectmr();
			break;
		case 18:	/*r*/
			reject();
			break;
		case 19:	/*s*/
			submit();
			break;
		case 20:	/*t*/
			break;
		case 21:	/*u*/
			break;
		case 22:	/*v*/
			break;
		}
	}
	end:
	echo();
	cbreak();
	endwin();
	exit(0);
}

void make(void)
{
	int ret;
	char filename[64];
	char *dot;

	tabopen();
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"MAKE",24,22));
	if(strlen(filename) < (size_t)1)
		return;
	if ((dot = strchr(filename, '.')) != NULL)
	{
		*dot = '\0';
	}

	sprintf(systembuff,"make %s | less",filename);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void showget(void)
{
	int ret;
	char filename[64];

	tabopen();
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"SHOWGET",24,22));
	if(strlen(filename) < (size_t)1)
		return;

	sprintf(systembuff,"showget.ksh %s %s",filename,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void showput(void)
{
	int ret;
	char filename[64];

	tabopen();
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"SHOWPUT",24,22));
	if(strlen(filename) < (size_t)1)
		return;

	sprintf(systembuff,"showput.ksh %s %s",filename,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void compile(void)
{
	int ret;
	char filename[64];
	char *dot;

	tabopen();
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"CC",24,22));
	if(strlen(filename) < (size_t)1)
		return;
	if ((dot = strchr(filename, '.')) != NULL)
	{
		*dot = '_';
	}
	strcat(filename, ".c");

	sprintf(systembuff,"cc %s",filename);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void get(void)
{
	int ret;
	char *vp;
	char filename[64];

	tabopen();
	sprintf(filename, "%s",popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"GET",52,22));
	if(strlen(filename) < (size_t)1)
		return;
	sprintf(systembuff,"get.ksh %s %s %s",filename,username,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void put(void)
{
	int ret;
	char filename[64];

	tabopen();
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"PUT",52,22));
	if(strlen(filename) < (size_t)1)
		return;
	sprintf(systembuff,"put.ksh %s %s %s",filename,username,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void submit(void)
{
	int ret;
	char *vp;
	char filename[64];

	tabopen();
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"SUBMIT",52,22));
	if(strlen(filename) < (size_t)1)
		return;
	sprintf(systembuff,"submit.ksh %s %s %s",filename,username,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}


void cms_editor(void)
{
	int ret;
	char filename[64];

	tabopen();
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"TEXT EDIT",52,22));
	if(strlen(filename) < (size_t)1)
		return;

	sprintf(systembuff,"%s %s",editor,filename);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("echo [m;/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	nonl();
	noecho();
	cbreak();
	clear();
}


void listfile(void)
{
	int ret;
#ifdef MSDOS
	locate(1, 1);
#endif
	sprintf(systembuff,"listfile.ksh");
	noraw();
	echo();
	nl();
	nocbreak();
	clear();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void putprint(void)
{
	int ret;
#ifdef MSDOS
	locate(1, 1);
#endif
	sprintf(systembuff,"putprint.ksh");
	noraw();
	echo();
	nl();
	nocbreak();
	clear();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void unget(void)
{
	int ret;
	char filename[64];

	tabopen();
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"UNGET",52,22));
	if(strlen(filename) < (size_t)1)
		return;
	sprintf(systembuff,"unget.ksh %s %s %s",filename,username,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void vget(void)
{
	FILE *fp2;
	int i, n, ret;
	char filename[64];
	char revision[3];
	char buff[64], cutbuff[3];
	char *newline;
	size_t len;

	ret = 0;

	tabopen();
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"VGET",52,22));
	if(strlen(filename) < (size_t)1)
		return;
	sprintf(filename2,"%s",filename);
	if ((newline = strchr(filename, ' ')) != NULL)
	{
		*newline = '\0';
	}
	/*
	if ((newline = strchr(filename2, '.')) != NULL)
	{
		*newline = '_';
	}
	*/
	sprintf(revisionbuff,"%s/%s/%s/verfile.%s",lockdir,sysname,filename,version);

	if ((fp2 = fopen(revisionbuff, "r")) == NULL) {
		errmsg(revisionbuff);
		cleanbuff();
		return;
	}
	n = 0;
	while((fgets(buff, 64, fp2)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		len = (size_t)strlen(buff) - 2;
		for (i=0;i < len;i++)
		{
			cutbuff[i] = buff[i+len];
		}
		cutbuff[i] = '\0';
		sprintf(list2[n],"%s",cutbuff);
		n++;
	}
	N2 = n -1;
	fclose(fp2);

#ifdef DEBUG
	locate(1, 24);clear_line();
	printf("AF version = %s", version);getch();
#endif

	cleanbuff();

	strcpy(revision, popmenu3(((80/2)/2) - 4,((LINES/2)/2) - 4,"",4,22));
	if(strlen(revision) < (size_t)1)
		return;
	sprintf(systembuff,"vget.ksh %s %s %s %s",filename,username,version,revision);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void putlog(void)
{
	FILE *fp2;
	int i, n, ret;
	char filename[64];
	char revision[3];
	char buff[64], cutbuff[3];
	char *newline;


	ret = 0;
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"PUTLOG",52,22));
	if(strlen(filename) < (size_t)1)
		return;
	sprintf(filename2,"%s",filename);
	if ((newline = strchr(filename, ' ')) != NULL)
	{
		*newline = '\0';
	}
	if ((newline = strchr(filename2, '.')) != NULL)
	{
		*newline = '_';
	}
	sprintf(revisionbuff,"%s/%s/%s/verfile.%s",lockdir,sysname,filename2,version);

	if ((fp2 = fopen(revisionbuff, "r")) == NULL) {
		cleanbuff();
		return;
	}
	n = 0;
	while((fgets(buff, 64, fp2)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		for (i=0;i < 2;i++)
		{
			cutbuff[i] = buff[i+2];
		}
		cutbuff[i] = '\0';
		sprintf(list2[n],"%s",cutbuff);
		n++;
	}
	N2 = n - 1;
	fclose(fp2);

#ifdef DEBUG
	locate(1, 24);clear_line();
	printf("AF version = %s", version);getch();
#endif

	cleanbuff();

	strcpy(revision, popmenu3(((80/2)/2) - 4,((LINES/2)/2) - 4,"",4,22));
	if(strlen(revision) < (size_t)1)
	{
		update_revision();
		return;
	}
	sprintf(systembuff,"putlog.ksh %s %s %s %s",filename,username,version,revision);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}


void mredit(void)
{
	FILE *fp3;
	int i,j, n, ret;
	char *newline;
	char filename[64];
	char revision[4];
	char mrfiles[64];
	char cutbuff[64];
	char buff[33];

	sprintf(mr_revisionfile,"%s/%s/mrfiles",mrdir,sysname);

	if ((fp3 = fopen(mr_revisionfile, "r")) == NULL) {
		errmsg(mr_revisionfile);
		return;
	}
	n = 0;
	while((fgets(buff, 31 + 1, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

//	strcpy(revision, popmenu5(((80/2)/2) - 4,((LINES/2)/2) - 4,"",5,22));
	strcpy(revision, popmenu5(20,12,"",5,22));

	if(strlen(revision) < (size_t)1)
		return;

	sprintf(systembuff,"mredit.ksh %s %s %s",revision,username,version);

	if (popmsg(((80)/2)/2 + 7,LINES/2 - 4,"ＭＲの編集開始") == 1)
	{
		;
	}
	else
	{
		goto skip1;
	}
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
skip1:
	cleanbuff();
		
}

void tredit(void)
{
	FILE *fp3;
	int i,j, n, ret;
	char *newline;
	char filename[64];
	char revision[4];
	char trfiles[64];
	char cutbuff[64];
	char buff[33];

	sprintf(tr_revisionfile,"%s/%s/trfiles",trdir,sysname);

	if ((fp3 = fopen(tr_revisionfile, "r")) == NULL) {
		errmsg(tr_revisionfile);
		return;
	}
	n = 0;
	while((fgets(buff, 31 + 1, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

	strcpy(revision, popmenu5(((80/2)/2) - 4,((LINES/2)/2) - 4,"",5,22));

	if(strlen(revision) < (size_t)1)
		return;

	sprintf(systembuff,"tredit.ksh %s %s %s",revision,username,version);

	if (popmsg(((80)/2)/2 + 7,LINES/2 - 4,"TRの編集開始") == 1)
	{
		;
	}
	else
	{
		goto skip1;
	}
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
skip1:
	cleanbuff();
		
}
void rejectmr(void)
{
	FILE *fp3;
	int i, n, ret;
	char *newline;
	char filename[64];
	char revision[4];
	char mrfiles[64];
	char cutbuff[64];
	char buff[64];

	sprintf(mr_revisionfile,"%s/%s/mrfiles",mrdir,sysname);


	if ((fp3 = fopen(mr_revisionfile, "r")) == NULL) {
		errmsg(mr_revisionfile);
		return;
	}
	n = 0;
	while((fgets(buff, 64, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

	strcpy(filename, popmenu5(((80/2)/2) - 4,((LINES/2)/2) - 4,"",5,22));
	if(strlen(filename) < (size_t)1)
		return;
	sprintf(systembuff,"rejectmr.ksh %s %s %s",filename,username,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
	update_mr();
}

void mr(void)
{
	int ret;
	char filename[64];
	char revision[4];
	char mrnum[8];

#ifdef MSDOS
	printf("\033[>1h");
#endif

	input_window(((80/2)/2) - 4,((LINES/2)/2) - 4,mrnum,"新しい MR [001 - 999]を入力");
	if(strlen(mrnum) < (size_t)1)
		return;

	sprintf(systembuff,"mr.ksh %s %s %s",mrnum,username,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void tr(void)
{
	int ret;
	char filename[64];
	char revision[4];
	char trnum[8];

#ifdef MSDOS
	printf("\033[>1h");
#endif

	input_window(((80/2)/2) - 4,((LINES/2)/2) - 4,trnum,"新しい TR [001 - 999]を入力");
	if(strlen(trnum) < (size_t)1)
		return;

	sprintf(systembuff,"tr.ksh %s %s %s",trnum,username,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void update_revision(void)
{
	int i;

	for (i=0;i < 100;i++)
	{
		memset(list2[i],'\0',12);
	}
}

void update_mr(void)
{
	int i;

	for (i=0;i < 1000;i++)
	{
		memset(mrlist2[i],'\0',12);
	}
}

void cleanbuff(void)
{
	int i;

	memset(filename2,'\0',sizeof(filename2));

	memset(systembuff,'\0',sizeof(systembuff));
	memset(revisionbuff,'\0',sizeof(revisionbuff));
	memset(mr_revisionfile,'\0',sizeof(mr_revisionfile));
	memset(mr_editfile,'\0',sizeof(mr_editfile));
	memset(tr_revisionfile,'\0',sizeof(tr_revisionfile));
	memset(tr_editfile,'\0',sizeof(tr_editfile));
}

void mrcsvout(void)
{
	FILE *fp3;
	int i, n, ret, ret2;
	char *newline;
	char filename[64];
	char revision[4];
	char mrfiles[64];
	char cutbuff[64];
	char buff[64];


	sprintf(mr_revisionfile,"%s/%s/mrfiles",mrdir,sysname);

	if ((fp3 = fopen(mr_revisionfile, "r")) == NULL) {
		errmsg(mr_revisionfile);
		return;
	}
	n = 0;
	while((fgets(buff, 64, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

	strcpy(revision, popmenu5(((80/2)/2) - 4,((LINES/2)/2) - 4,"",5,22));

	if(strlen(revision) < (size_t)1)
		return;

	sprintf(mr_editfile,"mrcsvout.ksh -s %s %s %s",revision,sysname,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(mr_editfile);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
	cleanbuff();
}

void trcsvout(void)
{
	FILE *fp3;
	int i, n, ret, ret2;
	char *newline;
	char filename[64];
	char revision[4];
	char mrfiles[64];
	char cutbuff[64];
	char buff[64];


	sprintf(mr_revisionfile,"%s/%s/mrfiles",mrdir,sysname);

	if ((fp3 = fopen(mr_revisionfile, "r")) == NULL) {
		errmsg(mr_revisionfile);
		return;
	}
	n = 0;
	while((fgets(buff, 64, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

	strcpy(revision, popmenu5(((80/2)/2) - 4,((LINES/2)/2) - 4,"",5,22));

	if(strlen(revision) < (size_t)1)
		return;

	sprintf(mr_editfile,"trreport.ksh -s %s %s %s",revision,sysname,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(mr_editfile);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
	cleanbuff();
}

void mrreport(void)
{
	FILE *fp3;
	int i, n, ret, ret2;
	char *newline;
	char filename[64];
	char revision[4];
	char mrfiles[64];
	char cutbuff[64];
	char buff[64];


	sprintf(mr_revisionfile,"%s/%s/mrfiles",mrdir,sysname);

	if ((fp3 = fopen(mr_revisionfile, "r")) == NULL) {
		errmsg(mr_revisionfile);
		return;
	}
	n = 0;
	while((fgets(buff, 64, fp3)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			for (i=0;i < 3;i++)
			{
				cutbuff[i] = buff[i];
			}
			cutbuff[i] = '\0';
			sprintf(mrlist2[n],"%s",cutbuff);
			n++;
		}
	}
	M2 = n - 1;
	fclose(fp3);

	strcpy(revision, popmenu5(((80/2)/2) - 4,((LINES/2)/2) - 4,"",5,22));

	if(strlen(revision) < (size_t)1)
		return;

	sprintf(mr_editfile,"mrreport.ksh -s %s %s %s",revision,sysname,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(mr_editfile);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
	cleanbuff();
}

void newfile(void)
{
	int ret;
	char filename[64];

	/*
	input_window(((80/2)/2) - 4,((LINES/2)/2) - 4,filename,"新しいファイル名を入力");
	*/
	tabopen();
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"PUTLOG",52,22));
	if(strlen(filename) < (size_t)1)
		return;
	sprintf(systembuff,"newfile.ksh %s %s %s",filename,username,version);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void reject(void)
{
	FILE *fp2;
	int i, n, ret;
	char filename[64];
	char revision[3];
	char buff[64], cutbuff[3];
	char *newline;

	tabopen();
	strcpy(filename, popmenu2(((80/2)/2) - 4,((LINES/2)/2) - 4,"REJECT",52,22));
	if(strlen(filename) < (size_t)1)
		return;
	sprintf(filename2,"%s",filename);

	if ((newline = strchr(filename, ' ')) != NULL)
	{
		*newline = '\0';
	}
	if ((newline = strchr(filename2, '.')) != NULL)
	{
		*newline = '_';
	}

	sprintf(revisionbuff,"%s/%s/%s/verfile.%s",lockdir,sysname,filename2,version);

	if ((fp2 = fopen(revisionbuff, "r")) == NULL) {
		cleanbuff();
		return;
	}
	n = 0;
	while((fgets(buff, 64, fp2)) != NULL)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		for (i=0;i < 2;i++)
		{
			cutbuff[i] = buff[i+2];
		}
		cutbuff[i] = '\0';
		sprintf(list2[n],"%s",cutbuff);
		n++;
	}
	N2 = n - 1;
	fclose(fp2);

	strcpy(revision, popmenu3(((80/2)/2) - 4,((LINES/2)/2) - 4,"",4,22));
	if(strlen(revision) < (size_t)1)
		return;

	cleanbuff();
	sprintf(systembuff,"reject.ksh %s %s %s %s",filename,username,version,revision);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(systembuff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
	update_revision();
}


void cmsmore(void)
{
	int ret;
	char buff[256];

#ifdef DEBUG
	locate(1, 24);clear_line(); printf("mr_editfile = %s",mr_editfile);getch();
#endif
	sprintf(buff,"less %s",mr_editfile);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(buff);
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void tabedit(void)
{
	FILE *fp4, *fp5;

	int i, n, len, maxlen;
	int ret;
	int color = 7;
	char buff[256];
	char *newline;

	tabclean();

	sprintf(table_filename,"%s",tabfile);

	sprintf(buff,"echo [m;vi %s",table_filename);
	noraw();
	echo();
	nl();
	nocbreak();
	ret = system("/bin/stty echo onlcr icrnl");
	ret = system(buff);
	ret = system("tabchg.ksh");
	raw();
	noecho();
	nonl();
	cbreak();
	clear();
}

void envset(void)
{
	char *envbuff;
	char envbuff2[64];

#ifdef DEBUG
	locate(1, 24);clear_line();
	printf("CMS_TABFILE = %s", getenv("CMS_TABFILE"));getch();
#endif

	if ((envbuff = getenv("CMS_VERSION")) == (char *)NULL)
		strcpy(version, "0");
	else
		strcpy(version, envbuff);

	if ((envbuff = getenv("CMSPATH")) == (char *)NULL)
	{
		strcpy(cmspathname, "/cms");
		strcpy(lockdir, "/cms/diff/lock");
		strcpy(mrdir, "/cms/diff/mr/ver_0");
		strcpy(trdir, "/cms/diff/tr/ver_0");
	}
	else
	{
		strcpy(cmspathname, envbuff);
		sprintf(lockdir,"%s/diff/lock", cmspathname);
		sprintf(mrdir,"%s/diff/mr/ver_%s", cmspathname,version);
		sprintf(trdir,"%s/diff/tr/ver_%s", cmspathname,version);
	}

	if ((envbuff = getenv("CMS_USERNAME")) == (char *)NULL)
		strcpy(username, "cms");
	else
		strcpy(username, envbuff);

	if ((envbuff = getenv("CMS_TABFILE")) == (char *)NULL)
	{
		strcpy(tabfile, "sampletab");
		sprintf(filebuff,"%s/diff/tabs/%s",cmspathname,tabfile);
	}
	else
	{
		strcpy(tabfile, envbuff);
		sprintf(filebuff,"%s/diff/tabs/%s",cmspathname,tabfile);
	}

	if ((envbuff = getenv("CMS_EDITOR")) == (char *)NULL)
		strcpy(editor, "vi");
	else
		strcpy(editor, envbuff);
	strcat(cmseditor, editor);

}

void envset2(void)
{
	char *envbuff;

	if ((envbuff = getenv("CMS_SYSNAME")) == (char *)NULL)
		strcpy(sysname, "cms");
	else
		strcpy(sysname, envbuff);

}

void tabclean(void)
{
	int i;
	for (i=0;i<64;i++)
		table_filename[i] = '\0';
	for (i=0;i<100;i++)
		memset(list[i],'\0',64);
}

char buff[10][128];

/************************************************************************/
/* NAME      :int vs_print()*/
/* FUNCTION  :指定したウインドウの指定位置に文字列を書き込む*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
int vs_print(p,no,x,y,N)
char *p;	/*文字列へのポインタ*/
int no;/*ウインドウへのポインタ*/
int x;		/*表示桁*/
int y;		/*表示行*/
int N;		/*ダミー*/
{
	WINDOW *vs;
	mvwprintw(vs,y,x,p);
	return (0);
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
char *vs_ieee_c(int no,int x,int y,char *str,int N)
{
	WINDOW *vs;
	char p[80];
	char *pr;
	if(mvwgetstr(vs,y,x,p) != 0)
	{
		pr = p;
		return((char *)pr);
	}
	return((char *)NULL);
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
int vs_status(int no,char *s)
{
	WINDOW *vs;
	short ch;
	int i;
	int cnt = 0;
	int len;
	int option = 0;
	int x,y;

	len = strlen(s);
	for(i=0;i<len;i++)
	{
		switch(s[i])
		{
		case 'c':
			getyx(vs,y,x);
			return(x);
			break;
		case 'r':
			break;
		case 'x':
			getyx(vs,y,x);
			return(x);
		case 'y':
			getyx(vs,y,x);
			return(y);
		}
	}
	ch = wgetch(vs);
	switch(ch)
	{
	case 'a':
		return 1;
	case 'b':
		return 2;
	case 'c':
		return 3;
	case 'd':
		return 4;
	case 'e':
		return 5;
	case 'f':
		return 6;
	case 'g':
		return 7;
	case 'h':
		return 8;
	case 'i':
		return 9;
	case 'j':
		return 10;
	case 'k':
		return 11;
	case 'l':
		return 12;
	case 'm':
		return 13;
	case 'n':
		return 14;
	case 'o':
		return 15;
	case 'p':
		return 16;
	case 'q':
		return 17;
	case 'r':
		return 18;
	case 's':
		return 19;
	case 't':
		return 20;
	case 'u':
		return 21;
	case 'v':
		return 22;
	case 'w':
		return 23;
	case 'x':
		return 24;
	case 'y':
		return 25;
	case 'z':
		return 26;
	}
}


/************************************************************************/
/* NAME      :int popmenu()*/ 
/* FUNCTION  :ユーザに選択を促すポップメニューを表示する*/ 
/*            未使用*/ 
/*            */ 
/*            */ 
/* RETURN    :メニューのFILE*/


/************************************************************************/
int popmenu(x,y,buff)
int x;	/*表示桁位置*/
int y;	/*表示行位置*/
char *buff;	/*表示するメッセージ*/
{
	WINDOW *pvs;
	int ch;
	int item = 1;
	int x2;
	int i;
	int j = menuline;

	pvs = newwin(22,52,y,x);
	noecho();
	wclear(pvs);
	wrefresh(pvs);
	for(;;)
	{
		for(i=0;i<21;i++)
		{
			mvwprintw(pvs,i+1,2,"%s",cmsmenu[i]);
		}

		wmove(pvs,j+1,1);
		box(pvs,'|','-');
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,j+1,2,"%s",cmsmenu[j]);
		wattroff(pvs,A_REVERSE);

		wrefresh(pvs);
		ch = wgetch(pvs);
		getyx(pvs,item,x2);
		switch(ch)
		{
		case '':
			wclear(pvs);
			wattron(pvs,A_REVERSE);
			box(pvs,' ',' ');
			wattroff(pvs,A_REVERSE);
			wrefresh(pvs);
			break;

		case 'a':
			j = 1;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'b':
			j = 2;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'c':
			j = 3;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'd':
			j = 4;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'e':
			j = 5;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'f':
			j = 6;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'g':
			j = 7;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'h':
			j = 8;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'i':
			j = 9;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'J':
			j = 10;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'K':
			j = 11;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'l':
			j = 12;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'm':
			j = 13;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'n':
			j = 14;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'o':
			j = 15;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'p':
			j = 16;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'Q':
			j = 17;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 'r':
			j = 18;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;
		case 's':
			j = 19;
			wmove(pvs,j+1,2);
			wrefresh(pvs);
			break;

		case ' ':
			if(j <18)
				j++;
			else
				j = 1;
			break;
		case 'j': case 0x42:
			if(j <19)
				j++;
			break;
		case 'k': case 0x41:
			if(j > 1)
				j--;
			break;
		case 0x0d: case 0x0a: case 'Z':
			wclear(pvs);
			delwin(pvs);
			return j;
		case 'q':
			if(popmsg(((80)/2)/2 + 8,LINES/2 - 4,"Quit Y or N") == 1)
			{
				delwin(pvs);
				return -1;
			}
			wattron(pvs,A_REVERSE);
			box(pvs,' ',' ');
			wattroff(pvs,A_REVERSE);
			wrefresh(pvs);
			break;
		defualt:
			break;
		}
	}
}


char *popmenu2(x,y,buff,xwidth,ylen)
/*
int x;	表示桁位置
int y;	表示行位置
char *buff;	表示するメッセージ
int xwidth; ウインドウの横幅
int ylen; ウインドウの縦の長さ
*/
{
	WINDOW *pvs;
	int ch;
	int item = 1;
	int x2;
	int i;
	int j = 0;
	char rbuff[64];
	int yy = 0;
	char *rp;

	pvs = newwin(ylen,xwidth,y,x);
	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');
	mvwprintw(pvs,0,0,"- %s -",buff);
	wattroff(pvs,A_REVERSE);
	for(;;)
	{
		for(i=0;i<20;i++)
		{
			mvwprintw(pvs,i+1,1,"                                                  ");
			mvwprintw(pvs,i+1,1,"%s",list[i+yy]);
		}

		wmove(pvs,j+1,2);
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,j+1,1,"%s",list[j+yy]);
		wattroff(pvs,A_REVERSE);

		wrefresh(pvs);
		ch = wgetch(pvs);
		getyx(pvs,item,x2);
		switch(ch)
		{
		case 'j': case 0x42:
			if (j+yy >= N)
				break;
			if(j > ylen - 4)
			{
				yy++;
				break;
			}
			if(j <= ylen - 4)
			{
				j++;
			}
			break;
		case 'k': case 0x41:
			if(j > ylen - 4 && yy != 0)
			{
				yy--;
				break;
			}
			if(j > 0)
			{
				j--;
			}
			break;
		case '5':
			errmsg(list[j+yy]);
			break;
		case 0x0d: case 0x0a: case'Z':
			delwin(pvs);
			sprintf(rbuff,"%s",list[j+yy]);
			rp = rbuff;
			return (rp);
		case 'q':
			delwin(pvs);
			return ("");
		defualt:
			break;
		}
	}
}


char *popmenu3(x,y,buff,xwidth,ylen)
int x;	/*表示桁位置*/
int y;	/*表示行位置*/
char *buff;	/*表示するメッセージ*/
int xwidth; /*ウインドウの横幅*/
int ylen; /*ウインドウの縦の長さ*/
{
	WINDOW *pvs;
	int ch;
	int item = 1;
	int x2;
	int i;
	int j = 0;
	char rbuff[64];
	int yy = 0;
	char *rp;

	pvs = newwin(ylen,xwidth,y,x);
	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');
	wattroff(pvs,A_REVERSE);
	for(;;)
	{
		for(i=0;i<20;i++)
		{
			mvwprintw(pvs,i+1,1,"  ");
			mvwprintw(pvs,i+1,1,"%s",list2[i+yy]);
		}

		wmove(pvs,j+1,2);
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,j+1,1,"%s",list2[j+yy]);
		wattroff(pvs,A_REVERSE);

		wrefresh(pvs);
		ch = wgetch(pvs);
		getyx(pvs,item,x2);
		switch(ch)
		{
		case ' ':
			if(j <=ylen)
				j++;
			else
				j = 0;
			break;
		case 'j': case 0x42:
			if (j+yy >= N2)
				break;
			if(j > ylen - 4)
			{
				yy++;
				break;
			}
			if(j <=ylen)
				j++;
			break;
		case 'k': case 0x41:
			if(j > ylen - 4 && yy != 0)
			{
				yy--;
				break;
			}
			if(j > 0)
				j--;
			break;
		case 0x0d: case 0x0a: case'Z':
			delwin(pvs);
			sprintf(rbuff,"%s",list2[j+yy]);
			rp = rbuff;
			return (rp);
		case 'q':
			delwin(pvs);
			return ("");
		defualt:
			break;
		}
	}
}

char *popmenu4(x,y,buff,xwidth,ylen)
int x;	/*表示桁位置*/
int y;	/*表示行位置*/
char *buff;	/*表示するメッセージ*/
int xwidth; /*ウインドウの横幅*/
int ylen; /*ウインドウの縦の長さ*/
{
	WINDOW *pvs;
	int ch;
	int item = 1;
	int x2;
	int i;
	int j = 0;
	char rbuff[64];
	int yy = 0;
	char *rp;

	pvs = newwin(ylen,xwidth,y,x);
	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');
	wattroff(pvs,A_REVERSE);
	for(;;)
	{
		for(i=0;i<20;i++)
		{
			mvwprintw(pvs,i+1,1,"  ");
			mvwprintw(pvs,i+1,1,"%s",mrlist[i+yy]);
		}

		wmove(pvs,j+1,2);
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,j+1,1,"%s",mrlist[j+yy]);
		wattroff(pvs,A_REVERSE);

		wrefresh(pvs);
		ch = wgetch(pvs);
		getyx(pvs,item,x2);
		switch(ch)
		{
		case ' ':
			if(j <=ylen)
				j++;
			else
				j = 0;
			break;
		case 'j': case 0x42:
			if(j > ylen - 4)
			{
				yy++;
				break;
			}
			if(j <=ylen)
				j++;
			break;
		case 'k': case 0x41:
			if(j > ylen - 4 && yy != 0)
			{
				yy--;
				break;
			}
			if(j > 0)
				j--;
			break;
		case 0x0d: case 0x0a: case'Z':
			delwin(pvs);
			sprintf(rbuff,"%s",mrlist[j+yy]);
			rp =rbuff;
			return (rp);
		case 'q':
			delwin(pvs);
			return ("");
		defualt:
			break;
		}
	}
}

char *popmenu5(x,y,buff,xwidth,ylen)
int x;	/*表示桁位置*/
int y;	/*表示行位置*/
char *buff;	/*表示するメッセージ*/
int xwidth; /*ウインドウの横幅*/
int ylen; /*ウインドウの縦の長さ*/
{
	WINDOW *pvs;
	int ch;
	int item = 1;
	int x2;
	int i;
	int j = 0;
	char rbuff[64];
	int yy = 0;
	char *rp;

	pvs = newwin(ylen,xwidth,y,x);
	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');
	wattroff(pvs,A_REVERSE);
	for(;;)
	{
		for(i=0;i<20;i++)
		{
			mvwprintw(pvs,i+1,1,"  ");
			mvwprintw(pvs,i+1,1,"%s",mrlist2[i+yy]);
		}

		wmove(pvs,j+1,2);
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,j+1,1,"%s",mrlist2[j+yy]);
		wattroff(pvs,A_REVERSE);

		wrefresh(pvs);
		ch = wgetch(pvs);
		getyx(pvs,item,x2);
		switch(ch)
		{
		case ' ':
			if(j <=ylen)
				j++;
			else
				j = 0;
			break;
		case 'j': case 0x42:
			if (j+yy >= M2)
				break;
			if(j > ylen - 4)
			{
				yy++;
				break;
			}
			if(j <=ylen)
				j++;
			break;
		case 'k': case 0x41:
			if(j > ylen - 4 && yy != 0)
			{
				yy--;
				break;
			}
			if(j > 0)
				j--;
			break;
		case 0x0d: case 0x0a: case'Z':
			delwin(pvs);
			sprintf(rbuff,"%s",mrlist2[j+yy]);
			rp = rbuff;
			return (rp);
		case 'q':
			delwin(pvs);
			return ("");
		defualt:
			break;
		}
	}
}


/************************************************************************/
/* NAME      :int input_window()*/ 
/* FUNCTION  :ユーザに入力を促すポップアップウインドウを表示する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void *input_window(x,y,buff,msg)
int x;	/*表示桁位置*/
int y;	/*表示行位置*/
char *buff;	/*入力する文字*/
char *msg;	/*表示するメッセージ*/
{
	WINDOW *mvs;
	mvs = newwin(5,50,y,x);
	wattroff(mvs,A_REVERSE);
	box(mvs,'|','-');
	mvwprintw(mvs,4,0,"+");
	mvwprintw(mvs,4,49,"+");
	mvwprintw(mvs,1,4,msg);
	wattron(mvs,A_REVERSE);
Reply:
	mvwprintw(mvs,0,0,"                 Input  Window                   ");

	wrefresh(mvs);

	mvwprintw(mvs,2,4,"                                             ");
	echo();
	nocbreak();
	nl();

	mvwgetstr(mvs,2,4,buff);
	if(strlen(buff) > (size_t)31)
	{
		memset(buff,'\0',64);
		goto Reply;
	}

	noecho();
	cbreak();

	wrefresh(mvs);

	wattroff(mvs,A_REVERSE);
	noecho();
	delwin(mvs);
}

void errmsg(buff)
char *buff;
{
	int i;
	int ch;
	WINDOW *pvs;

	if(strlen(buff) < (size_t)1)
		sprintf(buff,"何かキーに触って下さい");

	echo();

	pvs = newwin(5,64,LINES/2,8);
	box(pvs,'|','-');

	wattron(pvs,A_REVERSE);
	mvwprintw(pvs,0,1,"----------------------CMS-ERROR-MESSAGE-----------------------");
	wattroff(pvs,A_REVERSE);
	mvwprintw(pvs,0,0,"+");
	mvwprintw(pvs,0,63,"+");
	mvwprintw(pvs,4,0,"+");
	mvwprintw(pvs,4,63,"+");

	mvwprintw(pvs,2,4,"%s",buff);
	wrefresh(pvs);
	wgetch(pvs);
	box(pvs,' ',' ');
	wclear(pvs);
	wrefresh(pvs);
	delwin(pvs);
}


/************************************************************************/
/* NAME      :int popmsg()*/ 
/* FUNCTION  :ユーザに選択を促すポップアップウインドウを表示する*/ 
/*            未使用*/ 
/*            */ 
/*            */ 
/* RETURN    :１　Ｙｅｓ　０　Ｎｏ*/
/************************************************************************/
int popmsg(x,y,buff)
int x;	/*表示桁位置*/
int y;	/*表示行位置*/
char *buff;	/*表示するメッセージ*/
{
	WINDOW *pvs;
	int i;
	int ch;
	pvs = newwin(6,40,y,x);
	/*1995.12.26
	wattron(pvs,A_REVERSE);
	*/
	box(pvs,'|','-');
	/*
	wattroff(pvs,A_REVERSE);
	*/
	noecho();
	for(;;)
	{
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,0,1,"----------CMS Pop Up Message----------");
		wattroff(pvs,A_REVERSE);
		mvwprintw(pvs,0,0,"+");
		mvwprintw(pvs,0,39,"+");
		mvwprintw(pvs,5,0,"+");
		mvwprintw(pvs,5,39,"+");

		mvwprintw(pvs,2,4,"%s",buff);
		mvwprintw(pvs,4,27,"Y or N :");
		wrefresh(pvs);
		ch = wgetch(pvs);
		switch(ch)
		{
		case 'y': case 'Y':
			delwin(pvs);
			return(1);
		case 'n': case 'N':
			delwin(pvs);
			return(0);
		}
	}
}

