/*
	
  名称
      
  概要
      
  構文
      
  説明

      
  多言語化対応
      

  診断
      

  例
      

  参照
      
  バグ
      
  著者
      
  標準準拠


  作者後書


*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <memory.h>
#include <malloc.h>
#include <locale.h>
#include <time.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#ifndef CYGWIN
#include <curses.h>
#else
#include <ncurses/curses.h>
#endif
#include <signal.h>
#include <locale.h>

#define MAXLINE 256
#define MAXLEN 64
#define WIDTH 32
#define LINE 24

/*
int main(x,y,buff,xwidth,ylen)
int x;	表示桁位置
int y;	/*表示行位置
char *buff;	表示するメッセージ
int xwidth; ウインドウの横幅
int ylen; ウインドウの縦の長さ
*/
char *basename(char *path)
{
	int i,j;
	int len;
	char *p;

	len = strlen(path);
	p = (char *)malloc(sizeof(path));
	for(i=0;i<len;i++)
	{
		if(path[len-i] == '/')
		{
			i--;
			break;
		}
	}
	for(j=0;i != 0;j++,i--)
	{
		p[j] = path[len-i];
	}
	p[j] = '\0';
	return((char *)p);
}


int main(int argc,char *argv[])
{
	WINDOW *pvs;
	int ch;
	int item = 1;
	int x2;
	int i;
	int j = 0;
	char rbuff[WIDTH];
	int yy = 0;
	int n;
	FILE *fp;
	char buff[MAXLEN + 1];
	char listbox[MAXLINE][MAXLEN];
	char *newline;
	static ylen = 24;
	char qid[8];
	char *env;

	if ((fp = fopen(argv[1], "r")) == NULL)
	{
		fprintf(stderr,"%s が見つかりません",argv[1]);
		exit(1);
	}
	if (argc < 3)
	{
		if((env = getenv("CMS_QUEID")) == NULL)
		{
			fprintf(stderr,"環境変数 CMS_QUEID が設定されていません");
			exit(1);
		}
		else
		{
			sprintf(qid,"%s",env);
		}
	}
	else
	{
		if((env = getenv("CMS_QUEID")) == NULL)
		{
			fprintf(stderr,"環境変数 CMS_QUEID が設定されていません");
			exit(1);
		}
		else
		{
			sprintf(qid,"%s",env);
		}
	}

	memset(listbox[MAXLEN - 1],'-',WIDTH - 2);
	n = 0;
	while((fgets(buff, MAXLEN - 1, fp)) != NULL && n < MAXLINE - 1)
	{
		if ((newline = strchr(buff, '\n')) != NULL)
		{
			*newline = '\0';
		}
		if (buff[0] != '\0')
		{
			sprintf(listbox[n],"%s",buff);
			n++;
		}
	}
	fclose(fp);

 	setlocale(LC_ALL,"");
	initscr();
	cbreak();
	noecho();

	pvs = newwin(LINE,WIDTH,(LINES/2)-(LINE/2),(COLS/2)-(WIDTH/2));
	for(i=0;i<LINE - 2;i++)
	{
		memset(buff,' ',strlen(listbox[i+yy]));
		mvwprintw(pvs,i+1,1,buff);
	}
	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');
	mvwprintw(pvs,0,0,"- %s -",basename(argv[0]));
	wattroff(pvs,A_REVERSE);
	for(;;)
	{
		for(i=0;i<LINE - 2;i++)
		{
			memset(buff,' ',strlen(listbox[i+yy]));
			mvwprintw(pvs,i+1,1,buff);
			mvwprintw(pvs,i+1,1,"%s",listbox[i+yy]);
		}

		wmove(pvs,j+1,2);
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,j+1,1,"%s",listbox[j+yy]);
	/*
		if(j > ylen - 4)
			mvwprintw(pvs,j+1,1,"%s",listbox[j+yy]);
		else
			mvwprintw(pvs,j+1,1,"%s",listbox[j]);
	*/
		wattroff(pvs,A_REVERSE);

		wrefresh(pvs);
		ch = wgetch(pvs);
		getyx(pvs,item,x2);
		switch(ch)
		{
		case 'j': case 0x42:
			if(j + yy >= n - 1)
				break;
			if(j > ylen - 4)
			{
				yy++;
				break;
			}
			if(j <= ylen - 4 && (n-1) > j)
			{
				j++;
			}
			break;
		case 'k': case 0x41:
			if(j > ylen - 4 && yy != 0)
			{
				yy--;
				break;
			}
			if(j > 0)
			{
				j--;
			}
			break;
		case 0x0d: case 0x0a: case'Z':
			delwin(pvs);
			if((env = getenv("CMS_LOGNAME")) == NULL)
				sprintf(rbuff,"dumy");
			else
				sprintf(rbuff,"%s",env);
			sprintf(buff,"qctrl -s %s %s %s",qid,listbox[j+yy],rbuff);
			system(buff);

			echo();
			nocbreak();
			endwin();
			exit(0);
		case 'q': case 0x1b:
			delwin(pvs);
			echo();
			nocbreak();
			endwin();
			/*
			return ((char *)NULL);
			*/
			exit(-1);
		defualt:
			break;
		}
	}
}

