/*
 * $Id: CmsFtpClient.java,v 0.0 2009/01/21 00:00:00 t-imamura Exp $
 *
 * Copyright (c) 2009 t-imamura, All rights reserved.
 */
package cms3.actions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * FTPȈՃNCAg.
 * <br>
 * FTP̐\Pbg쐬AڃR}h𑗐Ms܂B
 * PORT[hEPASV[h̃[hɂΉĂ܂B
 * t@C̑MȊOɁAfBNgȂǂs܂B
 *
 * <pre>
 * CmsFtpClient ftp = new CmsFtpClient("ftp.example.com", false);
 * // ڑ
 * ftp.connect();
 * // OC
 * ftp.logon("user", "pass");
 *
 * // t@CM
 * byte[] data = ]f[^;
 * ftp.put("/home/user/ftptest.txt", data);
 *
 * // t@CM
 * OutputStream os = new OutputStream();
 * ftp.get("/home/user/ftptest.txt", baos);
 *
 * // t@C폜
 * ftp.dele("/home/user/ftptest.txt");
 *
 * // ؒf
 * ftp.disconnect();
 * </pre>
 */
public class CmsFtpClient {

    /** FTP|[gԍ */
    private static final int FTP_PORT_NO = 21;
    /** Amj}XOCID */
    private static final String ANONYMOUS_USERID = "anonymous";
    /** PASV[h̐ڑ擾ׂ̐K\ */
    private static final Pattern PASV_REPLY_MESSAGE = Pattern.compile(
        "227 .*\\(([0-9]{1,3}),([0-9]{1,3}),([0-9]{1,3}),([0-9]{1,3}),([0-9]{1,3}),([0-9]{1,3})\\).*");
    /** JgfBNg擾ׂ̐K\ */
    private static final Pattern PWD_REPLY_MESSAGE = Pattern.compile("257 .*\"(.*)\".*");

    /** IPAhX */
    private final InetAddress address;
    /** |[gԍ */
    private final int portNo;

    /** FTP\Pbg */
    private Socket ftpCtrl;
    /** FTP(OutputStream) */
    private BufferedWriter ctrlOut;
    /** FTPo(InputStream) */
    private BufferedReader ctrlIn;

    /** pbVu[h */
    private boolean passive = false;
    /** fobO[h */
    public boolean debug = false;

    /**
     * FTPȈՃNCAgIuWFNg\z܂B
     *
     * @param address IPAhX or zXg
     * @param passive pbVu[h
     * @throws UnknownHostException <code>address</code>IPAhXȂꍇ
     */
    public CmsFtpClient(String address, boolean passive) throws UnknownHostException {
        this(InetAddress.getByName(address), FTP_PORT_NO, passive);
    }

    /**
     * FTPȈՃNCAgIuWFNg\z܂B
     *
     * @param address IPAhX
     * @param passive pbVu[h
     */
    public CmsFtpClient(InetAddress address, boolean passive) {
        this(address, FTP_PORT_NO, passive);
    }

    /**
     * FTPȈՃNCAgIuWFNg\z܂B
     *
     * @param address IPAhX
     * @param portNo  |[gԍ
     * @param passive pbVu[h
     */
    public CmsFtpClient(InetAddress address, int portNo, boolean passive) {
        this.address = address;
        this.portNo = portNo;
        this.passive = passive;
    }

    @Override
    protected void finalize() throws Throwable {
        disconnect();
        super.finalize();
    }

    /**
     * pbVu[hݒ肵܂B
     *
     * @param passive pbVu[h
     */
    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    /**
     * fobO[hݒ肵܂B
     *
     * @param debug fobO[h
     */
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    /**
     * FTPR}h𑗐M܂B
     * <br>
     * MvCbZ[WKvȏꍇ́Ae {@link StringBuffer} 
     * <code>replyMessage</code> Ɏw肵܂B
     *
     * @param command FTPR}h
     * @param replyMessage vCbZ[W
     * @return vCR[h
     */
    private int sendCommand(String command, StringBuffer replyMessage) {
        int replyCode = 0;

        try {
            // R}hM
            if (command != null) {
                debug("FTP > %s", command);

                ctrlOut.write(command);
                ctrlOut.write("\r\n");
                ctrlOut.flush();
            }

            // X|XM
            String reply = null;
            while ((reply = ctrlIn.readLine()) != null) {
                debug("FTP < %s", reply);
                if (replyMessage != null)
                    replyMessage.append(reply);

                // vCR[h
                replyCode  = (reply.charAt(0) - '0') * 100;
                replyCode += (reply.charAt(1) - '0') * 10;
                replyCode += (reply.charAt(2) - '0') * 1;

                // Ȃꍇ́AI
                if (reply.charAt(3) == ' ') break;

                replyCode = 0;
                if (replyMessage != null)
                    replyMessage.append("\n");
            }
        } catch (IOException e) {
            replyCode = 0;
        }

        return replyCode;
    }

    /**
     * FTPR}h𑗐MAf[^RlNV쐬܂B
     *
     * @param command FTPR}h
     * @return f[^RlNV
     * @throws IOException o̓G[ꍇ
     */
    private Socket creatDataConnection(String command) throws IOException {
        return passive ? creatDataConnectionPasv(command) : creatDataConnectionPort(command);
    }

    /**
     * FTPR}h𑗐MAPORT[hŃf[^RlNV쐬܂B
     *
     * @param command FTPR}h
     * @return f[^RlNV
     * @throws IOException o̓G[ꍇ
     */
    private Socket creatDataConnectionPort(String command) throws IOException {
        Socket ftpData = null;
        ServerSocket serverSocket = null;

        try {
            serverSocket = new ServerSocket(0, 1, ftpCtrl.getLocalAddress());

            byte[] ip = serverSocket.getInetAddress().getAddress();
            int port = serverSocket.getLocalPort();
            debug("INFO: Open data connection. (%d.%d.%d.%d:%d)",
                    (ip[0] & 0xFF), (ip[1] & 0xFF), (ip[2] & 0xFF), (ip[3] & 0xFF), port);

            String cmdPort = "PORT "
                    + (ip[0] & 0xff) + "," + (ip[1] & 0xff) + ","
                    + (ip[2] & 0xff) + "," + (ip[3] & 0xff) + ","
                    + ((port / 256) & 0xff) + "," + (port & 0xff);
System.out.printf("createDataCo 5 - %s",cmdPort);
            if (sendCommand(cmdPort, null) == 200) {
                if (sendCommand(command, null) == 150) {
                    ftpData = serverSocket.accept();
                }
            }

        } catch (IOException e) {
            // Bug: nullł邱Ƃ炩ȎQftpData𖳑ʂnull`FbNĂ܂
            // if (ftpData != null) ftpData.close();
            // ftpData = null;
            throw e;
        } finally {
            if (serverSocket != null)
                serverSocket.close();
        }

        return ftpData;
    }

    /**
     * FTPR}h𑗐MAPASV[hŃf[^RlNV쐬܂B
     *
     * @param command FTPR}h
     * @return f[^RlNV
     * @throws IOException o̓G[ꍇ
     */
    private Socket creatDataConnectionPasv(String command) throws IOException {
        Socket ftpData = null;

        try {
            StringBuffer msg = new StringBuffer();
            if (sendCommand("PASV", msg) != 227) {
                return null;
            }

            Matcher match = PASV_REPLY_MESSAGE.matcher(msg.toString());
            if (!match.find() || match.groupCount() != 6) {
                // f[^RlNV̏񂪎ȂB
                return null;
            }

            String address = match.group(1) + "." + match.group(2) + "."
                    + match.group(3) + "." + match.group(4);
            int portNo = Integer.parseInt(match.group(5)) * 256
                    + Integer.parseInt(match.group(6));
            debug("INFO: Connect data connection. (%s:%d)", address, portNo);

            ftpData = new Socket(address, portNo);

            if (sendCommand(command, null) != 150) {
                ftpData.close();
                ftpData = null;
            }
        } catch (NumberFormatException e) {
            ftpData = null;
        } catch (IOException e) {
            if (ftpData != null)
                ftpData.close();
            ftpData = null;
            throw e;
        }

        return ftpData;
    }

    /**
     * ڑ܂B
     *
     * @return 
     */
    public boolean connect() {
        if (ftpCtrl != null) return false;

        try {
            ftpCtrl = new Socket(address, portNo);
            ctrlOut = new BufferedWriter(new OutputStreamWriter(ftpCtrl.getOutputStream()));
            ctrlIn  = new BufferedReader(new InputStreamReader(ftpCtrl.getInputStream()));

            if (sendCommand(null, null) != 220) {
                disconnect();
                return false;
            }
        } catch (IOException e) {
            try {
                if (ctrlIn != null)
                    ctrlIn.close();
                if (ctrlOut != null)
                    ctrlOut.close();
                if (ftpCtrl != null)
                    ftpCtrl.close();
            } catch (IOException ex) {
                // N[Y̗O͖
            }
            ftpCtrl = null;
            ctrlOut = null;
            ctrlIn  = null;
            return false;
        }
        return true;
    }

    /**
     * ؒf܂B
     *
     * @return 
     */
    public boolean disconnect() {
        if (ftpCtrl == null) return false;
        boolean result = true;

        // I
        if (sendCommand("QUIT", null) != 221) {
            result = false;
        }

        try {
            if (ctrlIn != null)
                ctrlIn.close();
        } catch (IOException e) {
            result = false;
        } finally {
            ctrlIn = null;
        }
        try {
            if (ctrlOut != null)
                ctrlOut.close();
        } catch (IOException e) {
            result = false;
        } finally {
            ctrlOut = null;
        }
        try {
            if (ftpCtrl != null)
                ftpCtrl.close();
        } catch (IOException e) {
            result = false;
        } finally {
            ftpCtrl = null;
        }

        return result;
    }

    /**
     * Amj}XOC܂B
     *
     * @return 
     */
    public boolean anonymousLogon() {
        return logon(ANONYMOUS_USERID, ANONYMOUS_USERID);
    }

    /**
     * Amj}XOC܂B
     *
     * @param email [AhX
     * @return 
     */
    public boolean anonymousLogon(String email) {
        return logon(ANONYMOUS_USERID, email);
    }

    /**
     * OC܂B
     *
     * @param user [U
     * @param pass pX[h
     * @return 
     */
    public boolean logon(String user, String pass) {
        if (user == null) return false;
        if (pass == null) return false;
        if (ftpCtrl == null) connect();
        boolean result = true;

        // [U
        if (sendCommand("USER " + user, null) != 331) {
            result = false;
        }

        // pX[h
        if (sendCommand("PASS " + pass, null) != 230) {
            result = false;
        }

        return result;
    }

    /**
     * ]f[^̌`ݒ肵܂B
     *
     * @param binary oCif[^
     * @return 
     */
    public boolean type(boolean binary) {
        if (ftpCtrl == null) return false;
        boolean result = true;

        if (sendCommand(binary ? "TYPE I" : "TYPE A", null) != 250) {
            result = false;
        }

        return result;
    }

    /**
     * f[^𑗐M܂B
     *
     * @param name t@C
     * @param data f[^
     * @return 
     */
    public boolean put(String name, byte[] data) {
        if (ftpCtrl == null) return false;
        if (name == null || name.isEmpty()) return false;
        if (data == null) return false;
        boolean result = true;

        Socket ftpData = null;
        OutputStream dataOut = null;
        InputStream dataIn = null;

        try {
            ftpData = creatDataConnection("STOR " + name);
            dataOut = ftpData.getOutputStream();
            dataIn  = ftpData.getInputStream();

            // f[^M
            dataOut.write(data);
            dataOut.close();
            dataOut = null;
            if (sendCommand(null, null) != 226) {
                result = false;
            }

        } catch (IOException e) {
            result = false;
        } finally {
            try {
                if (dataIn != null)
                    dataIn.close();
            } catch (IOException e) {
                result = false;
            } finally {
                dataIn = null;
            }
            try {
                if (dataOut != null)
                    dataOut.close();
            } catch (IOException e) {
                result = false;
            } finally {
                dataOut = null;
            }
            try {
                if (ftpData != null)
                    ftpData.close();
            } catch (IOException e) {
                result = false;
            } finally {
                ftpData = null;
            }
        }

        return result;
    }

    /**
     * f[^M܂B
     *
     * @param name t@C
     * @param data f[^
     * @return 
     */
    public boolean get(String name, OutputStream data) {
        if (ftpCtrl == null) return false;
        if (name == null || name.isEmpty()) return false;
        if (data == null) return false;
        boolean result = true;

        Socket ftpData = null;
        OutputStream dataOut = null;
        InputStream dataIn = null;

        try {
            ftpData = creatDataConnection("RETR " + name);
            //2011.11.12 t@CԈႦꍇAIOExceptionɈُIoOCiS.Onoj
            if(ftpData == null)
            	return false;
            dataOut = ftpData.getOutputStream();
            dataIn = ftpData.getInputStream();

            byte[] buf = new byte[1024];
            int len = 0;

            // f[^M
            while ((len = dataIn.read(buf)) != -1) {
                data.write(buf, 0, len);
            }
            dataIn.close();
            dataIn = null;
            if (sendCommand(null, null) != 226) {
                result = false;
            }

        } catch (IOException e) {
            result = false;
        } finally {
            try {
                if (dataIn != null)
                    dataIn.close();
            } catch (IOException e) {
                result = false;
            } finally {
                dataIn = null;
            }
            try {
                if (dataOut != null)
                    dataOut.close();
            } catch (IOException e) {
                result = false;
            } finally {
                dataOut = null;
            }
            try {
                if (ftpData != null)
                    ftpData.close();
            } catch (IOException e) {
                result = false;
            } finally {
                ftpData = null;
            }
        }

        return result;
    }

    /**
     * t@C폜܂B
     *
     * @param name t@C
     * @return 
     */
    public boolean dele(String name) {
        if (ftpCtrl == null) return false;
        if (name == null || name.isEmpty()) return false;
        boolean result = true;

        if (sendCommand("DELE " + name, null) != 250) {
            result = false;
        }

        return result;
    }

    /**
     * 1ʂ̃fBNgɃJgfBNgړ܂B
     *
     * @return 
     */
    public boolean cdup() {
        if (ftpCtrl == null) return false;
        boolean result = true;

        if (sendCommand("CDUP", null) != 250) {
            result = false;
        }

        return result;
    }

    /**
     * JgfBNgړ܂B
     * fBNgpX́A΃pX͑΃pXŎw肵܂B
     *
     * @param path fBNgpX
     * @return 
     */
    public boolean cwd(String path) {
        if (ftpCtrl == null) return false;
        if (path == null || path.isEmpty()) return false;
        boolean result = true;

        if (sendCommand("CWD " + path, null) != 250) {
            result = false;
        }

        return result;
    }

    /**
     * w肵fBNg폜܂B
     * fBNgpX́A΃pX͑΃pXŎw肵܂B
     *
     * @param path fBNgpX
     * @return 
     */
    public boolean rmd(String path) {
        if (ftpCtrl == null) return false;
        if (path == null || path.isEmpty()) return false;
        boolean result = true;

        if (sendCommand("RMD " + path, null) != 250) {
            result = false;
        }

        return result;
    }

    /**
     * w肵fBNg쐬܂B
     * fBNgpX́A΃pX͑΃pXŎw肵܂B
     *
     * @param path fBNgpX
     * @return 
     */
    public boolean mkd(String path) {
        if (ftpCtrl == null) return false;
        if (path == null || path.isEmpty()) return false;
        boolean result = true;

        if (sendCommand("MKD " + path, null) != 250) {
            result = false;
        }

        return result;
    }

    /**
     * w肵fBNg𒲍܂B
     * fBNgpX́A΃pX͑΃pXŎw肵܂B
     *
     * @param path fBNgpX
     * @return 0:fBNg݂͑B 2:fBNg݂͑ȂB 1:̑
     */
    public int stat(String path) {
    	int stat = 0;
        if (ftpCtrl == null) return -1;
        if (path == null || path.isEmpty()) return -1;
        int result = 1;

        stat = sendCommand("STAT " + path, null);
        switch(stat)
        {
        case 450:
            result = 2;
            break;
        case 211:
            result = 0;
            break;
        default:
            result = 1;
        	break;
        }

        return result;
    }
     
    /**
     * JgfBNg̃t@Cꗗ擾܂B
     *
     * @return t@Cꗗ
     */
    public String list() {
        return list(null);
    }

    /**
     * t@Cꗗ擾܂B
     *
     * @param path fBNgpX
     * @return t@Cꗗ
     */
    public String list(String path) {
        if (ftpCtrl == null) return null;

        Socket ftpData = null;
        OutputStream dataOut = null;
        InputStream dataIn = null;
        ByteArrayOutputStream result = new ByteArrayOutputStream();

        String command = "LIST";
        if(path != null) command += " " + path;

        try {
            ftpData = creatDataConnection(command);
            dataOut = ftpData.getOutputStream();
            dataIn = ftpData.getInputStream();

            byte[] buf = new byte[1024];
            int len = 0;

            // f[^M
            while ((len = dataIn.read(buf)) != -1) {
                result.write(buf, 0, len);
            }
            result.flush();
            dataIn.close();
            dataIn = null;
            if (sendCommand(null, null) != 226) {
                result.reset();
            }

        } catch (IOException e) {
            result.reset();
        } finally {
            try {
                if (dataIn != null)
                    dataIn.close();
            } catch (IOException e) {
                result.reset();
            } finally {
                dataIn = null;
            }
            try {
                if (dataOut != null)
                    dataOut.close();
            } catch (IOException e) {
                result.reset();
            } finally {
                dataOut = null;
            }
            try {
                if (ftpData != null)
                    ftpData.close();
            } catch (IOException e) {
                result.reset();
            } finally {
                ftpData = null;
            }
        }

        return result.toString();
    }

    /**
     * JgfBNg擾܂B
     *
     * @return fBNgpX
     */
    public String pwd() {
        if (ftpCtrl == null) return null;

        StringBuffer reply = new StringBuffer();
        if (sendCommand("PWD", reply) != 257) {
            return null;
        }

        Matcher match = PWD_REPLY_MESSAGE.matcher(reply.toString());
        if (!match.find() || match.groupCount() != 1) {
            return null;
        }

        return match.group(1);
    }

    /**
     * w肳ꂽ̕ƈgāAtR\[ɏo͂܂B
     * <code>debug == false</code> ̏ꍇ́Ao͂܂B
     *
     * @param format 
     * @param args ̏wqɂQƂ
     */
    private void debug(String format, Object... args) {
        if (!debug) return;
        System.out.println(String.format(format, args));
    }

	public void FtpMain() {
		// TODO ꂽ\bhEX^u
		
	}

}

