#pragma ident "@(#) curlib01.c 2.0.1 2006.07.13,20:52"
#include <ncurses/curses.h>
#include <string.h>

/************************************************************************/
/* NAME      :varprint()*/
/* FUNCTION  :*/ 
/*            数値に３桁毎にカンマを付ける。１５桁までの数値に対応*/ 
/*            */ 
/*            */ 
/* RETURN    : カンマを付けた文字列へのポインタ。*/
/************************************************************************/
char *varprint(char *buff)
{
	static int k,l,m,len;
	static char buff2[256];

	len = strlen(buff);
	if(len > 17)
	{
		sprintf(buff,"%s","-1");
		return(buff);
	}
	for(k=0;k<len;k++)
		if(buff[k] == '.')
			return(buff);
	for(k=0,l=0,m=len;k<len;k++,m--)
	{
		switch(buff[k])
		{
	//	case '-':
	//	case '+':
		case '*':
		case '\\':
		case '$':
		case '%':
		case ' ':
		case ',':
			break;
		default:
			if(buff[k-1] != '-')
			if(buff[k-1] != '+')
			if(buff[k-1] != '*')
			if(buff[k-1] != '\\')
			if(buff[k-1] != '$')
			if(buff[k-1] != '%')
			if(buff[k-1] != ' ')
			if (((k==(len-3)||k==(len-6)||k==(len-9)||k==(len-12)||k==(len-15)) && k >= 4) && k != 0)
			{
				buff2[l] = ',';
				l++;
			}

			buff2[l] = buff[k];
			l++;
		//	if(k<2)
		//	{
		//		buff2[0] = '*';
		//	}
			break;
		}
	}
	if(l > 19)
		return(buff);
	buff2[l] = '\0';
//	strcpy(buff,lastprint(buff2));
//	strcpy(buff,buff2);
	sprintf(buff,"%s",buff2);
//	free(buff2);
	return(buff);
}

/************************************************************************/
/* NAME      :compare()*/
/* FUNCTION  :*/ 
/*            文字列の比較*/ 
/*            */ 
/*            */ 
/* RETURN    : ０：処理成功、-1：処理失敗                           */
/************************************************************************/
int compare(int c, char *p,char *s)
{
	
	if((strcmp(p,s)) == 0)
		return(c);
	else
		return(-1);
}

/************************************************************************/
/* NAME      :char *cutspace()*/
/* FUNCTION  :スペースを削除*/
/*            文字列の中の全てのスペースを削除する。*/ 
/*            */ 
/*            */ 
/* RETURN    :スペースを削除された文字列へのポインタ*/
/************************************************************************/
char *cutspace(char *s)
{
	static int i,j;
	static int len;
	static char p[256];

	len = strlen(s);
	for(i=0,j=0;i<len;i++)
	{
		if(s[i] == ' ')
		;
		else
		{
			p[j] = s[i];
			j++;
		}
	}
	if(j == 0)
	{
		memset(p,'\0',len);
		sprintf(s,"%s",p);
		return(s);
	}
	p[j] = '\0';
	sprintf(s,"%s",p);
	return(s);
}

/************************************************************************/
/* NAME      :char *cutspace_right()*/
/* FUNCTION  :*/
/*            文字列最後の右側のスペースを削除*/ 
/*            */ 
/*            */ 
/* RETURN    :スペースを削除された文字列へのポインタ*/
/************************************************************************/
char * cutspace_right(char *s)
{
	static int i,j;
	static int len;
	static char p[256];

	len = strlen(s);
	j=0;
	for(i=len;i >= 0;i--)
	{
		if(s[i] != ' ' && s[i] != '\0')
		{
			break;
		}
		j++;
	}
	for(i=0;i<len-(j-1);i++)
	{
		p[i] = s[i];
	}
	s[i] = '\0';
	return(s);
}

/************************************************************************/
/* NAME      :char *addspace()*/
/* FUNCTION  :*/
/*            文字列にスペースを追加*/ 
/*            */ 
/*            */ 
/* RETURN    :スペースを追加された文字列へのポインタ*/
/************************************************************************/
char *addspace(int len, char *s)
{
	static char spacer[1024];
	static char tmp[1024];

	sprintf(spacer,"%s",(char *)cutspace(s));
	sprintf(tmp,"%s",spacer);
	memset(spacer,'\0',sizeof(spacer));
	memset(spacer,' ',(len-(strlen(tmp))));
	sprintf(s,"%s%s",tmp,spacer);
	return((char *)s);
}

/************************************************************************/
/* NAME      :int *ifspace()*/
/* FUNCTION  :*/
/*            スペースを数える*/ 
/*            */ 
/*            */ 
/* RETURN    :スペースが無い場合は０：あった場合は０以上
/************************************************************************/
int ifspace(int len,char *s)
{
	static int i,j;
	for(i=0,j=0;i<len;i++)
	{
		if(s[i] == ' ')
		{
			j++;
		}
	}
	if(j < 1)
		return 0;
	else
		return (j);
}

/************************************************************************/
/* NAME      :char *srcep()*/
/* FUNCTION  :*/ 
/*            スペースを左に寄せ、文字列を右に寄せる*/ 
/*            */ 
/*            */ 
/* RETURN    :スペースを含んだ文字列へのポインタ*/
/************************************************************************/
char *srcep(char *buff)
{
	static int i,j,k;
	static int len;
	static char p[256];

//	if(buff[strlen(buff) - 1] != 0x20)
//		return((char  *)buff);


	for(len=0;buff[len] != 0 ||buff[len] != '\0';len++);

	for(i=len-1,k=0;i>0;i--)
	{
		if(buff[i] != 0x20)
			break;
		k++;
	}
	for(i=0;i<k;i++)
		p[i] = 0x20;
	for(j=0;j<(len-k);i++,j++)
	{
		p[i] = buff[j];
	}
	p[i] = '\0';
	sprintf(buff,"%s",p);
	return((char  *)buff);
}

/************************************************************************/
/* NAME      :char *slcep()*/
/* FUNCTION  :*/ 
/*            スペースの右に寄せ、文字列を左に寄せる*/ 
/*            */ 
/*            */ 
/* RETURN    :スペースを含んだ文字列へのポインタ*/
/************************************************************************/
char *slcep(char *buff)
{
	static int i,j,k,l;
	static int len;
	static char p[256];


	for(len=0;buff[len] != 0 ||buff[len] != '\0';len++);

	for(i=0;i<len;i++)
	{
		if(buff[i] != 0x20)
			break;
	}
	for(j=0,k=i,l=i;j<(len-l);j++,k++)
		p[j] = buff[k];
	for(i=j;i<len;i++)
		p[i] = 0x20;
	p[i] = '\0';
	sprintf(buff,"%s",p);
	return((char  *)buff);
}


/************************************************************************/
/* NAME      :char * sccep()*/
/* FUNCTION  :*/ 
/*            スペースを左右に寄せ、文字列を中央にする*/ 
/*            */ 
/*            */ 
/* RETURN    :スペースを含んだ文字列へのポインタ*/
/************************************************************************/
char *sccep(char *buff)
{
	static int i,j,k;
	static int len,dif;
	static int c,a;
	static char p[256];

	for(len=0;buff[len] != 0 ||buff[len] != '\0';len++);

	dif = 0;

	for(i=len-1,k=0;i>0;i--)
	{
		if(buff[i] != 0x20)
			break;
		k++;
	}
	for(c=0;c<len;c++)
	{
		if(buff[c] != 0x20)
			break;
	}
	a = c;
	dif=k+c;
	for(i=0;i<(k+c)/2;i++)
		p[i] = 0x20;
	for(;c<(len-k)+1;i++,c++)
		p[i] = buff[c];
	for(j=0;j<(k+a)/2;i++,j++)
		p[i] = 0x20;
	if(i == len)
	{
		p[i] = '\0';
	}
	else
	{
		p[i-1] = '\0';
		if(strlen(p) > len)
			p[len] = '\0';
	}
	sprintf(buff,"%s",p);
	return((char  *)buff);
}

/************************************************************************/
/* NAME      :int popmsg()*/ 
/* FUNCTION  :*/ 
/*            ユーザに選択を促すポップアップウインドウを表示する*/ 
/*            */ 
/*            */ 
/* RETURN    :１　Ｙｅｓ　０　Ｎｏ*/
/************************************************************************/
int popmsg(int x,int y,char *buff)
{
	WINDOW *pvs;
	static int i;
	static int ch;

	pvs = newwin(6,48,y,x);
	keypad(pvs,TRUE);
	meta(pvs, TRUE);
	/*1995.12.26
	wattron(pvs,A_REVERSE);
	*/
	box(pvs,'|','-');
	/*
	wattroff(pvs,A_REVERSE);
	*/
	noecho();
	for(;;)
	{
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,0,1,"============ Popup Window Message ============");
		wattroff(pvs,A_REVERSE);
		mvwprintw(pvs,0,0,"+");
		mvwprintw(pvs,0,47,"+");
		mvwprintw(pvs,5,0,"+");
		mvwprintw(pvs,5,47,"+");

		mvwprintw(pvs,2,4,"[%s]",buff);
		mvwprintw(pvs,4,30,"Y or N :");
		wrefresh(pvs);
		ch = wgetch(pvs);
		switch(ch)
		{
		case 'y': case 'Y':
			delwin(pvs);
			return(1);
		case 'n': case 'N':
			delwin(pvs);
			return(0);
		}
	}
}

/************************************************************************/
/* NAME      :dialogmsg()*/ 
/* FUNCTION  :*/
/*            ユーザに現在の状況を布告するダイアログウインドウを表示する*/ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
int dialogmsg(int x,int y,char *buff)
{
	static int i;
	static int ch;
	WINDOW *pvs;

	pvs = newwin(8,48,y,x);
	keypad(pvs,TRUE);
	meta(pvs, TRUE);
	box(pvs,'|','-');

	noecho();
	wattron(pvs,A_REVERSE);
	mvwprintw(pvs,0,1," -----------      DIALOG MESSAGE ----------- ");
	wattroff(pvs,A_REVERSE);
	mvwprintw(pvs,0,0,"+");
	mvwprintw(pvs,0,47,"+");
	mvwprintw(pvs,7,0,"+");
	mvwprintw(pvs,7,47,"+");

	mvwprintw(pvs,4,4,"[%s]",buff);
	wrefresh(pvs);
	delwin(pvs);

	/*
	box(pvs,' ',' ');
	wclear(pvs);
	wrefresh(pvs);
	delwin(pvs);
	endwin();
	*/
}

/************************************************************************/
/* NAME      :dialogmsg()*/ 
/* FUNCTION  :*/
/*            ユーザにRROR ノスシィ、ケ、/ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
void errmsg(int x,int y,char *buff)
{
	WINDOW *errvs;
	errvs = newwin(5,64,y,x);
	box(errvs,'|','-');

	wattron(errvs,A_REVERSE);
	mvwprintw(errvs,0,1,"                                                              ");
	wattroff(errvs,A_REVERSE);
	mvwprintw(errvs,0,0,"+");
	mvwprintw(errvs,0,63,"+");
	mvwprintw(errvs,4,0,"+");
	mvwprintw(errvs,4,63,"+");

	mvwprintw(errvs,2,4,"%s",buff);
	wrefresh(errvs);
	wgetch(errvs);
	wattroff(errvs,A_REVERSE);
	delwin(errvs);
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    : ０：処理成功、０以外：処理失敗                           */
/************************************************************************/
char *vs_ieee_c(WINDOW *vs,int x,int y,char *p,int N)
{
	if(mvwgetstr(vs,y,x,p) != (int)0)
	{
		*p = '\0';
		return((char *)p);
	}
	return((char *)NULL);
}
