#pragma ident "@(#) dtree.cc 2.1.7 2012.12.10,14:54"
/*
名前
	DTREE (Directory Tree) - Linux ディレクトリウォーカー

概要
	本プログラムはディレクトリでの操作に主眼を置いています。
	ツリーを作成するプログラムは簡単なスクリプトです。
	そのためプログラムの変更も容易に出来ます。
	以下がそのシェルスクリプトです。
	dtree.sh
	dtree_path.sh
	dtree.root.sh
	dtree.root_path.sh


拡張

	All Rights Reserved Shigeki.Ono (C)2009
*/

#include "../ftx/ftx.h"
#include "../ftx/filer.h"

static DIR *dir;

extern LocalTree *dtree;

extern char dmode;
extern int file_num;

//ウインドウ１と２のカラム位置
int filer_line1[] = {0,33,44,56,68,79,89};
int dtree_line1[] = {0,44,68,79,89,100};
//ウインドウ３と４のカラム位置
int dtree_line2[] = {0,12,24,36,48,52,54,54,54,54};

static char helpbuff2[22][128] =
	{" H  このヘルプを表示",
	" /  検索名入力                     ^L  選択ディレクトリの移動",
	" n  画面を下に検索                  S  画面の更新",
	" N  画面を上に検索                 ^E  vi の実行",
	"                                    @  ツリー表示時フルパスを表示",
	" p  単一ディレクトリをコピー        t  画面の先頭へ",
	"^P  選択ディレクトリのコピー        g  最後尾に",
	" m  ディレクトリを作成              !  シェルモードに",
	" r  ディレクトリを削除              1  アクセス時刻表示",
	"^R  選択ディレクトリを配下まで削除  9  作成年月表示",
	" c  ディレクトリをチェンジ          0  作成時刻表示",
	" i  ひとつ上のディレクトリへ        2  メニュー表示切替",
	"＾  先頭に.のあるファイルも表示     u  半画面上に",
	" M  ディレクトリ移動/名前変更       d  半画面下に",
	"^W ^W  選択ディレクトリを削除       j  一行下に",
	"^A  属性を変更                      k  一行上に",
	"^B  ファイラーを起動した場所に戻る  G(g) 画面最後尾に",
	"^H  $HOME に戻る                    ^K ブックマークに位置を保存",
	" -  以前に移動した場所に移動        ~  ブックマークメニューを開く",
	" +  以前に移動した場所から戻る",
	" Enter ツリー表示の終了（選択中のディレクトリを表示）"
	" "
	};

/************************************************************************/
/* NAME      :void helpmsg2()*/ 
/* FUNCTION  :ヘルプを表示する*/ 
/*            未使用*/ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
static void helpmsg2(int x,int y)
{
	WINDOW *pvs;
//	int ch;
	int i;
	pvs = newwin(23,72,y,x);
	box(pvs,ACS_VLINE,ACS_HLINE);

	wattron(pvs,A_REVERSE);
	mvwprintw(pvs,0,1,"                         Help  Window Message                         ");
	wattroff(pvs,A_REVERSE);
	mvwprintw(pvs,0,0,"+");
	mvwprintw(pvs,0,71,"+");
	mvwprintw(pvs,22,0,"+");
	mvwprintw(pvs,22,71,"+");

	noecho();
	for(i=0;i<22;i++)
		mvwprintw(pvs,i+1,1,"%s",helpbuff2[i]);
	wrefresh(pvs);
	wgetch(pvs);
	delwin(pvs);
}
char onobuff[128];


/************************************************************************/
/* NAME      :char *basename()*/
/* FUNCTION  :パス名の最後の名前だけを抜き取る*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :char ポインタ*/
/************************************************************************/
char *LocalTree::basename(char *s)
{
	char p[512];
	char ss[512];
//	char *sr;
	int i;
	int j;
	int k;
	int flg = 0;

	j=k=0;
	for(i=strlen(s);i > 0;i--)
	{
		if(s[i] == '/' || i < 0)
		{
			p[j] = '\0';
			flg = 1;
			break;
		}
		else
		{
			p[j] = s[i];
			j++;
		}
	}
	if(flg == 1)
	{
		k = j-1;
	}
	else
	{
		p[j] = s[i];
		k = j;
	}
	for(i=0;i < j;i++)
	{
		ss[i] = p[k];
		k--;
	}
	ss[i] ='\0';
	strcpy(s,ss);
	return(s);
}

/************************************************************************/
/* NAME      :char *pathcount()*/
/* FUNCTION  :パス名の区切り文字 / を数える*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :char ポインタ*/
/************************************************************************/
int LocalTree::pathcount(char *p)
{
	int i;
	int j;

	j=0;
	for(i=strlen(p);i > 0;i--)
	{
		if(p[i] == '/')
		{
			j++;
		}
	}
	return(j);
}

/************************************************************************/
/* NAME      :void line_clear2()*/
/* FUNCTION  :指定されたウインドウの桁位置と行位置をスペースで埋める*/ 
/*            */ 
/*int no;	ウインドウ番号*/
/*int x;	桁位置*/
/*int y;	行位置*/
/*int sy;	開始行位置*/
/*int end;	終了行位置*/
/*int len;	カラムの長さ*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::line_clear2(int no,int x,int y,int sy,int end,int len)
{
	int i;
	char buff[128];
	for(i=0;i < len;i++)
		buff[i] = 'X';
	buff[i] = '\0';
	for(i=0;i < end+sy;i++)
	{
		vs_print(buff,pt[no].vs,x,i+sy);
	}
}

/************************************************************************/
/* NAME      :void vs_cls2()*/
/* FUNCTION  :該当ウインドウの指定カラムの文字を消去する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::vs_cls2(int no,int col)
{
	switch(no)
	{
	case 0:
		line_clear2(no,dtree_line1[col]+1,5,5,93,dtree_line1[col+1]-dtree_line1[col]-1);
		break;
	case 1:
		line_clear2(no,dtree_line1[col]+1,0,0,2,dtree_line1[col+1]-dtree_line1[col]-1);
		break;
	case 2:
		line_clear2(no,dtree_line1[col]+1,5,5,93,dtree_line1[col+1]-dtree_line2[col]-1);
		break;
	}
}
/************************************************************************/
/* NAME      :void set_screen2()*/
/* FUNCTION  :ファイルを表示する４つのウインドウを描画する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::set_screen2(void)
{
	int i;
	for(i=2;i<dtree_max_lines - dtree_botom;i++)
	{
		mvwprintw(pt[0].vs,i,filer_line1[1],"|");
		mvwprintw(pt[0].vs,i,filer_line1[2],"|");
		mvwprintw(pt[0].vs,i,filer_line1[3],"|");
		mvwprintw(pt[0].vs,i,filer_line1[4],"|");
		mvwprintw(pt[0].vs,i,filer_line1[5],"|");
	}
	for(i=0;i<89;i++)
	{
		mvwprintw(pt[0].vs,2,i,"-");
		mvwprintw(pt[0].vs,4,i,"-");
	}
	wmove(pt[0].vs,1,1);
	mvwaddstr(pt[0].vs,3,filer_line1[0]+1,"  NAME");
	mvwaddstr(pt[0].vs,3,filer_line1[1]+1," Size/Dir");
	mvwaddstr(pt[0].vs,3,filer_line1[2]+1,"  Date/Time");
	mvwaddstr(pt[0].vs,3,filer_line1[3]+1,"  Attr");
	mvwaddstr(pt[0].vs,3,filer_line1[4]+1,"  Owner");
	mvwaddstr(pt[0].vs,3,filer_line1[5]+1,"  Group");
}

/************************************************************************/
/* NAME      :int dtree_clear()*/ 
/* FUNCTION  :ディレクトリを配列に記録する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::dtree_clear(void)
{
	int i;
	for(i=2;i<dtree_max_lines;i++)
	{
		mvwprintw(pt[1].vs,i,dtree_line1[0],"                                            ");
		mvwprintw(pt[1].vs,i,dtree_line1[1],"                        ");
		mvwprintw(pt[1].vs,i,dtree_line1[2],"           ");
		mvwprintw(pt[1].vs,i,dtree_line1[3],"           ");
	}
	for(i=2;i<dtree_max_lines;i++)
	{
		mvwprintw(pt[1].vs,i,dtree_line1[1],"|");
		mvwprintw(pt[1].vs,i,dtree_line1[2],"|");
		mvwprintw(pt[1].vs,i,dtree_line1[3],"|");
		mvwprintw(pt[1].vs,i,dtree_line1[4],"|");
	}
	for(i=0;i<89;i++)
	{
		mvwprintw(pt[1].vs,2,i,"-");
		mvwprintw(pt[1].vs,4,i,"-");
	}

	wmove(pt[1].vs,1,1);
	mvwaddstr(pt[1].vs,3,dtree_line1[0]+1,"  DirectoryName");
	mvwaddstr(pt[1].vs,3,dtree_line1[1]+1,"  FileName");
	mvwaddstr(pt[1].vs,3,dtree_line1[2]+1,"  Attr");
	mvwaddstr(pt[1].vs,3,dtree_line1[3]+1,"  Owner");
}

/************************************************************************/
/* NAME      :int file_clear()*/ 
/* FUNCTION  :ディレクトリを配列に記録する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::filer_clear(void)
{
	int i;
	for(i=2;i<dtree_max_lines;i++)
	{
		mvwprintw(pt[0].vs,i,filer_line1[0],"                                 ");
		mvwprintw(pt[0].vs,i,filer_line1[1],"           ");
		mvwprintw(pt[0].vs,i,filer_line1[2],"            ");
		mvwprintw(pt[0].vs,i,filer_line1[3],"            ");
		mvwprintw(pt[0].vs,i,filer_line1[4],"           ");
		mvwprintw(pt[0].vs,i,filer_line1[5],"          ");
	}
	for(i=2;i<dtree_max_lines;i++)
	{
		mvwprintw(pt[0].vs,i,filer_line1[0],"|");
		mvwprintw(pt[0].vs,i,filer_line1[1],"|");
		mvwprintw(pt[0].vs,i,filer_line1[2],"|");
		mvwprintw(pt[0].vs,i,filer_line1[3],"|");
		mvwprintw(pt[0].vs,i,filer_line1[4],"|");
		mvwprintw(pt[0].vs,i,filer_line1[5],"|");
		mvwprintw(pt[0].vs,i,filer_line1[6],"|");
	}
	for(i=0;i<89;i++)
	{
		mvwprintw(pt[0].vs,2,i,"-");
		mvwprintw(pt[0].vs,4,i,"-");
	}

	wmove(pt[0].vs,1,1);
	mvwaddstr(pt[0].vs,3,filer_line1[0]+1,"  NAME");
	mvwaddstr(pt[0].vs,3,filer_line1[1]+1," Size/Dir");
	mvwaddstr(pt[0].vs,3,filer_line1[2]+1,"  Date/Time");
	mvwaddstr(pt[0].vs,3,filer_line1[3]+1,"  Attr");
	mvwaddstr(pt[0].vs,3,filer_line1[4]+1,"  Owner");
	mvwaddstr(pt[0].vs,3,filer_line1[5]+1,"  Group");

}

int LocalTree::tree(int start,int end)
{
	int i,j;
	int ch,ch2;
	int x,y;
	int yy = 5;
	char buff[512],cwdpath[512],cwdpath2[512],copybuff[512];
	char tmpbuff[512];
	char tmpbuff2[512];
	char execbuff[512];
	WINDOW *evs;
	char *vp,*sp,*dp;
	char filebuff[512];
	uid_t fuid;
	gid_t fgid;
	char findstr[512];
	int findf = 0;
	int fcount = 0;
	int dflag = 1;
	int ret;
	char *cret;

	unsigned int swptmp;
	char buffx[256];
	char buffy[256];
	char buffz[256];

	char *nln;

	char ftmp[256];
	char ftmp2[256];

	static unsigned int deep = 0;

	dtree_all_cls(1);

	evs = newwin(1,COLS,LINES-1,0);

	dtree_max_lines = LINES;
	pmode = 'h';
	dtree_fmode = 'm';
	dtree_file_num = 2;
	dtree_botom = 2;
	dtree_pathisto = 0;
	dtree_pathcnt = 0;
	dtree_jump = 0;
	pt[1].vs = newwin(dtree_max_lines - (dtree_botom+0),90,1,0);

	dtree_set_screen();

	dtree_displaymenu1(evs,dflag);

	x = 1;
	y = 0;

	dmode = 'v';

	cret = getcwd(cwdpath,512);
	sprintf(dirstack[0],"%s",cwdpath);
	dtree_pathisto++;
	dtree_pathcnt++;

	if (COLS > 89)
	{
		if(strlen(cwdpath) > (size_t)72)
		{
			sprintf(cwdpath2,"Path=...%-69s%4d dirs",right2(cwdpath,69),dtree_file_num);
			sprintf(tmpbuff,"%s",cwdpath2);
		}
		else
		{
			sprintf(tmpbuff,"Path=%-72s%4d dirs",cwdpath,dtree_file_num);
		}
	}
	else
	{
		if(strlen(cwdpath) > (size_t)62)
		{
			sprintf(cwdpath2,"Path=...%-59s%4d dirs",right2(cwdpath,59),dtree_file_num);
			sprintf(tmpbuff,"%s",cwdpath2);
		}
		else
		{
			sprintf(tmpbuff,"Path=%-62s%4d dirs",cwdpath,dtree_file_num);
		}
	}

	vs_print(tmpbuff,pt[1].vs,dtree_line1[0]+1,1);

	dtree_initbuff();

	dtree_dirprint();

	while(1)
	{
		dtree_datadisp(1,x,y,5);
		fileprint(".");

		/*
		ウインドウの枠を表示する
		*/
		box(pt[1].vs,ACS_VLINE,ACS_HLINE);

		if((vp = getenv("CMS_USERNAME")) == NULL)
		{
		//	sprintf(tmpbuff,"%-42sCW v1.2 2008(c)S.Ono#",getenv("LOGNAME"));
			sprintf(tmpbuff,"%-52s DTREE v2.09 2009(c)S.Ono#",getenv("LOGNAME"));
		}
		else
		{
			if((sp = getenv("LOGNAME")) == NULL)
				sprintf(tmpbuff,"%-16s- %-34s DTREE v2.05 2009(c)S.Ono#",vp,"no-login");
			else
				sprintf(tmpbuff,"%-52s DTREE v2.09 2009(c)S.Ono#",vp);
		}
		wattron(pt[1].vs,A_REVERSE);
		mvwprintw(pt[1].vs,0,1,tmpbuff);
		wattroff(pt[1].vs,A_REVERSE);

	//	rectang(1);
		cret = getcwd(cwdpath,512);

		if (COLS > 89)
		{
			if(strlen(cwdpath) > (size_t)72)
			{
			
				sprintf(cwdpath2,"Path=...%-69s%4d dirs",right2(cwdpath,69),dtree_file_num);
				sprintf(tmpbuff,"%s",cwdpath2);
			}
			else
			{
			
				sprintf(tmpbuff,"Path=%-72s%4d dirs",cwdpath,dtree_file_num);
			}
		}
		else
		{
			if(strlen(cwdpath) > (size_t)62)
			{
			
				sprintf(cwdpath2,"Path=...%-59s%4d dirs",right2(cwdpath,59),dtree_file_num);
				sprintf(tmpbuff,"%s",cwdpath2);
			}
			else
			{
			
				sprintf(tmpbuff,"Path=%-62s%4d dirs",cwdpath,dtree_file_num);
			}
		}
		vs_print(tmpbuff,pt[1].vs,dtree_line1[0]+1,1);

		wmove(pt[1].vs,y,1);
		wattron(pt[1].vs,A_REVERSE);
		sprintf(filebuff,"%-42s",ts[y+(yy-5)].buff10);
		vs_print(filebuff,pt[1].vs,dtree_line1[0]+2,yy);

		sprintf(filebuff,"%-42s"," ");
		wattroff(pt[1].vs,A_REVERSE);

		if (regline[y+(yy-5)] == 1)
			vs_print("*",pt[1].vs,dtree_line1[0]+1,yy);

		wrefresh(pt[1].vs);

		/*
		シンボリックリンクを表示
		*/
		memset(ftmp,'\0',256);
		sprintf(tmpbuff2,"%s",ts[y+(yy-5)].dtree2);
		if((readlink(basename(tmpbuff2), ftmp, 256)) != -1)
		{
			sprintf(ftmp2,"%s->%s",ts[y+(yy-5)].dtree2,ftmp);
			if((yy-5) < 10)
				dialogmsg2(30, yy - 4,ftmp2,"シンボリックリンクされています。");
			else
				dialogmsg2(30, yy + 2,ftmp2,"シンボリックリンクされています。");
		}
		/*
		パス名を表示
		*/
		if(pmode == 'p')
		{
			sprintf(tmpbuff2,"%s",ts[y+(yy-5)].dtree2);
			if((yy-5) < 10)
				dialogmsg2(30, yy + 2,tmpbuff2,"現在のパス名です。");
			else
				dialogmsg2(30, yy - 4,tmpbuff2,"現在のパス名です。");
		}

		/*
		コマンド操作
		*/
		ch = wgetch(pt[1].vs);

		wattroff(pt[1].vs,A_REVERSE);
		sprintf(filebuff,"%-42s",ts[y+(yy-5)].buff10);
		vs_print(filebuff,pt[1].vs,dtree_line1[0]+2,yy);

		if (regline[y+(yy-5)] == 1)
			vs_print("*",pt[1].vs,dtree_line1[0]+1,yy);

		dtree_set_screen();

		dtree_displaymenu1(evs,dflag);

		switch(ch)
		{
		/*
		ＣＭＳの起動
		*/
		case '@':
			noraw();
			echo();
			nl();
			nocbreak();
			ret = system("/bin/stty echo onlcr icrnl;cmsmenu");
			raw();
			noecho();
			nonl();
			cbreak();

			rectang(1);
			dtree_initbuff();
			wclear(pt[1].vs);
			dtree_set_screen();
			dtree_dirprint();
			fileprint(".");
			dtree_set_screen();
			wrefresh(pt[1].vs);
			break;

		case '4':
			for (j=0;j<=intCPnum;j++)
				vs_print(selcp[j],pt[1].vs,dtree_line1[0]+23,yy+j);
			break;
		/*
		ファイルの選択（マーク）
		*/
		case '\t':
			if (intCPnum < 256)
			{
				sprintf(selcp[intCPnum],"%s",ts[y+(yy-5)].dtree2);
				stat(ts[y+(yy-5)].dtree2,fptr);
				if(!(fptr->st_mode & S_IFDIR) == 0)
				{
					if (regline[y+(yy-5)] == 1)
					{
						vs_print(" ",pt[1].vs,dtree_line1[0]+1,yy);
						regline[y+(yy-5)] = 0;
						cpflag[intCPnum] = 0;
						intCPnum--;
					}
					else
					{
						vs_print("*",pt[1].vs,dtree_line1[0]+1,yy);
						regline[y+(yy-5)] = 1;
						cpflag[intCPnum] = y+(yy-5);
						intCPnum++;
					}
				}
			}
			else
			{
				intCPnum = 0;
			}
			break;

		/*
		複数選択移動
		*/
		case '':
			input_window(8,4,copybuff,"移動先を入力して下さい");
			if(strlen(copybuff) < (size_t)0)
				break;
			cret = getcwd(ftmp,255);
			sprintf(buff,"%3d: Move %s -> %s",intCPnum,ftmp,copybuff);
			if(popmsg(2+8,(LINES/2)-4,buff) == 1)
			{
				for (j=0;j<dtree_file_num;j++)
				{
					if(regline[j] == 1)
					{
					stat(copybuff,fptr);
					if((fptr->st_mode & S_IFDIR) != 0)
					{
						sprintf(buff,"mv -f %s %s > /dev/null 2>&1",ts[j].buff10,copybuff);
						dialogmsg(33,6,buff);
						ret = system(buff);
					}
					else
					{
						sprintf(buff,"%s が見つかりません",copybuff);
						sys_errmsg(4,10,buff);
					}
					}
				}
			}
			intCPnum = 0;
			dtree_initbuff();
			dtree_dirprint();
			fileprint(".");
			y = 0;
			yy = 5;
			goto allCLS2;

		/*
		複数選択コピー
		*/
		case '':
			input_window(8,4,copybuff,"コピー先を入力して下さい");
			if(strlen(copybuff) < (size_t)0)
				break;
			cret = getcwd(ftmp,255);
			sprintf(buff,"%3d: cp -pruf %s -> %s",intCPnum,ftmp,copybuff);
			if(popmsg(2+8,(LINES/2)-4,buff) == 1)
			{
				for (j=0;j<dtree_file_num;j++)
				{
					if(regline[j] == 1)
					{
						stat(copybuff,fptr);
						if((fptr->st_mode & (S_IWOTH | S_IWGRP | S_IWUSR | S_ISUID | S_ISGID)) != 0)
						{
							stat(copybuff,fptr);
							if((fptr->st_mode & S_IWUSR) != 0)
							{
								sprintf(buff,"cp -pruf %s %s > /dev/null 2>&1",ts[j].dtree2,copybuff);
								dialogmsg(33,6,buff);
								ret = system(buff);
							}
							else
							{
								sprintf(buff,"%s に書き込み権限がありません。",copybuff);
								sys_errmsg(4,10,buff);
							}
						}
						else
						{
							sprintf(buff,"%s が見つかりません",copybuff);
							sys_errmsg(4,10,buff);
						}
					}
				}
			}
			intCPnum = 0;
			dtree_initbuff();
			dtree_dirprint();
			fileprint(".");
			dtree_clear();
			y = 0;
			yy = 5;
			goto allCLS2;

		/*
		ディレクトリの複数選択削除
		*/
		case '':
			ch2 = wgetch(pt[1].vs);
			switch(ch2)
			{
			case '':
				cret = getcwd(ftmp,255);
				sprintf(buff,"%s 配下の選択したディレクトリを次のコマンドで削除します。rm -r",ftmp);
				if(popmsg(2+8,(LINES/2)-4,buff) == 1)
				{
					for (j=0;j<dtree_file_num;j++)
					{
						if(regline[j] == 1)
						{
							stat(selcp[j],fptr);
							if((fptr->st_mode & S_IFMT) != 0)
							{
								sprintf(buff,"%s",ts[j].dtree2);
								sprintf(tmpbuff,"%s 以下を全て削除します。よろしいですか？",buff);
								if(popmsg(2+8,(LINES/2)-4,tmpbuff) == 1)
								{
									sprintf(buff,"rm -r %s > /dev/null 2>&1",ts[j].dtree2);
									popmsg(33,6,buff);
									ret = system(buff);
								}
								else
								{
								}
							}
							else
							{
								sprintf(buff,"%s が見つかりません",selcp[j]);
								sys_errmsg(4,10,buff);
							}
						}
					}
				}
				intCPnum = 0;
				dtree_initbuff();
				dtree_dirprint();
				fileprint(".");
				dtree_clear();
				y = 0;
				yy = 5;
				goto allCLS2;

			default:
				break;
			}

		case '2':
		/*
		メニューバーを切り替える
		*/
			if(dflag == 1)
				dflag = 0;
			else
				dflag = 1;
			dtree_displaymenu1(evs,dflag);
			break;

		case 'g':
		/*
		ツリー列の最後を表示（但しカーソルは最下部に）
		*/
			if(y > (dtree_file_num - (dtree_max_lines - 7)))
			{
				yy = dtree_max_lines - ((dtree_max_lines - 4) - (dtree_file_num));
			}
			if(dtree_file_num > (dtree_max_lines - 7))
			{
				y = dtree_file_num - (dtree_max_lines - 8);
				yy = dtree_max_lines - 4;
			}
			dtree_clear();
			dtree_set_screen();
			break;
		case 'G':
		/*
		ツリー列の最後を表示（但しカーソルは最上部に）
		*/
			if(y > (dtree_file_num - (dtree_max_lines - 7)))
				break;
			if(dtree_file_num > (dtree_max_lines - 7))
				y = dtree_file_num - (dtree_max_lines - 8);
			dtree_clear();
			dtree_set_screen();
			break;

		/*
		ファイル画面トップに
		*/
		case 't':
			y = 0;
			yy = 5;
			dtree_datadisp(1,x,y,5);
			wattroff(pt[1].vs,A_REVERSE);
			sprintf(filebuff,"%-42s",ts[y+(yy-5)].buff10);
			vs_print(filebuff,pt[1].vs,dtree_line1[0]+2,yy);
			dtree_clear();
			dtree_set_screen();
			break;

		case 'T':
		/*
		ファイル列を最初から表示
		*/
			y = 0;
			dtree_clear();
			dtree_set_screen();
			break;

		case '/':
		/*
		ファイルを文字列で検索
		*/
			input_window(4,2,findstr,"検索名を入力");
			if(strlen(findstr) < (size_t)1)
				strcpy(findstr," ");

		case 'n':
		/*
		ファイルを文字列で再び検索
		*/
			fcount = 0;
			if(strlen(findstr) < (size_t)1)
				break;
			y++;
			for(;y+(yy-5)<dtree_file_num;y++)
			{
				if(fcount > MAX_TREE)
					break;
			//	if((findf = findex(ts[y+(yy-5)].dtree2, findstr)) != -1)
				if((findf = findex(ts[y+(yy-5)].buff10, findstr)) != -1)
				{
					fcount = 0;
					sprintf(buff,"[%s] が見つかりました",findstr);
					dialogmsg(33,6,buff);
					break;
				}
				fcount++;
				if(y+(yy-5) < dtree_file_num)
				{
					if(y >= MAX_TREE - dtree_max_lines)
					{
						y = MAX_TREE - dtree_max_lines;
					}
				}
				else
				{
					break;
				}
			}
			dtree_clear();
			dtree_set_screen();

			/*見つからなければ前にいた位置に戻る*/
			if(y > MAX_TREE || y >= dtree_file_num || strlen(ts[y+(yy-5)].buff10) < (size_t)1)
			{
				dialogmsg(2,(LINES/2),"見つかりません");

				y = 0;
				yy = 5;
				dtree_clear();
				dtree_set_screen();
				dtree_datadisp(1,x,y,5);
				wattroff(pt[1].vs,A_REVERSE);
				sprintf(filebuff,"%-42s",ts[y+(yy-5)].buff10);
				vs_print(filebuff,pt[1].vs,dtree_line1[0]+2,yy);
				break;
			}
			break;

		 case 'N':
			/*2009/03/10*/
			fcount = 0;
			if(strlen(findstr) < (size_t)1)
				break;
			y--;
			for(;y+(yy-5)>0;y--)
			{
				if(fcount > MAX_TREE)
					break;
				if((findf = findex(ts[y+(yy-5)].buff10, findstr)) != -1)
				{
					fcount = 0;
					sprintf(buff,"[%s] が見つかりました。",findstr);
					dialogmsg(33,6,buff);
					break;
				}
				fcount++;
			}
			dtree_clear();
			dtree_set_screen();

			/*見つからなければ先頭に戻る*/
			if(y < 1 || strlen(ts[y+(yy-5)].buff10) < (size_t)1)
			{
				y = 0;
				yy = 5;
				dtree_clear();
				dtree_set_screen();
				dtree_datadisp(1,x,y,5);
				wattroff(pt[1].vs,A_REVERSE);
				sprintf(filebuff,"%-42s",ts[y+(yy-5)].buff10);
				vs_print(filebuff,pt[1].vs,dtree_line1[0]+2,yy);
				break;
			}
			break;

		case '':
		/*
		ファイルの属性（モード）を変更
		*/
			fuid = getuid();
			fgid = getgid();
			input_window(4,2,buff,"ファイル／ディレクトリの属性を変更します");
			if(strlen(buff) < (size_t)1 || (size_t)4 < strlen(buff))
				break;
			if(atoi(buff) > 778 || 1 > atoi(buff))
				break;
			/*
          		S_IRUSR        所有者による読出し
           		S_IWUSR        所有者による書込み
           		S_IXUSR        所有者による実行(検索)
           		S_IRGRP        グループによる読出し
           		S_IWGRP        グループによる書込み
           		S_IXGRP        グループによる実行(検索)
           		S_IROTH        他人(つまり、誰でも)による読出し
			if(chmod(ts[y+(yy-5)].buff10,fpid,fgid) == -1)
				break;
		   */
			sprintf(execbuff,"chmod %s %s > /dev/null 2>&1",buff,ts[y+(yy-5)].buff10);
			if(popmsg(6,(LINES/2)-4,execbuff) == 0)
			{
				break;
			}
			ret = system(execbuff);
			dtree_initbuff();
			dtree_dirprint();
			fileprint(".");
			break;
		case '':
		/*
		CWを起動したディレクトリに戻る
		*/
			if(strlen(startdirname) < (size_t)1)
				break;
			stat(startdirname,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				if(chdir(startdirname) == -1)
					break;

				cret = getcwd(dirstack[dtree_pathcnt],256);
				if(dtree_pathcnt < 128)
					dtree_pathcnt++;
				if(dtree_pathisto < 128)
					dtree_pathisto++;
				checkhisto();

				dtree_all_cls(1);

				dtree_initbuff();
				dtree_dirprint();
				fileprint(".");
				dtree_clear();
				dtree_set_screen();
				y = 0;
				yy = 5;
				dirlocateclear();
			}
			break;
		case '':
		/*
		環境変数 HOME に定義されたディレクトリに移動する
		*/
			if(strlen(homedirname) < (size_t)1)
				break;
			stat(homedirname,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				if(chdir(homedirname) == -1)
					break;

				dtree_all_cls(1);

				dtree_initbuff();
				dtree_dirprint();
				fileprint(".");
				dtree_clear();
				dtree_set_screen();
				y = 0;
				yy = 5;
				dirlocateclear();
			}
			break;

		case '^':
		/*
		Hiddenファイル・ディレクトリを表示／非表示の切替え（デフォルト）
		*/
			switch(dmode)
			{
			case 'v':
				dmode = 'h';
				break;
			case 'h':
				dmode = 'v';
				break;
			default :
				dmode = 'h';
				break;
			}
			dtree_clear();
			initbuff();
			dtree_initbuff();
			dtree_dirprint();
			fileprint(".");
			y = 0;
			yy = 5;
			break;

		/*
		現在のパスをブックマークとして保存
		*/
		case '':
			if(popmsg2(2+8,(LINES/2)-4,"カレントディレクトリをブックマークに保存しますか？") == 1)
			{
				sprintf(bookmarks[bookline],"%s",cwdpath);
				if(bookmarksave() == -1)
				{
					popmsg(2+8,(LINES/2)-4,"ブックマークを保存出来ません。");
				}
			}
			break;

		/*
		ブックマークのディレクトリに移動する。
		*/
		case '~':
			if((vp = getenv("HOME")) == NULL)
			{
				sprintf(buff,"環境変数 HOME が設定されていません");
				sys_errmsg(4,10,buff);
				break;
			}

			sprintf(buff,"%s",ts[y+(yy-5)].dtree2);
			if((dp = bookmarkmenu(2,2,buff)) == NULL)
			{
				break;
			}
			sprintf(docbuff,"%s",dp);

			dtree_all_cls(1);

			if(chdir(docbuff) == -1)
				break;
			dtree_initbuff();
			dtree_dirprint();
			fileprint(".");
			dtree_clear();
			dtree_set_screen();
			y = 0;
			yy = 5;
			break;

		/*
		ダイアログボックスでパス名を表示するかどうかのフラグ
		*/
		case '=':
			switch(pmode)
			{
			case 'p':
				pmode = 'h';
				break;
			case 'h':
				pmode = 'p';
				break;
			default :
				pmode = 'h';
				break;
			}
			break;

		case 'H': case '?':
		/*
		CWのヘルプメッセージを表示
		*/
			helpmsg2(4,1);
			dtree_displaymenu1(evs,dflag);
			break;

		case 'r':
		/*
		ディレクトリの削除
		*/
			stat(ts[y+(yy-5)].dtree2,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				sprintf(buff,"rmdir(%s)",ts[y+(yy-5)].dtree2);
				if(popmsg(2+8,(LINES/2)-4,buff) == 1)
				{
					sprintf(tmpbuff,"%s",cutchars(cutspace(ts[y+(yy-5)].buff10),'|'));
					sprintf(tmpbuff2,"%s",right2(tmpbuff,strlen(tmpbuff)-1));
					rmdir(tmpbuff2);
					dtree_initbuff();
					dtree_dirprint();
					fileprint(".");
				}
			}
			break;

		case '':
		/*
		ファイル指定なしでｖｉエディタを起動する。
		*/
			ret = system("clear");
			noraw();
			echo();
			nl();
			nocbreak();

			sprintf(buff,"/bin/stty echo onlcr icrnl;vi");
			wattroff(pt[1].vs,A_REVERSE);
			wrefresh(pt[1].vs);
			ret = system(buff);

			wclear(pt[1].vs);
			dtree_set_screen();
			noecho();
			cbreak();
			dtree_dirprint();
			fileprint(".");
			box(pt[1].vs,ACS_VLINE,ACS_HLINE);
			rectang(1);
			break;

		case '-':
		/*
		ディレクトリ移動の履歴を遡る
		*/
			if(dtree_pathisto > 0)
				dtree_pathisto--;
			else
				break;
			if(chdir(dirstack[dtree_pathisto]) == -1)
			{
				sys_errmsg(4,10,"出発点のディレクトリのPATH情報がありません。");
				break;
			}
			dtree_all_cls(1);
			dtree_initbuff();
			dtree_dirprint();
			fileprint(".");
			dtree_clear();
			y = 0;
			yy = 5;
			/*
			dirlocateclear();
			*/
			break;
		case '+':
		/*
		ディレクトリ移動の履歴を戻る
		*/
			if(dtree_pathisto < dtree_pathcnt)
				dtree_pathisto++;
			else
				break;
			if(chdir(dirstack[dtree_pathisto]) == -1)
				break;

			dtree_all_cls(1);
		//	for(j=0;j<MAX_FILES;j++)
		//		regline[j] = 0;
		//	for(j=0;j<MAX_FILES;j++)
		//		cpflag[j] = 0;

			dtree_initbuff();
			dtree_dirprint();
			fileprint(".");
			dtree_clear();
			y = 0;
			yy = 5;
			/*
			dirlocateclear();
			*/
			break;
		case 'c':
		/*
		ディレクトリを移動する。
		*/
		//	execchdir:


			stat(ts[y+(yy-5)].dtree2,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				cret = getcwd(ftmp,256);
				if(1 == 1)
				{
					memset(ftmp,'\0',256);
					
					if(deep < 0 || (readlink(ts[y+(yy-5)].dtree2, ftmp, 256)) != -1)
					{
						deep = 0;
						goto skipdir;
					}
					sprintf(dirlocate[dirlocateyy[deep]], "%s",ts[y+(yy-5)].dtree2);
					dirlocatey[deep] = y;
					dirlocateyy[deep] = yy;
					deep++;
				}
				skipdir:
				if(chdir(ts[y+(yy-5)].dtree2) == -1)
					break;
				cret = getcwd(dirstack[dtree_pathcnt],256);
				if(dtree_pathcnt < 128)
					dtree_pathcnt++;
				if(dtree_pathisto < 128)
					dtree_pathisto++;
				checkhisto();

				dtree_all_cls(1);

				dtree_jump = pathcount(ts[y+(yy-5)].dtree2);

				dtree_initbuff();
				dtree_dirprint();
				fileprint(".");
				dtree_datadisp(1,x,y,5);
				y = 0;
				yy = 5;
				dtree_clear();
			}
			break;
		case 'i':
		/*
		ディレクトリを上に移動する。
		*/
			stat("..",fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				if(chdir("..") == -1)
					break;
				cret = getcwd(dirstack[dtree_pathcnt],256);
				if(dtree_pathcnt < 128)
					dtree_pathcnt++;
				if(dtree_pathisto < 128)
					dtree_pathisto++;
				checkhisto();

				dtree_all_cls(1);

				dtree_set_screen();
				dtree_initbuff();
				dtree_dirprint();
				fileprint(".");
				dtree_datadisp(1,x,y,5);

				if(deep > 0)
				{
					deep--;
					y = dirlocatey[deep];
					yy = dirlocateyy[deep];
					if((yy-5) > (dtree_file_num))
					{
						yy = 5;
					}
					if((yy - dtree_file_num) >= 5)
					{
						yy = (yy - dtree_file_num);
					}
				}
				else
				{
					y = 0;
					yy = 5;
				}
				filer_clear();
				dtree_clear();

				if(dtree_jump > 0)
				{
					y = 0;
					yy = 5;
				}
			}
			break;

		case '':
		/*
		ディレクトリを削除する。
		*/
			stat(ts[y+(yy-5)].dtree2,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				sprintf(buff,"rm -r %s で指定したディレクトリを完全に削除します。",ts[y+(yy-5)].dtree2);
				if(popmsg(2+8,(LINES/2)-4,buff) == 1)
				{
					sprintf(buff,"%s に rm -r を実行します。本当に良いですか？",ts[y+(yy-5)].dtree2);
					if(popmsg(2+8,(LINES/2)-4,buff) == 1)
					{
						sprintf(buff,"rm -rf %s",ts[y+(yy-5)].dtree2);
						ret = system(buff);
					}
					dtree_initbuff();
					dtree_dirprint();
					fileprint(".");
					dtree_datadisp(1,x,y,5);
				}
			}
			goto allCLS2;

		case 'M':
		/*
		ディレクトリを移動または名前を変更する。
		*/
			sprintf(buff,"%s",ts[y+(yy-5)].dtree2);
			input_window(4,2,copybuff,"移動先を入力して下さい");
			if(strlen(copybuff) < (size_t)0)
				break;
			sprintf(buff,"move %s -> %s",ts[y+(yy-5)].dtree2,copybuff);
			if(popmsg(2+8,(LINES/2)-4,buff) == 1)
			{
				stat(copybuff,fptr);
				if((fptr->st_mode & S_IFDIR) != 0)
				{
					sprintf(buff,"mv -f %s %s > /dev/null 2>&1",ts[y+(yy-5)].dtree2,copybuff);
					ret = system(buff);

					dtree_initbuff();
					dtree_dirprint();
					fileprint(".");
				}
				else
				{
					sprintf(buff,"ディレクトリ %s が見つかりません。ディレクトリ名を変更します。",copybuff);
					if(popmsg2(2,(LINES/2)-4,buff) == 1)
					{
						sprintf(buff,"mv -f %s %s > /dev/null 2>&1",ts[y+(yy-5)].dtree2,copybuff);
						ret = system(buff);
						dtree_initbuff();
						dtree_dirprint();
						fileprint(".");
					}
					else
					{
						sprintf(buff," %s ディレクトリ名変更を行いませんでした",copybuff);
						sys_errmsg(4,10,buff);
						break;
					}
				}
			}
			break;
		case 'p':
		/*
		ディレクトリをコピーする。
		*/
			loop1:
			input_window(8,4,copybuff,"コピー先を入力して下さい");
			if(strlen(copybuff) < (size_t)0)
				break;
			sprintf(buff,"cp -pruf %s -> %s",ts[y+(yy-5)].dtree2,copybuff);
			if(popmsg(2+8,(LINES/2)-4,buff) == 1)
			{
				stat(copybuff,fptr);
				if((fptr->st_mode & S_IFDIR) != 0)
				{
					stat(copybuff,fptr);
					if((fptr->st_mode & (S_IWOTH | S_IWGRP | S_IWUSR | S_ISUID | S_ISGID)) != 0)
					{
						sprintf(tmpbuff2,"%s",ts[y+(yy-5)].dtree2);
						sprintf(buff,"cp -pruf %s %s > /dev/null 2>&1",basename(tmpbuff2),copybuff);
						dialogmsg(33,6,buff);
						ret = system(buff);
					}
					else
					{
						sprintf(buff,"%s に書き込み権限がありません。",copybuff);
						sys_errmsg(4,10,buff);
					}
				}
				else
				{
					sprintf(buff,"%s が見つかりません",copybuff);
					sys_errmsg(4,10,buff);
					goto loop1;
				}
			}
			break;
		case 'U':
			if(yy > 5)
			{
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				break;
			}

			y -= 5;
			if(y < 1)
				y = 0;
			dtree_clear();
			break;
		case '': case 'u':
		/*
		半ページ上へ
		*/
			for(i=0;i<(LINES/2) - dtree_botom;i++)
			{
				y -= 1;
				if(y < 1)
				{
					y = 0;
					break;
				}
			}
			dtree_clear();
			break;
 
		case 'D':
		/*
		５行ダウン
		*/
			if(y+yy > MAX_TREE || y+yy > dtree_file_num + 3 || strlen(ts[y+(yy-5)].buff10) < (size_t)1)
			{
				break;
			}
			if(yy < dtree_max_lines - (dtree_botom + 2))
			{
				if(yy >  dtree_max_lines - (dtree_botom + 7))
				{
					yy = dtree_max_lines - (dtree_botom + 7);
				}
				yy++;
				if(yy >= dtree_file_num + 5)
				{
					yy = dtree_file_num + 4;
					break;
				}
				yy++;
				if(yy >= dtree_file_num + 5)
				{
					yy = dtree_file_num + 4;
					break;
				}
				yy++;
				if(yy >= dtree_file_num + 5)
				{
					yy = dtree_file_num + 4;
					break;
				}
				yy++;
				if(yy >= dtree_file_num + 5)
				{
					yy = dtree_file_num + 4;
					break;
				}
				yy++;
				if(yy >= dtree_file_num + 5)
				{
					yy = dtree_file_num + 4;
					break;
				}
				break;
			}

			y += 5;
			if(y >= MAX_TREE - dtree_max_lines)
				y = MAX_TREE - dtree_max_lines;
			
			if(yy < (dtree_max_lines - (dtree_botom + 2)))
				yy = dtree_file_num - 5;

			dtree_clear();
			break;

		case '': case 'd':
		/*
		半ページ下へ
		*/
			if(y > (dtree_file_num - (dtree_max_lines - 7)))
				break;
			if(y > MAX_TREE || y+(yy-5) > (dtree_file_num + 4) - (dtree_max_lines - dtree_botom) + 7)
				break;
			for(i=0;i<(LINES/2)-3;i++)
			{
				y += 1;
				if(y >= MAX_TREE - dtree_max_lines)
				{
					y = MAX_TREE - dtree_max_lines;
					break;
				}
			}
			if(y > dtree_file_num - dtree_max_lines)
				y = dtree_file_num - (dtree_max_lines - 8);
			dtree_clear();
			break;

		 case 'k': case 'K': case 0x41:
		/*
		上スクロール
		*/
			if(yy > 5)
			{
				yy--;
				break;
			}

			y -= 1;
			if(y < 1)
			{
				y = 0;
			}
			dtree_clear();
			break;

		 case 'j': case 'J': case 0x42:
		/*
		下スクロール
		*/
			if(y+yy > MAX_TREE || y+yy > dtree_file_num + 3)
				break;
			if(yy > dtree_file_num + 5)
			{
				break;
			}
			if(yy < (dtree_max_lines - (dtree_botom + 2)) && yy <= dtree_file_num + 5)
			{
				yy++;
				break;
			}

			y += 1;
			if(y >= MAX_TREE - dtree_max_lines)
			{
				y = MAX_TREE - dtree_max_lines;
			}

			dtree_clear();
			dtree_set_screen();
			break;

		case '!':
		/*
		シェルモードへ移行
		*/
			ret = system("clear");
			if((vp = (char *)getenv("SHELL")) == NULL)
			{
				sprintf(buff,"/bin/stty echo onlcr;/bin/ksh");
			}
			else
			{
				sprintf(buff,"/bin/stty echo onlcr eof ;%s",vp);
			}
			echo();
			nocbreak();
			nl();
			ret = system("echo [m");
			ret = system(buff);
			wclear(pt[1].vs);
			dtree_set_screen();
			noecho();
			cbreak();

			box(pt[1].vs,ACS_VLINE,ACS_HLINE);
			rectang(1);

			dtree_initbuff();
			dtree_dirprint();
			fileprint(".");
			y = 0;
			yy = 5;
			break;

		case 'P':
		/*
		カレントディレクトリ全ファイルの画面出力
		*/
			if(popmsg(2+8,(LINES/2)-4,"画面に出力します") == 1)
			{
				ret = system("clear");
				wclear(pt[1].vs);
				dtree_set_screen();
			}
			break;

		case 'S':
		/*
		画面の再描画
		*/
			dtree_set_screen();
			rectang(1);
			wrefresh(pt[1].vs);
			break;

		case '':
			dialogmsg(12,7,"ＭＡＫＥコマンドを実行中です");
			/*
			ret = system("make > /dev/null 2>&1 | topic -c64 -x4 -y4 -l14");
			ret = system("make 2>&1 | topic -c64 -x4 -y4 -l14 -e");
			*/
			noraw();
			echo();
			nl();
			nocbreak();
			sprintf(ftmp,"%s",ts[y+(yy-5)].buff10);
			if((nln = strchr(ftmp,'.')) != NULL)
				*nln = '\0';
			sprintf(buff,"/bin/stty onlcr;make %s 2>&1 | more",ftmp);
			printf("\033[2J");
			/*
			sys_errmsg(4,10,buff);
			ret = system("/bin/stty onlcr;make 2>&1 | more");
			*/
			ret = system(buff);
			raw();
			noecho();
			nonl();
			cbreak();

			dtree_initbuff();
			dtree_dirprint();
			fileprint(".");
			y = 0;
			yy = 5;

			wclear(pt[1].vs);
			dtree_set_screen();
			break;

		case 'm':
		/*
		ディレクトリを作成する
		*/
			input_window(4,2,buff,"作成するディレクトリ名を入力");
			if(strlen(buff) < (size_t)0)
				break;
			if(popmsg(6,(LINES/2)-4,buff) == 0)
			{
				break;
			}
			if(strlen(buff) < (size_t)1)
				break;
			/*
          		S_IRUSR        所有者による読出し
           		S_IWUSR        所有者による書込み
           		S_IXUSR        所有者による実行(検索)
           		S_IRGRP        グループによる読出し
           		S_IWGRP        グループによる書込み
           		S_IXGRP        グループによる実行(検索)
           		S_IROTH        他人(つまり、誰でも)による読出し
		   */
			if(mkdir(buff,S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IWGRP|S_IXGRP|S_IROTH) == -1)
				break;
			stat(buff,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				dtree_initbuff();
				dtree_dirprint();
				fileprint(".");
			}
			break;

		case 'O':
		/*
		入力でディレクトリを移動する
		*/
			input_window(4,2,buff,"移動するディレクトリ名を入力");
			if(strlen(buff) < (size_t)1)
				break;
			stat(buff,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				if(chdir(buff) == -1)
					break;

				cret = getcwd(dirstack[dtree_pathcnt],256);
				if(dtree_pathcnt < 128)
					dtree_pathcnt++;
				if(dtree_pathisto < 128)
					dtree_pathisto++;
				checkhisto();

				dtree_initbuff();
				dtree_dirprint();
				fileprint(".");
				y = 0;
				yy = 5;
			}
			break;

		case 'C':
		/*
		全ウインドウの再描画
		*/
	//	allCLS:
			wclear(pt[1].vs);
			dtree_max_lines = LINES;
			delwin(pt[1].vs);
			pt[1].vs = newwin(dtree_max_lines - dtree_botom,COLS,1,0);
			dtree_set_screen();
			box(pt[1].vs,ACS_VLINE,ACS_HLINE);
			wrefresh(pt[1].vs);
			delwin(evs);
			evs = newwin(3,COLS,LINES-1,0);
			dtree_displaymenu1(evs,dflag);
			for(j=0;j<256;j++)
			{
				memset(selcp[j],'\0',64);
			}
			dtree_all_cls(1);
			dtree_dirprint();
			fileprint(".");
			break;

		 case 'Z':
		allCLS2:
			for(j=0;j<256;j++)
			{
				memset(selcp[j],'\0',512);
			}
			dtree_all_cls(1);

			for(j=5;j < (dtree_file_num - (dtree_max_lines - 8));j++)
				vs_print("x",pt[1].vs,dtree_line1[0]+1,j);
			dtree_dirprint();
			fileprint(".");
			break;

		case 0x0d: case 0x0a:

			stat(ts[y+(yy-5)].dtree2,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				cret = getcwd(ftmp,256);
				if(1 == 1)
				{
					memset(ftmp,'\0',256);
					
					if(deep < 0 || (readlink(ts[y+(yy-5)].dtree2, ftmp, 256)) != -1)
					{
						deep = 0;
						goto skipdir2;
					}
					dirlocateclear();
					sprintf(dirlocate[dirlocateyy[deep]], "%s",ts[y+(yy-5)].dtree2);
					dirlocatey[deep] = y;
					dirlocateyy[deep] = yy;
					deep++;
				}
				skipdir2:

				if(chdir(ts[y+(yy-5)].dtree2) == -1)
					break;

				cret = getcwd(dirstack[dtree_pathcnt],256);
				if(dtree_pathcnt < 128)
					dtree_pathcnt++;
				if(dtree_pathisto < 128)
					dtree_pathisto++;
				checkhisto();

				dtree_initbuff();
				dtree_dirprint();
				dtree_datadisp(1,x,y,5);
				y = 0;
				yy = 5;
				dmode = 'h';
				dtree_clear();
			//	filer_clear();
				set_screen2();
				dirprint_all(".",dtree_fmode);
			}
			swptmp = getpid();
			sprintf(buffx,"%d",swptmp);
			sprintf(buffy,"/tmp/dtree1.%s",buffx);
			sprintf(buffz,"/tmp/dtree2.%s",buffx);
			unlink(buffy);
			unlink(buffz);
			sprintf(buffy,"/tmp/dtree1.root.%s",buffx);
			sprintf(buffz,"/tmp/dtree2.root.%s",buffx);
			unlink(buffy);
			unlink(buffz);
			return(0);
		/*
		検索実行
		*/
		 case 'q': case 'Q':
		/*
		終了
		*/
			if(popmsg(30,LINES - 11,"終了します") == 1)
				goto dtree_end;
			break;

		 case '3':
			swptmp = getpid();
			sprintf(buffx,"%d",swptmp);
			break;
		}
	}
	dtree_end:
	swptmp = getpid();
	sprintf(buffx,"%d",swptmp);
	sprintf(buffy,"/tmp/dtree1.%s",buffx);
	sprintf(buffz,"/tmp/dtree2.%s",buffx);
	unlink(buffy);
	unlink(buffz);
	sprintf(buffy,"/tmp/dtree1.root.%s",buffx);
	sprintf(buffz,"/tmp/dtree2.root.%s",buffx);
	unlink(buffy);
	unlink(buffz);

	endwin();
//	printf("\033[5>l");
	printf("\033[2J");
	exit(0);
}

/************************************************************************/
/* NAME      :void dtree_all_cls()*/
/* FUNCTION  :該当ウインドウを消去し再度作成する*/ 
/*            */ 
/*int no;	ウインドウ番号*/
/*int col;	カラム番号*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::dtree_all_cls(int no)
{
	int j;

	wclear(pt[no].vs);
	max_lines = LINES;
	delwin(pt[no].vs);
	pt[no].vs = newwin(LINES - 2,90,1,0);
	dtree_set_screen();
	box(pt[no].vs,ACS_VLINE,ACS_HLINE);
	wrefresh(pt[no].vs);
	for(j=0;j<256;j++)
	{
		memset(selcp[j],'\0',512);
	}
	for(j=0;j<MAX_TREE;j++)
		regline[j] = 0;
	for(j=0;j<MAX_TREE;j++)
		cpflag[j] = 0;
	intCPnum = 0;
	wclrtoeol(pt[no].vs);
}

/************************************************************************/
/* NAME      :void dtree_datadisp()*/
/* FUNCTION  :指定された範囲でファイルを表示する*/ 
/*            */ 
/*int no;	ウインドウ番号*/
/*int x;	桁位置*/
/*int y;	行位置*/
/*int sy;	表示開始行*/
/*int end;	表示終了行*/
/*int start;	表示開始*/
/*int end2;	表示終了*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::dtree_datadisp(int no,int x,int y,int sy)
{
	int i;

	for(i=0;i < LINES - 3;i++)
	{
		vs_print(ts[i+y].buff10,pt[no].vs,dtree_line1[0]+2,i+sy);
	//	vs_print(ts[i+y].buff3,pt[no].vs,dtree_line1[1]+1,i+sy);
		vs_print(ts[i+y].buff1,pt[no].vs,dtree_line1[1]+1,i+sy);
		vs_print(ts[i+y].buff5,pt[no].vs,dtree_line1[2]+1,i+sy);
		vs_print(ts[i+y].buff6,pt[no].vs,dtree_line1[3]+1,i+sy);
		if (regline[i+y] == 1)
			vs_print("*",pt[1].vs,dtree_line1[0]+1,i+sy);
	}
}

/************************************************************************/
/* NAME      :void set_screen()*/
/* FUNCTION  :ファイルを表示する４つのウインドウを描画する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::dtree_set_screen(void)
{
	int i;
	for(i=2;i<dtree_max_lines - dtree_botom;i++)
	{
		mvwprintw(pt[1].vs,i,dtree_line1[1],"|");
		mvwprintw(pt[1].vs,i,dtree_line1[2],"|");
		mvwprintw(pt[1].vs,i,dtree_line1[3],"|");
		mvwprintw(pt[1].vs,i,dtree_line1[4],"|");
//		mvwprintw(pt[1].vs,i,dtree_line1[5],"|");
	}
	for(i=0;i<89;i++)
	{
		mvwprintw(pt[1].vs,2,i,"-");
		mvwprintw(pt[1].vs,4,i,"-");
	}
	wmove(pt[1].vs,1,1);
	mvwaddstr(pt[1].vs,3,dtree_line1[0]+1,"  DirectoryName");
	mvwaddstr(pt[1].vs,3,dtree_line1[1]+1,"  FileName");
	mvwaddstr(pt[1].vs,3,dtree_line1[2]+1,"  Attr");
	mvwaddstr(pt[1].vs,3,dtree_line1[3]+1,"  Owner");
}


/************************************************************************/
/* NAME      :void dtree_initbuff()*/
/* FUNCTION  :テキスト配列を初期化する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::dtree_initbuff(void)
{
	int i;
	for(i=0;i<MAX_TREE;i++)
	{
		memset(ts[i].buff10, '\0',sizeof(ts[i].buff10));
	//	memset(ts[i].buff3, '\0',sizeof(ts[i].buff3));
		memset(ts[i].buff1, '\0',sizeof(ts[i].buff1));
		memset(ts[i].buff5, '\0',sizeof(ts[i].buff5));
		memset(ts[i].buff6, '\0',sizeof(ts[i].buff6));
	}
}

/************************************************************************/
/* NAME      :void dtree_displaymenu1()*/
/* FUNCTION  :キーメニューを表示する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::dtree_displaymenu1(WINDOW *evs,int flag)
{
	if(flag)
	{
		mvwprintw(evs,0,1,"chdir cp exec edit find view Mv mkdir ^Remove Quit    ");
		mvwprintw(evs,0,52+2,"j down k up ^D down ^U up");

		wattron(evs,A_REVERSE);
		mvwprintw(evs,0,1,"%c",'c');
		mvwprintw(evs,0,8,"%c",'p');
		mvwprintw(evs,0,11,"%c",'x');
		mvwprintw(evs,0,15,"%c",'e');
		mvwprintw(evs,0,20,"%c",'/');
		mvwprintw(evs,0,25,"%c",'v');
		mvwprintw(evs,0,30,"%c",'M');
		mvwprintw(evs,0,33,"%c",'m');
		mvwprintw(evs,0,39,"%c",'^');
		mvwprintw(evs,0,40,"%c",'R');
		mvwprintw(evs,0,47,"%c",'Q');

		mvwprintw(evs,0,52+2,"%c",'j');
		mvwprintw(evs,0,59+2,"%c",'k');
		mvwprintw(evs,0,64+2,"%c",'^');
		mvwprintw(evs,0,65+2,"%c",'D');
		mvwprintw(evs,0,72+2,"%c",'^');
		mvwprintw(evs,0,73+2,"%c",'U');
		wattroff(evs,A_REVERSE);
	}
	else
	{
		mvwprintw(evs,0,1,"Fconv fconv Cls rmdir Top Gotom ^Attr ^Home ^Back ^topic Help -prev +next");
		wattron(evs,A_REVERSE);
		mvwprintw(evs,0,1,"%c",'F');
		mvwprintw(evs,0,7,"%c",'f');
		mvwprintw(evs,0,13,"%c",'C');
		mvwprintw(evs,0,17,"%c",'r');
		mvwprintw(evs,0,23,"%c",'T');
		mvwprintw(evs,0,27,"%c",'G');
		mvwprintw(evs,0,27+6,"%c",'^');
		mvwprintw(evs,0,28+6,"%c",'A');
		mvwprintw(evs,0,33+6,"%c",'^');
		mvwprintw(evs,0,34+6,"%c",'H');
		mvwprintw(evs,0,39+6,"%c",'^');
		mvwprintw(evs,0,40+6,"%c",'B');
		mvwprintw(evs,0,45+6,"%c",'^');
		mvwprintw(evs,0,52+6,"%c",'H');
		mvwprintw(evs,0,57+6,"%c",'-');
		mvwprintw(evs,0,63+6,"%c",'+');
		wattroff(evs,A_REVERSE);
	}
	wrefresh(evs);
	werase(evs);
}

/************************************************************************/
/* NAME      :int get_dtree()*/ 
/* FUNCTION  :ディレクトリツリーをウインドウに表示する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    : ０：処理成功、０以外：処理失敗                           */
/************************************************************************/
int LocalTree::get_dtree(void)
{
	WINDOW *hvs;

	FILE *fp;
	int i;
	char *newline;
	char *ev;
	char ebuff[129];
	char buff[256];
	char buffx[256];
	char buffy[256];
	char buffz[256];
	unsigned int swptmp;
	char *cret;

//	static char dbuff1[] = "/tmp/dtree1.swp";
//	static char dbuff2[] = "/tmp/dtree2.swp";
	char dbuffroot1[256]; // "/tmp/dtree1.root.swp";
	char dbuffroot2[256]; // "/tmp/dtree2.root.swp";

	swptmp = getpid();
	sprintf(buffx,"%d",swptmp);
	sprintf(buffy,"/tmp/dtree1.%s",buffx);
	sprintf(buffz,"/tmp/dtree2.%s",buffx);
	sprintf(dbuffroot1,"/tmp/dtree1.root.%s",buffx);
	sprintf(dbuffroot2,"/tmp/dtree2.root.%s",buffx);

	if((ev = (char *)getenv("TMP")) == NULL)
	{
		strcpy(ebuff,"/tmp");
	}
	else
	{
		strcpy(ebuff,ev);
		strcat(ebuff,"/tmp");
	}
	if(strlen(ebuff) > (size_t)128)
	{
		sys_errmsg(4,10,"HELP_DIR to long");
		return -1;
	}
	cret = getcwd(buff,256);
	if((strcmp(buff, "/")) == 0)
	{
		if((fp = fopen(dbuffroot1,"r")) == NULL)
		{
			sys_errmsg(4,10,"dtree.root.(PID) ファイルを読み込めません。");
			return 0;
		}
	}
	else
	{
		if((fp = fopen(buffy,"r")) == NULL)
		{
			return -1;
		}
	}
	


	i = 0;
	while(fgets(ts[i].dtree1,128,fp) != NULL)
	{
		if((newline = (char *)strchr(ts[i].dtree1,'\n')) != NULL)
		{
			*newline = '\0';
			i++;
		}
	}
	fclose(fp);
	if((strcmp(buff, "/")) == 0)
	{
		if((fp = fopen(dbuffroot2,"r")) == NULL)
		{
			return -1;
		}
	}
	else
	{
		if((fp = fopen(buffz,"r")) == NULL)
		{
			return -1;
		}
	}
	
	i = 0;
	while(fgets(ts[i].dtree2,128,fp) != NULL)
	{
		if((newline = (char *)strchr(ts[i].dtree2,'\n')) != NULL)
		{
			*newline = '\0';
			i++;
		}
	}
	fclose(fp);
	return(i);
}

/************************************************************************/
/* NAME      :int fileprint(char *)*/ 
/* FUNCTION  :ディレクトリを配列に記録する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::fileprint(const std::string Dname)
{
	struct dirent *dp;
	int i=0;
//	int j=0;
//	int k=0;
//	struct tm *ftm;
	char cwdpath[512];
	char attrbuff[128];	//48バイトしか確保していなかったバグ修正 2012.5.5
	char *cret;

	if((dir = opendir(Dname.c_str())) == (DIR *)NULL)
		exit(1);
	while((dp = readdir(dir)) != (struct dirent *)NULL)
	{
		stat(dp->d_name,fptr);
		if(!S_ISDIR(fptr->st_mode))
		{
			if(dmode == 'v')
			{
				sprintf(ts[i].buff1,"%-23s",dp->d_name);
				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(ts[i].buff5,"%-10s",attrbuff);
			//	sprintf(ts[i].buff6," %s",cmpgid(fptr->st_gid));
				sprintf(ts[i].buff6," %s",cmpuid(fptr->st_uid));
				i++;
			}
			if(dp->d_name[0] != '.' && dmode == 'h')
			{
				sprintf(ts[i].buff1,"%-23s",dp->d_name);
				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(ts[i].buff5,"%-10s",attrbuff);
			//	sprintf(ts[i].buff6," %s",cmpgid(fptr->st_gid));
				sprintf(ts[i].buff6," %s",cmpuid(fptr->st_uid));
				i++;
			}
		}
		else
		{
			cret = getcwd(cwdpath,512);
			if(!strcmp(cutspace(cwdpath),"/"))
			{
				if(dp->d_name[0] == '.')
					continue;
			}
			if(dmode == 'v')
			{
				sprintf(ts[i].buff1,"%-23s",dp->d_name);
				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(ts[i].buff5,"%-10s",attrbuff);
			//	sprintf(ts[i].buff6," %s",cmpgid(fptr->st_gid));
				sprintf(ts[i].buff6," %s",cmpuid(fptr->st_uid));
				i++;
			}
			if(dp->d_name[0] != '.' && dmode == 'h')
			{
				sprintf(ts[i].buff1,"%-23s",dp->d_name);
				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(ts[i].buff5,"%-10s",attrbuff,1);
			//	sprintf(ts[i].buff6," %s",cmpgid(fptr->st_gid));
				sprintf(ts[i].buff6," %s",cmpuid(fptr->st_uid));
				i++;
			}
			if(i > MAX_TREE - 1)
			{
				closedir(dir);
				return;
			}
		}
	}
	closedir(dir);
}
/************************************************************************/
/* NAME      :int dtree_dirprint(void)*/ 
/* FUNCTION  :ディレクトリを配列に記録する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalTree::dtree_dirprint(void)
{
	int i=0;
//	int j=0;
//	int k=0;
	int fline;
	unsigned int pid;
	struct tm *ftm;
//	char cwdpath[512];
	char attrbuff[256];
	char buff[256];
	char buffx[256];
	char buffy[256];
	char buffz[256];
	unsigned int swptmp;
	char *cret;
	int ret;

	dialogmsg(33,6,"少々お待ちください");

	cret = getcwd(buff,256);
	if((strcmp(buff, "/")) != 0)
	{
		swptmp = getpid();
		sprintf(buffx,"%d",swptmp);
		sprintf(buffy,"dtree.sh > /tmp/dtree1.%s",buffx);
		sprintf(buffz,"dtree_path.sh > /tmp/dtree2.%s",buffx);
		ret = system(buffy);
		ret = system(buffz);
	}
	else
	{
		swptmp = getpid();
		sprintf(buffx,"%d",swptmp);
		sprintf(buffy,"dtree.root.sh > /tmp/dtree1.root.%s",buffx);
		sprintf(buffz,"dtree.root_path.sh > /tmp/dtree2.root.%s",buffx);
		ret = system(buffy);
		ret = system(buffz);
	}

	fline=get_dtree();

	for(i=0;i<fline;i++)
	{
		sprintf(ts[i].buff10,"%s",ts[i].dtree1);
	}
	if(i > MAX_TREE - 1)
	{
		dtree_file_num = MAX_TREE;
		return;
	}
	dtree_file_num = fline;
}

/************************************************************************/
/* NAME      :int dtree()*/ 
/* FUNCTION  :ファイラーのメインルーチン*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
int LocalTree::dtree(void)
{
//	int i,j,k;
	int ret;
	char *vp;
	char *cret;

	/*
	signal(SIGINT,SIG_IGN);
	signal(SIGWINCH,resize);
	*/
	initscr();
	cbreak();
	noecho();
	if((vp = getenv("HOME")) == NULL)
	{
		sys_errmsg(4,10,"環境変数 HOME が設定されていません。");
		sprintf(homedirname,"/home");
	}
	else
	{
		sprintf(homedirname,"%s",vp);
	}
	bookmark();
	readowner();
	readgroup();
	cret = getcwd(startdirname,256);

	dtree_max_lines = LINES;

//	i = j = k= 0;
	while(1)
	{
		ret = tree(1,dtree_max_lines);
		switch(ret)
		{
		case 0:
			goto end;
		default:
			break;
		}
	}
	end:
	endwin();
	printf("\033[2J");
	printf("\n");
	return(0);
}

