#pragma ident "@(#) filer.cc 2.2.4 2012.12.10,14:54"
/*

コンプリートウォーカー(Complete Walker)

	本プログラムはひとつのログインユーザだけで複数の開発を管理出来るように
	考えられたプログラム設計システムです。
	そのシステムの核となるのが、本プログラムコマンド cw です。
	本プログラムは開発システム自体がファイルシステムになっており、
	各Linux の /home の下に作成されるログインディレクトリ名として登録する
	形になっています。
	今回 cw は5つのシステムを統合しました。
	最初はローカルファイラーとしての cw 、それにツリー構造を操作するツリー
	ファイラー、また、インターネット接続をFTPで行う FTP ファイラー、そして、
	データベースとの接続を行うプログラムを自動作成するASE エディタ、最後は、
	この開発システム自体をファイラーする CMS ファイラー cf です。
	そして、これらのプログラムのソースコードは、C++ 言語のクラスを採用しました。
	そのため、部分活用、全体活用とも C言語の場合より楽になっています。
	但し、ASE エディタが利用するライブラリは C言語で書いたままにしてあります。

	また、開発システムがディレクトリ構造そのものなので、他のコンピュータへの
	移動が非常に簡単に出来るのが大きな特徴となっています。

	本システムを利用することで、複雑なシステムの開発管理を論理的に
	ナビゲーションすることが可能となります。
	また、Complte Wlakerは開発ターゲットを以下に絞ってあります。

	開発環境
		Linux

	ユーザインターフェース
		CUESESライブラリを利用したCUIです。

	データベース
		PostgreSQLデータベース
		ECPGプリプロセッサを活用してDBグリッドを設計します。

	インターネット
		FTPプロトコルを利用したファイラークラスを提供します。

	バージョン/リビジョンコントロール
		CMS(Change Management System)
		バージョン管理は本システムの第二の核になるシステムです。
		Kshの機能を利用しています。



1.ファイル管理
	CW - Linux ファイラー(vi ライクな操作でファイル管理)

概要
	Linux用の汎用ファイラー。
	CURSESライブラリを利用し、ウインドウを定義することでビジュアルに
	ファイルを操作出来るようにしてあります。
	操作出来るファイルの数は１ディレクトリ当たり4096個です。
	本ファイラーの特徴はLinuxコマンドを実行する 機能を中心にしたことです。
	そのためシェルスクリプトも実行コマンドとして
	利用します。たとえば dtree.sh や fconv.shシェルコマンドです。
	FTXクラスライブラリとリンクしてありますので、FTPファイラー
	cwの機能の詳細については cwのマニュアルを参照して下さい。


機能
	ツリー表示
		ツリー表示は以下のシェルスクリプトを利用します。
		dtree.sh
		dtree_path.sh
		dtree.root.sh
		dtree.root_path
		以上のスクリプトはfindコマンドとawk+sedを使用して/tmpディレクトリに
		ディレクトリのツリーとパス名の2つのファイルを作成します。
		ルートディレクトリのツリー表示はそのためだけの2つのファイルを作成し
		ます。
		通常ツリーはカレントディレクトリ以下を表示するため、カレントディレクトリ
		が深い場合ツリーは大きなサイズのファイルを必要とします。
		そのため特に、ルートディレクトリの他、/usr /usr/lib 等の表示には時間が
		かかります。
		ツリー行の最大行は 8192行になります。（#define MAX_TREE で調整可能）
		ツリー表示での操作はソースファイル dtree.cc を参考にしてください。

	コピー機能
		＜ファイラー＞
		ファイルのコピーは cp コマンドをオプション無しで使用します。 
		ファイラーコマンド'p'でコピーを行う場合は同名ファイルの存在についても
		チェックを行うので不要な上書きを防止出来ます。
		TABキーで選択し、''で実行するファイルの複数コピーを行う場合は
		同名ファイルの上書きチェックをしていませんので注意してください。
		＜ツリー＞
		ファイルのコピーは cp コマンドの -pruf オプションを使用します。 
		ディレクトリのコピーを行うためコピー先ディレクトリの中の同名ファイル
		のチェックは行いません。
		この機能は危険な場合もありますが、ディレクトリを一括してバックアップする
		のに便利です。
		選択したディレクトリの一括コピー機能でバックアップすると良いでしょう。
	削除機能
		ファイルの削除は''コマンドで行います。TAB キーで選択して削除する
		場合は、'' と2回続けて '' キーを押してください。
	ブックマーク
		移動したディレクトリをブックマークとして保存出来ます。
		保存するファイル名は環境変数 $HOME に設定されたディレクトリにbookmark.cw
		というファイルになります。
		ブックマークされたディレクトリに移動する場合はファイラーから'~'コマンド
		によってブックマークメニューを表示します。
		ブックマークメニューからは'j','k',や矢印キーでディレクトリの選択を行い、
		Enter,または'c'コマンドで指定したブックマークに移動出来ます。
		カレントディレクトリをブックマークに保存するには'^K'コマンドで行います。

	FTXファイラー
		'X'に続き'X'とダブル'X'をコマンドすると、FTXファイラーが表示されます。
		FTXファイラーはビジュアルに操作可能なFTPクライアントです。
		ファイルの送信、受信はローカルミニファイラーとの切替えで行います。
		'X' が最初のダブルコマンドで操作します。（例：'X''S' = 送信）
		クラスライブラリ化してあるので、cw 以外のファイラーでもソースコードさえ
		あればリンク可能となっています。参考に C++ と C言語両方のリンク用の
		サンプルコードを用意しました。
		詳細は FTX のマニュアルを参考にしてください。

	ASEエディタ
		.pgc .def という拡張子のファイルを Enter キーで開きます。
		.pgc は vi .def は ASE エディタの画面になります。
		Automatic Subform Editor というデータベースグリッド設計エディタです。
		データベースは PostgreSQL に対応しています。
		DBグリッドを設計し、 ECPG プリプロセッサに対応したソースコードの生成が
		出来ます。CW では ASE が生成する定義ファイル(.def)やSQLスクリプト
		ファイル(.sql)そして ECPGファイル(.pgc)をアンダーラインや強調表示で
		明示的に扱っています。
		なお、ASE エディタに関連して、libsubform.a というDB操作ライブラリを
		C言語のソース付で用意してあります。
		詳細は libsubformと ASE のマニュアルを参考にしてください。

	CMS リビジョン管理ファイラー
		'_' コマンドでCMS ファイラーに変身します。
		CMSファイラーはファイル管理の他にCMS登録ソースファイルの差分管理を行う
		ファイラーです。CMSのシェルコマンドを実行します。
		リビジョン管理ファイラーなので、/cms 配下ではCMSに登録されたファイル
		しか表示しません。
		'S' が最初のダブルコマンドで利用します。（例：'S''B' = PUT）
		他のファイラー機能はCW と同等です。

2.ＣＭＳ

		cw や cf はバージョン管理を行う cmsmenu というプログラムを実行出来ます。
		cf はそれ自体が cms 専用ファイラーです。
		'@'コマンドで cmsmenu を起動しバージョン/リビジョンの管理が行えます。
		cw と cf については cw.txt を御覧ください。

		さて、CMSが管理するディレクトリは以下のディレクトリになります。

		+cms
		  +bin				CMSのコマンド専用
		  +diff
		  | +lock			排他成制御用（各種制御用ファイルも含む）
		  | | +ase
		  | | +cms
		  | | +curlib01
		  | | +cw
		  | | +ftx
		  | | +libsubform
		  | +log			CMS操作の記録
		  | +tabs			各ソースの管理ファイル
		  | +mr				修正記録の管理
		  | | +ver_0
		  | | +ver_1
		  | | +ver_2
		  | | +ver_3
		  | | +ver_4
		  | | +ver_5
		  | | +ver_6
		  | | +ver_7
		  | | +ver_8
		  | | +ver_9
		  | +tr				故障記録の管理
		  | | +ver_0
		  | | +ver_1
		  | | +ver_2
		  | | +ver_3
		  | | +ver_4
		  | | +ver_5
		  | | +ver_6
		  | | +ver_7
		  | | +ver_8
		  | | +ver_9
		  | +ver_0			差分の管理(バージョン0〜9、リビジョン0〜99)
		  | +ver_1
		  | +ver_2
		  | +ver_3
		  | +ver_4
		  | +ver_5
		  | +ver_6
		  | +ver_7
		  | +ver_8
		  | +ver_9
		  +etc				FTXの管理ファイル(hosts.ftx)
		  +fusr				CMS ログインユーザ用(full contact user)
		  | | +ase			オートマチックサブフォームエディタのソース
		  | | +cms			CMSメニュー等のソースと cf のソース
		  | | +curlib01		wsubform用のユーティリティ関数等
		  | | +cw			コンプリートウォーカー本体
		  | | +ftx			FTPクラスライブラリ + ローカルファイラークラス
		  | | +libsubform	DBグリッド＆サブフォームライブラリ
		  +musr				CMS ログインユーザ用（個人用 make user）
		  | | +gun
		  | | +emi
		  | | +ono
		  +src				最新のソースファイル
		  | | +ase
		  | | +cms
		  | | +curlib01
		  | | +cw
		  | | +ftx
		  | | +libsubform
		  +man				各開発システムのマニュアル等
		  | | +ase
		  | | +cms
		  | | +curlib01
		  | | +cw
		  | | +ftx
		  | | +libsubform
		  +doc				CMS自身ののマニュアルとドキュメント
		  +lib				kterm & teraerm 用の端末制御ファイルソース
		  | | +terminfo		kterm & teraerm 用の端末制御ファイル
		  +siten			バージョン起点のソースファイル
		  | | +ase
		  | | +cms
		  | | +curlib01
		  | | +cw
		  | | +ftx
		  | | +libsubform
		  +sub				submitされたファイル
		  +tmp				テンポラリディレクトリ


		CMSの詳しい説明はCMSマニュアルを参照してください。


	All Rights Reserved Shigeki.Ono (C)2009
*/
#include "../ftx/ftx.h"
#include "../ftx/filer.h"
#include <sys/wait.h>


#define ON 1
#define OFF 0
#define MAX_WINDOW 1

//以下のインスタンス名は本ライブラリで固定されている。
//ファイラーのためのリストボックスクラス
extern ListBox *pFilerListBox;
//ホスト、ユーザ、パスワードを管理するリストボックスクラス
extern ListBox *pListBox;
//FTPとの応答を記録するリストボックスクラス（詳細情報）
extern ListBox *ImmLog;
//FTPのLIST受信ファイルを読み取るクラス
extern OpenFileListBox *ftp;

//ASEのためのクラスとインスタンスと各フラグ
extern AseEditor *aseeditor;
//extern int ConnectASE(int argc, char *argv[]);
extern	int fulldisplay;
extern	int readflg;
extern	int nonopt;
extern	int dbtitle;

//static char *argv[] = {"ase","-c80","-l25","noname.def"};
//char *argv[10];

//ファイラーのためのクラスとインスタンス
LocalFiler *uf;
LocalTree *dtree;
CMSLocalFiler *cms;


//ウインドウ１と２のカラム位置
extern int line1[];
//ウインドウ３と４のカラム位置
extern int line2[];
//ヘルプ表示のための配列。80*25の画面に収まるようになっている。

static char helpbuff[22][128] =
	{" H  このヘルプを表示                i  ひとつ上へ",
	" v  ファイルを表示                   選択ファイル移動",
	" e  ファイルを編集                  C  画面の更新",
	"  SHIFT-JISに変換                  vi の実行",
	" x  実行ファイルを実行              @  CMS の起動",
	" p  ファイルをコピー                t  画面の先頭へ",
	"  選択ファイルコピー              g  最後尾に",
	" m  ディレクトリを作成              !  シェルモードに",
	" r  ディレクトリを削除              2  アクセス時刻表示",
	"^R  ファイルを削除                  9  作成年月表示",
	" c  ディレクトリを移動              0  作成時刻表示",
	"  移動ディレクトリ入力            1  メニュー表示切替",
	" F  UTF-8に変換                     u  半画面上に",
	" M  ファイル移動/名前変更           d  半画面下に",
	" 選択ファイルを削除             j  一行下に  k 一行上に",
	"  属性を変更                       tar -czf  T tar -xzf  =複数選択",
	"  cw を起動した場所に             ~  ブックマークの選択",
	"^H  $HOME に戻る                    ^ .ファイルの表示非表示",
	" -  以前に移動した場所に移動        \\ カレントツリーに変身",
	" +  以前に移動した場所から移動       ブックマーク位置を保存",
	" n  検索を開始。入力は '/' で       ~  ブックマークメニューを開く",
	" f  EUCに変換                       TAB ファイルを複数選択する"
	};

 static char ehelpbuff[22][128] =
	{" H  Display this help               i  Go to Parent directory",
	" v  Display a file                   Choice file move",
	" e  Vi edit-file                    C  Refresh screen",
	" f  Convert into SHIFT-JIS           Edit a vi new-file",
	" x  Execute of file                 @  Enter the CMS",
	" p  File copy                       t  Go to top line",
	"  Copy of choice files            g  Go to bottom line",
	" m  Make directory                  !  Go to shell mode",
	" r  Remove directory                2  Update Time",
	"  Remove file                     9  Create date",
	" c  Change directory                0  Create time",
	"  Jump directory                  1  Change of the menubar",
	" F  Convert into UTF-8              u  Half screen up",
	" M  Move file(rename)               d  Half screen down",
	" Choice remove                  j  1 line down  k 1line up",
	"  Change attribute                 tar -czf  T tar -xzf  =plural",
	"  Back to start directory         ~  Choice to Bookmark",
	"^H  Back to $HOME directory         ^  Display to all file",
	" -  Previus directory               \\ Change to Tree-Filer",
	" +  Next directory                   Save of the curennt directory",
	" /  Find file or directory(and n)   TAB Plural choice",
	" f  Convert into EUC"
	};

/************************************************************************/
/* NAME      :void helpmsg()*/ 
/* FUNCTION  :ヘルプを表示する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
static void helpmsg(int x,int y)
{
	WINDOW *pvs;
//	int ch;
	int i;
	pvs = newwin(23,78,y,x);

	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');

	noecho();
	for(i=0;i<22;i++)
	{
		mvwprintw(pvs,i+0,1,"%-78s"," ");
		mvwprintw(pvs,i+0,1,"%s",helpbuff[i]);
	}
	wattroff(pvs,A_REVERSE);
	wrefresh(pvs);
	wgetch(pvs);
	delwin(pvs);
}

static void helpmsg2(int x,int y)
{
	WINDOW *pvs;
//	int ch;
	int i;
	pvs = newwin(23,78,y,x);

	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');

	noecho();
	for(i=0;i<22;i++)
	{
		mvwprintw(pvs,i+0,1,"%-78s"," ");
		mvwprintw(pvs,i+0,1,"%s",ehelpbuff[i]);
	}
	wattroff(pvs,A_REVERSE);
	wrefresh(pvs);
	wgetch(pvs);
	delwin(pvs);
}

int LocalFiler::RemoveTmpDir(void)
{
	//FTPファイラー情報を保存したファイルを削除する。
	unlink(pFilerListBox->txtTmpDirListFile);
	//FTPファイラー情報を保存したディレクトリを削除する。
	rmdir(pFilerListBox->txtEditDir);
	endwin();
	return(0);
}

void LocalFiler::FTPConnect(void)
{
//	u_int intServerReplyCode;
//	char *strCommand;
	char *result;
	int intResultLocation;
	
	int ret;

	//ファイラー階層初期化のためのクラス
	pFilerListBox = new ListBox();

	//FTPファイラーの情報（LIST -aL）を保存するディレクトリを設定
	pFilerListBox->setTmpDir();

	//ホスト接続用リストボックス作成
	pListBox = new ListBox();

	pListBox->height = 5;
	pListBox->width = 90;
	pListBox->sx = 0;
	pListBox->sy = 4;
	sprintf(pListBox->title,"%s","Hostname");

	pListBox->line = 0;
	pListBox->cursol = 0;

	//接続情報監視のためのリストボックス作成（詳細情報）
	ImmLog = new ListBox();

	ImmLog->height = 5;
	ImmLog->width = 90;
	ImmLog->sx = 0;
	ImmLog->sy = 4;
	ImmLog->line = -1;
	ImmLog->cursol = -1;

	//FTPファイラーのためのリストボックス作成
	ftp = new OpenFileListBox();

	ftp->height = LINES-10;
	ftp->width = 90;
	ftp->sx = 0;
	ftp->sy = 9;

	while((pListBox->popmsg(1,0,"ホストコンピュータと接続を開始します")))
	{
		pListBox->Clear();
		// /home/cms/etc/hosts.ftx ファイルよりホスト設定情報を読み取る。
		pFilerListBox->readHostSetFile();
		//リストボックスで選択した結果はホスト名とユーザID
		result = pListBox->Listbox();
        //結果がNULLの場合は終了する。Listbox()で'q'で終了の場合。2010.03.29追加
		if(!result)
			return;
		// : で区切られた結果からホスト名だけを抜き取る。
		intResultLocation = pFilerListBox->InStr(1,result,':');
		sprintf(pFilerListBox->txtHostName,"%s",pFilerListBox->Left(result,intResultLocation));
		//FTP接続経過情報リストボックスのタイトルにホスト名を入れる。
		sprintf(ImmLog->title,"%s",pFilerListBox->txtHostName);
		if (strlen(pFilerListBox->txtHostName) == 0)
		{
			pListBox->MsgBox("ホストコンピュータ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		//残りのホスト情報（userID,Password,HomeDir,LISTコマンド,転送イメージ、Active/Passiveモード,サーバ切断時間）をリストボックスクラスのメンバ変数に保存する。
		sprintf(pFilerListBox->txtUserID,"%s",pFilerListBox->pf[pListBox->index].userid);
		sprintf(pFilerListBox->txtPassword,"%s",pFilerListBox->pf[pListBox->index].passwd);
		sprintf(pFilerListBox->txtHomeDir,"%s",pFilerListBox->pf[pListBox->index].homedir);
		sprintf(pFilerListBox->txtOPTL,"%s",pFilerListBox->pf[pListBox->index].OPTL);
		pFilerListBox->intTYPE = pFilerListBox->pf[pListBox->index].TYPE;
		pFilerListBox->intPASV = pFilerListBox->pf[pListBox->index].PASV;
		pFilerListBox->intWAIT = pFilerListBox->pf[pListBox->index].WAIT;
		sprintf(pFilerListBox->txtEditor,"%s",pFilerListBox->pf[pListBox->index].editor);
		sprintf(pFilerListBox->txtViewer,"%s",pFilerListBox->pf[pListBox->index].viewer);
		sprintf(pFilerListBox->txtBrowser,"%s",pFilerListBox->pf[pListBox->index].browser);


		if (strlen(pFilerListBox->txtUserID) == 0)
		{
			pListBox->MsgBox("ログオンユーザ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtPassword) == 0)
		{
			pListBox->MsgBox("パスワードの入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtHomeDir) == 0)
		{
			pListBox->MsgBox("初期ディレクトリの入力がありません");
			RemoveTmpDir();
			return;
		}
		//ホストへ最初の接続
		pFilerListBox->intDoFirstConnect();

		//ファイラーリストボックスの初期化（ディレクトリの階層化情報）
		pFilerListBox->InitCursol(0);
		pFilerListBox->deep = 0;

		//FTPファイラーを実行する。
		pFilerListBox->ftx();
	}

	//FTPファイラー情報を保存したファイルを削除する。
	unlink(pFilerListBox->txtTmpDirListFile);
	//FTPファイラー情報を保存したディレクトリを削除する。
	rmdir(pFilerListBox->txtEditDir);

	//全てのメモリを開放する。
	delete pFilerListBox;
	delete pListBox;
	delete ImmLog;

	//終了する。
	return;
}

void LocalFiler::FTPSelect(void)
{
//	u_int intServerReplyCode;
//	char *strCommand;
	char *result;
	int intResultLocation;
	
	int ret;

	while((pListBox->popmsg(1,0,"ホストコンピュータと接続を開始します")))
	{
		pListBox->Clear();
		// /home/cms/etc/hosts.ftx ファイルよりホスト設定情報を読み取る。
		pFilerListBox->readHostSetFile();
		//リストボックスで選択した結果はホスト名とユーザID
		result = pListBox->Listbox();
		// : で区切られた結果からホスト名だけを抜き取る。
		intResultLocation = pFilerListBox->InStr(1,result,':');
		sprintf(pFilerListBox->txtHostName,"%s",pFilerListBox->Left(result,intResultLocation));
		//FTP接続経過情報リストボックスのタイトルにホスト名を入れる。
		sprintf(ImmLog->title,"%s",pFilerListBox->txtHostName);
		if (strlen(pFilerListBox->txtHostName) == 0)
		{
			pListBox->MsgBox("ホストコンピュータ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		//残りのホスト情報（userID,Password,HomeDir）をリストボックスクラスのメンバ変数に保存する。
		sprintf(pFilerListBox->txtUserID,"%s",pFilerListBox->pf[pListBox->index].userid);
		sprintf(pFilerListBox->txtPassword,"%s",pFilerListBox->pf[pListBox->index].passwd);
		sprintf(pFilerListBox->txtHomeDir,"%s",pFilerListBox->pf[pListBox->index].homedir);
		sprintf(pFilerListBox->txtOPTL,"%s",pFilerListBox->pf[pListBox->index].OPTL);
		pFilerListBox->intTYPE = pFilerListBox->pf[pListBox->index].TYPE;
		pFilerListBox->intPASV = pFilerListBox->pf[pListBox->index].PASV;
		pFilerListBox->intWAIT = pFilerListBox->pf[pListBox->index].WAIT;
		sprintf(pFilerListBox->txtEditor,"%s",pFilerListBox->pf[pListBox->index].editor);
		sprintf(pFilerListBox->txtViewer,"%s",pFilerListBox->pf[pListBox->index].viewer);
		sprintf(pFilerListBox->txtBrowser,"%s",pFilerListBox->pf[pListBox->index].browser);

		if (strlen(pFilerListBox->txtUserID) == 0)
		{
			pListBox->MsgBox("ログオンユーザ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtPassword) == 0)
		{
			pListBox->MsgBox("パスワードの入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtHomeDir) == 0)
		{
			pListBox->MsgBox("初期ディレクトリの入力がありません");
			RemoveTmpDir();
			return;
		}
		//ホストへ最初の接続
		pFilerListBox->intDoFirstConnect();

		//ファイラーリストボックスの初期化（ディレクトリの階層化情報）
		pFilerListBox->InitCursol(0);
		pFilerListBox->deep = 0;

		//FTPファイラーを実行する。
		pFilerListBox->ftx();
	}

	//FTPファイラー情報を保存したファイルを削除する。
	unlink(pFilerListBox->txtTmpDirListFile);
	//FTPファイラー情報を保存したディレクトリを削除する。
	rmdir(pFilerListBox->txtEditDir);

	//全てのメモリを開放する。
	delete pFilerListBox;
	delete pListBox;
	delete ImmLog;
	delete ftp;

	//終了する。
	return;
}

int LocalFiler::filer(int start,int end)
{
	int i,j;
	int ch,ch2;
	int x,y;
	int yy = 5;
	char buff[512],cwdpath[512],cwdpath2[512];
	char tmpbuff[512];
	WINDOW *evs;
	char *vp,*sp;
	char filebuff[512];
	char findstr[512];
	int findf = 0;
	int fcount = 0;
	int dflag = 1;

	unsigned int swptmp;
	char buffx[256];
	char buffy[256];
	char buffz[256];

	char ftmp[256];
	char ftmp2[256];

	//ディレクトリの深さ（階層）
	static int deep = 0;

	//FTXのためのコマンド
//	char strCommand[256];
//	char attrbuff[256];

	//ASE エディタのための変数
	FILE *fp;
	char *nlline;
	int len;
	char chgbuff[256];
	int xcol,xrow;

//	signal(SIGCHLD, SIGCHLD_handler2);
	signal(SIGQUIT, SIG_IGN);

	dtree = new LocalTree();	//ツリーファイラーのためのインスタンス
	cms = new CMSLocalFiler();	//CMSファイラーのためのインスタンス

	fmode = 'm';	//日付表示はファイルの作成日に
	dmode = 'h';	// 'v'と 'h' .の付いたファイルの表示非表示を切替える
	pathisto = 0;	//ディレクトリ移動履歴はまずゼロから
	pathcnt = 0;	//パス名のカウント
	botom = 2;		//ファイル最下行を設定（LINESより2行上になる）
	static int sym = 1;

	//複数選択コピー、移動、削除用のバッファとマークをクリア
	tabselectclear();

	noecho();
	cbreak();

	evs = newwin(1,90,LINES-1,0);

	max_lines = LINES;
	pt[0].vs = newwin(max_lines - (botom),90,1,0);

	set_screen(0);
	displaymenu1(evs,dflag);

	x = 1;
	y = 0;

	y = 0;
	yy = 5;

	dirlocateclear();

	char *ret = getcwd(cwdpath,512);
	sprintf(dirstack[0],"%s",cwdpath);
	pathisto++;
	pathcnt++;
	if (COLS > 89)
	{
		if(strlen(cwdpath) > (size_t)70)
		{
			sprintf(cwdpath2,"Path=...%-70s%4d files",right2(cwdpath,70),file_num);
			sprintf(tmpbuff,"%s",cwdpath2);
		}
		else
		{
			sprintf(tmpbuff,"Path=%-70s%4d files",cwdpath,file_num);
		}
	}
	else
	{
		if(strlen(cwdpath) > (size_t)62)
		{
			sprintf(cwdpath2,"Path=...%-62s%4d files",right2(cwdpath,62),file_num);
			sprintf(tmpbuff,"%s",cwdpath2);
		}
		else
		{
			sprintf(tmpbuff,"Path=%-62s%4d files",cwdpath,file_num);
		}
	}
	vs_print(tmpbuff,pt[0].vs,line1[0]+1,1);
	initbuff();

	dirprint_all(".",fmode);
	while(1)
	{
		set_screen_line2(0);

		datadisp(0,x,y,5);

		/*
		ウインドウの枠を表示する
		*/
		box(pt[0].vs,ACS_VLINE,ACS_HLINE);
		if((vp = getenv("CMS_USERNAME")) == NULL)
		{
			sprintf(tmpbuff,"%-52s CW v2.20 1995-10(c)S.Ono#",getenv("LOGNAME"));
		}
		else
		{
			if((sp = getenv("LOGNAME")) == NULL)
				sprintf(tmpbuff,"%-16s- %-34s CW v2.05 1995-09(c)S.Ono#",vp,"no-login");
			else
				sprintf(tmpbuff,"%-16s- %-34s CW v2.05 1995-09(c)S.Ono#",vp,sp);
		}
		wattron(pt[0].vs,A_REVERSE);
		mvwprintw(pt[0].vs,0,1,tmpbuff);
		wattroff(pt[0].vs,A_REVERSE);

	//	rectang(0);
		ret = getcwd(cwdpath,512);

		vs_print("                                                                                        ",pt[0].vs,line1[0]+1,1);
		if (COLS > 89)
		{
			if(strlen(cwdpath) > (size_t)70)
			{
				sprintf(cwdpath2,"Path=...%-70s%4d files",right2(cwdpath,70),file_num);
				sprintf(tmpbuff,"%s",cwdpath2);
			}
			else
			{
				sprintf(tmpbuff,"Path=%-70s%4d files",cwdpath,file_num);
			}
		}
		else
		{
			if(strlen(cwdpath) > (size_t)62)
			{
				sprintf(cwdpath2,"Path=...%-62s%4d files",right2(cwdpath,62),file_num);
				sprintf(tmpbuff,"%s",cwdpath2);
			}
			else
			{
				sprintf(tmpbuff,"Path=%-62s%4d files",cwdpath,file_num);
			}
		}
		vs_print(tmpbuff,pt[0].vs,line1[0]+1,1);

		wmove(pt[0].vs,y,1);
		wattron(pt[0].vs,A_REVERSE);
		sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
		vs_print(filebuff,pt[0].vs,line1[0]+2,yy);

		sprintf(filebuff,"%-30s"," ");
		wattroff(pt[0].vs,A_REVERSE);

		if (regline[y+(yy-5)] == 1)
			vs_print("*",pt[0].vs,line1[0]+1,yy);

		wrefresh(pt[0].vs);

		/*
		シンボリックリンクを表示 2009/03/16
		*/
		memset(ftmp,'\0',256);
		if(sym == 1)
		if((readlink(fs[y+(yy-5)].buff1, ftmp, 256)) != -1)
		{
			sprintf(ftmp2,"%s->%s",fs[y+(yy-5)].buff1,ftmp);
			if(yy < 10)
				dialogmsg2(30, yy + 2,ftmp2,"シンボリックリンクされています。");
			else
				dialogmsg2(30, yy - 4,ftmp2,"シンボリックリンクされています。");
		}

		/*
		コマンド操作
		*/
		ch = wgetch(pt[0].vs);

		wattroff(pt[0].vs,A_REVERSE);
		sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
		vs_print(filebuff,pt[0].vs,line1[0]+2,yy);

		if (regline[y+(yy-5)] == 1)
			vs_print("*",pt[0].vs,line1[0]+1,yy);

		displaymenu1(evs,dflag);

		switch(ch)
		{
		case '(':
			if(sym == 1)
				sym = 0;
			else
				sym = 1;
			break;
		case KEY_F(1):
			break;
		case 0x0a: case 0x0d:
			readflg = 1;
			nonopt = 1;
			stat(fs[y+(yy-5)].buff1,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
				break;
			sprintf(buff,"%s",cutspace(fs[y+(yy-5)].buff1));
			len = strlen(buff);
			if(((!strcmp(right2(buff,4),".def")) && (!strcmp(Mid1(buff,1,1),"_")))  || (!strcmp(right2(buff,4),".sql")) ||  (!strcmp(right2(buff,4),".pgc")) || (!strcmp(right2(buff,6),".def.c")) )
			{
				sprintf(buff,"/bin/stty echo onlcr icrnl;vi %s",fs[y+(yy-5)].buff1);
				wattroff(pt[0].vs,A_REVERSE);
				wrefresh(pt[0].vs);
				int ret = system(buff);
				wclear(pt[0].vs);
				set_screen(0);
				noecho();
				cbreak();
				dirprint_all(".",fmode);
				box(pt[0].vs,ACS_VLINE,ACS_HLINE);
				rectang(0);
				break;
			}
			if(strcmp(Mid1(buff,len-3,4),".def") != 0)
			{
				break;
			}
			j=0;
			if((fp =fopen(buff,"r")) == (FILE *)NULL)
			{
				exit(1);
			}
			while(fgets(buff,256,fp) != (char *)NULL)
			{
				if((nlline = strchr(buff,'\n')) != (char *)NULL)
				{
					*nlline = '\0';
					j++;
				}
			}
			fclose(fp);
		//BUG 2009.08.03 modifyed. strlen() ???
		//	xcol = strlen(buff)-1;
			xcol = strlen(buff);
			xrow = j;
			if(xcol > 256)
			{
				sprintf(tmpbuff,"Over colums 256\n");
				if(popmsg(2+8,(LINES/2)-4,tmpbuff) == 1)
				{
					break;
				}
			}
			if(xrow > 78)
			{
				sprintf(tmpbuff,"%s","Over rows 78\n");
				if(popmsg(2+8,(LINES/2)-4,tmpbuff) == 1)
				{
					break;
				}
			}
			clear();
			aseeditor = new AseEditor();
			sprintf(chgbuff,"%s",fs[y+(yy-5)].buff1);
			aseeditor->ase(xcol,xrow,fs[y+(yy-5)].buff1,0);
			delete aseeditor;
			clear();
			goto allCLS;

			cls_all(0);

			rectang(0);
			initbuff();
			wclear(pt[0].vs);
			set_screen(0);
			dirprint_all(".",fmode);
			wrefresh(pt[0].vs);
			break;

		/*
		ASEの操作
		*/
		case 'a':
			ch2 = wgetch(pt[0].vs);
			switch(ch2)
			{
			case 'a':
				xcol = COLS;
				xrow = LINES;
				input_window(4,2,buff,"ASE エディタが作成するファイル名を入力");
				sprintf(tmpbuff,"%s.def",buff);
				if(strlen(buff) < (size_t)1)
					break;
				if(!access(tmpbuff,R_OK))
				{
					if(popmsg(4,10,"同じ名前のファイルかディレクトリがあります。"))
					;
					else
						break;
				}
				aseeditor = new AseEditor();
				aseeditor->ase(xcol-4,xrow-2,tmpbuff,0);
				delete aseeditor;
				break;
			case 'b':
				input_window(4,2,buff,"ASE エディタが作成するファイル名を入力");
				sprintf(tmpbuff,"%s.def",buff);
				if(strlen(buff) < (size_t)1)
					break;
				input_window(4,2,buff,"フォームの横の領域を入力");
				{
					if(atoi(buff) < 5)
						break;
					xcol = atoi(buff);
				}
				input_window(4,2,buff,"フォームの縦の領域を入力");
				{
					if(atoi(buff) < 3)
						break;
					xrow = atoi(buff);
				}
				if(!access(tmpbuff,R_OK))
				{
					if(popmsg(4,10,"同じ名前のファイルかディレクトリがあります。"))
					;
					else
						break;
				}
				aseeditor = new AseEditor();
				aseeditor->ase(xcol-4,xrow-2,tmpbuff,0);
				delete aseeditor;
			}
			break;

		/*
		FTPファイラーの操作
		*/
		case 'X':
			ch2 = wgetch(pt[0].vs);
			switch(ch2)
			{
			/*
			FTPファイラーの起動と接続
			*/
			case 'X':
				FTPConnect();

				cls_all(0);
				initbuff();
				dirprint_all(".",fmode);
				y = 0;
				yy = 5;
				break;
			}
			break;
		/*
		現在のパスをブックマークとして保存
		*/
		case '':
			if(popmsg2(2+8,(LINES/2)-4,"カレントディレクトリをブックマークに保存しますか？") == 1)
			{
				sprintf(bookmarks[bookline],"%s",cwdpath);
				popmsg(15,1,bookmarks[bookline]);
				if(bookmarksave() == -1)
				{
					popmsg(2+8,(LINES/2)-4,"ブックマークを保存出来ません。");
				}
			}
			break;
		/*
		ファイル・ディレクトリを作成した日付で表示
		*/
		case '7':
			break;

		/*
		ＣＭＳの起動
		*/
		case '@':
			command00(0);
			dirprint_all(".", fmode);
			wrefresh(pt[0].vs);
			break;

		case '^':
		/*
		Hiddenファイル・ディレクトリを表示／非表示の切替え（デフォルト）
		*/
			command01(0, y, yy);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			break;

		case '~':
		/*
		ブックマークのディレクトリに移動する。
		*/
			if(command02(0,y,yy) != 0)
			{
				dirprint_all(".", fmode);
				dirlocateclear();
				y = 0;
				yy = 5;
			}
			break;

		case '0':
		/*
		ファイル・ディレクトリを作成した日付と時間で表示（デフォルト）
		*/
			command03(0);
			dirprint_all(".", fmode);
			break;

		case '2':
		/*
		ファイル・ディレクトリを最新アクセスした日付で表示
		*/
			command04(0);
			dirprint_all(".", fmode);
			break;

		case '9':
		/*
		ファイル・ディレクトリを作成した日付で表示
		*/
			command05(0);
			dirprint_all(".", fmode);
			break;

		case '_':
		/*
		CMSファイラー(cf)の実行
		*/
			cms->cms();
			y = 0;
			yy = 5;
			cls_all(0);
			initbuff();
			dirprint_all(".",fmode);
			break;

		/*
		ツリーファイラー(dtree)の実行
		*/
		case '\\': case '{':
			dtree->dtree();
			y = 0;
			yy = 5;
			goto allCLS;

		/*
		ファイルの選択（マーク）
		*/
		case '\t':
			command06(0, y, yy);
			break;

		/*
		複数選択表示（less）
		*/
		case '':
			command07(0);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			box(pt[0].vs,ACS_VLINE,ACS_HLINE);
			rectang(0);
			goto allCLS2;

		/*
		複数選択移動
		*/
		case '':
			command29(0, y, yy);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			goto allCLS2;

		/*
		複数選択コピー
		*/
		case '':
			command30(0, y, yy);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			goto allCLS2;

		/*
		複数選択削除（ファイルのみ）
		*/
		case '':
			ch2 = wgetch(pt[0].vs);
			switch(ch2)
			{
			case '':
				command08(0);
				dirprint_all(".", fmode);
				y = 0;
				yy = 5;
				goto allCLS2;

			default:
				break;
			}
			break;

		case 'T':
		/*
		tar -xzf fine-name を実行
		*/
			command09(0, y, yy);
			dirprint_all(".", fmode);
			break;

		case '':
		/*
		tar -czf fine-name を実行
		*/
			command10(0, y, yy);
			dirprint_all(".", fmode);
			break;

		case '':
		/*
		複数選択の tar -czf fine-name を実行
		*/
			command31(0, y, yy);
			dirprint_all(".", fmode);
			goto allCLS;

		case '/':
		/*
		ファイルを文字列で検索
		*/
			input_window(4,2,findstr,"検索名を入力");
			if(strlen(findstr) < (size_t)0)
				strcpy(findstr," ");

		case 'n':
		/*
		ファイルを文字列で再び検索
		*/
			fcount = 0;
			if(strlen(findstr) < (size_t)1)
				break;
			y++;
			for(;y+(yy-5)<file_num;y++)
			{
				if(fcount > MAX_FILES)
					break;
				if((findf = findex(fs[y+(yy-5)].buff1, findstr)) != -1)
				{
					fcount = 0;
					sprintf(buff,"[%s] が見つかりました",findstr);
					dialogmsg(33,6,buff);
					break;
				}
				fcount++;
				if(y+(yy-5) < file_num)
				{
					if(y >= MAX_FILES - max_lines)
					{
						y = MAX_FILES - max_lines;
					}
				}
				else
				{
					break;
				}
			}
			cls_all(0);

			//見つからなければ前にいた位置に戻る
			if(y > MAX_FILES || y >= file_num || strlen(fs[y+(yy-5)].buff1) < (size_t)1)
			{
				dialogmsg(2,(LINES/2),"見つかりません");

				y = 0;
				yy = 5;
				cls_all(0);
				datadisp(0,x,y,5);
				wattroff(pt[0].vs,A_REVERSE);
				sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
				vs_print(filebuff,pt[0].vs,line1[0]+2,yy);
				break;
			}
			break;

		 case 'N':
			fcount = 0;
			if(strlen(findstr) < (size_t)1)
				break;
			y--;
			for(;y+(yy-5)>0;y--)
			{
				if(fcount > MAX_FILES)
					break;
				if((findf = findex(fs[y+(yy-5)].buff1, findstr)) != -1)
				{
					fcount = 0;
					sprintf(buff,"[%s] が見つかりました。y = %d,yy= %d",findstr,y,yy);
					dialogmsg(33,6,buff);
					break;
				}
				fcount++;
			}
			datadisp(0,x,y,5);
			cls_all(0);
			set_screen(0);

			if(y < 1 || strlen(fs[y+(yy-5)].buff1) < (size_t)1)
			{
				y = 0;
				yy = 5;
				cls_all(0);
				set_screen(0);
				datadisp(0,x,y,5);
				wattroff(pt[0].vs,A_REVERSE);
				sprintf(filebuff,"%-42s",fs[y+(yy-5)].buff1);
				vs_print(filebuff,pt[0].vs,line1[0]+2,yy);
				break;
			}
			break;

		case '':
		/*
		ファイルの属性（モード）を変更
		*/
			command11(0, y, yy);
			dirprint_all(".", fmode);
			break;

		case '':
		/*
		CWを起動したディレクトリに戻る
		*/
			command12(0);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			break;

		case '':
		/*
		環境変数 HOME に定義されたディレクトリに移動する
		*/
			command13(0);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			dirlocateclear();
			break;

		case 'H':
		/*
		CWのヘルプメッセージを表示
		*/
			helpmsg(1,1);
			displaymenu1(evs,dflag);
			break;

		case '?':
		/*
		英語のASEヘルプメッセージを表示する
		*/
			helpmsg2(1,1);
			displaymenu1(evs,dflag);
			break;

		case 'f':
		/*
		ファイルのコードをＥＵＣコードに変換する
		*/
			command14(y, yy);
			break;

		case 'F':
		/*
		ファイルのコードをUTF-8コードに変換する
		*/
			command15(y, yy);
			break;

		case '':
		/*
		ファイルのコードをシフトJISコードに変換する
		*/
			command16(y, yy);
			break;

		case 'r':
		/*
		ディレクトリの削除
		*/
			if(command17(0, y, yy) != 0)
			{
				dirprint_all(".",fmode);
			}
			break;

		case '':
		/*
		ファイル指定なしでｖｉエディタを起動する。
		*/
			command18(0);
			dirprint_all(".",fmode);
			wattron(pt[0].vs,A_REVERSE);
			box(pt[0].vs,' ',' ');
			wattroff(pt[0].vs,A_REVERSE);
			rectang(0);
			break;

		case 'e':
		/*
		ファイル指定でｖｉエディタを起動する。
		*/
			command19(0, y, yy);
			dirprint_all(".",fmode);
			wattron(pt[0].vs,A_REVERSE);
			box(pt[0].vs,' ',' ');
			wattroff(pt[0].vs,A_REVERSE);
			rectang(0);
			break;

#ifdef CYGWIN
		/*
		ファイル指定でWindows版 vimエディタを起動する。
		*/
		//	command20(0, y ,yy);
		case 'E':
			stat(fs[y+(yy-5)].buff1,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
				break;
			system("clear");
			noraw();
			echo();
			nl();
			nocbreak();

			//Windows　の vimエディタを起動する。(vimのインストール位置固定)
			sprintf(buff,"/cygdrive/c/vim/VIM32 %s",fs[y+(yy-5)].buff1);
			wattroff(pt[0].vs,A_REVERSE);
			wrefresh(pt[0].vs);
			system(buff);

			wclear(pt[0].vs);
			set_screen(0);
			noecho();
			cbreak();
			dirprint_all(".",fmode);
			box(pt[0].vs,ACS_VLINE,ACS_HLINE);
			rectang(0);
			break;
#endif

		case '-':
		/*
		ディレクトリ移動の履歴を遡る
		*/
			command21(0, y, yy);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			break;

		case '+':
		/*
		ディレクトリ移動の履歴を戻る
		*/
			command22(0, y, yy);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			break;

		case 'c':
		/*
		ディレクトリを移動する。
		*/
		//	execchdir:

			set_screen_line1(0);
			set_screen(0);


			stat(fs[y+(yy-5)].buff1,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				char *ret = getcwd(ftmp,256);
				if(1 == 1)
				{
					memset(ftmp,'\0',256);
					
					if(deep < 0 || (readlink(fs[y+(yy-5)].buff1, ftmp, 256)) != -1)
					{
						deep = 0;
						goto skipdir;
					}
				}
				skipdir:

				if(chdir(fs[y+(yy-5)].buff1) == -1)
					break;
				sprintf(dirlocate[dirlocateyy[deep]], "%s",fs[y+(yy-5)].buff1);
				dirlocatey[deep] = y;
				dirlocateyy[deep] = yy;
				deep++;
				ret = getcwd(dirstack[pathcnt],512);
				if(pathcnt < 128)
					pathcnt++;
				if(pathisto < 128)
					pathisto++;
				checkhisto();

				tabselectclear();

				cls_all(0);
				initbuff();
				dirprint_all(".",fmode);
				y = 0;
				yy = 5;
			}
			break;
		case 'i':
		/*
		ディレクトリを上に移動する。
		*/
			set_screen(0);

			stat("..",fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				if(chdir("..") == -1)
					break;
				ret = getcwd(dirstack[pathcnt],512);
				if(pathcnt < 128)
					pathcnt++;
				if(pathisto < 128)
					pathisto++;
				checkhisto();

				tabselectclear();

				cls_all(0);
				initbuff();
				dirprint_all(".",fmode);

				if(deep > 0)
				{
					deep--;
					y = dirlocatey[deep];
					yy = dirlocateyy[deep];
				}
				else
				{
					y = 0;
					yy = 5;
				}
			}
			break;

		case 'v':
		/*
		ファイルビューアを起動する。
		*/
			command25(0, y, yy);
			break;

		case '':
		/*
		ファイルを削除する。
		*/
			if(command26(0, y, yy) != 0)
			{
				dirprint_all(".",fmode);
			}
			break;

		case 'M':
		/*
		ファイルを移動または名前を変更する。
		*/
			if(command27(0, y, yy) != 0)
			{
				dirprint_all(".",fmode);
			}

			break;

		case 'p':
		/*
		ファイルをコピーする。
		*/
			command28(y, yy);
			break;

		case '!':
		/*
		シェルモードへ移行
		*/
			command32(0);
			dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			break;

		case 'm':
		/*
		ディレクトリを作成する
		*/
			if(command33(0) != 0)
			{
				dirprint_all(".",fmode);
			}
			break;

		case 'O':
		/*
		入力でディレクトリを移動する
		*/
			if(command34(0) != 0)
			{
				dirprint_all(".",fmode);
				y = 0;
				yy = 5;
			}
			break;

		case '':
		/*
		コマンド入力でプログラムの実行
		*/
			command35(0);
			dirprint_all(".",fmode);
			break;

		case 'x':
		/*
		ファイルを実行する（コマンド実行 fork()使用）。
		*/
			if(command36(0, y, yy) != 0)
			{
				dirprint_all(".",fmode);
			}
			break;

		case 's':
		/*
		シンボリックリンクの作成
		*/
			if(command37(0, y, yy) != 0)
			{
				dirprint_all(".",fmode);
			}
			break;

		/*
		ＭＡＫＥコマンドを実行
		*/
		case '':
			command38(0, y, yy);
			clear();
			wclear(pt[0].vs);
			set_screen(0);
			refresh();
			goto allCLS;

		/*
		ＭＡＫＥコマンド（引数つき）を実行
		*/
		case ']':
			command39(0, y, yy);
			clear();
			wclear(pt[0].vs);
			set_screen(0);
			refresh();
			goto allCLS;

		case '1':
		/*
		メニューバーを切り替える
		*/
			if(dflag == 1)
				dflag = 0;
			else
				dflag = 1;
			displaymenu1(evs,dflag);
			break;

		case 'g':
		/*
		ファイル列の最後を表示
		*/
			if(y > (file_num - (max_lines - 7)))
			{
				yy = max_lines - ((max_lines - 4) - (file_num));
			}
			if(file_num > (max_lines - 8))
			{
				y = file_num - (max_lines - 8);
				yy = max_lines - 4;
			}
			cls_all(0);
			break;

		case 'G':
		/*
		ファイル列の最後を表示
		*/
			if(y > (file_num - (max_lines - 7)))
				break;
			if(file_num > (max_lines - 7))
				y = file_num - (max_lines - 8);
			cls_all(0);
			break;
		/*
		ファイル画面トップに
		*/
		case 't':
			y = 0;
			yy = 5;
			cls_all(0);

			datadisp(0,x,y,5);
			wattroff(pt[0].vs,A_REVERSE);
			sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
			vs_print(filebuff,pt[0].vs,line1[0]+2,yy);
			break;

		case 'U':
			if(yy > 5)
			{
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				break;
			}

			y -= 5;
			if(y < 1)
				y = 0;
			cls_all(0);
			break;
		case '': case 'u':
		/*
		半ページ上へ
		*/
			for(i=0;i<(LINES/2) - botom;i++)
			{
				y -= 1;
				if(y < 1)
				{
					y = 0;
					break;
				}
			}
			cls_all(0);
			break;
 
		case 'D':
		/*
		５行ダウン
		*/

			if(y+yy > MAX_FILES || y+yy > file_num + 3 || strlen(fs[y+(yy-5)].buff1) < (size_t)1)
			{
				break;
			}
			if(yy < max_lines - (botom + 2))
			{
				if(yy >  max_lines - (botom + 7))
				{
					yy = max_lines - (botom + 7);
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				break;
			}

			y += 5;
			if(y >= MAX_FILES - max_lines)
				y = MAX_FILES - max_lines;
			
			if(yy < (max_lines - (botom + 2)))
				yy = file_num - 5;

			cls_all(0);
			break;

		case '': case 'd':
		/*
		半ページ下へ
		*/
			if(y > (file_num - (max_lines - 7)))
				break;
			if(y > MAX_FILES || y+(yy-5) > (file_num + 4) - (max_lines - botom) + 7)
				break;
			for(i=0;i<(LINES/2)-3;i++)
			{
				y += 1;
				if(y >= MAX_FILES - max_lines)
				{
					y = MAX_FILES - max_lines;
					break;
				}
			}
			if(y > file_num - max_lines)
				y = file_num - (max_lines - 8);
			cls_all(0);
			break;

			case 'k': case 'K': case 0x41:
		/*
		上スクロール
		*/

			if(yy > 5)
			{
				yy--;
				break;
			}

			y -= 1;
			if(y < 1)
				y = 0;
			cls_all(0);
			break;

		 case 'j': case 'J': case 0x42:
		/*
		下スクロール
		*/
			if(y+yy > MAX_FILES || y+yy > file_num + 3)
				break;
			if(yy > file_num + 5)
			{
				break;
			}
			/*
			if(yy < (max_lines - 8) && yy <= file_num + 5)
			*/
			if(yy < (max_lines - (botom + 2)) && yy <= file_num + 5)
			{
				yy++;
				break;
			}

			y += 1;
			if(y >= MAX_FILES - max_lines)
				y = MAX_FILES - max_lines;

			cls_all(0);
			break;

		case 'C':
		/*
		全ウインドウの再描画
		*/
		allCLS:
			wclear(pt[0].vs);
			max_lines = LINES;
			delwin(pt[0].vs);
			pt[0].vs = newwin(max_lines - botom,90,1,0);
			set_screen(0);
			box(pt[0].vs,ACS_VLINE,ACS_HLINE);
			wrefresh(pt[0].vs);
			delwin(evs);
			evs = newwin(3,90,LINES-1,0);
			displaymenu1(evs,dflag);
			for(j=0;j<256;j++)
			{
				memset(selcp[j],'\0',512);
			}
			tabselectclear();
			wclrtoeol(pt[0].vs);
			cls_all(0);
			initbuff();
			dirprint_all(".",fmode);
			break;

		 case 'Z':
		allCLS2:
			for(j=0;j<256;j++)
			{
				memset(selcp[j],'\0',512);
			}
			tabselectclear();

			for(j=5;j < (file_num - (max_lines - 8));j++)
				vs_print(" ",pt[0].vs,line1[0]+1,j);
			dirprint_all(".",fmode);
			break;
		/*
		検索実行
		*/
		 case 'q': case 'Q':
		/*
		終了
		*/
			if(popmsg(30,LINES - 11,"終了します") == 1)
				goto filerend;
			break;
		}
	}

filerend:
	swptmp = getpid();
	sprintf(buffx,"%d",swptmp);
	sprintf(buffy,"/tmp/dtree1.%s",buffx);
	sprintf(buffz,"/tmp/dtree2.%s",buffx);
	unlink(buffy);
	unlink(buffz);

	endwin();
	printf("\033[5>l");
	for(i=0;i<MAX_WINDOW;i++)
		delwin(pt[i].vs);
	delwin(evs);
	initbuff();
	printf("\033[2J");
	return(0);
}

/************************************************************************/
/* NAME      :int main()*/ 
/* FUNCTION  :ファイラーのメインルーチン*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
/*
int main(void)
{
	int i,j,k;
	int ret;
	char *vp;

	LocalFiler *uf;

	setlocale(LC_ALL,"");

	uf = new LocalFiler();
	dtree = new LocalTree();
	cms = new CMSLocalFiler();

	initscr();
	cbreak();
	noecho();

	uf->bookmark();

	if((vp = getenv("HOME")) == NULL)
	{
		uf->sys_errmsg(4,10,"環境変数 HOME が設定されていません /home を使用します");
		sprintf(uf->homedirname,"/home");
	}
	else
	{
		sprintf(uf->homedirname,"%s",vp);
	}
	uf->max_lines = LINES;

	uf->readowner();
	uf->readgroup();
	getcwd(uf->startdirname,256);

	i = j = k= 0;
	while(1)
	{
		ret = uf->filer(1,uf->max_lines);
		switch(ret)
		{
		case 0:
			goto end;
		default:
			break;
		}
	}
	end:
	endwin();
	printf("\n");
	return(0);
}
*/

