#pragma ident "@(#) comcurses.cc 1.0.9 2012.01.31,14:42"
#include "ftx.h"
#include "filer.h"

static DIR *dir;

extern LocalFiler *uf;
extern LocalTree *dtree;

//以下のインスタンス名は本ライブラリで固定されている。
extern ListBox *pFilerListBox;	//ファイラーのためのリストボックスクラス
extern ListBox *pListBox;	//ホスト、ユーザ、パスワードを管理するリストボックスクラス
extern ListBox *ImmLog;	//FTPとの応答を記録するリストボックスクラス（詳細情報）
extern OpenFileListBox *ftp;
extern int ftpflag;
extern "C" int jmvwgetnstr(WINDOW *win, int y, int x, unsigned char *str, int n, int wmode, int cmode);

//ウインドウ１と２のカラム位置
int line1[] = {0,33,44,56,68,79,89};
//ウインドウ３と４のカラム位置*/
int line2[] = {0,12,24,36,48,52,54,54,54,54};

static char helpbuff[22][128] =
	{" H  このヘルプを表示                i  ひとつ上へ",
	" v  ファイルを表示                   選択ファイル移動",
	" e  ファイルを編集                  C  画面の更新",
	"  SHIFT-JISに変換                  vi の実行",
	" x  実行ファイルを実行              @  CMS の起動",
	" p  ファイルをコピー                t  画面の先頭へ",
	"  選択ファイルコピー              g  最後尾に",
	" m  ディレクトリを作成              !  シェルモードに",
	" r  ディレクトリを削除              2  アクセス時刻表示",
	"^R  ファイルを削除                  9  作成年月表示",
	" c  ディレクトリを移動              0  作成時刻表示",
	"  移動ディレクトリ入力            1  メニュー表示切替",
	" F  UTF-8に変換                     u  半画面上に",
	" M  ファイル移動/名前変更           d  半画面下に",
	" 選択ファイルを削除             j  一行下に",
	"  属性を変更                      k  一行上に",
	"  cw を起動した場所に             ~  ブックマークの選択",
	"  $HOME に戻る                    ^ .ファイルの表示非表示",
	" -  以前に移動した場所に移動        \\ カレントツリーに変身",
	" +  以前に移動した場所から移動       現在位置を保存",
	" n  検索を開始。入力は '/' で       TAB ファイルを複数選択する"
	" f  EUCに変換"
	};

 static char ehelpbuff[22][128] =
	{" H  Display this help               i  Go to Parent directory",
	" v  Display a file                   Choice file move",
	" e  Vi edit-file                    C  Refresh screen",
	" f  Convert into SHIFT-JIS           Edit a vi new-file",
	" x  Execute of file                 @  Enter the CMS",
	" p  File copy                       t  Go to top line",
	"  Copy of choice files            g  Go to bottom line",
	" m  Make directory                  !  Go to shell mode",
	" r  Remove directory                2  Update Time",
	"  Remove file                     9  Create date",
	" c  Change directory                0  Create time",
	"  Jump directory                  1  Change of the menubar",
	" F  Convert into UTF-8              u  Half screen up",
	" M  Move file(rename)               d  Half screen down",
	" Choice remove                  j  1 line down",
	"  Change attribute                k  1 line up",
	"  Back to start directory         ~  Choice to Bookmark",
	"  Back to $HOME directory         ^  Display to all file or.",
	" -  Previus directory               \\ Change of Tree-Filer",
	" +  Next directory                   Save of the curennt directory",
	" /  Find file or directory.(n)      TAB Plural choice"
	" f  Convert into EUC"
	};


/************************************************************************/
/* NAME      :void cls_all()*/
/* FUNCTION  :指定ウインドウの全カラムの文字を消去する*/ 
/*            */ 
/*int no;	ウインドウ番号*/
/*int col;	カラム番号*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::cls_all(int no)
{
	int i;
	for(i=0;i<6;i++)
		vs_cls(no,i);

}

/************************************************************************/
/* NAME      :void all_cls()*/
/* FUNCTION  :該当ウインドウを消去し再度作成する*/ 
/*            */ 
/*int no;	ウインドウ番号*/
/*int col;	カラム番号*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::all_cls(int no)
{
	int j;

	wclear(pt[no].vs);
	max_lines = LINES;
	delwin(pt[no].vs);
	pt[no].vs = newwin(max_lines - botom,90,1,0);
	set_screen(no);
	box(pt[no].vs,ACS_VLINE,ACS_HLINE);
	wrefresh(pt[no].vs);
	for(j=0;j<256;j++)
	{
		memset(selcp[j],'\0',512);
	}
	for(j=0;j<MAX_FILES;j++)
		regline[j] = 0;
	for(j=0;j<MAX_FILES;j++)
		cpflag[j] = 0;
	intCPnum = 0;
	wclrtoeol(pt[no].vs);
	cls_all(no);
}

/************************************************************************/
/* NAME      :void tabselectclear()()*/
/* FUNCTION  :TABで選択したマークを消去する*/ 
/*            */ 
/*int no;	ウインドウ番号*/
/*int col;	カラム番号*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::tabselectclear(void)
{
	int j;

	for(j=0;j<256;j++)
	{
		memset(selcp[j],'\0',512);
	}
	for(j=0;j<MAX_FILES;j++)
		regline[j] = 0;
	for(j=0;j<MAX_FILES;j++)
		cpflag[j] = 0;
	intCPnum = 0;
}

/************************************************************************/
/* NAME      :void vs_cls()*/
/* FUNCTION  :該当ウインドウの指定カラムの文字を消去する*/ 
/*            */ 
/*int no;	ウインドウ番号*/
/*int col;	カラム番号*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::vs_cls(int no,int col)
{
	line_clear(no,line1[col]+1,5,5,93,line1[col+1]-line1[col]-1);
}

/************************************************************************/
/* NAME      :void line_clear()*/
/* FUNCTION  :指定されたウインドウの桁位置と行位置をスペースで埋める*/ 
/*            */ 
/*int no;	ウインドウ番号*/
/*int x;	桁位置*/
/*int y;	行位置*/
/*int sy;	開始行位置*/
/*int end;	終了行位置*/
/*int len;	カラムの長さ*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::line_clear(int no,int x,int y,int sy,int end,int len)
{
	int i;
	char buff[128];
	for(i=0;i < len;i++)
		buff[i] = ' ';
	buff[i] = '\0';
	for(i=0;i < end+sy;i++)
	{
		vs_print(buff,pt[no].vs,x,i+sy);
	}
}

/************************************************************************/
/* NAME      :void datadisp()*/
/* FUNCTION  :指定された範囲でファイルを表示する*/ 
/*            */ 
/*int no;		ウインドウ番号*/
/*int x;		桁位置*/
/*int y;		行位置*/
/*int sy;		表示開始行*/
/*int end;		表示終了行*/
/*int start;	表示開始*/
/*int end2;		表示終了*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::datadisp(int no,int x,int y,int sy)
{
	int i;

	for(i=0;i < LINES - 3;i++)
	{
		vs_print(fs[i+y].buff1,pt[no].vs,line1[0]+2,i+sy);
		if(!strcmp(right2(fs[i+y].buff1,4),".def"))
		{
			wattron(pt[no].vs,A_BOLD);
			vs_print(fs[i+y].buff1,pt[no].vs,line1[0]+2,i+sy);
			wattroff(pt[no].vs,A_BOLD);
		}
		if(!strcmp(right2(fs[i+y].buff1,4),".css"))
		{
			wattron(pt[no].vs,A_BOLD);
			vs_print(fs[i+y].buff1,pt[no].vs,line1[0]+2,i+sy);
			wattroff(pt[no].vs,A_BOLD);
		}
		if(!strcmp(right2(fs[i+y].buff1,4),".pgc"))
		{
			wattron(pt[no].vs,A_UNDERLINE | A_BOLD);
			vs_print(fs[i+y].buff1,pt[no].vs,line1[0]+2,i+sy);
			wattroff(pt[no].vs,A_UNDERLINE | A_BOLD);
		}
		if(!strcmp(right2(fs[i+y].buff1,4),".sql"))
		{
			wattron(pt[no].vs,A_UNDERLINE);
			vs_print(fs[i+y].buff1,pt[no].vs,line1[0]+2,i+sy);
			wattroff(pt[no].vs,A_UNDERLINE);
		}
		vs_print(fs[i+y].buff2,pt[no].vs,line1[1]+1,i+sy);
		vs_print(fs[i+y].buff3,pt[no].vs,line1[2]+1,i+sy);
		vs_print(fs[i+y].buff4,pt[no].vs,line1[3]+1,i+sy);
		vs_print(fs[i+y].buff5,pt[no].vs,line1[4]+1,i+sy);
		vs_print(fs[i+y].buff6,pt[no].vs,line1[5]+1,i+sy);
	//2009.03.11
		if (regline[i+y] == 1)
		{
			switch(dmode)
			{
			case 'v':
				vs_print("*",pt[no].vs,line1[0]+1,i+sy);
				break;
			case 'h':
				vs_print(" ",pt[no].vs,line1[0]+1,i+sy);
				break;
			default :
				break;
			}
		}
	}
}

/************************************************************************/
/* NAME      :void vs_print()*/
/* FUNCTION  :指定したウインドウの指定位置に文字列を書き込む*/ 
/*            */ 
/*char *p;		文字列へのポインタ*/
/*WINDOW *vs;	ウインドウへのポインタ*/
/*int x;		表示桁*/
/*int y;		表示行*/
/*int N;		ダミー*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::vs_print(const std::string Message,WINDOW *vs,int x,int y)
{
	char msg[1024];

	sprintf(msg,"%s",Message.c_str());

	mvwprintw(vs,y,x,msg);
}

/************************************************************************/
/* NAME      :void set_screen()*/
/* FUNCTION  :ファイルを表示する４つのウインドウを描画する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::set_screen(int no)
{
	int i;
	for(i=2;i<max_lines - botom;i++)
	{
		mvwprintw(pt[no].vs,i,line1[1],"|");
		mvwprintw(pt[no].vs,i,line1[2],"|");
		mvwprintw(pt[no].vs,i,line1[3],"|");
		mvwprintw(pt[no].vs,i,line1[4],"|");
		mvwprintw(pt[no].vs,i,line1[5],"|");
		mvwprintw(pt[no].vs,i,line1[6],"|");
	}
	for(i=0;i<89;i++)
	{
		mvwprintw(pt[no].vs,2,i,"-");
		mvwprintw(pt[no].vs,4,i,"-");
	}
	wmove(pt[no].vs,1,1);
	mvwaddstr(pt[no].vs,3,line1[0]+1,"  NAME");
	mvwaddstr(pt[no].vs,3,line1[1]+1," Size/Dir");
	mvwaddstr(pt[no].vs,3,line1[2]+1,"  Date/Time");
	mvwaddstr(pt[no].vs,3,line1[3]+1,"  Attr");
	mvwaddstr(pt[no].vs,3,line1[4]+1,"  Owner");
	mvwaddstr(pt[no].vs,3,line1[5]+1,"  Group");
}

/************************************************************************/
/* NAME      :void set_screen_line1()*/
/* FUNCTION  :ファイルを表示するline1を描画する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::set_screen_line1(int no)
{
	int i;
	for(i=2;i<max_lines - botom;i++)
	{
		mvwprintw(pt[no].vs,i,line1[1]," ");
		mvwprintw(pt[no].vs,i,line1[2]," ");
		mvwprintw(pt[no].vs,i,line1[3]," ");
		mvwprintw(pt[no].vs,i,line1[4]," ");
		mvwprintw(pt[no].vs,i,line1[5]," ");
	}
}

/************************************************************************/
/* NAME      :void set_screen_line2()*/
/* FUNCTION  :ファイルを表示する最初のline1だけを描画する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::set_screen_line2(int no)
{
	int i;
	for(i=5;i<max_lines - botom;i++)
	{
		mvwprintw(pt[no].vs,i,line1[1],"|");
		mvwprintw(pt[no].vs,i,line1[2],"|");
		mvwprintw(pt[no].vs,i,line1[3],"|");
		mvwprintw(pt[no].vs,i,line1[4],"|");
		mvwprintw(pt[no].vs,i,line1[5],"|");
		mvwprintw(pt[no].vs,i,line1[6],"|");
	}
}

/************************************************************************/
/* NAME      :void initbuff()*/
/* FUNCTION  :テキスト配列を初期化する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::initbuff(void)
{
	int i;
	for(i=0;i<MAX_FILES;i++)
	{
		memset(fs[i].buff1, '\0',512);
		memset(fs[i].buff2, '\0',32);
		memset(fs[i].buff3, '\0',64);
		memset(fs[i].buff4, '\0',32);
		memset(fs[i].buff5, '\0',32);
		memset(fs[i].buff6, '\0',32);
	}
}

/************************************************************************/
/* NAME      :void displaymenu1()*/
/* FUNCTION  :キーメニューを表示する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::displaymenu1(WINDOW *evs,int flag)
{
	int i,j,k;

	if(flag)
	{
		mvwprintw(evs,0,1,"chdir cp exec edit find view Mv mkdir ^Remove Quit    ");
		mvwprintw(evs,0,52+2,"j down k up ^D down ^U up");

		wattron(evs,A_REVERSE);
		mvwprintw(evs,0,1,"%c",'c');
		mvwprintw(evs,0,8,"%c",'p');
		mvwprintw(evs,0,11,"%c",'x');
		mvwprintw(evs,0,15,"%c",'e');
		mvwprintw(evs,0,20,"%c",'/');
		mvwprintw(evs,0,25,"%c",'v');
		mvwprintw(evs,0,30,"%c",'M');
		mvwprintw(evs,0,33,"%c",'m');
		mvwprintw(evs,0,39,"%c",'^');
		mvwprintw(evs,0,40,"%c",'R');
		mvwprintw(evs,0,47,"%c",'Q');

		mvwprintw(evs,0,52+2,"%c",'j');
		mvwprintw(evs,0,59+2,"%c",'k');
		mvwprintw(evs,0,64+2,"%c",'^');
		mvwprintw(evs,0,65+2,"%c",'D');
		mvwprintw(evs,0,72+2,"%c",'^');
		mvwprintw(evs,0,73+2,"%c",'U');
		wattroff(evs,A_REVERSE);
	}
	else
	{
		mvwprintw(evs,0,1,"Fconv fconv Cls rmdir Top Gotom ^Attr ^Home ^Back ^topic Help -prev +next :vis \\ tree");
		wattron(evs,A_REVERSE);
		mvwprintw(evs,0,1,"%c",'F');
		mvwprintw(evs,0,7,"%c",'f');
		mvwprintw(evs,0,13,"%c",'C');
		mvwprintw(evs,0,17,"%c",'r');
		mvwprintw(evs,0,23,"%c",'T');
		mvwprintw(evs,0,27,"%c",'G');
		mvwprintw(evs,0,27+6,"%c",'^');
		mvwprintw(evs,0,28+6,"%c",'A');
		mvwprintw(evs,0,33+6,"%c",'^');
		mvwprintw(evs,0,34+6,"%c",'H');
		mvwprintw(evs,0,39+6,"%c",'^');
		mvwprintw(evs,0,40+6,"%c",'B');
		mvwprintw(evs,0,45+6,"%c",'^');
		mvwprintw(evs,0,52+6,"%c",'H');
		mvwprintw(evs,0,57+6,"%c",'-');
		mvwprintw(evs,0,63+6,"%c",'+');
		mvwprintw(evs,0,71+4,"%c",':');
		mvwprintw(evs,0,76+4,"%c",'\\');
		wattroff(evs,A_REVERSE);
	}
	wrefresh(evs);
	werase(evs);
}

/************************************************************************/
/* NAME      :void displaymenu2()*/
/* FUNCTION  :キーメニューを表示する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::displaymenu2(WINDOW *evs)
{
	int i,j,k;
  
	wattron(evs,A_REVERSE);
	for(k=0;k<80;k+=13)
		for(i=0;i<2;i++)
			mvwprintw(evs,i,k+1,"          ");

	mvwprintw(evs,0,1,"eXex    ");
	mvwprintw(evs,0,14,"*Tree    ");
	mvwprintw(evs,0,27,"Edit     ");
	mvwprintw(evs,0,40,"coPy     ");
	mvwprintw(evs,0,53,"Mkdir    ");
	mvwprintw(evs,0,66,"Rmdir    ");
	mvwprintw(evs,1,1,"Move     ");
	mvwprintw(evs,1,14,"Fconv   ");
	mvwprintw(evs,1,27,"Chdir    ");
	mvwprintw(evs,1,40,"View     ");
	mvwprintw(evs,1,53,"^Remeve  ");
	mvwprintw(evs,1,66,"Quit     ");
	wrefresh(evs);
	wattroff(evs,A_REVERSE);
	werase(evs);
}

/************************************************************************/
/* NAME      :void dialogmsg()*/ 
/* FUNCTION  :ユーザに選択を促すポップアップウインドウを表示する*/ 
/*            */ 
/*int x;	表示桁位置*/
/*int y;	表示行位置*/
/*char *buff;	表示するメッセージ*/
/*            */ 
/*            */ 
/* RETURN    :１　Ｙｅｓ　０　Ｎｏ*/
/************************************************************************/
void LocalFiler::dialogmsg(int x,int y,const std::string Message)
{
	WINDOW *pvs;
	int i;
	int ch;
	pvs = newwin(6,46,y,x);
	box(pvs,ACS_VLINE,ACS_HLINE);
	noecho();
	wattron(pvs,A_REVERSE);
	mvwprintw(pvs,0,1," ########## Filer Dialog Message ########## ");
	wattroff(pvs,A_REVERSE);
	mvwprintw(pvs,0,0,"+");
	mvwprintw(pvs,0,45,"+");
	mvwprintw(pvs,5,0,"+");
	mvwprintw(pvs,5,45,"+");

	mvwprintw(pvs,3,4,"%s",Message.c_str());
	wrefresh(pvs);
	delwin(pvs);
}

/************************************************************************/
/* NAME      :void dialogmsg2()*/ 
/* FUNCTION  :ユーザに選択を促すポップアップウインドウを表示する*/ 
/*            */ 
/*int x;	表示桁位置*/
/*int y;	表示行位置*/
/*char *buff;	表示するメッセージ*/
/*char *header;	タイトル名*/
/*            */ 
/*            */ 
/* RETURN    :１　Ｙｅｓ　０　Ｎｏ*/
/************************************************************************/
void LocalFiler::dialogmsg2(int x,int y,const std::string Message,const std::string Header)
{
	WINDOW *pvs;
	int i;
	int ch;

	pvs = newwin(5,50,y,x);
	box(pvs,ACS_VLINE,ACS_HLINE);
	noecho();
	wattron(pvs,A_REVERSE);
	mvwprintw(pvs,0,1,Header.c_str());
	wattroff(pvs,A_REVERSE);

	mvwprintw(pvs,1,4,"%s",Message.c_str());
	wrefresh(pvs);
	delwin(pvs);
}

/************************************************************************/
/* NAME      :int popmsg()*/ 
/* FUNCTION  :ユーザに選択を促すポップアップウインドウを表示する*/ 
/*            */ 
/*int x;	表示桁位置*/
/*int y;	表示行位置*/
/*char *buff;	表示するメッセージ*/
/*            */ 
/*            */ 
/* RETURN    :１　Ｙｅｓ　０　Ｎｏ*/
/************************************************************************/
int LocalFiler::popmsg(int x,int y, const std::string Message)
{
	WINDOW *pvs;
	int i;
	int ch;
	char msg[1024];

	sprintf(msg,"%s",Message.c_str());

	pvs = newwin(6,48,y,x);
	box(pvs,ACS_VLINE,ACS_HLINE);
	noecho();
	for(;;)
	{
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,0,1,"============ Filer Window Message ============");
		wattroff(pvs,A_REVERSE);
	//	mvwprintw(pvs,0,0,"+");
	//	mvwprintw(pvs,0,47,"+");
	//	mvwprintw(pvs,5,0,"+");
	//	mvwprintw(pvs,5,47,"+");

		mvwprintw(pvs,2,4,"%s",msg);
		mvwprintw(pvs,4,30,"Y or N :");
		wrefresh(pvs);
		ch = wgetch(pvs);
		switch(ch)
		{
		case 'y': case 'Y':
			delwin(pvs);
			return(1);
		case 'n': case 'N':
			delwin(pvs);
			return(0);
		}
	}
}

/************************************************************************/
/* NAME      :int popmsg2()*/ 
/* FUNCTION  :ユーザに選択を促すポップアップウインドウを表示する（ロング表示）*/ 
/*            */ 
/*int x;	表示桁位置*/
/*int y;	表示行位置*/
/*char *buff;	表示するメッセージ*/
/*            */ 
/*            */ 
/* RETURN    :１　Ｙｅｓ　０　Ｎｏ*/
/************************************************************************/
int LocalFiler::popmsg2(int x,int y,const std::string Message)
{
	WINDOW *pvs;
	int i;
	int ch;
	pvs = newwin(6,72,y,x);
	box(pvs,ACS_VLINE,ACS_HLINE);
	noecho();
	for(;;)
	{
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,0,1,"============================= Filer Window Message ==================");
		wattroff(pvs,A_REVERSE);

		mvwprintw(pvs,2,4,"%s",Message.c_str());
		mvwprintw(pvs,3,30,"Y or N :");
		wrefresh(pvs);
		ch = wgetch(pvs);
		switch(ch)
		{
		case 'y': case 'Y':
			delwin(pvs);
			return(1);
		case 'n': case 'N':
			delwin(pvs);
			return(0);
		}
	}
}

/************************************************************************/
/* NAME      :void usermsg()*/ 
/* FUNCTION  :メッセージをウインドウに表示する*/ 
/*            */ 
/*int x;	表示桁位置*/
/*int y;	表示行位置*/
/*char *buff;	表示するメッセージ*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::usermsg(int x,int y,char *buff)
{
	WINDOW *uvs;
	uvs = newwin(5,64,y,x);
	box(uvs,'+','+');
	mvwprintw(uvs,2,4,"%s",buff);
	wrefresh(uvs);
	delwin(uvs);
	getch();
}

/************************************************************************/
/* NAME      :void sys_errmsg()*/
/* FUNCTION  :エラーメッセージをウインドウに表示する*/ 
/*            */ 
/*int x;	表示桁位置*/
/*int y;	表示行位置*/
/*char *buff;	表示するメッセージ*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::sys_errmsg(int x,int y,const std::string Message)
{
	WINDOW *errvs;
	char msg[1024];

	sprintf(msg,"%s",Message.c_str());

	errvs = newwin(5,64,y,x);
	box(errvs,ACS_VLINE,ACS_HLINE);

	wattron(errvs,A_REVERSE);
	mvwprintw(errvs,0,1,"                                                              ");
	wattroff(errvs,A_REVERSE);
//	mvwprintw(errvs,0,0,"+");
//	mvwprintw(errvs,0,63,"+");
//	mvwprintw(errvs,4,0,"+");
//	mvwprintw(errvs,4,63,"+");

	mvwprintw(errvs,2,4,"%s",msg);
	wrefresh(errvs);
	wgetch(errvs);
	wattroff(errvs,A_REVERSE);
	delwin(errvs);
}

/************************************************************************/
/* NAME      :void helpmsg()*/ 
/* FUNCTION  :ヘルプを表示する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
/*
void LocalFiler::helpmsg(int x,int y)
{
	WINDOW *pvs;
	int ch;
	int i;
	pvs = newwin(23,72,y,x);
	box(pvs,ACS_VLINE,ACS_HLINE);

	wattron(pvs,A_REVERSE);
	mvwprintw(pvs,0,1,"                         Help  Window Message                         ");
	wattroff(pvs,A_REVERSE);
//	mvwprintw(pvs,0,0,"+");
//	mvwprintw(pvs,0,71,"+");
//	mvwprintw(pvs,22,0,"+");
//	mvwprintw(pvs,22,71,"+");

	noecho();
	for(i=0;i<22;i++)
		mvwprintw(pvs,i+1,1,"%s",helpbuff[i]);
	wrefresh(pvs);
	wgetch(pvs);
	delwin(pvs);
}

void LocalFiler::helpmsg2(int x,int y)
{
	WINDOW *pvs;
	int ch;
	int i;
	pvs = newwin(23,72,y,x);
	box(pvs,ACS_VLINE,ACS_HLINE);

	wattron(pvs,A_REVERSE);
	mvwprintw(pvs,0,1,"                         Help  Window Message                         ");
	wattroff(pvs,A_REVERSE);
//	mvwprintw(pvs,0,0,"+");
//	mvwprintw(pvs,0,71,"+");
//	mvwprintw(pvs,22,0,"+");
//	mvwprintw(pvs,22,71,"+");

	noecho();
	for(i=0;i<22;i++)
		mvwprintw(pvs,i+1,1,"%s",ehelpbuff[i]);
	wrefresh(pvs);
	wgetch(pvs);
	delwin(pvs);
}
*/

/************************************************************************/
/* NAME      :void fsort()*/ 
/* FUNCTION  :*/ 
/*            */ 
/*int filenum;	ファイル数*/
/*int int point;ファイル名文字の位置*/
/* RETURN    :なし/
/************************************************************************/
void LocalFiler::fsort(int filenum,int point)
{
	int i,j,k;
	char t;
	int t2;
	i=j=0;

	for(i=0;i<filenum;i++)
	{
		fil[j] = fs[i].buff1[point];
		fileindex[i] = j;
		j++;
	}

	for(i=0;i<filenum-1;i++)
	{
        for(j=filenum-1;j>i;j--)
		{
			if(fil[j-1]>fil[j])
			{
				t=fil[j];
				t2=fileindex[j];
 				fil[j]=fil[j-1];
				fileindex[j] = fileindex[j-1];
	 			fil[j-1]=t;
				fileindex[j-1]=t2;
 			}
		}
	}
	switch(point)
	{
	case 1:
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff2[i],"%s",fs[fileindex[i]].buff1);
		}

		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff1,"%s",fsortbuff2[i]);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff2[i],"%s",fs[fileindex[i]].buff2);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff2,"%s",fsortbuff2[i]);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff2[i],"%s",fs[fileindex[i]].buff3);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff3,"%s",fsortbuff2[i]);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff2[i],"%s",fs[fileindex[i]].buff4);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff4,"%s",fsortbuff2[i]);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff2[i],"%s",fs[fileindex[i]].buff5);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff5,"%s",fsortbuff2[i]);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff2[i],"%s",fs[fileindex[i]].buff6);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff6,"%s",fsortbuff2[i]);
		}
		break;
	default:
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff[i],"%s",fs[fileindex[i]].buff1);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff1,"%s",fsortbuff[i]);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff[i],"%s",fs[fileindex[i]].buff2);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff2,"%s",fsortbuff[i]);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff[i],"%s",fs[fileindex[i]].buff3);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff3,"%s",fsortbuff[i]);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff[i],"%s",fs[fileindex[i]].buff4);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff4,"%s",fsortbuff[i]);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff[i],"%s",fs[fileindex[i]].buff5);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff5,"%s",fsortbuff[i]);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fsortbuff[i],"%s",fs[fileindex[i]].buff6);
		}
		for(i=0;i<filenum;i++)
		{
			sprintf(fs[i].buff6,"%s",fsortbuff[i]);
		}
		break;
	}
}


/************************************************************************/
/* NAME      :int dirprint_all(char *)*/ 
/* FUNCTION  :ディレクトリを配列に記録する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::dirprint_all(const std::string Message,int type)
{
	struct dirent *dp;
	int i=0;
	int j=0;
	int k=0;
	struct tm *ftm;
	char cwdpath[512];
	char attrbuff[128];
	char dname[1024];
	char *cret;

	sprintf(dname,"%s",Message.c_str());

	if((dir = opendir(dname)) == (DIR *)NULL)
		exit(1);

	while((dp = readdir(dir)) != (struct dirent *)NULL)
	{
		stat(dp->d_name,fptr);
		if(!S_ISDIR(fptr->st_mode))
		{
			if(dmode == 'v')
			{
				sprintf(fs[i].buff1,"%s",dp->d_name);
			//	sprintf(fs[i].buff2,"%+10lu",fptr->st_size);
				sprintf(fs[i].buff2,"%10lu",fptr->st_size);
				switch(type)
				{
				case 'm':
					ftm = localtime(&fptr->st_mtime);
					sprintf(fs[i].buff3,"%2d/%2d-%.2d:%.2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_hour,ftm->tm_min);
					break;
				case 'u':
					ftm = localtime(&fptr->st_atime);
					sprintf(fs[i].buff3,"%2d/%2d-%.2d:%.2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_hour,ftm->tm_min);
					break;
				case 'y':
					ftm = localtime(&fptr->st_mtime);
					if(ftm->tm_year <= 99 && ftm->tm_year > 69)
						sprintf(fs[i].buff3,"%2d/%2d-19%2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year);
					else
						sprintf(fs[i].buff3,"%2d/%2d-%4d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year+1900);
					break;
				default:
					ftm = localtime(&fptr->st_mtime);
					break;
				}
				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(fs[i].buff4,"%-10s",attrbuff);
				sprintf(fs[i].buff5," %s",cmpuid(fptr->st_uid));
				sprintf(fs[i].buff6," %s",cmpgid(fptr->st_gid));
				j++;
				i++;
			}

			if(dp->d_name[0] != '.' && dmode == 'h')
			{
				sprintf(fs[i].buff1,"%s",dp->d_name);
			//	sprintf(fs[i].buff2,"%+10lu",fptr->st_size);
				sprintf(fs[i].buff2,"%10lu",fptr->st_size);
				switch(type)
				{
				case 'm':
					ftm = localtime(&fptr->st_mtime);
					sprintf(fs[i].buff3,"%2d/%2d-%.2d:%.2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_hour,ftm->tm_min);
					break;
				case 'u':
					ftm = localtime(&fptr->st_atime);
					sprintf(fs[i].buff3,"%2d/%2d-%.2d:%.2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_hour,ftm->tm_min);
					break;
				case 'y':
					ftm = localtime(&fptr->st_mtime);
					if(ftm->tm_year <= 99 && ftm->tm_year > 69)
						sprintf(fs[i].buff3,"%2d/%2d-19%2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year);
					else
						sprintf(fs[i].buff3,"%2d/%2d-%4d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year+1900);
					break;
				default:
					ftm = localtime(&fptr->st_mtime);
					break;
				}
				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(fs[i].buff4,"%-10s",attrbuff);
				sprintf(fs[i].buff5," %s",cmpuid(fptr->st_uid));
				sprintf(fs[i].buff6," %s",cmpgid(fptr->st_gid));
				j++;
				i++;
			}

		}
		else
		{
			cret = getcwd(cwdpath,512);
			if(!strcmp(cutspace(cwdpath),"/"))
			{
				if(dp->d_name[0] == '.')
					continue;
			}
			if(dmode == 'v')
			{
				sprintf(fs[i].buff1,"%s",dp->d_name);
				sprintf(fs[i].buff2,"   %s","<DIR>");
				switch(type)
				{
				case 'm':
					ftm = localtime(&fptr->st_mtime);
					break;
				case 'u':
					ftm = localtime(&fptr->st_atime);
					break;
				default:
					ftm = localtime(&fptr->st_mtime);
					break;
				}
				if(ftm->tm_year <= 99 && ftm->tm_year > 69)
					sprintf(fs[i].buff3,"%2d/%2d-19%2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year);
				else
					sprintf(fs[i].buff3,"%2d/%2d-%4d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year+1900);

				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(fs[i].buff4,"%-10s",attrbuff,1);
				sprintf(fs[i].buff5," %s",cmpuid(fptr->st_uid));
				sprintf(fs[i].buff6," %s",cmpgid(fptr->st_gid));
				k++;
				i++;
			}
			if(dp->d_name[0] != '.' && dmode == 'h')
			{
				sprintf(fs[i].buff1,"%s",dp->d_name);
				sprintf(fs[i].buff2,"   %s","<DIR>");
				switch(type)
				{
				case 'm':
					ftm = localtime(&fptr->st_mtime);
					break;
				case 'u':
					ftm = localtime(&fptr->st_atime);
					break;
				default:
					ftm = localtime(&fptr->st_mtime);
					break;
				}
				if(ftm->tm_year <= 99 && ftm->tm_year > 69)
					sprintf(fs[i].buff3,"%2d/%2d-19%2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year);
				else
					sprintf(fs[i].buff3,"%2d/%2d-%4d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year+1900);

				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(fs[i].buff4,"%-10s",attrbuff,1);
				sprintf(fs[i].buff5," %s",cmpuid(fptr->st_uid));
				sprintf(fs[i].buff6," %s",cmpgid(fptr->st_gid));
				k++;
				i++;
			}

		}
		if(i > MAX_FILES - 1)
		{
			file_num = j+k;
			closedir(dir);
			return;
		}
	}
	file_num = j+k;
	closedir(dir);
	for(i=29;i>0;i--)
	{
		fsort(file_num,i);
	}
	fsort(file_num,0);
}

/************************************************************************/
/* NAME      :int dirprint(char *)*/ 
/* FUNCTION  :ディレクトリを配列に記録する*/ 
/*            */ 
/*char *dname;	ディレクトリ名*/
/*char type;	日付の型（年、更新日、作成日）*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
/*
void LocalFiler::dirprint(char *dname,int type)
{
	struct dirent *dp;
	int i=0;
	int j=0;
	int k=0;
	struct tm *ftm;
	char cwdpath[512];
	char attrbuff[128];

	if((dir = opendir(dname)) == (DIR *)NULL)
		exit(1);

	while((dp = readdir(dir)) != (struct dirent *)NULL)
	{
		if(dp->d_name[0] != '.')
		{		
			stat(dp->d_name,fptr);
			if(!S_ISDIR(fptr->st_mode))
			{
				sprintf(fs[i].buff1,"%s",dp->d_name);
				sprintf(fs[i].buff2,"%+10lu",fptr->st_size);
				switch(type)
				{
				case 'm':
					ftm = localtime(&fptr->st_mtime);
					sprintf(fs[i].buff3,"%2d/%2d-%.2d:%.2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_hour,ftm->tm_min);
					break;
				case 'u':
					ftm = localtime(&fptr->st_atime);
					sprintf(fs[i].buff3,"%2d/%2d-%.2d:%.2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_hour,ftm->tm_min);
					break;
				case 'y':
					ftm = localtime(&fptr->st_mtime);
					if(ftm->tm_year <= 99 && ftm->tm_year > 69)
						sprintf(fs[i].buff3,"%2d/%2d-19%2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year); else
						sprintf(fs[i].buff3,"%2d/%2d-%4d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year+1900);
					break;
				default:
					ftm = localtime(&fptr->st_mtime);
					break;
				}
				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(fs[i].buff4,"%-10s",attrbuff);
				sprintf(fs[i].buff5," %s",cmpuid(fptr->st_uid));
				sprintf(fs[i].buff6," %s",cmpgid(fptr->st_gid));
				j++;
	
			}
			else
			{
				getcwd(cwdpath,512);
				if(!strcmp(cutspace(cwdpath),"/"))
				{
					if(dp->d_name[0] == '.')
						continue;
				}
				sprintf(fs[i].buff1,"%s",dp->d_name);
				sprintf(fs[i].buff2,"   %s","<DIR>");
				switch(type)
				{
				case 'm':
					ftm = localtime(&fptr->st_mtime);
					break;
				case 'u':
					ftm = localtime(&fptr->st_atime);
					break;
				default:
					ftm = localtime(&fptr->st_mtime);
					break;
				}
				if(ftm->tm_year <= 99 && ftm->tm_year > 69)
					sprintf(fs[i].buff3,"%2d/%2d-19%2d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year);
				else
					sprintf(fs[i].buff3,"%2d/%2d-%4d",ftm->tm_mon+1,ftm->tm_mday,ftm->tm_year+1900);
	
				lstat(dp->d_name,fptr);
				attrview(fptr->st_mode,attrbuff);
				sprintf(fs[i].buff4,"%-10s",attrbuff,1);
				sprintf(fs[i].buff5," %s",cmpuid(fptr->st_uid));
				sprintf(fs[i].buff6," %s",cmpgid(fptr->st_gid));
				k++;
			}
			i++;
			if(i > MAX_FILES - 1)
			{
				file_num = j+k;
				closedir(dir);
				return;
			}
		}
	}
	file_num = j+k;
	closedir(dir);
	for(i=29;i>0;i--)
	{
		fsort(file_num,i);
	}
	fsort(file_num,0);
}
*/

char *LocalFiler::cmpuid(uid_t uid)
{
	int i;
	for(i=0;i<256;i++)
	{
		if(atoi(userid[i]) == (int)uid)
		{
			return(username[i]);
		}
	}
	return((char *)"        ");
}

char *LocalFiler::cmpgid(uid_t gid)
{
	int i;
	for(i=0;i<256;i++)
	{
		if(atoi(groupid[i]) == (int)gid)
		{
			return(groupname[i]);
		}
	}
//	return("        ");
	return((char *)"GGGGGGGG");
}

/************************************************************************/
/* NAME      :int cutspace(char *)*/ 
/* FUNCTION  :指定した文字列からホワイトスペースを削除する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :スペースを削除した文字列へのポインタ*/
/************************************************************************/
char *LocalFiler::cutspace(char *s)
{
	int i,j;
	int len;
	char p[512];

	len = strlen(s);
	for(i=0,j=0;i<len;i++)
	{
		if(s[i] == ' ')
		;
		else
		{
			p[j] = s[i];
			j++;
		}
	}
	p[j] = '\0';
	sprintf(s,"%s",p);
	return((char *)s);
}

/************************************************************************/
/* NAME      :int cutchars(char *,char c)*/ 
/* FUNCTION  :指定した文字列からホワイトスペースを削除する*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :スペースを削除した文字列へのポインタ*/
/************************************************************************/
char *LocalFiler::cutchars(char *s,int c)
{
	int i,j;
	int len;
	char p[512];

	len = strlen(s);
	for(i=0,j=0;i<len;i++)
	{
		if(s[i] == c)
		;
		else
		{
			p[j] = s[i];
			j++;
		}
	}
	p[j] = '\0';
	sprintf(s,"%s",p);
	return((char *)s);
}

/************************************************************************/
/* NAME      :int input_window()*/ 
/* FUNCTION  :ユーザに入力を促すポップアップウインドウを表示する*/ 
/*            */ 
/*int x;	表示桁位置*/
/*int y;	表示行位置*/
/*char *buff;	入力する文字*/
/*char *msg;	表示するメッセージ*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void *LocalFiler::input_window(int x,int y,char *buff,const std::string Message)
{
	WINDOW *mvs;
	int ret;

	mvs = newwin(5,64,y,x);
	wattroff(mvs,A_REVERSE);
	box(mvs,ACS_VLINE,ACS_HLINE);
	mvwprintw(mvs,1,4,Message.c_str());
	wattron(mvs,A_REVERSE);
	mvwprintw(mvs,0,0,"                     Input  Window                              ");

	mvwprintw(mvs,2,4,"                                                     ");
	wrefresh(mvs);

	mvwprintw(mvs,2,4,"                                                     ");
	echo();
	nocbreak();
	nl();

//	mvwgetstr(mvs,2,4,buff);
	memset(buff,'\0',sizeof(buff));
	ret = jmvwgetnstr(mvs,2,4,(unsigned char *)cutspace(buff),53,1,1);
	switch(ret)
	{
	case 0x1b:
		break;
	default:
		break;
	}

	noecho();
	cbreak();

	wrefresh(mvs);

	wattroff(mvs,A_REVERSE);
	noecho();
	delwin(mvs);
	return(NULL);
}

/************************************************************************/
/* NAME      :int input_window()*/ 
/* FUNCTION  :ユーザに入力を促すポップアップウインドウを表示する*/ 
/*            */ 
/*int x;	表示桁位置*/
/*int y;	表示行位置*/
/*char *buff;	入力する文字*/
/*char *buff2;	表示する文字*/
/*char *msg;	表示するメッセージ*/
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void *LocalFiler::input_window(int x,int y,char *buff,char *buff2,const std::string Message)
{
	WINDOW *mvs;
	int ret;

	mvs = newwin(5,64,y,x);
	wattroff(mvs,A_REVERSE);
	box(mvs,ACS_VLINE,ACS_HLINE);
	mvwprintw(mvs,1,4,Message.c_str());
	wattron(mvs,A_REVERSE);
	mvwprintw(mvs,0,0,"                     Input  Window2                             ");

	mvwprintw(mvs,2,4,"                                                     ");
	wrefresh(mvs);

	mvwprintw(mvs,2,4,"                                                     ");
	echo();
	nocbreak();
	nl();
	strcpy(buff,buff2);
	ret = jmvwgetnstr(mvs,2,4,(unsigned char *)cutspace(buff),53,1,1);
	switch(ret)
	{
	case 0x1b:
		break;
	default:
		break;
	}
	noecho();
	cbreak();
	wrefresh(mvs);

	wattroff(mvs,A_REVERSE);
	noecho();
	delwin(mvs);
	return(NULL);
}

/************************************************************************/
/* NAME      :void rectang()*/ 
/* FUNCTION  :ウインドウの四隅に＋を描く*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::rectang(int no)
{
	mvwprintw(pt[no].vs,0,line1[0],"+");
	mvwprintw(pt[no].vs,0,line1[6],"+");
	mvwprintw(pt[no].vs,max_lines - (botom+1), line1[0],"+");
	mvwprintw(pt[no].vs,max_lines - (botom+1), line1[6],"+");
}


/*
 _INCLUDE_POSIX_SOURCE
#  ifndef S_IRWXU		   fcntl.h might have already defined these   
#    define S_ISUID 0004000	   set user ID on execution   
#    define S_ISGID 0002000	   set group ID on execution   

#    define S_IRWXU 0000700	   read, write, execute permission (owner)   
#    define S_IRUSR 0000400	   read permission (owner)   
#    define S_IWUSR 0000200	   write permission (owner)   
#    define S_IXUSR 0000100	   execute permission (owner)   

#    define S_IRWXG 0000070	   read, write, execute permission (group)   
#    define S_IRGRP 0000040	   read permission (group)   
#    define S_IWGRP 0000020	   write permission (group)   
#    define S_IXGRP 0000010	   execute permission (group)   

#    define S_IRWXO 0000007	   read, write, execute permission (other)   
#    define S_IROTH 0000004	   read permission (other)   
#    define S_IWOTH 0000002	   write permission (other)   
#    define S_IXOTH 0000001	   execute permission (other)   
#  endif    S_IRWXU   

#  define _S_IFMT   0170000	   type of file   
#  define _S_IFREG  0100000	   regular   
#  define _S_IFBLK  0060000	   block special   
#  define _S_IFCHR  0020000	   character special   
#  define _S_IFDIR  0040000	   directory   
#  define _S_IFIFO  0010000	   pipe or FIFO   

#  define S_ISDIR(_M)  ((_M & _S_IFMT)==_S_IFDIR)    test for directory   
#  define S_ISCHR(_M)  ((_M & _S_IFMT)==_S_IFCHR)    test for char special   
#  define S_ISBLK(_M)  ((_M & _S_IFMT)==_S_IFBLK)    test for block special   
#  define S_ISREG(_M)  ((_M & _S_IFMT)==_S_IFREG)    test for regular file   
#  define S_ISFIFO(_M) ((_M & _S_IFMT)==_S_IFIFO)    test for pipe or FIFO   
#endif    _INCLUDE_POSIX_SOURCE   
*/

/************************************************************************/
/* NAME      :void attrview(at,attrbuff)*/ 
/* FUNCTION  :ファイル・ディレクトリの属性（モード）を表示*/ 
/*            short at */ 
/*            char *attrbuff */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void LocalFiler::attrview(int at,char *attrbuff)
{
	int i;
	char buff[128];
	char ubuff[3][2];
	char gbuff[3][2];
	char obuff[3][2];
	char lbuff[32];

		/*
		_S_IFMT   0170000	   type of file   
		_S_IFREG  0100000	   regular   
		_S_IFBLK  0060000	   block special   
		_S_IFCHR  0020000	   character special   
		_S_IFDIR  0040000	   directory   
		_S_IFIFO  0010000	   pipe or FIFO   
		*/
	if(S_ISDIR(at))
	{
		if(at & S_IFDIR)
		{
			strcpy(buff,"d");
		}
	}
	else
	{
		if(at & S_IFMT)
		{
			strcpy(buff,"-");
		}
		if(S_ISCHR(at))
		{
			strcpy(buff,"c");
		}
		if(S_ISFIFO(at))
		{
			strcpy(buff,"p");
		}
		if(S_ISSOCK(at))
		{
			strcpy(buff,"s");
		}
		if(S_ISBLK(at))
		{
			strcpy(buff,"b");
		}
		if(S_ISLNK(at))
		{
			strcpy(buff,"l");
		}
	}

	if(at & S_IRWXU)
	{
		strcpy(ubuff[0],"r");
		strcpy(ubuff[1],"w");
		strcpy(ubuff[2],"x");
	}
	if(at & S_IRWXG)
	{
		strcpy(gbuff[0],"r");
		strcpy(gbuff[1],"w");
		strcpy(gbuff[2],"x");
	}
//	if(at & S_IRWXU) 2009.03.28
	if(at & S_IRWXO)
	{
		strcpy(obuff[0],"r");
		strcpy(obuff[1],"w");
		strcpy(obuff[2],"x");
	}

	if(at & S_IRUSR)
		strcpy(ubuff[0],"r");
	else
		strcpy(ubuff[0],"-");

	if(at & S_IWUSR)
		strcpy(ubuff[1],"w");
	else
		strcpy(ubuff[1],"-");

	if(at & S_IXUSR)
		strcpy(ubuff[2],"x");
	else
		strcpy(ubuff[2],"-");


	if(at & S_IRGRP)
		strcpy(gbuff[0],"r");
	else
		strcpy(gbuff[0],"-");

	if(at & S_IWGRP)
		strcpy(gbuff[1],"w");
	else
		strcpy(gbuff[1],"-");

	if(at & S_IXGRP)
		strcpy(gbuff[2],"x");
	else
		strcpy(gbuff[2],"-");



	if(at & S_IROTH)
		strcpy(obuff[0],"r");
	else
		strcpy(obuff[0],"-");

	if(at & S_IWOTH)
		strcpy(obuff[1],"w");
	else
		strcpy(obuff[1],"-");

	if(at & S_IXOTH)
		strcpy(obuff[2],"x");
	else
		strcpy(obuff[2],"-");


	if(at & S_ISUID)
	{
		if(at & S_IXUSR)
			strcpy(ubuff[2],"s");
		else
			strcpy(ubuff[2],"S");
	}
	if(at & S_ISGID)
		strcpy(gbuff[2],"s");
	if(at & S_ISVTX)
	{
		if(at & S_IXUSR)
			strcpy(obuff[2],"t");
		else
			strcpy(obuff[2],"T");
	}

	sprintf(attrbuff,"%-1s%-1s%-1s%-1s%-1s%-1s%-1s%-1s%-1s%-1s",buff,ubuff[0],ubuff[1],ubuff[2],gbuff[0],gbuff[1],gbuff[2],obuff[0],obuff[1],obuff[2]);
}

void LocalFiler::checkhisto(void)
{
	int i;

	if(pathisto > 256)
	{
		for(i=1;i<512;i++)
		{
			sprintf(dirstack[i-1],"%s",dirstack[i]);
		}
	}
}

/************************************************************************/
/* NAME      :int findex()*/ 
/* FUNCTION  :ファイル名文字列を検索する*/ 
/*            char *s ファイル名*/ 
/*            char *t 検索する文字*/ 
/*            */ 
/* RETURN    :/成功すれば文字の位置／失敗すれば−１*/
/************************************************************************/
int LocalFiler::findex(char *s,char *t)
{
	int i, j, k;

	for (i = 0;s[i] != '\0'; i++)
	{
		for (j=i, k=0; t[k] != '\0' && s[j] == t[k]; j++, k++)
			;
		if (t[k] == '\0')
			return(i);
	}
	return(-1);
}

/****************************************************************************
任意位置からの文字の取り出し
* 
*	NAME	:	void Mid(char *ds,char *ss,int a, int b);
* 	ARG		:	char *ds;	取り出された文字列のポインタ
* 				char *ss;	取り出す文字列のポインタ
* 				int    a;	取り出す文字の位置
* 				int    b;	取り出す文字数
* 	ETURN	:	なし
****************************************************************************/
void LocalFiler::Mid(char *ds, char *ss, int a, int b)
{
	int k,n;
	n=strlen(ss);
	if((0<a && a<=n) && (0<b && b<=n) && (a+b-1<=n)){
		for(k=a; k<a+b; k++)
		    ds[k-a]=ss[k-1];
		ds[b]='\0';
	}
	else
		ds[0]='\0';
}

/****************************************************************************
任意位置からの文字の取り出し
* 
*	NAME	:	void Mid1(char *ds,char *ss,int a, int b);
* 	ARG		:	
* 				char *ss;	取り出す文字列のポインタ
* 				int    a;	取り出す文字の位置
* 				int    b;	取り出す文字数
* 	ETURN	:	char   *;	取り出された文字列のポインタ
****************************************************************************/
char *LocalFiler::Mid1(char *ss, int a, int b)
{
	int k,n;
	char *ds;
	static char retds[512];

	n=strlen(ss);
	ds = (char *)malloc(n+1);
	if((0<a && a<=n) && (0<b && b<=n) && (a+b-1<=n)){
		for(k=a; k<a+b; k++)
		    ds[k-a]=ss[k-1];
		ds[b]='\0';
	}
	else
		ds[0]='\0';
	sprintf(retds,"%s",ds);
	free(ds);
	return((char *)retds);
}

char *LocalFiler::Mid2(char *ss, int a, int b)
{
	int k,n;
	char *ds;
	static char retds[512];

	n=strlen(ss);
	ds = (char *)malloc(n+1);
	if((0<a && a<=n) && (0<b && b<=n) && (a+b-1<=n)){
		for(k=a; k<a+b; k++)
		    ds[k-a]=ss[k-1];
		ds[b]='\0';
	}
	else
		ds[0]='\0';
	sprintf(retds,"%s",ds);
	free(ds);
	return((char *)retds);
}

char *LocalFiler::Mid3(char *ss, int a, int b)
{
	int k,n;
	char *ds;
	static char retds[512];

	n=strlen(ss);
	ds = (char *)malloc(n+1);
	if((0<a && a<=n) && (0<b && b<=n) && (a+b-1<=n)){
		for(k=a; k<a+b; k++)
		    ds[k-a]=ss[k-1];
		ds[b]='\0';
	}
	else
		ds[0]='\0';
	sprintf(retds,"%s",ds);
	free(ds);
	return((char *)retds);
}

char *LocalFiler::Mid4(char *ss, int a, int b)
{
	int k,n;
	char *ds;
	static char retds[512];

	n=strlen(ss);
	ds = (char *)malloc(n+1);
	if((0<a && a<=n) && (0<b && b<=n) && (a+b-1<=n)){
		for(k=a; k<a+b; k++)
		    ds[k-a]=ss[k-1];
		ds[b]='\0';
	}
	else
		ds[0]='\0';
	sprintf(retds,"%s",ds);
	free(ds);
	return((char *)retds);
}


/*
char * LocalFiler::left2(char *s,size_t n)
{
	int i;
	char s1[512];
	static char s2[512];
	char *sr;
	for(i=0; s[i] == '\0'|| i < n;i++)
	{
		s1[i] = s[i];
	}
	s1[i] = '\0';
	strcpy(s2,s1);
	sr = s2;
	return(sr);
}
*/

char *LocalFiler::right2(char *s, size_t n)
{
	int i;
	char s1[512];
	static char s2[512];
	char *sr;
	n = (size_t)strlen(s) - n;
	for(i=n; s[i] != '\0';i++)
	{
		s1[i-n] = s[i];
	}
	s1[i-n] = '\0';
	strcpy(s2,s1);
	sr = s2;
	return(sr);
}

/*
char  *ss;	取り出す文字列のポインタ
int    a;	右端から取り出す文字数
戻り値	:	なし
*/
void LocalFiler::right3(char *ds, char *ss, int a)
{
	int k;
	if(0 < a && a <= (size_t)strlen(ss))
	{
		for(k = 0; k < a; k++)
			ds[k] = ss[strlen(ss)-a+k];
		ds[a] = '\0';
	}
	else
		ds[0]='\0';
}

void LocalFiler::dirlocateclear(void)
{
	int i;
	for (i=0;i<256;i++)
	{
		memset(dirlocate[i],'\0',512);
		dirlocatey[i] = 0;
		dirlocateyy[i] = 5;
	}
}

void LocalFiler::dirlocateofset(char mode)
{
	int i;
	for (i=0;i<256;i++)
	{
		switch(mode)
		{
		case 'v':
			dirlocatey_save[i] = dirlocatey[i];
			dirlocateyy_save[i] = dirlocateyy[i];
			dirlocatey[i] = 1;
			dirlocateyy[i] = 5;
			break;
		case 'h':
			dirlocatey[i] = dirlocatey_save[i];
			dirlocateyy[i] = dirlocateyy_save[i];
			break;
		default:
			break;
		}
	}
}

int LocalFiler::resize(void)
{
	int ret = system("ls -l");
	delwin(pt[0].vs);
	initscr();
	cbreak();
	noecho();
	pt[0].vs = newwin(max_lines - botom,90,1,0);
	set_screen(0);
	box(pt[0].vs,ACS_VLINE,ACS_HLINE);
	wrefresh(pt[0].vs);
}

/************************************************************************/
/* NAME      :int filemode(ut,at,*firbuff)*/ 
/* FUNCTION  :ファイル・ディレクトリの属性（モード）を表示*/ 
/*            uid_t ut */ 
/*            mode_t at */ 
/*            char *filebuff;
/*            
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
int LocalFiler::filemode(uid_t ut,mode_t at, char *filebuff)
{
	int i;
	mode_t mode = 0x00000000;

	char buff[512];

	uid_t uid;

		/*
		_S_IFMT   0170000	   type of file   
		_S_IFREG  0100000	   regular   
		_S_IFBLK  0060000	   block special   
		_S_IFCHR  0020000	   character special   
		_S_IFDIR  0040000	   directory   
		_S_IFIFO  0010000	   pipe or FIFO   
		*/
	if(S_ISDIR(at))
	{
		if(at & S_IFDIR)
		{
			return(1);
		}
	}
	else
	{
		if(S_ISCHR(at))
		{
			return(1);
		}
		if(S_ISFIFO(at))
		{
			return(1);
		}
		if(S_ISBLK(at))
		{
			return(1);
		}
		if(S_ISLNK(at))
		{
			return(1);
		}
	}

	if(at & S_ISUID)
		return(0);
	if(at & S_ISGID)
		return(0);

	if(at & S_IRUSR)
		mode = mode | 0x01000000;

	if(at & S_IWUSR)
		mode = mode | 0x00100000;

	if(at & S_IXUSR)
		mode = mode | 0x00010000;


	if(at & S_IRGRP)
		mode = mode | 0x00000100;

	if(at & S_IWGRP)
		mode = mode | 0x00000010;

	if(at & S_IXGRP)
		mode = mode | 0x00000001;

	/*16進数に変えてOTHERだけ除外*/
	switch(mode)
	{
	case 0x00100000:	//400
		break;
	case 0x01100000:	//600
		break;
	case 0x01010000:	//500
		break;
	case 0x01110000:	//700
		break;

	case 0x00000010:	//040
		break;
	case 0x00000110:	//060
		break;
	case 0x00000101:	//050
		break;
	case 0x00000111:	//070
		break;

	case 0x00100010:	//440
		break;
	case 0x01100100:	//640
		break;
	case 0x01100110:	//660
		break;
	case 0x01110101:	//750
		break;
	case 0x01110111:	//770
		break;
	default:
		sprintf(buff,"%s はオーナーとグループ以外に書き込み権限がありません。",filebuff);
		sys_errmsg(4,10,buff);
		break;
	}

	uid = getuid();

	//オーナーが違う場合も変換しない方向で
	if(ut != uid)
	{
		return(1);
	}

	return(0);

}

