#pragma ident "@(#) ftpcom.cc 1.1.5 2010.04.01,12:12"
#include "ftx.h"

extern	ListBox *ImmLog;

//PASVコマンドのために追加（バグ修正）
extern ListBox *pFilerListBox;

int glbintControlSocket;

static char hostaddr1[4];
static char hostaddr2[4];
static char hostaddr3[4];
static char hostaddr4[4];
static char port1[8];
static char port2[8];

//このコマンドは最初のLISTを実行する。
//hosts.ftxファイルに定義された初期ディレクトリ(txtHomeDir)に移動する。
int frmSockFTP::intDoFirstConnect(void)
{
	u_int intServerReplyCode;
	char *strCommand;
	char *result;

	sprintf(listboxmsg,"%s",txtHostName);
	glbintControlSocket = ConnectFTPControlSocket(listboxmsg);

	if (glbintControlSocket != INVALID_SOCKET)
	{
		sprintf(ImmediateMsg,"%s", strGetServerReply());
		subShowServerCommand(ImmediateMsg);
		sprintf(ImmediateMsg,"%s %s","CONNECTED to: ",txtHostName);
		subShowServerCommand(ImmediateMsg);

		intServerReplyCode = intDoUSERCommand();

		if (intServerReplyCode == 331)
		{
			intServerReplyCode = intDoPASSCommand();

			if (intServerReplyCode == 230)
			{
				sprintf(txtSystemType,"%s",strDoSYSTCommand());
				sprintf(ImmediateMsg,"%s%s","Logged into ",txtHostName);

				subShowServerCommand(ImmediateMsg);
				sprintf(txtWorkingDir,"%s",strDoCWDCommand(txtHomeDir));
				subShowServerCommand(txtWorkingDir);
				intServerReplyCode = intDoListCommand();
			}
			 else
			{
				subCloseIncompleteConnection();
				return(1);
			}
		}
		else
		{
			subCloseIncompleteConnection();
			return(1);
		}
	}
	return(0);
}

//このコマンドは再接続のLISTを実行する。
//再接続直前のディレクトリに移動する。
int frmSockFTP::intDoReConnect(const std::string strDirectory)
{
	u_int intServerReplyCode;
	char *strCommand;
	char *result;

	sprintf(listboxmsg,"%s",txtHostName);
	glbintControlSocket = ConnectFTPControlSocket(listboxmsg);

	if (glbintControlSocket != INVALID_SOCKET)
	{
		sprintf(ImmediateMsg,"%s", strGetServerReply());
		subShowServerCommand(ImmediateMsg);
		sprintf(ImmediateMsg,"%s %s","CONNECTED to: ",txtHostName);
		subShowServerCommand(ImmediateMsg);

		intServerReplyCode = intDoUSERCommand();

		if (intServerReplyCode == 331)
		{
			intServerReplyCode = intDoPASSCommand();

			if (intServerReplyCode == 230)
			{
				sprintf(txtSystemType,"%s",strDoSYSTCommand());
				sprintf(ImmediateMsg,"%s%s","Logged into ",txtHostName);

				subShowServerCommand(ImmediateMsg);
				sprintf(txtWorkingDir,"%s",strDoCWDCommand(strDirectory));
				subShowServerCommand(txtWorkingDir);
				intServerReplyCode = intDoListCommand();
			}
			 else
			{
				subCloseIncompleteConnection();
				return(1);
			}
		}
		else
		{
			subCloseIncompleteConnection();
			return(1);
		}
	}
	return(0);
}

int frmSockFTP::intDoDisconnect(void)
{
	int intServerReplyCode;
	int intWinsockReplyCode;

	char strCommand[256];
	
	int ret;

	if(MsgBox2("ホストコンピュータとの接続を終了します") == 1)
	{
		sprintf(strCommand,"%s\r\n", "QUIT");
		subShowServerCommand(strCommand);
		sprintf(ImmediateMsg,"%s\n",strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, ImmediateMsg);
		subShowServerReplyCode(intServerReplyCode);
		subGetServerReplyText();

		intWinsockReplyCode = close(glbintControlSocket);

		memset(txtWorkingDir,'\0',sizeof(txtWorkingDir));
		memset(txtSystemType,'\0',sizeof(txtSystemType));
		return(1);
	}
	else
	{
		return(0);
	}
}

static void cocnt(char *host)
{
	int i,j;
	int len;
	int cnt;
	char buff[256];
	
	cnt = 0;
	len = strlen(host);
	for(i=0,j=0;i<len;i++)
	{
		switch(host[i])
		{
		case ',': case ')': case '(':
			buff[j] = '\0';
			switch(cnt)
			{
			case 1:
				sprintf(hostaddr1,"%s",buff);
				break;
			case 2:
				sprintf(hostaddr2,"%s",buff);
				break;
			case 3:
				sprintf(hostaddr3,"%s",buff);
				break;
			case 4:
				sprintf(hostaddr4,"%s",buff);
				break;
			case 5:
				sprintf(port1,"%s",buff);
				break;
			case 6:
				sprintf(port2,"%s",buff);
				break;
			}
			cnt++;
			j = 0;
			break;
		default:
			buff[j] = host[i];
			j++;
			break;
		}
	}
	sprintf(host,"%s",buff);
}

u_int frmSockFTP::intDoListCommand(void)
{
	int intListenSocket;
	int intDataSocket;
	char strCommand[256];
	char strListCommand[256];
	u_int intServerReplyCode, intWinsockReply;

	char addrbuff[128];
	char portbuff[32];
	char hostbuff[32];
	char tmpbuff[256];

	intListenSocket = CreateListenSocket(glbintControlSocket);

	if(intTYPE)
	{
		optImageFileType = True;
	}
	if (intListenSocket != INVALID_SOCKET)
	{
		//リストコマンド
		if (optImageFileType == True)
		{
			sprintf(strCommand,"%s%s\r\n", "TYPE ","A N");
			subShowServerCommand (strCommand);
			intServerReplyCode = SendFTPCommand(glbintControlSocket,strCommand);
			subShowServerReplyCode (intServerReplyCode);
			subGetServerReplyText();
		}
		if (pFilerListBox->intPASV)
		{
			static char strReplyText[2048];
			int i,j;
	
			memset(strCommand,'\0',256);
			sprintf(strCommand,"%s\r\n","PASV");
			subShowServerCommand (strCommand);
			intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
			subShowServerReplyCode (intServerReplyCode);
			subGetServerReplyText();

			memset(strReplyText,'\0',sizeof(strReplyText));
			sprintf(strReplyText,"%s",strGetServerReply());

			cocnt(strReplyText );
			sprintf(portbuff,"%d",(atoi(port1)*256)+(atoi(port2)));

			i=InStr(0,strReplyText,'(');
			j=InStr(i+1,strReplyText,')');
			sprintf(addrbuff,"%s",Mid(strReplyText,i+1,(j-i)));

			cocnt(addrbuff );
			sprintf(hostbuff,"%s.%s.%s.%s",hostaddr1,hostaddr2,hostaddr3,hostaddr4);
			intDataSocket = CreateDataSocketPASV(hostbuff,portbuff);
			if(intDataSocket == INVALID_SOCKET)
			{
				return(0);
			}
		}

		sprintf(strListCommand,"%s",txtOPTL);
		sprintf(strCommand,"%s\r\n",strListCommand);
		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();

		if (intServerReplyCode < 400)
		{
			if(!pFilerListBox->intPASV)
			{
				intDataSocket = AcceptDataConnection(intListenSocket);
			}
			if (intDataSocket != INVALID_SOCKET)
			{
				unlink(txtTmpDirListFile);
				intServerReplyCode = ReadDataChannel(glbintControlSocket, intDataSocket, txtTmpDirListFile);
				close(intDataSocket);

			if(intServerReplyCode == 222)
			{
				ReadFTPServerReply(glbintControlSocket);
			}
			strDoPWDCommand();

				//listenソケットのクローズ
				intWinsockReply = close(intListenSocket);
			}
			else
			{
				intServerReplyCode = 999;
				subShowServerReplyCode (intServerReplyCode);
				subGetServerReplyText();
				subShowServerCommand ("データソケットが無効");
			}
		}
		else
		{
			sprintf(ImmediateMsg,"UNEXPECTED Reply Code %d",intServerReplyCode);
			subShowServerCommand(ImmediateMsg);
		}

		/*
		if (optImageFileType == True)
		{
			sprintf(strCommand,"%s%s\r\n","TYPE ", "I");
			subShowServerCommand (strCommand);
			intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		}
		*/
	}
	else
	{
		intServerReplyCode = 999;
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
		subShowServerCommand ("リスナーソケットが無効です。接続を確立出来ません。");
	}

	return(0);
}

u_int frmSockFTP::intDoMKDIRCommand(const std::string strDirName)
{
	char strCommand[256];
	u_int intServerReplyCode;


	if (strlen(strDirName.c_str()) == 0)
	{
		return(999);
	}
	else
	{
		sprintf(strCommand,"%s%s\r\n","MKD ",strDirName.c_str());

		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
	}
	if (intServerReplyCode != 230)
	{
		subShowServerCommand ("EXPECTED Reply Code 230");
	}
	return(intServerReplyCode);
}

u_int frmSockFTP::intDoRMFILECommand(const std::string strFileName)
{
	char strCommand[256];
	u_int intServerReplyCode;


	if (strlen(strFileName.c_str()) == 0)
	{
		return(999);
	}
	else
	{
		sprintf(strCommand,"%s%s\r\n","DELE ",strFileName.c_str());

		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
	}
	if (intServerReplyCode != 250)
	{
		subShowServerCommand ("EXPECTED Reply Code 230");
	}
	return(intServerReplyCode);
}

u_int frmSockFTP::intDoRMDIRCommand(const std::string strDirName)
{
	char strCommand[256];
	u_int intServerReplyCode;


	if (strlen(strDirName.c_str()) == 0)
	{
		return(999);
	}
	else
	{
		sprintf(strCommand,"%s%s\r\n","RMD ",strDirName.c_str());

		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
	}
	if (intServerReplyCode != 250)
	{
		subShowServerCommand ("EXPECTED Reply Code 230");
	}
	return(intServerReplyCode);
}

//このコマンドは mv (rename)を行う。RNTOと併用して実行しなければならない。
u_int frmSockFTP::intDoRNFRCommand(const std::string strDirName)
{
	char strCommand[256];
	u_int intServerReplyCode;

	if (strlen(strDirName.c_str()) == 0)
	{
		return(999);
	}
	else
	{
		sprintf(strCommand,"%s%s\r\n","RNFR ",strDirName.c_str());

		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
	}
	if (intServerReplyCode != 350)
	{
		subShowServerCommand ("EXPECTED Reply Code 230");
	}
	return(intServerReplyCode);
}

//このコマンドは mv (rename)先のファイル名の決定を行う。
u_int frmSockFTP::intDoRNTOCommand(const std::string strDirName)
{
	char strCommand[256];
	u_int intServerReplyCode;


	if (strlen(strDirName.c_str()) == 0)
	{
		return(999);
	}
	else
	{
		sprintf(strCommand,"%s%s\r\n","RNTO ",strDirName.c_str());

		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
	}
	if (intServerReplyCode != 250)
	{
		subShowServerCommand ("EXPECTED Reply Code 230");
	}
	return(intServerReplyCode);
}

u_int frmSockFTP::intDoPASSCommand(void)
{
	char strCommand[256];
	u_int intServerReplyCode;

	memset(strCommand,'\0',256);
	sprintf(strCommand,"%s%s\r\n","PASS ",txtPassword);
	subShowServerCommand ("PASS ****");
	intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
	subShowServerReplyCode (intServerReplyCode);
	subGetServerReplyText();
	
	switch(intServerReplyCode)
	{
	case 230:
		subShowServerCommand ("Server login complete.");
		break;

	case 530:
		subShowServerCommand ("530 Login incorrect.");
		break;

	default:
		subShowServerCommand ("EXPECTED Reply Code 230");
		break;
	}
	
	return(intServerReplyCode);
}

u_int frmSockFTP::intDoRETRCommand(const std::string strFileName, int optImage)
{
	int intListenSocket;
	int intDataSocket;
	char strCommand[256];
	char strType[256];
	char strServerReply[256];
	u_int intServerReplyCode, intWinsockReply;
	
	char addrbuff[128];
	char portbuff[32];
	char hostbuff[32];
	char tmpbuff[256];

	intListenSocket = CreateListenSocket(glbintControlSocket);

	if(intListenSocket != INVALID_SOCKET)
	{
		if(optImage == True)
		{
			strcpy(strType,"I");
		}
		else
		{
			strcpy(strType,"A N");
		}

		sprintf(strCommand,"%s%s\r\n","TYPE ",strType);
		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
		
	//ここにあったRETRコマンドの実行を以下のif文の後ろに移動した

		if (pFilerListBox->intPASV)
		{
			static char strReplyText[2048];
			int i,j;

			memset(strCommand,'\0',256);
			sprintf(strCommand,"%s\r\n","PASV");
			subShowServerCommand (strCommand);
			intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
			subShowServerReplyCode (intServerReplyCode);
			subGetServerReplyText();

			memset(strReplyText,'\0',sizeof(strReplyText));
			sprintf(strReplyText,"%s",strGetServerReply());

			cocnt(strReplyText );
			sprintf(portbuff,"%d",(atoi(port1)*256)+(atoi(port2)));

			i=InStr(0,strReplyText,'(');
			j=InStr(i+1,strReplyText,')');
			sprintf(addrbuff,"%s",Mid(strReplyText,i+1,(j-i)));

			cocnt(addrbuff );
			sprintf(hostbuff,"%s.%s.%s.%s",hostaddr1,hostaddr2,hostaddr3,hostaddr4);
			intDataSocket = CreateDataSocketPASV(hostbuff,portbuff);
		}
		//ここに移動してPASVを実行可能
		sprintf(strCommand,"%s%s\r\n","RETR ",strFileName.c_str());
		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();

		if (intServerReplyCode < 400)
		{
			if(!pFilerListBox->intPASV)
			{
				intDataSocket = AcceptDataConnection(intListenSocket);
			}

			if (intDataSocket != INVALID_SOCKET)
			{
				sprintf(strServerReply,"%s", strTransferGetFile(intDataSocket, strFileName.c_str()));
				subShowServerCommand (strServerReply);
				intServerReplyCode = atoi(Left(strServerReply, 3));
				subShowServerReplyCode (intServerReplyCode);

				intWinsockReply = close(intDataSocket);

				//listenソケットのクローズ
				intWinsockReply = close(intListenSocket);
				 ReadFTPServerReply(glbintControlSocket);
			}
			else
			{
				intWinsockReply = close(intListenSocket);
				intServerReplyCode = 999;
				subShowServerReplyCode (intServerReplyCode);
				subGetServerReplyText();
				subShowServerCommand ("データソケットが無効");
			}
			
		}
		else
		{
			sprintf(ImmediateMsg,"UNEXPECTED Reply Code %d", intServerReplyCode);
			subShowServerCommand(ImmediateMsg);
		}
	}
	else
	{
		intServerReplyCode = 999;
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
		subShowServerCommand ("リスナーソケットが無効");
	}
	return(intServerReplyCode);
}

u_int frmSockFTP::intDoSTORCommand(const std::string strFileName, int optImage)
{
	int intListenSocket;
	int intDataSocket;
	char strCommand[256];
	char strType[256];
	char strServerReply[256];
	u_int intServerReplyCode, intWinsockReply;
	
	char addrbuff[128];
	char portbuff[32];
	char hostbuff[32];
	char tmpbuff[256];

	intListenSocket = CreateListenSocket(glbintControlSocket);

	if(intTYPE)
	{
		optImageFileType = True;
	}
	if (intListenSocket != INVALID_SOCKET)
	{
		if (optImage == True)
			strcpy(strType,"I");
		else
			strcpy(strType,"A N");

		sprintf(strCommand,"%s%s\r\n","TYPE ",strType);
		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();

		if (pFilerListBox->intPASV)
		{
			static char strReplyText[2048];
			int i,j;
	
			memset(strCommand,'\0',256);
			sprintf(strCommand,"%s\r\n","PASV");
			subShowServerCommand (strCommand);
			intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
			subShowServerReplyCode (intServerReplyCode);
			subGetServerReplyText();

			memset(strReplyText,'\0',sizeof(strReplyText));
			sprintf(strReplyText,"%s",strGetServerReply());

			cocnt(strReplyText );
			sprintf(portbuff,"%d",(atoi(port1)*256)+(atoi(port2)));

			i=InStr(0,strReplyText,'(');
			j=InStr(i+1,strReplyText,')');
			sprintf(addrbuff,"%s",Mid(strReplyText,i+1,(j-i)));

			cocnt(addrbuff );
			sprintf(hostbuff,"%s.%s.%s.%s",hostaddr1,hostaddr2,hostaddr3,hostaddr4);
			intDataSocket = CreateDataSocketPASV(hostbuff,portbuff);
		}
		sprintf(strCommand,"%s%s\r\n","STOR ",strFileName.c_str());
		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);

		if (intServerReplyCode < 400)
		{
			if(!pFilerListBox->intPASV)
			{
				intDataSocket = AcceptDataConnection(intListenSocket);
			}
			if (intDataSocket != INVALID_SOCKET)
			{
				sprintf(strServerReply,"%s",strTransferPutFile(glbintControlSocket,intDataSocket, strFileName.c_str()));
				subShowServerCommand (strServerReply);
				intServerReplyCode = atoi(Left(strServerReply, 3));
				subShowServerReplyCode (intServerReplyCode);

				intWinsockReply = close(intDataSocket);

				//listenソケットのクローズ
				intWinsockReply = close(intListenSocket);
				ReadFTPServerReply(glbintControlSocket);
			}
			else
			{
				intWinsockReply = close(intListenSocket);
				intServerReplyCode = 999;
				subShowServerReplyCode (intServerReplyCode);
				subGetServerReplyText();
				subShowServerCommand ("データソケットが無効");
			}
		}
		else
		{
			sprintf(ImmediateMsg,"UNEXPECTED Reply Code %d", intServerReplyCode);
			subShowServerCommand(ImmediateMsg);
		}
	}
	else
	{
		intServerReplyCode = 999;
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
		subShowServerCommand ("リスナーソケットが無効");
	}
	return(intServerReplyCode);
}

//このコマンドはテキストファイル（テキストファイル）を表示するために作成された。
u_int frmSockFTP::intDoEDITCommand(const std::string strFileName, const std::string strEditFileName, int optImage)
{
	int intListenSocket;
	int intDataSocket;
	char strCommand[256];
	char strType[256];
	char strServerReply[256];
	u_int intServerReplyCode, intWinsockReply;
	
	char addrbuff[128];
	char portbuff[32];
	char hostbuff[32];
	char tmpbuff[256];

	intListenSocket = CreateListenSocket(glbintControlSocket);

	if(intTYPE)
	{
		optImageFileType = True;
	}
	if(intListenSocket != INVALID_SOCKET)
	{
		if(optImage == True)
		{
			strcpy(strType,"I");
		}
		else
		{
			strcpy(strType,"A N");
		}

		sprintf(strCommand,"%s%s\r\n","TYPE ",strType);
		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();

//sprintf(tmpbuff,"PASV=%d",pFilerListBox->intPASV);
//popmsg(1,1,tmpbuff);	
		if (pFilerListBox->intPASV)
		{
			static char strReplyText[2048];
			int i,j;
	
			memset(strCommand,'\0',256);
			sprintf(strCommand,"%s\r\n","PASV");
			subShowServerCommand (strCommand);
			intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
			subShowServerReplyCode (intServerReplyCode);
			subGetServerReplyText();

			memset(strReplyText,'\0',sizeof(strReplyText));
			sprintf(strReplyText,"%s",strGetServerReply());

			cocnt(strReplyText );
			sprintf(portbuff,"%d",(atoi(port1)*256)+(atoi(port2)));

			i=InStr(0,strReplyText,'(');
			j=InStr(i+1,strReplyText,')');
			sprintf(addrbuff,"%s",Mid(strReplyText,i+1,(j-i)));

			cocnt(addrbuff );
			sprintf(hostbuff,"%s.%s.%s.%s",hostaddr1,hostaddr2,hostaddr3,hostaddr4);
			intDataSocket = CreateDataSocketPASV(hostbuff,portbuff);
		}
		sprintf(strCommand,"%s%s\r\n","RETR ",strFileName.c_str());
		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();

		if (intServerReplyCode < 400)
		{
			if(!pFilerListBox->intPASV)
			{
				intDataSocket = AcceptDataConnection(intListenSocket);
			}

			if (intDataSocket != INVALID_SOCKET)
			{
				sprintf(strServerReply,"%s", strTransferGetFile(intDataSocket, strEditFileName.c_str()));
				subShowServerCommand (strServerReply);
				intServerReplyCode = atoi(Left(strServerReply, 3));
				subShowServerReplyCode (intServerReplyCode);

				intWinsockReply = close(intDataSocket);

				//listenソケットのクローズ
				intWinsockReply = close(intListenSocket);
				 ReadFTPServerReply(glbintControlSocket);
			}
			else
			{
				intWinsockReply = close(intListenSocket);
				intServerReplyCode = 999;
				subShowServerReplyCode (intServerReplyCode);
				subGetServerReplyText();
				subShowServerCommand ("データソケットが無効");
			}
			
		}
		else
		{
			sprintf(ImmediateMsg,"UNEXPECTED Reply Code %d", intServerReplyCode);
			subShowServerCommand(ImmediateMsg);
		}
	}
	else
	{
		intServerReplyCode = 999;
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
		subShowServerCommand ("リスナーソケットが無効");
	}
}

//このコマンドはバイナリファイル（画像等）を表示するために作成された。
u_int frmSockFTP::intDoVIEWCommand(const std::string strFileName, const std::string strEditFileName)
{
	int intListenSocket;
	int intDataSocket;
	char strCommand[256];
	char strType[256];
	char strServerReply[256];
	u_int intServerReplyCode, intWinsockReply;

	char addrbuff[128];
	char portbuff[32];
	char hostbuff[32];
	char tmpbuff[256];

	intListenSocket = CreateListenSocket(glbintControlSocket);

	if(intListenSocket != INVALID_SOCKET)
	{
		strcpy(strType,"I");

		sprintf(strCommand,"%s%s\r\n","TYPE ",strType);
		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();

		if (pFilerListBox->intPASV)
		{
			static char strReplyText[2048];
			int i,j;
	
			memset(strCommand,'\0',256);
			sprintf(strCommand,"%s\r\n","PASV");
			subShowServerCommand (strCommand);
			intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
			subShowServerReplyCode (intServerReplyCode);
			subGetServerReplyText();

			memset(strReplyText,'\0',sizeof(strReplyText));
			sprintf(strReplyText,"%s",strGetServerReply());

			cocnt(strReplyText );
			sprintf(portbuff,"%d",(atoi(port1)*256)+(atoi(port2)));

			i=InStr(0,strReplyText,'(');
			j=InStr(i+1,strReplyText,')');
			sprintf(addrbuff,"%s",Mid(strReplyText,i+1,(j-i)));

			cocnt(addrbuff );
			sprintf(hostbuff,"%s.%s.%s.%s",hostaddr1,hostaddr2,hostaddr3,hostaddr4);
			intDataSocket = CreateDataSocketPASV(hostbuff,portbuff);
		}
		sprintf(strCommand,"%s%s\r\n","RETR ",strFileName.c_str());
		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();

		if (intServerReplyCode < 400)
		{
			if(!pFilerListBox->intPASV)
			{
				intDataSocket = AcceptDataConnection(intListenSocket);
			}

			if (intDataSocket != INVALID_SOCKET)
			{
				sprintf(strServerReply,"%s", strTransferGetFile(intDataSocket, strEditFileName.c_str()));
				subShowServerCommand (strServerReply);
				intServerReplyCode = atoi(Left(strServerReply, 3));
				subShowServerReplyCode (intServerReplyCode);

				intWinsockReply = close(intDataSocket);

				//listenソケットのクローズ
				intWinsockReply = close(intListenSocket);
				ReadFTPServerReply(glbintControlSocket);
			}
			else
			{
				intServerReplyCode = 999;
				subShowServerReplyCode (intServerReplyCode);
				subGetServerReplyText();
				subShowServerCommand ("データソケットが無効");
			}
			
		}
		else
		{
			sprintf(ImmediateMsg,"UNEXPECTED Reply Code %d", intServerReplyCode);
			subShowServerCommand(ImmediateMsg);
		}
	}
	else
	{
		intServerReplyCode = 999;
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
		subShowServerCommand ("リスナーソケットが無効");
	}
}

u_int frmSockFTP::intDoNOOPCommand(void)
{
	char strCommand[256];
	u_int intServerReplyCode;

	memset(strCommand,'\0',256);
	sprintf(strCommand,"%s\r\n","NOOP");
	subShowServerCommand (strCommand);
	intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
	subShowServerReplyCode (intServerReplyCode);
	subGetServerReplyText();

	if(intServerReplyCode != 200)
		subShowServerCommand ("EXPECTED Reply Code 200");
	
	return(intServerReplyCode);
}

u_int frmSockFTP::intDoPASVCommand(void)
{
	char strCommand[256];
	u_int intServerReplyCode;

	memset(strCommand,'\0',256);
	sprintf(strCommand,"%s\r\n","PASV");
	subShowServerCommand (strCommand);
	intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
	subShowServerReplyCode (intServerReplyCode);
	subGetServerReplyText();

	if(intServerReplyCode != 227)
		subShowServerCommand ("EXPECTED Reply Code 227");
	
	return(intServerReplyCode);
}

u_int frmSockFTP::intDoUSERCommand(void)
{
	char strCommand[256];
	u_int intServerReplyCode;

	memset(strCommand,'\0',256);
	sprintf(strCommand,"%s%s\r\n","USER ",txtUserID);
	subShowServerCommand (strCommand);
	intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
	subShowServerReplyCode (intServerReplyCode);
	subGetServerReplyText();

	if(intServerReplyCode != 331)
		subShowServerCommand ("EXPECTED Reply Code 331");
	
	return(intServerReplyCode);
}

char *frmSockFTP::strDoCDUPCommand(void)
{
	char strCommand[256];
	u_int intServerReplyCode;

	sprintf(strCommand,"%s\r\n","CDUP");
	subShowServerCommand (strCommand);
	intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
	subShowServerReplyCode (intServerReplyCode);
	subGetServerReplyText();
}

char *frmSockFTP::strDoXCUPCommand(void)
{
	char strCommand[256];
	u_int intServerReplyCode;

	sprintf(strCommand,"%s\r\n","XCUP ");
	subShowServerCommand (strCommand);
	intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
	subShowServerReplyCode (intServerReplyCode);
	subGetServerReplyText();
	
	return(strDoPWDCommand());
}

char *frmSockFTP::strDoSITECommand(const std::string siteCommand,const std::string strMode, const std::string strFileName)
{
	char strCommand[256];
	u_int intServerReplyCode;

	sprintf(strCommand,"%s%s %s ./%s\r\n", "SITE ",siteCommand.c_str(),strMode.c_str(),strFileName.c_str());
	subShowServerCommand (strCommand);
	intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
	subShowServerReplyCode (intServerReplyCode);
	subGetServerReplyText();

	if(intServerReplyCode != 200)
		subShowServerCommand ("EXPECTED Reply Code 200");

	return(strDoPWDCommand());
}

char *frmSockFTP::strDoCWDCommand(const std::string strDirectory)
{
	char strCommand[256];
	u_int intServerReplyCode;

	sprintf(strCommand,"%s%s\r\n", "CWD ",strDirectory.c_str());
	subShowServerCommand (strCommand);
	intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
	subShowServerReplyCode (intServerReplyCode);
	subGetServerReplyText();
	
	return(strDoPWDCommand());
}

char *frmSockFTP::strDoPWDCommand(void)
{
	char strCommand[256];
	char strDirectory[256];
	u_int intServerReplyCode;
	char *sd;

	sprintf(strCommand,"%s\r\n", "PWD");
	subShowServerCommand (strCommand);
	intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
	subShowServerReplyCode (intServerReplyCode);
	subGetServerReplyText();

	if (intServerReplyCode == 250 || intServerReplyCode == 226)
		return((char *)NULL);
	if (intServerReplyCode == 257)
	{
		sprintf(strDirectory,"%s", strGetServerReplyText());
		sprintf(txtWorkingDir,"%s",strExtractQuotedExpression(strDirectory));
		sprintf(cdHostPath,"%s", strCutCr(txtWorkingDir));
		sd = strDirectory;
		return(sd);
	}
	else
	{
		sprintf(cdHostPath,"%s", "nul");
		return((char *)NULL);
	}
}

char *frmSockFTP::strDoSYSTCommand(void)
{
	char strCommand[256];
	static char strSystemType[256];
	u_int intServerReplyCode;
	char s2[256];

	sprintf(strCommand,"%s\r\n","SYST");
	subShowServerCommand (strCommand);
	intServerReplyCode = SendFTPCommand(glbintControlSocket, strCommand);
	subShowServerReplyCode (intServerReplyCode);
	subGetServerReplyText();
	
	if (intServerReplyCode == 215)
	{
		sprintf(strSystemType,"%s", strGetServerReplyText());
		sprintf(strSystemType,"%s", strCutCrLf(strSystemType));
		//test
		sprintf(strCommand,"%s%s\r\n", "TYPE ","I");
		subShowServerCommand (strCommand);
		intServerReplyCode = SendFTPCommand(glbintControlSocket,strCommand);
		subShowServerReplyCode (intServerReplyCode);
		subGetServerReplyText();
		return(strSystemType);
	}
	else
	{
		return((char *)NULL);
	}
}

char *frmSockFTP::strExtractQuotedExpression(char *strValue)
{
	int int1stQuoteLocation;
	int int2ndQuoteLocation;
	char *strQuotedValue;

char readbuff[256];

	strQuotedValue = strValue;
	
	int1stQuoteLocation = InStr(0, strValue, '"');
	
	if (int1stQuoteLocation < 1024)
	{
		int2ndQuoteLocation = InStr(int1stQuoteLocation + 1, strValue, '"');
		if (int2ndQuoteLocation > 0)
			strQuotedValue = Mid(strValue, int1stQuoteLocation + 2, int2ndQuoteLocation - 1);
	}
	return(strQuotedValue);
}

char *frmSockFTP::strGetServerReply(void)
{
	char lpReplyTextAddress[2048];
	static char strReply[2048];

	sprintf(lpReplyTextAddress,"%s", GetFTPServerReplyText());

	memset(strReply,'\0',2048);
	strcpy(strReply, lpReplyTextAddress);

	return(strReply);
}

char *frmSockFTP::strGetServerReplyText(void)
{
	static char strReplyText[2048];
	
	memset(strReplyText,'\0',sizeof(strReplyText));
	sprintf(strReplyText,"%s",strGetServerReply());
	return(Right(strReplyText, (size_t)strlen(strReplyText) - 4));

}

void frmSockFTP::subGetServerReplyText(void)
{
	static char strReplyText[2048];
	
	memset(strReplyText,'\0',sizeof(strReplyText));
	sprintf(strReplyText,"%s",strGetServerReply());
	if(ImmLog->AddItemTail(strReplyText) == FALSE)
	{
		ImmLog->Clear();
		ImmLog->Immediatebox(0);
		return;
	}
	ImmLog->Immediatebox(0);

}

char *frmSockFTP::strTransferGetFile(int hDataSocket, const std::string strFileName)
{
	int hFile;				// ローカルファイル用ハンドル
	int intBytes;			// データチャネル用バイトカウント
	long lngTotalBytes;		// データチャネル用トータルバイトカウント
	long lngPointerAddress;
	static char strServerReply[2048];
	static char ret[256];

	hFile = CreateTransferFile(strFileName);

	if (hFile != HFILE_ERROR)
	{
		lngTotalBytes = 0;
		do {
			// データチャネルより受信しバイトをカウントする
			intBytes = TransferFile(glbintControlSocket, hDataSocket, hFile);
			lngTotalBytes = lngTotalBytes + intBytes;
			sprintf(ret,"%ld bytes receiv.",lngTotalBytes );
		 	dialogmsg(1,0,ret);
		} while(intBytes > 0);
		close(hFile);
		return(strServerReply);
	}
	else
	{
		close(hFile);
		MsgBox ("Unable to create CreateTransferFile()");
		return(ret);
	}
}

char *frmSockFTP::strTransferPutFile(int hControlSocket, int hDataSocket, const std::string strFileName)
{

	int hFile;
	int intBytes;
	long int lngTotalBytes;
	int lngPointerAddress;
	static char strServerReply[256];
	static char ret[256];

	hFile = CreateTransferFile2(strFileName);

	if (hFile != HFILE_ERROR)
	{

		lngTotalBytes = 0;

		do {
		//ファイル送信用関数TransferFile3()に制御を渡す
		intBytes = TransferFile3(hControlSocket, hDataSocket, hFile);
		lngTotalBytes = lngTotalBytes + intBytes;
        sprintf(ret,"%ld bytes send.",lngTotalBytes );
        dialogmsg(1,0,ret);

		} while(intBytes > 0);

		close(hFile);
		
		return(strServerReply);
	}
	else
	{
		close(hFile);
		MsgBox ("Unable to create of send file.");
		return(ret);
	}
}

void frmSockFTP::subCloseIncompleteConnection(void)
{
	u_int intWinsockReplyCode;

	intWinsockReplyCode = close(glbintControlSocket);
	
	subShowServerCommand ("Socket closed--incomplete connection!");
}

char *frmSockFTP::strCutCr(char *strCommand)
{
	char *nl;
	static char strText[256];

	memset(strText,'\0',256);
	sprintf(strText,"%s",strCommand);
	if((nl = (char *)strchr(strText,'\r')) != (char *)NULL)
	{
		*nl = '\0';
		return(strText);
	}
	else
	{
		return(strText);
	}
}

char *frmSockFTP::strCutLf(char *strCommand)
{
	char *nl;
	static char strText[256];

	memset(strText,'\0',256);
	sprintf(strText,"%s",strCommand);
	if((nl = (char *)strchr(strText,'\n')) != (char *)NULL)
	{
		*nl = '\0';
		return(strText);
	}
	else
	{
		return(strText);
	}
}

char *frmSockFTP::strCutCrLf(char *strCommand)
{
	char *nl;
	static char strText[256];

	memset(strText,'\0',256);
	sprintf(strText,"%s",strCommand);
	if((nl = (char *)strchr(strText,'\n')) != (char *)NULL)
	{
		*nl = '\0';
		return(strText);
	}
	else
	{
		return(strText);
	}
}

void frmSockFTP::subShowServerCommand(const std::string Message)
{
	char strListBox[256];
	char strCommand[1024];

	sprintf(strCommand,"%s",Message.c_str());
	
	memset(strListBox,'\0',256);
	sprintf(strListBox,"%s",strCutCrLf(strCommand));

	if(ImmLog->AddItemTail(strListBox) == FALSE)
	{
		ImmLog->Clear();
		ImmLog->Immediatebox(0);
		return;
	}
	ImmLog->Immediatebox(0);
}

void frmSockFTP::subShowServerReplyCode(int intReplyCode)
{
	char strListBox[256];
	
	sprintf(strListBox,"%d",intReplyCode);
}

