#pragma ident "@(#) wsubform.h 3.0.5 2010.04.01,12:31"
#ifndef _WSUBFORM_H 
#define _WSUBFORM_H _WSUBFORM_H

#include <stdio.h>
#include <stdlib.h>
#ifdef CYGWIN
#include <ncurses/curses.h>
#else
#include <curses.h>
#endif
#include <string.h>
#include <math.h>
#include <sys/stat.h>

#define RIGHT		"RIGHT"		//ͤʸ()
#define LEFT		"LEFT"		//ͤʸ
#define CENTER		"CENTER"	//ʸ

#define FLD_TEXT		"TEXT"		//եɥ=text,char,varchar
#define FLD_NUMERIC		"NUMERIC"	//եɥ=integer,decimal,number
#define FLD_BOOL		"BOOL"		//̤(not use)
#define FLD_CURRENCY	"CURRENCY"	//եɥ=money(999,999,999,999,999)
#define FLD_DATE		"DATE"		//եɥ=(YYYY/MM/DD)
#define FLD_SINGLE		"SINGLE"	//̤(not use)
#define FLD_DOUBLE		"DOUBLE"	//̤(not use)
#define FLD_BYTE		"BYTE"		//̤(not use)
#define TEXT			1
#define NUMERIC			2
#define BOOL			3
#define CURRENCY		4
#define DATE			5
#define SINGLE			6
#define DOUBLE			7
#define BYTE			8

#define	ACT_EDIT	"EDIT"	//Խǽ
#define	ACT_NONE	"NONE"	//ԽԲ

#define	SKIP		"SKIP"	//Υˤãʤ
#define	STEP		"STEP"	//Υˤã

#define MAX_COL		1024		//å⥻κ
#define MAX_ROW		68		//å⥻κԿ
#define MAX_LEN		178		//å⥻κ
#define MAX_POS		1024		//κ
#define MAX_DEF		4096	//Ѳǽʺ
#define MAX_TMP		1024	//Ѳǽʺʸ
#define MAX_STR		1024	//Ѳǽʺʸ
#define MAX_DB_LINE	10000	//DBɤ߼Կ

#define MAX_FORM	10		//Ʊɽǽʥ֥եο
#define MAX_PANEL	18		//ĤΥ֥եֲǽʥѥͥκԿ

/*for textbox*/
typedef struct textbox
{
	struct textbox *next;		//ƥȥܥåϢݥ󥿡ؤ
	struct textbox *prev;		//PƥȥܥåϢݥ󥿡ؤ
	char *s;					//
	unsigned long n;			//
	int no;						//ƥȥܥåֹ
	int x;						//ƥȥܥåΰX
	int y;						//ƥȥܥåΰY
	int c;						//ƥȥܥåΥݥֹ
	int col;					//ƥȥܥåΥֹ
	int len;					//ƥȥܥåĹ
	int attr;					//
	int ftype;					//ƥȥܥåΥեɥ
	int action;					//ƥȥܥåΥ(EDIT or NONE)
	int align;					//ƥȥܥåΥ饤(RIGHT or LEFT or CENTER)
	int stype;					//ƥȥܥåΥåפȥƥå(SKIP or STEP)
} TextBox;

/*for grid*/
struct cell {
	int no;						//åɥֹ
	int x;						//åɥΰX
	int y;						//åɥΰY
	int c;						//åɥа(1-384)
	int len;					//Ĺ
	int attr;					//Now not use
	int ftype;					//Υեɥ
	int action;					//Υ(EDIT or NONE
	int align;					//Υ饤(RIGHT or LEFT or CENTER)
	int stype;					//Υåץƥå(SKIP or STEP)
	char s[MAX_STR];			//̤
	WINDOW * cell;
};

/*for panel*/
struct PanelBox {
	WINDOW *panel;	//ѥͥեؤΥݥ
	int sx;			//ѥͥեγϰX
	int ex;			//ѥͥեνüX
	int sy;			//ѥͥեγϰY
	int ey;			//ѥͥեνüY
	int width;		//ѥͥե
	int height;		//ѥͥեι⤵
};

struct SubForm {
	WINDOW *vs;		//֥եؤΥݥ
	int col;		//save column
	int line;		//save line
	int no;			//Textbox number
	int n;			//Textbox number
	int x;			//x col
	int y;			//y line
	int c;			//Cell position of numeric
	int len;		//Cell length
	int ftype;		//Filed type
	int action;		//Cell action
	int align;		//Cell aligment
	int stype;		//Cell skip or step.
};

struct VewBox {
	WINDOW *form;	/*Form WINDOW*/
	int panel_num;				//ѥֹͥ save number
	int maxlabel;				//٥κ
	int alltext;				//ѥͥΥƥֹ
	int maxtext;				//ƥȥκ
	int t_col;					//ƥȥΥֹ
	int t_line;					//ƥȥιֹ
	int t_n;					//ƥȥֹ
	int t_len;					//ƥȥĹ
	int t_c;					//ƥȥΥݥ
	int t_x;					//ƥȥξX
	int t_y;					//ƥȥξY
	int t_ftype;				//ƥȥΥեɥ(TEXT or NUMERIC or DATE or CURRNCY)
	int t_action;				//ƥȥΥ(EDIT or NONE)
	int t_align;				//ƥȥ饤(LEFT or RIGHT or CENTER)
	int t_stype;				//ƥȥΥåפȥƥå(SKIP or STEP)
	int g_col;					//åɥΥֹ
	int g_line;					//åɥιֹ
	int g_no;					//åɥֹ
	int g_len;					//åɥΤĹ
	int g_c;					//åɥΥݥֹ
	int g_x;					//åɥξX
	int g_y;					//åɥξY
	int g_ftype;				//åɥΥեɥ
	int g_action;				//åɥΤΥ
	int g_align;				//åɥΥ饤
	int g_stype;				//åɥΥåפȥƥå
	int g_dbindex;				//ģ¥åɥΥǥåݥ*splitDBbuff[index][]Τֹ
	int dbstartline;			//ģ󤫤饰åɤɽǽΥ饤splitDBbuff[index][]Τΰ־
	int dbstartcol;				//ģ󤫤饰åɤɽǽsplitDBbuff[index][]Τΰ־
} xt[MAX_FORM];

/*for form*/
struct FormBox {
//	WINDOW *form;
	int sx;						//ե०ɥγϰX
	int ex;						//ե०ɥνüX
	int sy;						//ե०ɥγϰY
	int ey;						//ե०ɥνüY
	int lcol;					//ե०ɥκǸΥ
	int width;					//not use
	int height;					//not use
	int attr;					//not use
	struct SubForm pos[MAX_COL];			//ƥȥܥåΥݥ
	struct SubForm st[MAX_COL][MAX_ROW];	//å⥻Υݥ
	struct PanelBox pt[MAX_PANEL];			//ѥͥΥݥ
	struct cell cp[MAX_COL][MAX_ROW];		//å⥻°ݻ롣
	char *splitDBbuff[MAX_DB_LINE][MAX_COL];//DBgrid()ѡDBιܤ˴ݥassget()Ѥ롣
} ft[MAX_FORM];

	char *splitDBbuff[MAX_COL];//textbox()ѡDBιܤݥUPDATE INSERTѤΰŪassset()Ѥ롣

static char panelprpty[][MAX_DEF] = {
	"PANEL_COLS=",				//Panel window width
	"PANEL_ROWS=",				//Panel window height
	"PANEL_SX=",				//Start of x line for panel window
	"PANEL_SY=",				//Start of y line for panel window
	"PANEL_DIFF=",				//One panel from next panel differnce y line
	"PANEL_NUM=",				//Panels of number
	"",
	"",
	"",
	"" };

/*for grid*/
static char gridprpty[][MAX_DEF] = {
	"COLS=",					//From window width
	"ROWS=",					//From window heigit
	"GRID_SX=",					//Start of x line for grid area
	"GRID_SY=",					//Start of y line for grid area
	"GRID_EX=",					//End of x line for grid area
	"GRID_EY=",					//End of y line for grid area
	"CELL_LENGTH=",				//Cell length
	"CELL_ALIGN=",				//Cell aligment
	"CELL_ACTION=",				//Cell action
	"GRID_TITLES=",				//Cell titles
	"GRID_FIELD_TYPE=",			//Cell field type
	"GRID_SKIP_STEP=",			//Cell skip or step
	"" };

/*for textbox*/
static char textboxprpty[][MAX_DEF] = {
	"COLS=",					//Form window width
	"ROWS=",					//Form window height
	"LABEL_X=",					//Start of x line for label
	"LABEL_Y=",					//Start of x line for label
	"LABEL_LENGTH=",			//Label length
	"LABEL_TEXT=",				//Label text
	"TEXTBOX_NO=",				//Textbox cell number(1 - end)
	"TEXTBOX_X=",				//Textbox x line
	"TEXTBOX_Y=",				//Textbox y line
	"TEXTBOX_LENGTH=",			//Text length
	"TEXTBOX_ALIGN=",			//Textbox alignment
	"TEXTBOX_ACTION=",			//Textbox cell action (edit or none)
	"TEXTBOX_FIELD_TYPE=",		//Cell field type(1 - 9)
	"TEXTBOX_SKIP_STEP=",		//Cell skip or step
	"" };

/*ؿ*/
extern char *addspace(int len, char *s);
extern int compare(int c, char *p,char *s);
extern char *cutspace(char *s);
extern char *cutspace_right(char *s);
extern int dialogmsg(int x,int y,char *buff);
extern int ifspace(int len,char *s);
extern int popmsg(int x,int y,char *buff);
extern int errmsg(int x,int y,char *buff);
extern char *sccep(char *buff);
extern char *slcep(char *buff);
extern char *srcep(char *buff);
extern char *varprint(char *buff);
extern char *vs_ieee_c(WINDOW *vs,int x,int y,char *p,int N);
extern int jmvwgetnstr(WINDOW *win, int y, int x, unsigned char *str, int n, int wmode, int cmode);

/*֥եॢؿ*/
extern int sf_wsubform(int no, int xcol,int rows,int fx ,int fy, char *f);
extern int sf_grid(int no,int maxtext,int xcol);
extern int sf_textbox(int no, int fx, int fy, char *f);
extern int sf_formtext(int no,int maxtext, int xcol);
extern int sf_paneltext(int no, int maxpaneltext, int xcol);
extern int sf_panels(int no, int xcol,int rows,int fx, int fy, char *f);
extern int sf_status(int no, int type, char opt);
extern int sf_tlocate(int no, int col);
extern int sf_glocate(int no, int col, char line);
extern void sf_tbegin(void);
extern int sf_tprev(void);
extern int sf_tnext(void);
extern int sf_tput(int no, int col, char *s);
extern int sf_gput(int no, int col, int line, char *s);
extern int sf_tget(int no, int col,char *s);
extern int sf_gget(int no, int col, int line,char *s);
extern int sf_tcep(int no, int col, int align, char *s);
extern int sf_gcep(int no, int col, int line, int align, char *s);
extern int sf_tvarprint(int no, int col, char *s);
extern int sf_gvarprint(int no, int col, int line, char *s);
extern void sf_initgridcell(int no);
extern int sf_getstartline(int no);
extern void sf_wrefreshcell(int no,int line,int col);
extern void sf_wrefreshform(int no);
extern void sf_startcell(int no);
extern void sf_to_text(int in,char *out);
extern long sf_to_numeric(char *in);
extern int sf_to_integer(char *in);
extern int sf_to_double(char *in);
extern int sf_textboxfree(int maxtext);
extern void sf_freeDB(int no, int DBcount, int maxcol);
extern int sf_DBgrid(int no,int maxtext,int xcol,int startline,int DBcount,int maxcol);
extern int sf_ggetDB(int no, int line, int col, int startline,char *s);
extern int sf_gputDB(int no, int line, int col, int startline,char *s);
extern int sf_tgetDB(int no, int col, char *s);
extern int sf_tputDB(int no, int col, char *s);
extern int sf_tgetDBall(int no);
extern void sf_assgetDB(int no,int line,int col, char *buff, int size);
extern void sf_assputDB(int no,int col, char *buff, int size);

extern int MakeTextBox(int no,int fx,int fy,int xcol,int xrow,int *label_no,char **label_text,int *label_x,int *label_y,int *label_length,int *textbox_no,int *textbox_x,int *textbox_y,int *textbox_length,int *textbox_align,int *textbox_action,int *textbox_field,int *textbox_skipstep, int m);

extern int MakeWsubForm(int no, int xcol,int rows,int fx ,int fy,int grid_sx,int grid_sy,int grid_ex,int grid_ey,int *cell_length,int *cell_align,int *cell_action,int *grid_field,int *grid_skipstep,char **grId_titles,int m);

#endif
