/***************************************************************************
 *            cxp-handler.h
 *
 *  Mon Nov 29 23:38:45 2004
 *  Copyright  2004  Yasumichi Akahoshi
 *  yasumichi@users.sourceforge.jp
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _CXP_HANDLER_H
#define _CXP_HANDLER_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <glib.h>
#include <glib-object.h>

#define CXP_TYPE_HANDLER				(cxp_handler_get_type ())
#define CXP_HANDLER(obj)				(G_TYPE_CHECK_INSTANCE_CAST ((obj), CXP_TYPE_HANDLER, CxpHandler))
#define CXP_HANDLER_CLASS(vtable)		(G_TYPE_CHECK_CLASS_CAST ((vtable), CXP_TYPE_HANDLER, CxpHandlerClass))
#define CXP_IS_HANDLER(obj)				(G_TYPE_CHECK_INSTANCE_TYPE ((obj), CXP_TYPE_HANDLER))
#define CXP_IS_HANDLER_CLASS(vtable)	(G_TYPE_CHECK_CLASS_TYPE ((vtable), CXP_TYPE_HANDLER))
#define CXP_HANDLER_GET_CLASS(inst)		(G_TYPE_INSTANCE_GET_INTERFACE ((inst), CXP_TYPE_HANDLER, CxpHandlerClass))

/*
 * Type macros.
 */

	typedef struct _CxpHandler CxpHandler;
	typedef struct _CxpHandlerClass CxpHandlerClass;
	typedef struct _CxpHandlerPrivate CxpHandlerPrivate;

	struct _CxpHandler
	{
		GObject parent;
		/* private */
		CxpHandlerPrivate *priv;
	};

	struct _CxpHandlerClass
	{
		GObjectClass parent;
		/* class members */
	};

/* used by CXP_TYPE_HANDLER */
	GType cxp_handler_get_type (void);

/*
 * Method definitions.
 */
	CxpHandler *cxp_handler_new (void);
	void cxp_handler_launch (CxpHandler *handler, const gchar *fullpath);
#ifdef __cplusplus
}
#endif

#endif				/* _CXP_HANDLER_H */
