/* $Id: cxp-about-dialog.c,v 1.6 2005/04/18 13:51:47 yasumichi Exp $ */
/**
 * \if japanese
 * @file
 * @brief ץꥱξɽ
 *
 * @author 
 * @date Sat Apr 9 2005
 * $Revision: 1.6 $
 * \endif
 * \if english
 * @file
 * @brief Dialog that displays information on application
 *
 * @author Yasumichi Akahoshi
 * @date Sat Apr 9 2005
 * $Revision: 1.6 $
 * \endif
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 

#include "cxp-about-dialog.h"

/*
 * CxpAboutDialogȴϢŤץ饤١Ȥʹ¤
 * Private structure related to CxpAboutDialog
 */
typedef struct
{
	gchar *appname;
	gchar *version;
	gchar *url;
	gchar *copyright;
	gchar *image_file;
	gboolean dispose_has_run;
} CxpAboutDialogPrivate;

/**
 * \if japanese
 * CxpAboutDialogΥ󥹥o˴ϢŤ줿ץ饤١Ȥʹ¤Τ뤿ޥǤ
 * \endif
 * \if english
 * It is an internal macro to obtain the private structure related to instance
 * o of the CxpAboutDialog type. 
 * \endif
 */
#define CXP_ABOUT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CXP_TYPE_ABOUT_DIALOG, CxpAboutDialogPrivate))

static GObjectClass *parent_class = NULL;

enum
{
	CXP_ABOUT_DIALOG_APPNAME = 1,
	CXP_ABOUT_DIALOG_VERSION,
	CXP_ABOUT_DIALOG_URL,
	CXP_ABOUT_DIALOG_COPYRIGHT,
	CXP_ABOUT_DIALOG_IMAGE_FILE,
};

static void cxp_about_dialog_class_init (gpointer g_class,
					    gpointer g_class_data);
static void cxp_about_dialog_init (CxpAboutDialog *dialog);
static GObject * cxp_about_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam *construct_properties);
static void cxp_about_dialog_construct_child (CxpAboutDialog *self);
static void cxp_about_dialog_dispose (GObject * obj);
static void cxp_about_dialog_finalize (GObject * obj);
static void cxp_about_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void cxp_about_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);

static void cxp_about_dialog_class_init (gpointer g_class,
					    gpointer g_class_data)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (g_class);
	CxpAboutDialogClass *dialog_class = CXP_ABOUT_DIALOG_CLASS(g_class);
	GParamSpec *pspec;

	parent_class = g_type_class_peek_parent (g_class);

	gobject_class->constructor = cxp_about_dialog_constructor;
	gobject_class->dispose = cxp_about_dialog_dispose;
	gobject_class->finalize = cxp_about_dialog_finalize;
	gobject_class->set_property = cxp_about_dialog_set_property;
	gobject_class->get_property = cxp_about_dialog_get_property;

	/* install properties. */
	pspec = g_param_spec_string ("appname",
				     "Application name",
				     "Set application name",
				     NULL,
				     G_PARAM_CONSTRUCT_ONLY | G_PARAM_READWRITE);
	g_object_class_install_property (gobject_class,
					 CXP_ABOUT_DIALOG_APPNAME, pspec);

	pspec = g_param_spec_string ("version",
				     "application version",
				     "Set application version",
				     NULL,
				     G_PARAM_CONSTRUCT_ONLY | G_PARAM_READWRITE);
	g_object_class_install_property (gobject_class,
					 CXP_ABOUT_DIALOG_VERSION, pspec);

	pspec = g_param_spec_string ("url",
				     "url of project page",
				     "Set url of project page",
				     NULL,
				     G_PARAM_CONSTRUCT_ONLY | G_PARAM_READWRITE);
	g_object_class_install_property (gobject_class,
					 CXP_ABOUT_DIALOG_URL, pspec);

	pspec = g_param_spec_string ("copyright",
				     "copyleft",
				     "Set copyright",
				     NULL,
				     G_PARAM_CONSTRUCT_ONLY | G_PARAM_READWRITE);
	g_object_class_install_property (gobject_class,
					 CXP_ABOUT_DIALOG_COPYRIGHT, pspec);

	pspec = g_param_spec_string ("image_file",
				     "fullpath of image file",
				     "Set fullpath of image file",
				     NULL,
				     G_PARAM_CONSTRUCT_ONLY | G_PARAM_READWRITE);
	g_object_class_install_property (gobject_class,
					 CXP_ABOUT_DIALOG_IMAGE_FILE, pspec);

	g_type_class_add_private (dialog_class, sizeof (CxpAboutDialogPrivate));
}

static void cxp_about_dialog_init (CxpAboutDialog *dialog)
{
	CxpAboutDialogPrivate *private = CXP_ABOUT_DIALOG_GET_PRIVATE(dialog);

	private->appname = NULL;
	private->version = NULL;
	private->url = NULL;
	private->copyright = NULL;
	private->image_file = NULL;
	private->dispose_has_run = FALSE;
}

static GObject * cxp_about_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam *construct_properties)
{
	GObject *obj;
	CxpAboutDialogClass *klass;

	klass = CXP_ABOUT_DIALOG_CLASS (g_type_class_peek (CXP_TYPE_ABOUT_DIALOG));
	obj = parent_class->constructor (type,
			n_construct_properties,
			construct_properties);

	cxp_about_dialog_construct_child (CXP_ABOUT_DIALOG(obj));

	return obj;
}

static void cxp_about_dialog_construct_child (CxpAboutDialog *self)
{
	CxpAboutDialogPrivate *private = CXP_ABOUT_DIALOG_GET_PRIVATE(self);
	GtkWidget *vbox = GTK_DIALOG(self)->vbox;
	GtkWidget *image;
	GtkWidget *version_label;
	GtkWidget *url_label;
	GtkWidget *copyright_label;
	GtkWidget *close_button;
	gchar *version_text;

	gtk_window_set_destroy_with_parent(GTK_WINDOW(self), TRUE);
	gtk_dialog_set_default_response (GTK_DIALOG (self), GTK_RESPONSE_CLOSE);
	gtk_window_set_title (GTK_WINDOW(self), private->appname);

	if (private->image_file != NULL)
	{
		if (g_file_test (private->image_file, G_FILE_TEST_EXISTS))
		{
			image = gtk_image_new_from_file (private->image_file);
			gtk_box_pack_start (GTK_BOX(vbox), image, TRUE, TRUE, 0);
			gtk_widget_show (image);
		}
		else
		{
			g_warning ("Couldn't find pixmap file: %s", private->image_file);
		}
	}

	if ((private->appname != NULL) && (private->version != NULL))
	{
		version_text = g_strdup_printf ("%s %s", private->appname, private->version);
		version_label = gtk_label_new (version_text);
		gtk_box_pack_start (GTK_BOX(vbox), version_label, TRUE, TRUE, 0);
		gtk_label_set_justify (GTK_LABEL (version_label), GTK_JUSTIFY_LEFT);
		gtk_widget_show (version_label);
		g_free (version_text);
	}

	if (private->url != NULL)
	{
		url_label = gtk_label_new (private->url);
		gtk_box_pack_start (GTK_BOX (vbox), url_label, TRUE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (url_label), GTK_JUSTIFY_LEFT);
		gtk_widget_show (url_label);
	}

	if (private->copyright != NULL)
	{
		copyright_label = gtk_label_new (private->copyright);
		gtk_box_pack_start (GTK_BOX (vbox), copyright_label, TRUE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (copyright_label), GTK_JUSTIFY_LEFT);
		gtk_widget_show (copyright_label);
	}

	close_button = gtk_button_new_from_stock("gtk-close");
	gtk_dialog_add_action_widget (GTK_DIALOG (self), close_button, GTK_RESPONSE_CLOSE);
	gtk_widget_show (close_button);
}

static void cxp_about_dialog_dispose (GObject * obj)
{
	CxpAboutDialogPrivate *private = CXP_ABOUT_DIALOG_GET_PRIVATE(obj);

	if (private->dispose_has_run)
	{
		/* If dispose did already run, return. */
		return;
	}
	/* Make sure dispose does not run twice. */
	private->dispose_has_run = TRUE;

	/* 
	 * In dispose, you are supposed to free all types referenced from this
	 * object which might themselves hold a reference to self. Generally,
	 * the most simple solution is to unref all members on which you own a 
	 * reference.
	 */

	/* Chain up to the parent class */
	G_OBJECT_CLASS (parent_class)->dispose (obj);
}

static void cxp_about_dialog_finalize (GObject * obj)
{
	CxpAboutDialogPrivate *private = CXP_ABOUT_DIALOG_GET_PRIVATE(obj);

	g_free (private->appname);
	g_free (private->version);
	g_free (private->url);
	g_free (private->copyright);
	g_free (private->image_file);

	/* Chain up to the parent class */
	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

/**
 * \if japanese
 * CxpAboutDialogΥ֥ȷȥ饹򷿴ƥϿGType롣
 * @return ϿΥˡ (ʣʤ) ̻ҤɽͤǤ
 * \endif
 * \if english
 * The object type and the class of CxpAboutDialog are registered to the type management 
 * system, and the GType type is obtained. 
 * @return A numerical value which represents the unique identifier of a registered type.
 * \endif
 */
GType cxp_about_dialog_get_type (void)
{
	static GType type = 0;

	if (type == 0)
	{
		static const GTypeInfo info = {
			sizeof (CxpAboutDialogClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			cxp_about_dialog_class_init,	/* class_init */
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof (CxpAboutDialog),
			0,	/* n_preallocs */
			//cxp_about_dialog_instance_init	/* instance_init */
			(GInstanceInitFunc) cxp_about_dialog_init	/* instance_init */
		};
		type = g_type_register_static (GTK_TYPE_DIALOG,
					       "CxpAboutDialogType",
					       &info, 0);
	}
	return type;
}

static void cxp_about_dialog_set_property (GObject * object,
					 guint property_id,
					 const GValue * value,
					 GParamSpec * pspec)
{
	CxpAboutDialogPrivate *priv = CXP_ABOUT_DIALOG_GET_PRIVATE(object);

	switch (property_id)
	{
	case CXP_ABOUT_DIALOG_APPNAME:
		g_free (priv->appname);
		priv->appname = g_value_dup_string (value);
		break;
	case CXP_ABOUT_DIALOG_VERSION:
		g_free (priv->version);
		priv->version = g_value_dup_string (value);
		break;
	case CXP_ABOUT_DIALOG_URL:
		g_free (priv->url);
		priv->url = g_value_dup_string (value);
		break;
	case CXP_ABOUT_DIALOG_COPYRIGHT:
		g_free (priv->copyright);
		priv->copyright = g_value_dup_string (value);
		break;
	case CXP_ABOUT_DIALOG_IMAGE_FILE:
		g_free (priv->image_file);
		priv->image_file = g_value_dup_string (value);
		break;
	default:
		/* We don't have any other property... */
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void cxp_about_dialog_get_property (GObject * object,
					 guint property_id,
					 GValue * value, GParamSpec * pspec)
{
	CxpAboutDialogPrivate *priv = CXP_ABOUT_DIALOG_GET_PRIVATE(object);

	switch (property_id)
	{
	case CXP_ABOUT_DIALOG_APPNAME:
		g_value_set_string (value, priv->appname);
		break;
	case CXP_ABOUT_DIALOG_VERSION:
		g_value_set_string (value, priv->version);
		break;
	case CXP_ABOUT_DIALOG_URL:
		g_value_set_string (value, priv->url);
		break;
	case CXP_ABOUT_DIALOG_COPYRIGHT:
		g_value_set_string (value, priv->copyright);
		break;
	case CXP_ABOUT_DIALOG_IMAGE_FILE:
		g_value_set_string (value, priv->image_file);
		break;
	default:
		/* We don't have any other property... */
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

/**
 * \if japanese
 * ץꥱξɽޤϡGtkDialog
 * ƱͤƤ
 *
 * @param [in] appname		ץꥱ̾
 * @param [in] version		ץꥱΥС
 * @param [in] url		ץꥱθ
 * @param [in] copyright	ɽ
 * @param [in] image_file	եХѥ
 * \endif
 * \if english
 * Creates a new about dialog.Please operate it as well as GtkDialog after it
 * makes it.
 *
 * @param [in] appname		Application name
 * @param [in] version		Version of application
 * @param [in] url		Official site of application
 * @param [in] copyright	Copyright display
 * @param [in] image_file	Absolute path of picture file
 * \endif
 */
GtkWidget *cxp_about_dialog_new(const gchar *appname, const gchar *version, const gchar *url, const gchar *copyright, const gchar *image_file)
{
	return	GTK_WIDGET(g_object_new(CXP_TYPE_ABOUT_DIALOG, "appname", appname, "version", version, "url", url, "copyright", copyright, "image_file", image_file, NULL)); 
}

