/* $Id: cxp-about-dialog.h,v 1.4 2005/04/17 18:03:18 yasumichi Exp $ */
/**
 * \if japanese
 * @file
 * @brief ץꥱξɽ
 *
 * @author 
 * @date Sat Apr 9 2005
 * $Revision: 1.4 $
 * \endif
 * \if english
 * @file
 * @brief Dialog that displays information on application
 *
 * @author Yasumichi Akahoshi
 * @date Sat Apr 9 2005
 * $Revision: 1.4 $
 * \endif
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 

#ifndef CXP_ABOUT_DIALOG_H
#define CXP_ABOUT_DIALOG_H

#include <gtk/gtk.h>
#include <glib-object.h>

/**
 * \if japanese
 * @brief CxpAboutDialogΥˡʼ̻Ҥ롣
 *
 * \endif
 * \if english
 * @brief A unique identifier of the CxpAboutDialog type is obtained. 
 *
 * \endif
 */
#define CXP_TYPE_ABOUT_DIALOG		  (cxp_about_dialog_get_type ())

/**
 * \if japanese
 * @brief objCxpAboutDialog˥㥹Ȥ롣
 *
 * \endif
 * \if english
 * @brief It is Cast in the CxpAboutDialog type as for obj. 
 *
 * \endif
 */
#define CXP_ABOUT_DIALOG(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), CXP_TYPE_ABOUT_DIALOG, CxpAboutDialog))

/**
 * \if japanese
 * @brief vtableCxpAboutDialogClass˥㥹Ȥ롣
 *
 * \endif
 * \if english
 * @brief It is Cast in the CxpAboutDialogClass type as for vtable. 
 *
 * \endif
 */
#define CXP_ABOUT_DIALOG_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), CXP_TYPE_ABOUT_DIALOG, CxpAboutDialogClass))

/**
 * \if japanese
 * @brief objCxpAboutDialogǤ뤫ǧ롣
 *
 * \endif
 * \if english
 * @brief Whether obj is CxpAboutDialog type is confirmed. 
 *
 * \endif
 */
#define CXP_IS_ABOUT_DIALOG(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CXP_TYPE_ABOUT_DIALOG))

/**
 * \if japanese
 * @brief vtableCxpAboutDialogClassǤ뤫ǧ롣
 *
 * \endif
 * \if english
 * @brief Whether vtable is CxpAboutDialogClass type is confirmed.
 *
 * \endif
 */
#define CXP_IS_ABOUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CXP_TYPE_ABOUT_DIALOG))

/**
 * \if japanese
 * @brief 󥹥inst顢CxpAboutDialogClass롣
 *
 * \endif
 * \if english
 * @brief The CxpAboutDialogClass type is obtained from instance inst. 
 *
 * \endif
 */
#define CXP_ABOUT_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), CXP_TYPE_ABOUT_DIALOG, CxpAboutDialogClass))

/**
 * \if japanese
 * @brief CxpAboutDialogClassΥ󥹥󥹷
 *
 * \endif
 */
typedef struct
{
	/**
	 * \if japanese
	 *  GtkDialogѾޤ
	 * \endif
	 */
	GtkDialog parent;
} CxpAboutDialog;

/**
 * \if japanese
 * @brief CxpAboutDialogClassΥ饹
 *
 * \endif
 */
typedef struct {
	/**
	 * \if japanese
	 * GtkDialogClassѾޤ
	 * \endif
	 */
	GtkDialogClass parent;
} CxpAboutDialogClass;

/* used by CXP_TYPE_ABOUT_DIALOG */
GType cxp_about_dialog_get_type (void);

/* API. */
GtkWidget *cxp_about_dialog_new(const gchar *appname, const gchar *version, const gchar *url, const gchar *copyright, const gchar *image_file);

#endif /* CXP_ABOUT_DIALOG_H */
