/* $Id: cxp-entry-dialog.c,v 1.8 2005/04/18 13:51:47 yasumichi Exp $ */
/**
 * \if japanese
 * @file
 * @brief 桼ʸϤ
 *
 * @author 
 * @date Sat Feb 12 2005
 * $Revision: 1.8 $
 * \endif
 * \if english
 * @file
 * @brief Dialog to request input of character string from user
 *
 * @author Yasumichi Akahoshi
 * @date Sat Feb 12 2005
 * $Revision: 1.8 $
 * \endif
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 

#include "cxp-entry-dialog.h"

/* If you use Pimpls, include the private structure 
 * definition here. Some people create a cxp-property_dialog-private.h header
 * which is included by the cxp-property_dialog.c file and which contains the
 * definition for this private structure.
 */

typedef struct
{
	GtkWidget *msg_label;
	GtkWidget *entry;
	gboolean dispose_has_run;
} CxpEntryDialogPrivate;

/**
 * \if japanese
 * CxpEntryDialogΥ󥹥o˴ϢŤ줿ץ饤١Ȥʹ¤Τ뤿ޥǤ
 * \endif
 * \if english
 * It is an internal macro to obtain the private structure related to instance
 * o of the CxpEntryDialog type. 
 * \endif
 */
#define CXP_ENTRY_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CXP_TYPE_ENTRY_DIALOG, CxpEntryDialogPrivate))

static GObjectClass *parent_class = NULL;


enum
{
	/**
	 * \if japanese
	 * ץѥƥfilename٤μ̻
	 * \endif
	 * \if english
	 * Identifier of property 'filename'
	 * \endif
	 */
	CXP_ENTRY_DIALOG_FILENAME = 1,
};

static void cxp_entry_dialog_class_init (gpointer g_class,
					    gpointer g_class_data);
static void cxp_entry_dialog_instance_init (GTypeInstance * instance,
					       gpointer g_class);
static void cxp_entry_dialog_dispose (GObject * obj);
static void cxp_entry_dialog_finalize (GObject * obj);
static void cxp_entry_dialog_entry_activate (GtkWidget *widget, gpointer user_data);

static void cxp_entry_dialog_class_init (gpointer g_class,
					    gpointer g_class_data)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (g_class);
	GParamSpec *pspec;

	gobject_class->dispose = cxp_entry_dialog_dispose;
	gobject_class->finalize = cxp_entry_dialog_finalize;

	g_type_class_add_private (g_class, sizeof (CxpEntryDialogPrivate));

	parent_class = g_type_class_peek_parent (g_class);
}

static void cxp_entry_dialog_instance_init (GTypeInstance * instance,
					       gpointer g_class)
{
	CxpEntryDialog *self = CXP_ENTRY_DIALOG (instance);
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
	CxpEntryDialogPrivate *private = CXP_ENTRY_DIALOG_GET_PRIVATE(instance);

	private->dispose_has_run = FALSE;

	gtk_window_set_destroy_with_parent(GTK_WINDOW(self), TRUE);
	gtk_dialog_set_default_response (GTK_DIALOG (self), GTK_RESPONSE_OK);

	private->msg_label = gtk_label_new("Message");
	gtk_misc_set_alignment (GTK_MISC(private->msg_label), 0, 0);
	gtk_label_set_line_wrap (GTK_LABEL(private->msg_label), TRUE);
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(self)->vbox), private->msg_label, TRUE, TRUE, 2);
	gtk_widget_show(private->msg_label);

	private->entry = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(self)->vbox), private->entry, TRUE, TRUE, 2);
	gtk_widget_show(private->entry);

	ok_button = gtk_button_new_from_stock("gtk-ok");
	gtk_dialog_add_action_widget (GTK_DIALOG (self), ok_button, GTK_RESPONSE_OK);
	gtk_widget_show (ok_button);

	cancel_button = gtk_button_new_from_stock("gtk-cancel");
	gtk_dialog_add_action_widget (GTK_DIALOG (self), cancel_button, GTK_RESPONSE_CANCEL);
	gtk_widget_show (cancel_button);

	g_signal_connect (private->entry, "activate",  G_CALLBACK(cxp_entry_dialog_entry_activate), self);
}

static void cxp_entry_dialog_dispose (GObject * obj)
{
	CxpEntryDialogPrivate *private = CXP_ENTRY_DIALOG_GET_PRIVATE(obj);

	if (private->dispose_has_run)
	{
		/* If dispose did already run, return. */
		return;
	}
	/* Make sure dispose does not run twice. */
	private->dispose_has_run = TRUE;

	/* 
	 * In dispose, you are supposed to free all types referenced from this
	 * object which might themselves hold a reference to self. Generally,
	 * the most simple solution is to unref all members on which you own a 
	 * reference.
	 */

	/* Chain up to the parent class */
	G_OBJECT_CLASS (parent_class)->dispose (obj);
}

static void cxp_entry_dialog_finalize (GObject * obj)
{
	/* Chain up to the parent class */
	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

static void cxp_entry_dialog_entry_activate (GtkWidget *widget, gpointer user_data)
{
	gtk_dialog_response (GTK_DIALOG(user_data), GTK_RESPONSE_OK);
}

/**
 * \if japanese
 * CxpEntryDialogΥ֥ȷȥ饹򷿴ƥϿGType롣
 * @return ϿΥˡ (ʣʤ) ̻ҤɽͤǤ
 * \endif
 * \if english
 * The object type and the class of CxpEntryDialog are registered to the type management 
 * system, and the GType type is obtained. 
 * @return A numerical value which represents the unique identifier of a registered type.
 * \endif
 */
GType cxp_entry_dialog_get_type (void)
{
	static GType type = 0;

	if (type == 0)
	{
		static const GTypeInfo info = {
			sizeof (CxpEntryDialogClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			cxp_entry_dialog_class_init,	/* class_init */
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof (CxpEntryDialog),
			0,	/* n_preallocs */
			cxp_entry_dialog_instance_init	/* instance_init */
		};
		type = g_type_register_static (GTK_TYPE_DIALOG,
					       "CxpEntryDialogType",
					       &info, 0);
	}
	return type;
}

/**
 * \if japanese
 * 桼ʸϤ׵᤹ޤϡGtkDialog
 * ƱͤƤ
 *
 * @param [in] title		Υȥ
 * @param [in] message		Ϥ¥å
 * @param [in] entry_text	˥åȤǥեȤʸ
 * \endif
 * \if english
 * The dialog that demands the input of the character string from the user is
 * made. Please operate it as well as GtkDialog after it makes it. 
 *
 * @param [in] title		Title of dialog
 * @param [in] message		Message to press input
 * @param [in] entry_text	Character string of default set in input column
 * \endif
 */
GtkWidget *cxp_entry_dialog_new(const gchar *title, const gchar *message, const gchar *entry_text)
{
	CxpEntryDialog *dialog;
	CxpEntryDialogPrivate *private;

	dialog = g_object_new(CXP_TYPE_ENTRY_DIALOG, NULL);
	private = CXP_ENTRY_DIALOG_GET_PRIVATE(dialog);
	gtk_window_set_title(GTK_WINDOW(dialog), title);
	gtk_label_set_text(GTK_LABEL(private->msg_label), message);
	gtk_entry_set_text(GTK_ENTRY(private->entry), entry_text);

	return	GTK_WIDGET(dialog);
}

/**
 * \if japanese
 * 桼Ϥʸޤ
 *
 * @param [in] dialog ʸ
 * @return 桼Ϥʸɬפʤʤ꼡衢Ƥ
 * \endif
 * \if english
 * The character string that the user input is acquired. 
 *
 * @param [in] dialog Dialog to want to acquire character string
 * @return Character string that user input. Please free it as soon as it
 * becomes unnecessary.
 * \endif
 */
gchar *cxp_entry_dialog_get_entry_text(CxpEntryDialog *dialog)
{
	CxpEntryDialogPrivate *private = CXP_ENTRY_DIALOG_GET_PRIVATE(dialog);

	return	g_strdup(gtk_entry_get_text(GTK_ENTRY(private->entry)));
}

