#!/bin/bash

# based on a2ps-4.13b-31.src.rpm

tar zxf ../i18n-fonts-0.1.tar.gz
patch -p1 < ../a2ps-4.13-conf.patch
patch -p1 < ../a2ps-4.13-etc.patch
patch -p1 < ../a2ps-4.13-flex.patch
patch -p1 < ../a2ps-4.13-security.patch
patch -p1 < ../a2ps-4.13-varargs.patch
bzcat ../a2ps-4.13-eucjp.patch.bz2 | patch -p1
patch -p1 < ../a2ps-4.13-autoenc.patch
patch -p1 < ../a2ps-4.13b-attr.patch
patch -p1 < ../a2ps-4.13b-numeric.patch
patch -p1 < ../a2ps-4.13b-encoding.patch
patch -p1 < ../a2ps-4.13b-tilde.patch
patch -p1 < ../a2ps-4.13b-rm.patch
patch -p1 < ../a2ps-4.13-euckr.patch
patch -p1 < ../a2ps-4.13-bison.patch
patch -p1 < ../a2ps-4.13-cygwin.patch

perl -pi -e "s,/usr/local/bin,/usr/bin," contrib/emacs/a2ps.el
EMACS=emacs ./configure \
  --prefix=/usr \
  --sysconfdir=/etc \
  --infodir=/usr/share/info \
  --mandir=/usr/share/man \
  --datadir=/usr/share \
  --enable-kanji

find . -name "*.info*" -exec rm -f {} \;
find src lib -name '*.l' -exec touch {} \;
(
    cd src
    /bin/sh ../auxdir/ylwrap "flex" sheets-map.l lex.yy.c sheets-map.c --
    /bin/sh ../auxdir/ylwrap "flex" lexssh.l lex.yy.c lexssh.c --
    cd ../lib
    /bin/sh ../auxdir/ylwrap "flex" lexppd.l lex.yy.c lexppd.c --
)
touch man/*.1
make

mkdir /tmp/a2ps
make DESTDIR=/tmp/a2ps install

install -m 0644 i18n-fonts-0.1/afm/*.afm   /tmp/a2ps/usr/share/a2ps/afm/
install -m 0644 i18n-fonts-0.1/fonts/*.pfb /tmp/a2ps/usr/share/a2ps/fonts/
mkdir -p /tmp/usr/share/emacs/site-lisp
install -m644 contrib/emacs/*.el contrib/emacs/*.elc \
   /tmp/a2ps/usr/share/emacs/site-lisp/
rm /tmp/a2ps/usr/share/info/dir
mkdir -p /tmp/a2ps/etc/postinstall
install -m755 CYGWIN-PATCHES/a2ps.sh /tmp/a2ps/etc/postinstall

mkdir -p /tmp/a2ps/usr/share/doc
install -m644 AUTHORS ChangeLog COPYING NEWS README TODO THANKS /tmp/a2ps/usr/share/doc
