/*
 * Copyright (c) 1997, 98, 2000, 01  
 *    Motoyuki Kasahara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/*
 * This program requires the following Autoconf macros:
 *   AC_C_CONST
 *   AC_TYPE_MODE_T
 *   AC_HEADER_STDC
 *   AC_HEADER_STAT
 *   AC_HEADER_DIRENT
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_DIRECT_H
#include <direct.h>
#endif

#ifdef  STAT_MACROS_BROKEN
#ifdef  S_ISREG
#undef  S_ISREG
#endif
#ifdef  S_ISDIR
#undef  S_ISDIR
#endif
#endif  /* STAT_MACROS_BROKEN */

#ifndef S_ISREG
#define S_ISREG(m)   (((m) & S_IFMT) == S_IFREG)
#endif
#ifndef S_ISDIR
#define S_ISDIR(m)   (((m) & S_IFMT) == S_IFDIR)
#endif

/*
 * Make a directory if the directory doesn't exist.
 *
 * If making the directory is succeeded or the directory has already 
 * created, 0 is returned.  Otherwise -1 is returned.
 */
int
make_missing_directory(path, mode)
    const char *path;
    mode_t mode;
{
    struct stat status;

    if (stat(path, &status) == 0 && S_ISDIR(status.st_mode))
	return 0;

#ifndef WIN32
    if (mkdir(path, mode) < 0)
	return -1;
#else
    if (mkdir(path) < 0)
	return -1;
#endif

    return 0;
}
