/**
 * randam numbers table
 * $Id: hashval.h,v 1.2 2005/12/09 09:56:19 tokita Exp $
 * $Source: /cvsroot/daemonshogi/daemonshogi/src/si/hashval.h,v $
 */

/** ハッシュキーの種.
    [駒種][座標]. 駒種は先手後手でも値を変える。 */
static const uint64_t hashval[32][16 * 10] = {
  // empty
  {
0x05E5CEFA32A16D0FULL, 0xD2CA5D5D1051FC62ULL, 0x490AC8D8D0CC29D6ULL, 0x030E53F849AE4EEDULL,
0x6DF877DCEC5FD78AULL, 0x6EC8987887F10EF7ULL, 0xB11F635AE3CE4BF9ULL, 0xE252530CF36C9BF4ULL,
0x3D769E34E55C54D3ULL, 0x111620E5943CA4B3ULL, 0xDA9A34EA55F42C67ULL, 0x575A9AEFEFF97064ULL,
0x752E76F7ADCCD933ULL, 0x6507668F8488A303ULL, 0x975F12EB924E6A0FULL, 0x0D188CE79638891BULL,
0xECCEB8F59C21B6E3ULL, 0x8E861581A28CD0EBULL, 0x5A60FBCD87458C41ULL, 0xACC3E969CC6A796BULL,
0x07A2743B82A9EE52ULL, 0xD72AD410C190A9BAULL, 0xF4C6BF95F3AD6DE5ULL, 0x6FF40F84EC7715E5ULL,
0x5D6DCE0249636096ULL, 0xFC9529D04117902AULL, 0x35B419646A9B2B5BULL, 0xAA923998962E680AULL,
0x844FCA19E102B4F4ULL, 0x1D2E484747F842E2ULL, 0x3996830E22DC83FBULL, 0xE9909051D47F2BDAULL,
0x68CA8AD64428029EULL, 0x8028AE6F3CF0B357ULL, 0x760E4BA7E730E03FULL, 0x83842CDD3A9F184FULL,
0xE0CBB08C7BD88F83ULL, 0xB5E2DFEBC1A2A01BULL, 0xCF6EBA1DBC2F6D89ULL, 0xB8136374DE2A73B8ULL,
0x66D5C189DC12354FULL, 0xCD9DA911B5119384ULL, 0x44C644D510E40091ULL, 0xBB26EF175332B4F4ULL,
0x2A3CC38DEDAE3D8AULL, 0x9D80A8AE028A27C1ULL, 0xFF8827498F23AF7CULL, 0x4901D79C0F423299ULL,
0xE16E6FCEBA66C5DDULL, 0x59F1188F4205B14DULL, 0xD3C5DEA9E087548CULL, 0xA0282AF9D85D20FBULL,
0x0B58AA807012FD76ULL, 0xF9480DD26EF5B0C8ULL, 0x7DF25689FD2E6A7EULL, 0xFE13E2D324E86014ULL,
0x8CDC26DB901DCC9CULL, 0x20D0A9F73A93AD39ULL, 0x2B4ACE87D924F387ULL, 0xFBC08F589189DA56ULL,
0xD75A60AC2027B757ULL, 0x981CF5B8BE9757A6ULL, 0x19C4C1FC85835BF5ULL, 0x6710A050D201755EULL,
0x054E546290E70C49ULL, 0x7FB45EA395671922ULL, 0x5C9A5AB21A498977ULL, 0x75FE6580C1F2D587ULL,
0x99FF9EA9502FB0A3ULL, 0xC81510769CBD6C2FULL, 0x12623798FDDF8805ULL, 0x70A61F497A9E756CULL,
0xD14CEC7F3B391A45ULL, 0xA600A347E7BBA290ULL, 0x99C0907F5F558570ULL, 0x2F25B8879297D241ULL,
0xAC7DE4D4661548F9ULL, 0x0123D764A57AF879ULL, 0x91ADFFD9F8520C92ULL, 0x084802C4EC67AE18ULL,
0x2939F4ACED57CFDBULL, 0x1A15580401051621ULL, 0xB2477B806BBDB128ULL, 0x0E0D8D9AB924A90AULL,
0x4F81A6C1C6F63FE1ULL, 0xE4A3BDB23FCF60BFULL, 0xCB444578D60C9D44ULL, 0xB503726B9405B23EULL,
0x03CA6FB1C75B8482ULL, 0xD372497DA39ABBE6ULL, 0x74EEDDBF645AB177ULL, 0x4372AD53DBDA11DEULL,
0xCA2517A94FAC038EULL, 0x11FA11F7D4D49C43ULL, 0x40BA3E1A07202886ULL, 0xA55EDC5EAF8A0CE3ULL,
0xE77F2A985A43911CULL, 0x69CA9AE5DA618CC6ULL, 0x766CE8EA95B0EFDCULL, 0x82587E0A327863D1ULL,
0x8DEE17E3DA5B88A3ULL, 0x502E10C6E3E4872CULL, 0xAAD39403F757258AULL, 0xB22D0803FDE02D52ULL,
0x011CEA9FA3F69C3AULL, 0xD91DA1116B74C0E6ULL, 0xBD1F7887273C6CFCULL, 0x6D5E6F28E42ACDB1ULL,
0xDFC0C35050F32AF2ULL, 0x8C83A83E73C7CD6FULL, 0x07BB90C727F20B49ULL, 0xD671F9D76B2D0C42ULL,
0xFF297C29D8552F5FULL, 0x5AD8AE8FE7D13700ULL, 0xD1CE4D253BB9FC27ULL, 0xB91A7577A26C87A7ULL,
0x85E120D1CCC3173EULL, 0x2E126C9D60D9EEAAULL, 0x4E4188FEF6797088ULL, 0x9C2F28463A4009F8ULL,
0x326322AE773D1541ULL, 0xD3E750B0D7FF34D0ULL, 0xB561C891FE6E67D6ULL, 0x8377187400FB7DD9ULL,
0xFAE972B542FDBDFFULL, 0x3E643DD10839DB0CULL, 0x461208F3908454D8ULL, 0xFE4A81762AFC8565ULL,
0x7340E9B32F970109ULL, 0x57D67DA485BD006FULL, 0x3B98AB021D74FF32ULL, 0x600890A50AB9F40DULL,
0xA5C3A82F3E43CF22ULL, 0xE70D1E0ACFEDA931ULL, 0x04F2425B94841298ULL, 0x3F5EC21E1DBFAC4DULL,
0x4C5E56B60F61FE99ULL, 0x40E83381E2A7D2B7ULL, 0x4AC9515431060C92ULL, 0x996776E6939CA24DULL,
0x96A66FC6252F3ECCULL, 0xC444B94D0C13E50AULL, 0x90F73B00DF8B79F8ULL, 0x35999D54B3CF0465ULL,
0xEA09FC2380B42BCBULL, 0x5D2F085F0BE3A2A6ULL, 0x8099F42F8FC5B4FFULL, 0x278E84BDC795CA83ULL,
0x490D6AC68DDED31EULL, 0x8C7E1E07C104F7BAULL, 0x27C13C78081D94F9ULL, 0x8B9735626CC22D77ULL,
0x4EA96D4493D33AB4ULL, 0xB0AA2B63EAC949BEULL, 0xBBB368431005C0B4ULL, 0xDB30E5AB7679C721ULL,
0xEAAF01B61E7BBAF2ULL, 0x8D0A269AC282287BULL, 0xAAB804D805F29474ULL, 0x76396598C0E95C85ULL,
  },
  // 先手　歩
  {
0xA47AF3BD75BE0167ULL, 0x7F28AB2C37E8C6F2ULL, 0x6739FEF8FB9C888AULL, 0x0B38E39D03B49EF5ULL,
0x047138FD059EB8F5ULL, 0x40E797E4B9740942ULL, 0x0FF1620B0E1209B0ULL, 0x93CFD9C27D653396ULL,
0x3C71F824A525E79DULL, 0x2F4DB0EB4E316D98ULL, 0x6B4CB5E2A0391582ULL, 0xEF9301EA43985836ULL,
0xE55A28DA7F798695ULL, 0x91AFCE2901A26B2EULL, 0xC0EDACDD6F22EB4AULL, 0x24243FC6549B8284ULL,
0x3E1E95E1B15A9E6CULL, 0x9AF1F3EC8521C028ULL, 0x0FF1167C4C8E9EB8ULL, 0x2B16BED4B70AB010ULL,
0x1DFB7D2391B5C786ULL, 0xBB03B4C39103477FULL, 0x4791B69B6CF18944ULL, 0x46779B7F7E090A4BULL,
0x16B9A0547A62F8B4ULL, 0x8DB7082915345B4EULL, 0x1E4A99A688312A45ULL, 0xC93055819776BF60ULL,
0xF408EF09861D74F6ULL, 0x63E44EE3FE3CA47FULL, 0x54A62EDFE216669AULL, 0xF032E492C91110FEULL,
0x04F0335CF8AFE95FULL, 0xA3E37E2E93C278E8ULL, 0x7094B19F8F6F5905ULL, 0xA97F884F8193D9F7ULL,
0xDC4B6A13464D0C1CULL, 0x7E5FAAAFB58028BBULL, 0x3E50AA9E8CE72427ULL, 0x65FEAC6B62B90BD4ULL,
0x7565AF46EF2B4DA1ULL, 0xB4746C247BA7DC6AULL, 0xA3E6923E7C977718ULL, 0x532B7A27A94BE53BULL,
0xE99CE890A4406CF8ULL, 0x6C2BD2DAFFBDE3E5ULL, 0x9446DCD91F40B5AEULL, 0x9998F008D80EE24BULL,
0x242595BF6A420039ULL, 0x503EE7E752EA983FULL, 0x2EEAFA1BDE45F562ULL, 0x7D3F98D34AABA7CBULL,
0x40DB710AAFD6421DULL, 0x7840F12CE6BF30B9ULL, 0x59121051FB4F3FD8ULL, 0x7CAF3AD095936A4AULL,
0x8323C7CA8BEDB5BAULL, 0xD605F215ED6A2C2CULL, 0x5D957CCA3AADCC0FULL, 0xCC05184CD7C9921EULL,
0x11ECB4B799607168ULL, 0x2572221F76622FDDULL, 0x604462361D5F1F33ULL, 0xC8BD9A6263AB9D43ULL,
0xE5B3A4AD24B921C2ULL, 0x9B9352234C877CAFULL, 0xB1E3CE07FFE14614ULL, 0x435C7F0A63AD8027ULL,
0x95AFCEEBA12D15CEULL, 0xD20C7966DAB65BC1ULL, 0x51B23DDBB29E983CULL, 0xBBE0E36860010652ULL,
0xF10189E699D4E547ULL, 0xABD9E36C9BCD2365ULL, 0x29908DE8611FB5B1ULL, 0xEE16C35ECA3EF3F7ULL,
0x90FDA58B940D8212ULL, 0x3068B78ADB2BB586ULL, 0xD1AE996ADCEBB058ULL, 0x4AB5C769F3F1E965ULL,
0xD18D341D9816C5D0ULL, 0x9A03D346CA9D986AULL, 0xE8D31615A11991F6ULL, 0x3A5279BB152A4960ULL,
0xDC9D6A7E54E1CC92ULL, 0x148C307232BE0ADCULL, 0x4E407391239DAFDEULL, 0x47303B9C47F7A359ULL,
0xB5A58114140CADBCULL, 0xE994501142D5B4BAULL, 0xCA17C7F249407D3FULL, 0x8AD3940E9DD36293ULL,
0x7242BE1EF3236400ULL, 0x16BF62FB451CD4E4ULL, 0xF16412381151CD13ULL, 0xFC79B0B8B412C31EULL,
0x0CE1129B16FFF585ULL, 0x8B81294C3C800D94ULL, 0x52B45BD5CE0BB4BAULL, 0x7D5B320E6C334DC6ULL,
0x7E84F2ADCE6F2D2BULL, 0x8B29C18BB0D43015ULL, 0x384082327EAE8030ULL, 0xBFC59BC7AD345BD8ULL,
0x0C975282D90175FDULL, 0xF049E0A52E7AA8DFULL, 0x8CADB13B204868ECULL, 0x6607028D52CD63D5ULL,
0xF7D9F0C4470FA9BBULL, 0x4E682B9D3E7B6D1BULL, 0xAF5FD7EE0A360062ULL, 0xF62FCFF8AFAA1002ULL,
0xF95C5789A7F6E394ULL, 0x2F10AC0ADC1B8A86ULL, 0x45659FF3AB5D7F2AULL, 0x7FA6B5CB47925FE3ULL,
0x3A923CC87B84A7F8ULL, 0xE72D9857ACD9BABAULL, 0x53EDB12B3D0A69CBULL, 0x0F922972A6855591ULL,
0xB5792B541B9DF29AULL, 0xC1BCE8C07FE69ADDULL, 0x315C4A5540983C25ULL, 0x511700CA79CCEFFDULL,
0x29D19D58930FFB89ULL, 0x7CD5721EDA1168B1ULL, 0x19ED77A8DCB80C87ULL, 0xF665092550037311ULL,
0x1468F15B169CC47DULL, 0x56077F6E932A6607ULL, 0x74E970756F7A5764ULL, 0xC79EB19BA50C3EBBULL,
0x5583E2C3153CBF38ULL, 0x23042323C9CF439BULL, 0x1776E4D5EA0264ACULL, 0x7491219A1EFEB5D0ULL,
0x734D6EDF14891E12ULL, 0x33A3B935B2B7344FULL, 0x11F34450CAFAF7CBULL, 0x864354B6210CF5E3ULL,
0xA5614F77CE6C9FB0ULL, 0xFA3C52F9086D89D0ULL, 0xD4ED468BCCAA3B4CULL, 0x0D5114C8195160F5ULL,
0x166D73D944F3E6D0ULL, 0xB74D05BD207EFB94ULL, 0xBAAA3F019BD6191CULL, 0xEA26EB472EA13A0CULL,
0x08E02175C161AF46ULL, 0xA57B5525EB1EF949ULL, 0x423F04B52C3C7077ULL, 0xCC0562E73342D5ADULL,
0xCBAFA4EFF36F7115ULL, 0x62E7324C6240A9A2ULL, 0x894576F47FDADA77ULL, 0x43E1328301A11F3CULL,
0xAC32BCC2A5C342B3ULL, 0x94D248AF2D1D7682ULL, 0xD119E80BF5D8EE40ULL, 0x88132A3EA7F27442ULL,
	},
	{
0x536F52258016FDB2ULL, 0x33B259698210C3BAULL, 0x1503D450C1BF154AULL, 0xFE524A77DACA3237ULL,
0x427E80558F0D5F54ULL, 0xCAE2E1A689D0DBA4ULL, 0x84B1DC888B4C4120ULL, 0x674A619388E9B50EULL,
0x6B2A138F5C45F8D5ULL, 0x44959A61A2BC5935ULL, 0xD8062C8D609D054DULL, 0xC9D6E14278F182D7ULL,
0xB3D32700ACD1A810ULL, 0xFBE6C05C664DC7BBULL, 0xDB789DAC5265FF53ULL, 0x51AA879DAF04EC7AULL,
0xBF6CD06A1C006BE6ULL, 0x25B5A74BCC8E8306ULL, 0x18A778A8B897B559ULL, 0xB75A456D25C7E871ULL,
0x6D1498E9C6D6A4E5ULL, 0x1693CF5B2F312080ULL, 0xDA6C8BA351649DC4ULL, 0xA74F60F9C2877FF3ULL,
0xC3D0F23A13C41015ULL, 0x2204BB8B781390ABULL, 0x8B78C9054EE18176ULL, 0x189A2E18EF5F1D03ULL,
0x7754D18A0B8B4CE8ULL, 0x101641BF403EDA04ULL, 0x3C85B870686F29B1ULL, 0x308E348E404CBA60ULL,
0x72E3D8CAF858FF4BULL, 0x664E4D9EE4508E43ULL, 0x5F2342B444C68A99ULL, 0x903CDDA6C8343665ULL,
0x173BB77F4011DEE3ULL, 0x00E44F2CD3655B09ULL, 0x0210A1C1D1C5DB64ULL, 0x28B5021302E749B9ULL,
0x18A0AC20AED84464ULL, 0xB958CE2F9D6856EBULL, 0x1C297DA85EEB4D24ULL, 0xF32DF114790FE2F5ULL,
0x29F74EF5A6C10617ULL, 0x1757DB5685E6EBE4ULL, 0xB2EE7F998F89513AULL, 0x29E6C9DF8314E826ULL,
0xE1EC0F72E9BDB478ULL, 0x48F85823A0468027ULL, 0xE998E3E479A2A06DULL, 0xDEF9404ACFF89F33ULL,
0x873E0D23F2B68801ULL, 0xDF484E9ABA833E5CULL, 0x45CAD406868B73A2ULL, 0x0DED25BD95213E28ULL,
0xB10C351312E79117ULL, 0x0C2FD1B19B4B9E3DULL, 0xB6C891B0EA2E9F3CULL, 0x85264F698C1D6465ULL,
0xE844CCB7C85AFB19ULL, 0x5EA61F8B58A48E92ULL, 0x2C54BBD6C612821FULL, 0x4420B2BD23557DB3ULL,
0xB720D36602AA7391ULL, 0x3A43FE70CBF4619BULL, 0xCA1136C74D0DF950ULL, 0x2B8CD12486B95039ULL,
0xD3B6E3494AEC0693ULL, 0x87148D8A6886DCDAULL, 0x047E80417CA8C949ULL, 0x1C32CC05655C3656ULL,
0x529F7AD503D40132ULL, 0x56D8026BF9830D3AULL, 0x3489788E41442DDDULL, 0xE1B3BA0A9903C564ULL,
0x0EB3D7CD370CAB25ULL, 0x7C800C510C5EC0A6ULL, 0x6EB0E9A319E281D3ULL, 0x861416A514B0E259ULL,
0xB2D1CCBDA4BBE888ULL, 0x530CD6330CAFC5FCULL, 0xAABB554490AB2F13ULL, 0xEB2964DEBF16854BULL,
0x12C73A050A4714C6ULL, 0x30BDE08C568A5464ULL, 0x8907D32B1D285888ULL, 0xC6C95E671E07ACE1ULL,
0xC0451361D544A7A4ULL, 0x43922BF0C4473B10ULL, 0x426408344530EE9AULL, 0x5EDE47E8F7D8429DULL,
0x08E61AF5B79D7572ULL, 0xD4226D647CB9BA5DULL, 0x8F8C7F8B11851F52ULL, 0xA24343A34FB5F112ULL,
0xCA50BAE0D1ED9B5DULL, 0x2BC6457506E12756ULL, 0x952AEEE42B2A531CULL, 0x7B7DBB4561E92CFBULL,
0xC964A652690D68EAULL, 0x9B1BB317E811BA9DULL, 0x21722EAD366B2737ULL, 0x7A3E3A0F851DF232ULL,
0x79852B235BD9D78FULL, 0x5DCF3B4D51822BBDULL, 0xC857EF4C409B16BEULL, 0x30C85038158AF595ULL,
0x60F05CF4CE216177ULL, 0x58CC7E87A260F9D3ULL, 0xAB4B74625581C35EULL, 0xE2185894CF1B4CC7ULL,
0x872D82D0BDD84860ULL, 0xEFB234D4C34882A9ULL, 0xF996DF0791800EA8ULL, 0x5DEF39813B89CCD2ULL,
0x9A8D704D77739DABULL, 0x6EA5C9CCA03E492EULL, 0x7644D018456B7511ULL, 0x27AA7A1B1967A0BCULL,
0xB9C4B33C1E759C80ULL, 0xC571114446140C52ULL, 0x90A66B8101165B87ULL, 0x44EC44ACE126D8EDULL,
0x0E8FBED3BF3C2726ULL, 0x90FFCDC668408F47ULL, 0xDC620589999340BEULL, 0x51252F65CD07F485ULL,
0xA6727D5F9EF8786EULL, 0xB02301C954343427ULL, 0xF61D032C8028030CULL, 0xB2DEE4600906A597ULL,
0x368FF179BEDB5A53ULL, 0xE0B544B19719C9FEULL, 0x21B6B66DFEF6ABFAULL, 0x0FEB01D9EFB6513DULL,
0xB785CFC2C77A72B4ULL, 0x220C9491DB0E2F32ULL, 0x2F193FB53057726EULL, 0x5D60CBB779130C9DULL,
0x066D3A1ED1627731ULL, 0xD9BE5DB4C0CBA95CULL, 0x729DBD2EC5EDE481ULL, 0x28678755404A17C9ULL,
0xF7E90576BFE55931ULL, 0xF7BDB0E3BAC81376ULL, 0xDE01512EF46669F0ULL, 0xF4E49A8CC56E1787ULL,
0x8A4432FE231ABB0CULL, 0x96C6E1772ECC4377ULL, 0x86F6C89818F5903AULL, 0xCEEBC705D0268EFCULL,
0x23A785FFD6083F55ULL, 0xD625042A62F54853ULL, 0x283DEA4AED7FD15EULL, 0x6C101ACE18535A3BULL,
0x09655F26CE148348ULL, 0xE9CB07AFFB346155ULL, 0x6A5EB88B607BC63AULL, 0x79856F31999E2AB7ULL,
	},
	{
0xC9C349BC77A7ED0EULL, 0xD915F8C2D7188CCEULL, 0xB22C01813E15F10FULL, 0x1136025CBC95FECCULL,
0x1672FF5E9D0F532AULL, 0xA8FBD92F3B933220ULL, 0xC3E4393AC2DD1767ULL, 0x0B7EBA53BFDB1588ULL,
0x29DF104A2F7FEEADULL, 0x691C0AA4F4613E88ULL, 0x9C2B6B06308242DEULL, 0x069B8F6E375A9313ULL,
0xCC660F0403F50CD3ULL, 0xCF244EA2E1C12EB0ULL, 0x5A5D341243F13802ULL, 0xCEBAF534527B80F8ULL,
0xA0A9466123894DC5ULL, 0x93F12260C87CBD9CULL, 0x8FF211959531A08CULL, 0xB9133EF95A97D842ULL,
0x80A21AFDA9D83578ULL, 0xFDFA980BC6EC70F1ULL, 0x5FF9C566574A3925ULL, 0x6D514C60671247D7ULL,
0x82C6F5305BA5E2A2ULL, 0x00FA3CC8517109A3ULL, 0xB52B4F9D22DF45D6ULL, 0x1ACF971F936E87BAULL,
0xD442DC926AB5BCDDULL, 0xEFFDC47C7B5DBA05ULL, 0x5B88C62DE0833E18ULL, 0xB6AA7B081C543A28ULL,
0xD5492DF71BD62AEFULL, 0xFEB6745691574242ULL, 0x0A97938A27BAE18FULL, 0x1FA6D15408859BA7ULL,
0x247214F9441AA229ULL, 0x0F31851A4A27542DULL, 0xAD2BE551A7AF265EULL, 0x44E5383642D082EAULL,
0x8631B1FFD2509FFBULL, 0x88D6F63A1303DF8AULL, 0x73C753F36EA8B229ULL, 0xAC739FAE49EE71A5ULL,
0xD56015CAD9A45EA3ULL, 0x35BE8AA73C4827A6ULL, 0x7E910C62251DCEB5ULL, 0xF6ABF4A2DB59B73CULL,
0x69DE7B8AD28155FCULL, 0x635CE86E0BADC35EULL, 0x2BD804CA91950B30ULL, 0x3B68033A3E15E65DULL,
0xA23F6A6E0694D97CULL, 0xC3811417F8DEE88CULL, 0x58310545FA28FB1AULL, 0x5E11E982126C1E7BULL,
0x7D91A7C55D1B644CULL, 0xCAADC0C7999DA3D0ULL, 0x1D288D9538BEC3D3ULL, 0xB572B34ECBA4EA2CULL,
0x723A2294FC51648AULL, 0x88B02E260247DDC1ULL, 0xDB83E0E896FE69CCULL, 0xA46FF860389FB36BULL,
0xEEE141BB751F96AEULL, 0x38B08D099FD54E84ULL, 0x9E17C098C6F40E5FULL, 0x008995D8C0750EC1ULL,
0x32723D9D6DF64210ULL, 0x056D23E3D050C0C6ULL, 0x223A9EF58D688F49ULL, 0x6338DBE538065E50ULL,
0x68366E4601E4E793ULL, 0xBEE9ABF5BEB84516ULL, 0x12BC530EF2ED38C6ULL, 0xC312C8B575768DC2ULL,
0x34F8B71848DA3379ULL, 0x7E60A047475F36A7ULL, 0x427F9682109B7B56ULL, 0xF1D529B206A3E819ULL,
0x22467901BE244355ULL, 0x758F7761E9B93277ULL, 0xF39ED655CD8BD620ULL, 0xDC33BBFCAF92486AULL,
0x94C4B42A7A1C9122ULL, 0x665600C70C9D61D6ULL, 0x78291FC421F966FEULL, 0xA881A52D95CA2679ULL,
0x3A8C42397405147FULL, 0x7FA95F431A00B952ULL, 0xB9733225B526D12BULL, 0x1131DD583DA34031ULL,
0x1EB05207412B6B14ULL, 0x9CD858E2371D0D0EULL, 0x72FAFEC1EAE36B95ULL, 0x98236357BE90E111ULL,
0xCEC28DE40623190DULL, 0x2428F5C89E171B6EULL, 0x2DD81FBDB5D7E7D0ULL, 0x6FC95453D3530869ULL,
0x3F77955E8F5232CCULL, 0x01C3A6B6DE0AEF38ULL, 0x49D60F00C37CE2B6ULL, 0x37223F9AAB2FEF8EULL,
0x5D5DB38AC59A00ADULL, 0x7BFD6C6586943A0CULL, 0xA107261CD6C30FA1ULL, 0xE5874FADA109B0E2ULL,
0x76A6FAD2F4416DFBULL, 0xDDE6B89403CF884AULL, 0x92FFB03F667AEF4DULL, 0x8349219F3D7910CBULL,
0xEB042F42950F5403ULL, 0x353901E8AFC16F50ULL, 0x8498972AD45F4360ULL, 0x8C2663AB28D8A98AULL,
0xCE9D28659796F248ULL, 0xA099438B5E3F172BULL, 0x214F7422D1E9AF92ULL, 0x1897941CF239FAF4ULL,
0x6D0F939A58BC24E7ULL, 0xEB23E18BE846C09DULL, 0xEB340DF2C7C3397CULL, 0x2AE5796BD05F1F13ULL,
0xD9883FF1BF692A11ULL, 0x7258AB037BC52894ULL, 0xE66F8CE654FC980CULL, 0xBD202CAAC1A024A7ULL,
0xF8FA5C8E337807AFULL, 0x9354F304B4D9E9FAULL, 0x6D55EDD03AED8398ULL, 0x6CE2CF32AFBE5091ULL,
0xB356529263D3E22DULL, 0x1C5FF947C5863EF1ULL, 0x7A167D124AD17798ULL, 0xE1E544937CB4C719ULL,
0x38E6237C10C4D567ULL, 0x7FCF1B9B30DDC272ULL, 0xF2FC62A42A0F9708ULL, 0x4C7589C61D785E1FULL,
0x88B5751F4F7C20B2ULL, 0xC53F891EDE931347ULL, 0xC63F8829023DA465ULL, 0x98AB82A827B09932ULL,
0xA50EB40FFBD0B71AULL, 0x761B70378C177977ULL, 0xE26D620271D53E57ULL, 0x338956B7775F107FULL,
0x230CF5984D2284B1ULL, 0x027EE056E00EEF0FULL, 0x586564605299D1F9ULL, 0x7EDBB610D179C3B5ULL,
0x02438238C38AFA12ULL, 0x5B62D874A5512D47ULL, 0x33E72D672AB4F3C6ULL, 0x50F99FB6A88019BDULL,
0xF977319BE225AEFDULL, 0xBF2B3B5CF2539F1FULL, 0xD7BBAD4A5D881031ULL, 0x1D56821B68008E60ULL,
	},
	{
0xD92D0A6BB4EA9495ULL, 0xDD0CA8063643739EULL, 0x5F1A2358DA2263D2ULL, 0x1A379B93645667B3ULL,
0xAA2610800BD1CA03ULL, 0x5A4D41A1C2880427ULL, 0xAD821D425A1E9DBBULL, 0x186C3DCD2E01BD29ULL,
0x092AD3AA94B03373ULL, 0x09BFE4582533F80BULL, 0x1D5EA0B14A8D2A6EULL, 0x8B6E6470D06248C1ULL,
0x1406A495216FC336ULL, 0x115E19482514F59DULL, 0xAE07FEA2C437C962ULL, 0x0948966E92906510ULL,
0xA7C1A0394F2AD0BCULL, 0xBF11445080C1F39DULL, 0xF522B6EE7013C3F9ULL, 0xD07969E9EE46925CULL,
0xEB230A0167928994ULL, 0xA77550FCA58678B4ULL, 0xA98A3B98B81CD179ULL, 0x43D3CA60D3EE2625ULL,
0xBD48BA75967DF49DULL, 0x5605B83949D4EB51ULL, 0x00D255141EE12DABULL, 0x4E246C284C9E3395ULL,
0x354ACB66E8B05857ULL, 0x8B8D97CDB016D2E8ULL, 0xAC587098D2C6D31AULL, 0x4AB44622DF16ADD0ULL,
0xA002EA9FC8D41551ULL, 0x47F6D48F97022B9AULL, 0x82ED616FD1F20A00ULL, 0x4F9F2AB75CA20532ULL,
0xA8D2FC1DEFA845C8ULL, 0x1C6480671C5E2D3DULL, 0x240F5E5233FFBCC6ULL, 0xF6FCD91CFAFAC061ULL,
0x9A96F4C8FC63B35FULL, 0x82ABFD11173626C7ULL, 0x21BC43C26E54433DULL, 0x03D91FD1E013D254ULL,
0xE59316AE2A48F401ULL, 0x371394A3AE874F22ULL, 0x7DD46468A8309567ULL, 0x800BE96E84E7AE31ULL,
0x578DF7C9D875BEE3ULL, 0xD17580D6315FAC5FULL, 0x8811707A737716F2ULL, 0x2FD64CAF94295A17ULL,
0xB2E3FC3ED8DBCAADULL, 0x1AA89A17756E7251ULL, 0x69923D1F7F246C50ULL, 0x7863F8C329F601C8ULL,
0x91C82D30BB75C5C8ULL, 0xDB48275941137988ULL, 0xEAFC74E018760A78ULL, 0x160E96E29976CA36ULL,
0xC28D95038AAE39CAULL, 0x20C587AB85D1AFB3ULL, 0x422F7A118FD67242ULL, 0x3F87FA241D71E6FBULL,
0x89FD8A36ADF96B10ULL, 0x35D6AE927042A266ULL, 0xF48A044AD6614875ULL, 0x12C4369F18D732AAULL,
0x78CF91B5E7A0856EULL, 0xCB32AC2892788541ULL, 0x1ACB41DCE93BBB6AULL, 0x68D0F8C8CC40CB10ULL,
0xC12EC1B0A2C8A713ULL, 0x0DA7BA01ADD7547FULL, 0x937B864EDF84E760ULL, 0x6D60B614A559724FULL,
0x3951CDFE06A79A84ULL, 0xA67E85CEE15FF4E6ULL, 0xF0F4CEDBB00C2A69ULL, 0x974B8FE78D4FB5E1ULL,
0x782826FC83EB50C3ULL, 0xE335B2C74169721BULL, 0x2FFBA5F603B69902ULL, 0xDEC901B8DB251C82ULL,
0xB920D3F2D15D6C94ULL, 0x8193CADF1DE0BC60ULL, 0x83E72ED1A98F044EULL, 0x4E91B38CCEFFDBFAULL,
0x73F8F1FD8CB06FECULL, 0xDD0518B27BE286AAULL, 0xC56261EC819E42F4ULL, 0x4CC2099FBB68D7CAULL,
0xD5A8007CF4885C7FULL, 0x7A56233B87DE2626ULL, 0x50C2C39EF361ADA0ULL, 0x38A34A684186E9C0ULL,
0x8765640370B7D877ULL, 0x2EBFC4530527941FULL, 0x60EA1DB145020029ULL, 0x3A3E73CB4542B571ULL,
0x70ADC8CFDDA72847ULL, 0x5F3D12E9FFEFF344ULL, 0x33C704F26841105BULL, 0x60C118A17E658790ULL,
0x616F4DC2CFFE8EACULL, 0x154C9A0C46C63958ULL, 0x856633D1120D0B68ULL, 0x6CC1DF7CCBAB022FULL,
0xD146A0DE4576E3CBULL, 0xE5EA95AD7082DE42ULL, 0x2E8F02FD31D92AF4ULL, 0xE3467BAAACC796E1ULL,
0x20C4764677E77474ULL, 0xE7EF2E29739EB181ULL, 0xF402890C1D9B12D2ULL, 0x46B43987885E0FC3ULL,
0x09D702C7C7817A8DULL, 0x36C4EB9A140F3705ULL, 0xD3452A2107894859ULL, 0x9282770CA2F2A867ULL,
0x2C3C62DFF144BF9AULL, 0xBE5DD9EAAC8A2C6EULL, 0x59FBA09492827464ULL, 0x56C4A1A3EBC5779EULL,
0xE30C174B06A43A73ULL, 0x4D9416A4183E17ADULL, 0xD4E3C7A69A3060F5ULL, 0x1092924004AE2B34ULL,
0xD0550018DB63B910ULL, 0x2BD6C198C2080006ULL, 0x6357B13383DCE378ULL, 0x9C3860BD29E1567EULL,
0xCBD07F3ADE9EE789ULL, 0xAF1C89311E10B27CULL, 0x3C6BCF69ACF624B2ULL, 0xDE3E077DDEAFD4DDULL,
0x21A6ABA69413452DULL, 0x8F444B9B12E7329FULL, 0xB29F3B86CC52F749ULL, 0x004B704C84350114ULL,
0x4E4ABDEC2294D8C3ULL, 0xF3B385AB170C38B8ULL, 0xC31F62935B182DFAULL, 0xDED0C38C3F01C296ULL,
0xA4631F5CACB4B4F1ULL, 0x7852888607EFDE63ULL, 0x3D9DA12C5A672270ULL, 0x848C129FD0AFB1A4ULL,
0x89D5C4AC68A19DBFULL, 0xA6DDAF12FF64DA88ULL, 0xD1BC97450AB0DDBAULL, 0xD0ECB6994A70D35BULL,
0x38D0BD1EAC3B6048ULL, 0xA1850C2BAC8AEDB2ULL, 0x8F113CF769BE936DULL, 0xA630FC32BD93AEA7ULL,
0x31FC1F306259AD86ULL, 0xFBE64A91F5265FDAULL, 0xA4B6014E8C7D6062ULL, 0x3C70F6034EF4BB0EULL,
	},
	{
0x79E015391493421AULL, 0x3A22E0EA6380FBBBULL, 0xC093938817CF434FULL, 0xD0DA618C00A34F92ULL,
0xDEBEE7D4C10D2538ULL, 0xB895BA95617A3F55ULL, 0x80B1F53AEE166821ULL, 0xBF1C248ED6CCC9CBULL,
0xB5BFE9448493E44DULL, 0xCFC6EC2324953E77ULL, 0x4F4392FA3465F41AULL, 0x22B3BE99C58CF37AULL,
0xC491622F91F4F77DULL, 0xFAC82C31E0FE5C62ULL, 0x57B5B48465F98071ULL, 0x33EEAB0EDF18CBA8ULL,
0xFC5891C1778FEE74ULL, 0xBC8C65652322C31CULL, 0xAF2BBD8824943D4BULL, 0xD63BE61A36395980ULL,
0x819F1087D3A75196ULL, 0xA31F470A9891E61BULL, 0x9AE35FA2AA451BE5ULL, 0x1676DC9E8249D502ULL,
0xD45DD3C7F8E08166ULL, 0xD83E7A7918574151ULL, 0x651F79557DE1175FULL, 0x0D03554EFD22B4AAULL,
0x450EFA5CF7FA64FDULL, 0x3C3A3637AFC3359EULL, 0x8DAFEB0B7F398D32ULL, 0xC0BC2C19E008A0ECULL,
0x23E5CC1BC3BBF8B3ULL, 0x483727E7B8AD23A3ULL, 0x6304EB169FF9D644ULL, 0xE7BCF8DB247B8EA1ULL,
0x570894B564080DE6ULL, 0x34B6EDF43E2225FDULL, 0x50DBA1BDDE4391A1ULL, 0xA2F2FA496E0E814DULL,
0x44EB43226D3ECCE6ULL, 0x217D9A0634910BE1ULL, 0x7184164355FB51DBULL, 0x9190DE26421EB653ULL,
0x3FB6F69030B5CA03ULL, 0x3BC8F5374A64751EULL, 0x2EACB5F77DC79E0CULL, 0xD9503FBEF2903A04ULL,
0xDEC5E1D25B7ABEC5ULL, 0x1FDA7F0E560E3082ULL, 0xFECEFE49E4C4777BULL, 0x007FF5A0E0752798ULL,
0xF3392E57F83F3841ULL, 0xF2D76040A6903DA1ULL, 0x8C2712E205ECD4E6ULL, 0xB6F187A1FBA81508ULL,
0x049EC7A3097BCB97ULL, 0xF1F9CA2DBB721307ULL, 0xD24C48BE0635C472ULL, 0xEAB4661CA4626BCFULL,
0x82A6384E30C3A190ULL, 0x74177C2C292B09C1ULL, 0xFF4AEF4C7262253BULL, 0xC5A8BB8153BDAF8BULL,
0x18F3018418526A63ULL, 0x9A7D6792AF020F5BULL, 0x2560E09251832989ULL, 0x70E2F11DB02DF385ULL,
0xD1FE160A93CA0A9FULL, 0x2E1FAB85C360FF33ULL, 0x0A48A153213112AEULL, 0xBAE0402BF2EF001BULL,
0xF60961CAAD229233ULL, 0x661B61891B9A4438ULL, 0xA11A1A3F907AD782ULL, 0xFD9EE82BC36AE911ULL,
0xD32B86DF12D14EA3ULL, 0x948BF3D9F429A40CULL, 0xFBBE331B0E7FA682ULL, 0xE16FE378ED8315C4ULL,
0xDB6A39259C260957ULL, 0xF6B7F6831E5C5486ULL, 0xC0F5D8FE81CC749DULL, 0xD9B8332497E7FC3FULL,
0xC5F4E152D8D5C316ULL, 0x258EBC44187BBC9FULL, 0x73F3387FBD5C0997ULL, 0x78751B1EDF481035ULL,
0xA05C708DE0BD7DA3ULL, 0xE37C202EB55B81BCULL, 0x1A9134F8885A3B1BULL, 0xF598E78EFB90A6E7ULL,
0xFCFD8D8ED8DCE47AULL, 0x448F3D0A186EC262ULL, 0x0F0F65C24D8C476CULL, 0x873614865405D0DEULL,
0xAB5F843BE277E5B6ULL, 0x6DF30B860B419F48ULL, 0x0A6D2278C77C80BCULL, 0x6792F0E927606A99ULL,
0xA7C0A0D3697E8C1AULL, 0x69C32023F16C73D1ULL, 0xB45667423E4EBA24ULL, 0xA5F0159CACE1E513ULL,
0x2EA4DF950718AB3BULL, 0xCC2501E7DFFC5EEBULL, 0x459F9A1C2C4E2745ULL, 0x1F454A00D3478738ULL,
0x218319EB6D702ECFULL, 0x26C9D2D39D52FD4CULL, 0x0A5E7A295E2C9F87ULL, 0x3BB8AEA202CE2930ULL,
0x29871A2211A81E27ULL, 0x87AD431D8E69761DULL, 0xD08FC207E3F77601ULL, 0x4DF5473E8713AA9FULL,
0x45583E99890FA4BFULL, 0x80400833D6A23AFCULL, 0x9050462267BF5702ULL, 0xB1573CFD85F3A4BAULL,
0xAF0A957ECE7BB100ULL, 0x71D450792EF81C70ULL, 0xDAB39816BEF6DC41ULL, 0x03E271FCA85D1945ULL,
0x47129A0CE4E8FA1EULL, 0x1C64ECCF39AB93B4ULL, 0xDC1D7807CB7CC8ABULL, 0x191B3F10DA161F7EULL,
0xF151FC4A8C3A7E1CULL, 0xACAF28E0575F62F1ULL, 0xFF459D0D01691CDFULL, 0x82A474D7C573CFDAULL,
0x913F1C52FD43C8F4ULL, 0xC6A78B2C42B1ECD3ULL, 0x7DBA9D95267E7542ULL, 0xCBBCF906F005EFB9ULL,
0x9218221CE1EF95E4ULL, 0x4934F5DFF73CE489ULL, 0x6B0300CF205962C1ULL, 0xC48598FF9D3E1DEDULL,
0x2828DAC9FEAE9BDDULL, 0xC84BE163A9173725ULL, 0x0756C21DE64FAF33ULL, 0x7A2CEAA7DC018134ULL,
0xB82DC476420D9617ULL, 0xFA58A9BED1C34F62ULL, 0x66E0CF89EC04BE5CULL, 0xB8D954896430398BULL,
0x11C4F1912F85D9CAULL, 0x95FD27AE978D14C9ULL, 0xBA9D4C3999B27C9AULL, 0x347A962C2927156AULL,
0x69F0ACB4DA7C0A09ULL, 0x5D250E8E14684745ULL, 0xC7C99FECA7258C32ULL, 0xB55C69C3C62D4BE4ULL,
0x42B505FFE67DBAC3ULL, 0x526CC7FB4135180EULL, 0x5AE79C7A6E6EA242ULL, 0xE5A3180D29DB3CA9ULL,
	},
	{
0x1644FD1189535AECULL, 0xBF6C84C7D52F9591ULL, 0x0380816D9B2499C5ULL, 0x4D9C3FA419286B74ULL,
0x086703E32DC5B0A9ULL, 0xAFEA7CD787F5B238ULL, 0x4F8BBDF40D446432ULL, 0xB9581A9A8B1391BFULL,
0x2428A3AFEC7CBFFCULL, 0xC8A73572BCF9C383ULL, 0x97421614A876BA9FULL, 0xDB6147438E172560ULL,
0x088E49E134251295ULL, 0x8D901B948393D7ECULL, 0x3D355E3BA80DF9DEULL, 0x15AC996E79F2D83FULL,
0x338D5AEC18A35C51ULL, 0xE5A923CCB1145F49ULL, 0xD060D21FA5724AEFULL, 0x1B3CD998EA2BB314ULL,
0xD767ADD1AA445CA8ULL, 0x52B04E888B9D80A5ULL, 0x5DF7C5681AE4A35FULL, 0xC0DC6E7F91F84749ULL,
0x0C243423D93A2A34ULL, 0xB22A1D281060D87EULL, 0x0DC30D5644DCD040ULL, 0xADABCBF9262471D4ULL,
0x8A18F79C5A3FB964ULL, 0x84B4B0D79A628068ULL, 0xD6186C7A77367CCFULL, 0x887B8006C1E3AFE3ULL,
0x5A84D627416DAF51ULL, 0xF8AF8C21EEA3810EULL, 0x545B895E3AFD65B8ULL, 0x7F08F7356B9A4674ULL,
0x2B47A57B4851D1B2ULL, 0x35403057F2C90F9DULL, 0x17213948C9FA2A02ULL, 0x4400513C9E9FBDD4ULL,
0x32A3A735F42AA4FDULL, 0xA2A30FAC93323793ULL, 0xE6DC27ECBCED6A9CULL, 0xE0E2DEE2FEE771F9ULL,
0xD016766F116009A2ULL, 0x2CCE8D229D7FD1ECULL, 0xDA202532017C298FULL, 0xF8A922289BAD38C8ULL,
0x574BD7E9392EE974ULL, 0xBD73032F949AEABCULL, 0x427AA1F66CDB99D5ULL, 0x585769B1660E5F3BULL,
0xB21915AB5683462EULL, 0x6A450A2CC320F622ULL, 0xBEDE24D28022D0D0ULL, 0xF24D6077C0917E6DULL,
0xC69BCF2E5F0F3A1FULL, 0x14A6778B114E75ABULL, 0x00A1BFE7335B0A6DULL, 0xA1722ABD4CACE988ULL,
0xCE57670CB58EBBFCULL, 0x7794CECC635CEF11ULL, 0x1017D0AFDC3D70E2ULL, 0x513BE94A5B37B599ULL,
0x0B7E7730EA4236D2ULL, 0xE0F91D37854C555DULL, 0x1DAF92CF85AA9915ULL, 0x677DBBE2A4DA9C47ULL,
0x893DF48BCE9E4720ULL, 0x134B7959E92A4575ULL, 0x2CB84EEF4CCE24A7ULL, 0x8D149C092F623A6BULL,
0xD422EB4F112C2E11ULL, 0x0C799F4BBCC9B705ULL, 0x24AE2E9599003AA3ULL, 0x3262A908851C6B96ULL,
0xD79AFCABD69FCBDEULL, 0xAF3862B31BEA02D3ULL, 0x1619FE084350C7CDULL, 0x6CA0BE34A313C36CULL,
0x4D78070F05243250ULL, 0x8B99EF9463DD5F71ULL, 0xC00E652D02D0B79AULL, 0x09036C7C434B65F0ULL,
0x6C9DA1EE36D8206BULL, 0x43FD12D9ED94355BULL, 0xA3326074B28696CAULL, 0xF2B0B03867F2BFB0ULL,
0xC3A9560B8883F837ULL, 0x4B5303A9B32BEB6FULL, 0x2F6002C3461D50A5ULL, 0x4892FC3F4C7DDECFULL,
0x6CC9BB46B977FFB2ULL, 0xF9AF667CA5E00CCFULL, 0xD8DAC9628241F7E0ULL, 0xBFF1733E21BD6DFDULL,
0x0792E4EA51ADFDE2ULL, 0x343A82F9B988E929ULL, 0x22110AF2CDB9CC1FULL, 0x30EE685739ED924BULL,
0x25F4C587C3168511ULL, 0x256BE58FEA6E105DULL, 0xE7004A65B02CED22ULL, 0x69C87FFE89AB2CE8ULL,
0x193F734BBB187B24ULL, 0xC29CE5DDC2AD4A8BULL, 0x771F76F6D39A6C91ULL, 0xA5FA0A21A2EC41BEULL,
0x4C3D75DC1949B120ULL, 0x1BF2CAD723F6ED86ULL, 0x4AE3622C9D94AF70ULL, 0x462E6E908EDD83F8ULL,
0x976286BC40589AC9ULL, 0xB39585AF5AD8B0A6ULL, 0x61D8F4DBB51A5034ULL, 0xA5FBC4A72BC34965ULL,
0x3C096D31B6297770ULL, 0x59433C83C06B6002ULL, 0x964DEC2E0A36F27FULL, 0x2C87EF41F3C365C9ULL,
0x73CFDEAA482A7CD8ULL, 0x472E1DD56F7D100EULL, 0x739327B23447B978ULL, 0xF4EDD5EC51A4AF05ULL,
0xC0FB8CB028D9D54EULL, 0x7D3635BAD22AB29BULL, 0x5BCFD1623C0451D6ULL, 0xAB819462E8882B2EULL,
0x6CF8C954BB7D81D6ULL, 0x97733DD90CEC2E3EULL, 0x0A68E8C1262DC080ULL, 0x7CE2B943738F2986ULL,
0xE1EF6B2903157186ULL, 0x9D15A12A8C205917ULL, 0xBFF9F9ECD3F466D6ULL, 0x33E6ED1B227BC753ULL,
0xCC64D9BAE97A5F04ULL, 0x84932C7838FD77FDULL, 0xA4EC09B70E1BEDA5ULL, 0xE3579A9F983CA1A0ULL,
0x31F56B8AD3B84522ULL, 0x6A3624A31AFA2313ULL, 0x2F94FFCFCFC407B5ULL, 0xB87F713CF07BB4DEULL,
0xEA277E9338947BA6ULL, 0xB5F1BBB36AB7B0B9ULL, 0x9AEA17DA25F43CFEULL, 0xD392DAE3710BAB71ULL,
0x2648F44F2E4BCD2FULL, 0xAD941D9F5B4887E9ULL, 0xBADA22A338CB2F85ULL, 0x42E5BE13CC5F1C12ULL,
0xF562FA3E24891743ULL, 0x30478DE51F00FAF1ULL, 0xBB1FA04053740AD8ULL, 0x7DFB253719E57927ULL,
0xF14B47F63F89457FULL, 0x986B4EDBECAB8B93ULL, 0x95B7FC45FFBE0F33ULL, 0xFD64A438E960B1F0ULL,
	},
	{
0x16BD677BED942A93ULL, 0x984E295BE1DC992EULL, 0x20AB4ACA740F8CB4ULL, 0xC9ACE5E5B46AD58CULL,
0xEA18DE67100BA183ULL, 0x36835727F003370AULL, 0xB2DA0D3A7156EFD6ULL, 0x79721435FED4668AULL,
0xFC8C7D3F601A559DULL, 0xCDC5CF33A1A18CA4ULL, 0xF03FC5BCBFAFC21CULL, 0xA8C477979CB4A5D9ULL,
0xD6EEF608DA4F18D4ULL, 0x6DA660BC36089CF8ULL, 0x3CA7BE620F1B18CAULL, 0x19A723496CC3C1A9ULL,
0x9BB6888DE34A1A34ULL, 0x1F3A7058ED7C4B33ULL, 0x1A371219068CF2D5ULL, 0xE855555709EDB9E4ULL,
0xF9D5A69111E4577BULL, 0xA13D7FFA65F913BFULL, 0xD6AEEC03A78A9F71ULL, 0xFE6FE9E19F372B4BULL,
0xB797508A2198E4D9ULL, 0xA97CF3ACEF6859B0ULL, 0x3F318BD42C921B3CULL, 0xE1F15F9EAD855776ULL,
0x029C53DB8214DBCAULL, 0xA8A6CC1C9C4B2996ULL, 0x27AD583077265510ULL, 0x7D0D46A0286C6AB4ULL,
0xF1EBD39D390A0220ULL, 0x4D604FE413DE92AEULL, 0xD2D3880C628F8B79ULL, 0xBBC432688EDF40D4ULL,
0xE70EC4DC0B277A25ULL, 0x43B6DC996AA8F780ULL, 0x87A12C1D905933D2ULL, 0x1C698831E4E729D2ULL,
0xBB4A4767214A0CEEULL, 0xEDDF589E8683F6D9ULL, 0xE183A13B837B1BFFULL, 0x8FE8C287B33C6F62ULL,
0xE5EB041A9EE9DFC4ULL, 0x1352FEBAD31ACE2FULL, 0xA807B4D51F3AB7D1ULL, 0x46EA031E71DF9C66ULL,
0x089EF9B2DEA9A5BDULL, 0xC3307C724BD35661ULL, 0x3B230467DEC0CB0EULL, 0x48C70BF102A4C742ULL,
0x8EE6611F4A339E74ULL, 0xE7079C2A2038FBE5ULL, 0xE11260EA5A5DE115ULL, 0xF14FF89F20A9601DULL,
0x4DA09261022EF2E0ULL, 0x42E0F40377C85354ULL, 0x82C63F58EF8A4334ULL, 0xB26C5114E9D143F9ULL,
0x4F9C12E6CB7A415BULL, 0xDFA952871A492B57ULL, 0xA3E77F26A0975E95ULL, 0xB68B4E6EE72015BAULL,
0x3C4F3668F69B69C0ULL, 0x1CEEE21001843D03ULL, 0xA3700FC8810CCAD4ULL, 0x40E56B29391A1E0DULL,
0x058FFB543654EAB8ULL, 0xE6E93BF71977DB8BULL, 0x91D73E3C43C9623BULL, 0xE89A9796CD0E3333ULL,
0xC96D0BB69A7D6122ULL, 0xCDE3E489B3FE4465ULL, 0x29CDB392BFCB1CA0ULL, 0x0B99AB85C05A69AEULL,
0x151F0BA42405FAA7ULL, 0xFBEFE8BA74EF70C2ULL, 0xB8956D7F80B09DE6ULL, 0x1663EE48569B8ED5ULL,
0xF5F99E2FA731EC6AULL, 0x45EE96A1BBA88979ULL, 0x02EA39EBB7E9A924ULL, 0x7DA0CDEA27DCAE4FULL,
0x8586C9DCF1073EE1ULL, 0xD4F689B8CF145E4FULL, 0x73787E8E23A6E96CULL, 0x868A1EAE6BB02367ULL,
0xDDA6A59964F27FD6ULL, 0x24FC83DB511F81A5ULL, 0x1FF2558BC06EC13FULL, 0x3B247BDA8645F750ULL,
0xA1D0773E87962B80ULL, 0x55E5CC15BEA4E986ULL, 0x71AE480B5A731199ULL, 0x2750A2B93C688D48ULL,
0x8A58AC8E2BDFDDCBULL, 0x0BD50C2300CD371DULL, 0x7EE42FE7539329ACULL, 0xBBB2E0EB337FDD9CULL,
0x9ED657BA37399CBEULL, 0x5BE9E5C754E40591ULL, 0x6177094A33135036ULL, 0x7369EEF4A276C096ULL,
0x0C9B18703207CD0BULL, 0x8232B8DA0F9AE13FULL, 0x1853BD5FD40B9782ULL, 0x199CD014589F0A4AULL,
0xC6399A621949A1BBULL, 0x5E10532200C7C85DULL, 0xC0632F024783ED07ULL, 0xCBD9905A7F8D784CULL,
0x5922125B26751802ULL, 0xF1DA82EC7C9255FBULL, 0x32181271BF4D95B3ULL, 0x964DFA05BCD4B242ULL,
0xA65962D78283D03BULL, 0x62E0C56C4F1CF873ULL, 0x50875904168887CEULL, 0xC6CB9B2298D0DE66ULL,
0x6B3AD116193554FFULL, 0x36BB89DF1F91D430ULL, 0x971439EACCE05391ULL, 0x53A9B4744F4E8ADEULL,
0xC75173C10188A16AULL, 0xCAF6C27107B733E2ULL, 0xB2BB20E7897C8B4FULL, 0xF36FEA976F37ED04ULL,
0x2C4BC4053063F77CULL, 0x4405BBE864EBA711ULL, 0x33E50C197AA3DC52ULL, 0xC25FD271EE28B78BULL,
0x64F3FA3E6A7057A1ULL, 0x7099751327973019ULL, 0xA5D221BE2714494FULL, 0x92CEB1E394FC0889ULL,
0xA04D1F1BAA332A5DULL, 0x5E41EEFB26182286ULL, 0x98A087018616378BULL, 0x454C0DBAEA53306BULL,
0xADBDFA526F4DED20ULL, 0x9C5D2EDC381792D2ULL, 0x6AD4C0C873303F98ULL, 0xC5AADDEA000252C0ULL,
0xD74547CDABFAF334ULL, 0x6A6EEADE1F5D788EULL, 0xDF8D278BD2A6F2BBULL, 0x89CD810AC88021F8ULL,
0x06D8DC5F45BA8BD9ULL, 0x4EB41A928312E3EBULL, 0xCE383725FB9D05F9ULL, 0xAF56C813D94236FBULL,
0x23BEA3025E391E80ULL, 0xD21CE4398277E7A2ULL, 0x78E3C3B73CF893C4ULL, 0x151FB36ABF0BC5A7ULL,
0xD50E9B91D9620E2CULL, 0x5E8E9FC6A40F184DULL, 0x561F5C8391E8654CULL, 0x0D8EBA204933AF37ULL,
	},
	{
0xAD674D61153DF192ULL, 0x1439A5872E0880FCULL, 0x607D148CA82283A0ULL, 0x9EB32DC4BD86DFF0ULL,
0xF150DD0B74B854FCULL, 0x8470EAFBFBEB1E74ULL, 0xBDDA5A8E78F1300CULL, 0x99FF629E1EF497A9ULL,
0x4669B8CB0B387365ULL, 0x2C31B09BBC5C8DCFULL, 0x4E66FDF75B41FED5ULL, 0x42405D49A550A454ULL,
0x0EC9EA132C2A48BDULL, 0xF872F6C71A716AD0ULL, 0x003CFA6C7F60BD89ULL, 0x9EE9DA73BEB634CFULL,
0xC824F5168F244135ULL, 0x6162DB408A6D5487ULL, 0x41056442C6A4E92DULL, 0x3E1479FA032BB0E4ULL,
0x6C0CB5AB5D0ACB0EULL, 0xFAF834DA28759985ULL, 0x569F4688D7FD0AF6ULL, 0x9A1A0BE1D868AD91ULL,
0xA44780B8015B2A83ULL, 0x86D5B7ECEAB3A47DULL, 0x7A5C5214CB47F7A4ULL, 0x56FF3A7DE39ECA38ULL,
0x0038B32234BC60D8ULL, 0x847C5C8AEBF90A43ULL, 0x83DCA6908048E289ULL, 0xF4B36AF8AE2B77B4ULL,
0x985D1738F5AB3790ULL, 0x7CDBFF7BD3C65A31ULL, 0x306E3E8EF6647529ULL, 0xD325ED042241EA4FULL,
0xCCE3C9B26478C0C4ULL, 0x862B76FAA0D311F2ULL, 0x540FC7A03A055C8CULL, 0xA531D2E2C486B79AULL,
0x0C478721B75DDD9DULL, 0xBD2294395B0355ADULL, 0x80FAEF75BCBAFD24ULL, 0xAF560AA2CFA4E132ULL,
0xCF178AF2BBDA9BF7ULL, 0xB07CCAA771D44D96ULL, 0xF2CA6EF62D033E63ULL, 0x6F4D91B096CE4D5EULL,
0x35B768F09A3F7C27ULL, 0xFBD375F9CC3949E5ULL, 0xCA355C6A22D99EF4ULL, 0x896ADB9CD43AEE97ULL,
0xF54A8A46D067EFDDULL, 0x8ECFF7FDCEF30E2EULL, 0xE6548DA135E5028DULL, 0x18D6C52FC8901AF5ULL,
0x80A5370D98B0A334ULL, 0x5DA92725DE53E51BULL, 0xE8861319526CEA76ULL, 0xBF9CACBB5046D47EULL,
0x9A595554321A60E1ULL, 0x7801C6E820785D95ULL, 0x2FE1153661EF09A4ULL, 0x138888B853FC0357ULL,
0xBCD246B7BEA9A28AULL, 0xC30B02D18500D241ULL, 0xD93D9C6C9C816584ULL, 0x44E0159D38C0E2DCULL,
0x05848D71ACED1E38ULL, 0xD40B256857261C6BULL, 0x10CC0D8117CE7461ULL, 0x1BE87404354F229AULL,
0x903821F9E1C7E1F8ULL, 0xA82A03CCDF5F1357ULL, 0x424F62BD68D6EA76ULL, 0xAA43D00AB1447C32ULL,
0x6F61A21B1761CE9BULL, 0x369AD720D961B8EEULL, 0xF4D36B356D61269CULL, 0x4D1EEAFC133EBF17ULL,
0xAE8CC29C26558297ULL, 0x1A157CB2C3A734D4ULL, 0x5F0F990792206FA6ULL, 0xDD3EA042A2F89339ULL,
0x0BE0AC622E0D0611ULL, 0xCEA855EB4D5FFEE1ULL, 0x014C27A32A887353ULL, 0x29CEBE8E645C738DULL,
0x55B52E18D156C908ULL, 0x40D8410067D5DA01ULL, 0xD1E8A319AF59B7F3ULL, 0x1B16CE53107AA17DULL,
0x993DEB60FC23C4A9ULL, 0xAB18636CC04C806FULL, 0xC9661966F8E6F1A4ULL, 0x19F39E7B9188123EULL,
0x8F43F284E78DD0BCULL, 0xFE93BF24A7502260ULL, 0xDB197EC8CA046C3EULL, 0x9933B067A6C59703ULL,
0xF3FC61AA50FC7E42ULL, 0x544ECB9FAA771809ULL, 0xA75D0E1840B3FAD7ULL, 0xDDB8DC2C9557C11AULL,
0xB6EE048E198C0830ULL, 0x23978B8F6598680CULL, 0x746AAE22017C1DF4ULL, 0x627AC6190B1F42E9ULL,
0x2FE713C0C2A22B4BULL, 0x3ACDD86F507A034AULL, 0x3AB7A5053281515AULL, 0x7553FE81987BCED7ULL,
0xC60E7E667CB9F633ULL, 0xB77BDCC88DEED71AULL, 0xD1ED229B9B3EB286ULL, 0xE9A8E4C66602B50AULL,
0xB6026781BD5BE285ULL, 0x7AC9F643016616DCULL, 0x8B7C6ADB7E0770C6ULL, 0xFDDFA6A90B2FC119ULL,
0xE413BFB5915AC829ULL, 0xD73C787C2FFD5DFEULL, 0xC7B3A948002FB7F5ULL, 0xD0ACF4E0AB05189BULL,
0xE78A249B20327BC3ULL, 0x74CC0995B1EE8B55ULL, 0x5275B65D35ED06E1ULL, 0x033445EDBBA21B95ULL,
0xBC046E8E15A12947ULL, 0xA8529194398776E9ULL, 0x9485580626EA224EULL, 0x6500C03D1DC787D5ULL,
0xC5EA9601E67EBBB0ULL, 0xBB45F580748CE31AULL, 0xE65FC614609215A0ULL, 0xC6C52486695C602DULL,
0x16F1D95C25B2E2DDULL, 0xE0CD17444D0C4A2EULL, 0x91A57BB8EB08F22BULL, 0x5104516C93DA5891ULL,
0x1FBA4C575E73888FULL, 0xD52AD3544EB06944ULL, 0x4E289F03B5DC3E25ULL, 0xFB76396C55B1C819ULL,
0x3B7739DB28AEC590ULL, 0x646EF51B3576A9A4ULL, 0x477E876DD16A443BULL, 0x02566406F3A861EAULL,
0xC2B7016A6CA5A7FAULL, 0x558E5B27EAE8C97FULL, 0xF82C2C5809FAB4C9ULL, 0x7677532E51223602ULL,
0x923259050AC15BA2ULL, 0x76C1C41B76C16507ULL, 0x6768849CB98549BDULL, 0x453166017065BAE3ULL,
0x32BB1C9D5C9785AAULL, 0xC83CFD67A80A40F0ULL, 0x966B201BE5375E16ULL, 0x552011BDC5CCE12BULL,
	},
	{
0xE1D97BCE1F6E3424ULL, 0xAE69DE1259DD6482ULL, 0x1EC2A388FC518ECCULL, 0x8689BEE4A9EF2761ULL,
0xB1D88227F932CF14ULL, 0x8B64293C53F8DA4EULL, 0x31F887ECE16CA7A2ULL, 0x8D9B08CFA6FFB551ULL,
0x54564269E37ED565ULL, 0x8C6AE5E3BB4C8435ULL, 0x42DE13D2CE61DBEDULL, 0x430A9F5922CB2B04ULL,
0xD3232340C897F9BBULL, 0x9C9D3769C982960EULL, 0x11F88364D66CBC62ULL, 0x8820D59EEA3FF773ULL,
0x5CE00959EC4C1267ULL, 0x7F4C20DC96EACE51ULL, 0x6FC3118F5920B72DULL, 0xD47CDC911723D5EDULL,
0x62B97CF00C065B66ULL, 0x84F144554B1EA582ULL, 0x90D184C297F5FADCULL, 0xDE13F99553D67B97ULL,
0xC6209FEEDF066678ULL, 0xBD827717FD1969FAULL, 0xE07C98A4FE8127ECULL, 0x9514E665C8FFD9C8ULL,
0x43B11D866BE18A60ULL, 0xA51DE37A07C5291CULL, 0x1F248DD7326DC1FEULL, 0x1095333C1A33F64FULL,
0x88187C55E826E24DULL, 0x87FDB196D7F586E7ULL, 0xD91068B9401391AAULL, 0x4917C444168F9A97ULL,
0x9C167C09173D2E5BULL, 0x1ACD6FAC78DEE4F2ULL, 0x82CFA82E78DA67FBULL, 0xBDE3C34202455AB4ULL,
0x949A67895D7C2646ULL, 0x0449B35F63FC79C5ULL, 0xC8407D69D843F48BULL, 0x62329E8D9E1DB552ULL,
0xB3E384A6FC6A0F36ULL, 0x5535ACA5596A39A0ULL, 0xDB23CDBF04A89F49ULL, 0x6F31EE4851E84D85ULL,
0x68C50A472D3DA5B3ULL, 0x2BA9A38845B9B198ULL, 0xCE40877740AF96D9ULL, 0xF7D558DB1EEE7F86ULL,
0xD8F846260E83ACBEULL, 0xFEAC999C7A2B362AULL, 0x4A2312A1E27584A4ULL, 0x5B84CFB63F49D149ULL,
0xE37FDB019A09B30FULL, 0x4F2C884ABC6F061DULL, 0x286EE6F925699783ULL, 0xF490BD589735FFFEULL,
0xC81D405E17F0DF70ULL, 0xBB42F4D1F2CD42DEULL, 0xC2BA8FBC6BDBD612ULL, 0x9F8AFD905D57AB72ULL,
0xE0EBECCAC3F6D548ULL, 0xB0CDD31471C3DF2BULL, 0x0210A6944543E9A5ULL, 0xF868B9129EF6E05CULL,
0x1AF3D3A099F6023BULL, 0x3C61F0263017E536ULL, 0x7BF68E7ACE38D2E3ULL, 0x6A797D418529027FULL,
0x1AE91F517E99E5FEULL, 0xB1895D9D6663B518ULL, 0x2A0CF7A63F1B3903ULL, 0x7036294A7FF4D7C2ULL,
0x3AF35131393E2541ULL, 0x296196AB5F0C1CBBULL, 0x8944757ABE7B44B1ULL, 0x9FE28975BC66B51DULL,
0xCE8A2FCBF41278C7ULL, 0x147B57F57BB46A18ULL, 0x2DA3AF7ACC233790ULL, 0x61FEB9C78A9A0E72ULL,
0x59682CB53761C99BULL, 0x5D236335B51CD8E6ULL, 0x17A6F642D9EA3168ULL, 0x6E90A8E398B6EA4AULL,
0xA68F2AEA95150B6FULL, 0xD6F2A7981A7AFCA1ULL, 0x5829457EE72BD3EFULL, 0x6E47542A27E2FA6FULL,
0xEC66CEA77970A619ULL, 0xF8AF87EA15480801ULL, 0xCFF1FBF033F3B642ULL, 0x5C619626A0255A76ULL,
0x6AE0BFCCD5F37F3AULL, 0x1D92377E768112CAULL, 0x17C1D26F60EBD8F3ULL, 0x867AA03A28453520ULL,
0x30C687C59B80F505ULL, 0xCACA66DB9253BF0BULL, 0xDE05DAEF90EC8BCCULL, 0x471F788B2690D1A8ULL,
0xF506F3F038A65B29ULL, 0xB667B930EF49DEB3ULL, 0x4716908E614F7623ULL, 0xD83B153DCFA0C9F1ULL,
0x3121258A9131CAE5ULL, 0x8C8EBB8D4DE5FA99ULL, 0x1D0741A4CDE7B2E7ULL, 0xDA5AEDE4280F6A9AULL,
0xE9A7B82423DA5739ULL, 0xB00456D90DB0DBDEULL, 0xDC155CD355BD313CULL, 0x6DBD1C471E207DF5ULL,
0xD1C8A797533DF63EULL, 0x730DF59334BB78B8ULL, 0xE89C6A24F575CACCULL, 0xFA43655BA05E02E1ULL,
0xB6FEDE7B06F6B0A5ULL, 0x859BD6569E99E59CULL, 0x7BAAB91DCC66C0B1ULL, 0x0325C38BD62C908AULL,
0x61C0962A19FCE854ULL, 0x95DF441B17CB2BD0ULL, 0x13210CE58172900AULL, 0xA3884B40DF4A680DULL,
0x5856F13D4B27C72BULL, 0x6016AD496A9C2664ULL, 0x7273CF65BC864F2FULL, 0x90DE82AEBF4F74FBULL,
0x30B97992A4F226ECULL, 0xAAC6D281A275C685ULL, 0x80E8946F49D1048CULL, 0xC02785E25A16BDC9ULL,
0x5E866AD9916B8348ULL, 0xEC33862F0AA8603DULL, 0x9282F5EFBBB6A81FULL, 0x0AF4901AA621051CULL,
0xAA0BF29C0F59C710ULL, 0x9642B5E3ADA6E096ULL, 0xE86F1211A065C09AULL, 0x7150C35A79EA9CFFULL,
0xBD64CED7BD990583ULL, 0x459CB66A59B30E1DULL, 0x7612347DA035CD27ULL, 0xD56F474D9931ACF6ULL,
0x74AEF407B1A970CFULL, 0x51300BB0700634C8ULL, 0x379C738D19A8ECD8ULL, 0x4E3A1862E7376BFBULL,
0xDE4923CA4E6C1EA6ULL, 0x7703255C0363DE49ULL, 0xA7414A83102D74ACULL, 0x6DAC2030E2F10F60ULL,
0x18369CF790226C01ULL, 0xA35DC93C0B2377BCULL, 0x1DF679D0828A654CULL, 0x18017023D22A6F8BULL,
	},
	{
0xDCE254AB08454902ULL, 0x55ACD265EEF9B328ULL, 0xCE687539FEB30E02ULL, 0x1B02F3D25F2EE602ULL,
0xA183DD874D2A7957ULL, 0xAE690F06C430E85EULL, 0xF290AA85C08F0DF8ULL, 0x8EA75040F6EA1329ULL,
0xEFC5D02F1A2C1447ULL, 0x1A19FD06DE9E1107ULL, 0xDF93CE22C808422BULL, 0x89EFC2D21CBFD1A4ULL,
0x26A7E95EA765BAE4ULL, 0x71CCF7AA104C5357ULL, 0x2F6F3EACC4E1144DULL, 0x0B63A51892D9CAEBULL,
0x1A6E3D49351A459AULL, 0x2EF5F66E2CA40BBAULL, 0x0BC99DDEEFCA21CAULL, 0x5AC52B560070747EULL,
0x3FD1B5E40EB34657ULL, 0x94D5800D5B020F6DULL, 0xCD801BF4F0DD34E1ULL, 0x439194D2A5730692ULL,
0x2328EDAB89F4A4D9ULL, 0x533FBE5B74BD0779ULL, 0xD6C5AC1994CBF868ULL, 0x1F44516D942EB39BULL,
0x58B88FF0775D261FULL, 0x9FAE6BD833A6C51AULL, 0x74D56AD865B95727ULL, 0x4C7FF578D5DB21C6ULL,
0x5311A7AEB8C9EFF9ULL, 0x01B1940735F2B07CULL, 0xD63CBF8C7CD7B7E0ULL, 0xEFFA14D01F2F6748ULL,
0xCC8285DCF33A59C4ULL, 0x4FAA5F951C9DB2E9ULL, 0x62B601DB21A486FEULL, 0x1C4F5E43F9D30A9FULL,
0xB099284990DC9B43ULL, 0x98DF653549483D58ULL, 0x0199AC2F0BF3BEDAULL, 0xBD97902E87DAC7B0ULL,
0xB2C249F6883B2AA3ULL, 0xF9E13847007C4C58ULL, 0x1BDE64375D905FB7ULL, 0xE5D91F6D46231AC9ULL,
0xFEF485FD9DAEDA9CULL, 0x984B2E46F5708A6AULL, 0x66B4626BA8AF0850ULL, 0x574FA98172B3D287ULL,
0xB16F35F213F409B7ULL, 0x42CA93F38438F1B7ULL, 0xC3B0019297FD2017ULL, 0x69808B04FC0329A2ULL,
0x0298F4CE010873C0ULL, 0x7284CB4A1F6E8E31ULL, 0xC38C7F4F0D6F440FULL, 0xA62C335E1E4229A0ULL,
0x53DEEF5EBC257652ULL, 0xAAD10B39B64D410EULL, 0x987836AFCCC3E754ULL, 0xBB0D0EBA13875762ULL,
0x8ABA6B301A04D98CULL, 0x743EBA161841A6B4ULL, 0x8506DDBE06B1583AULL, 0x9D6D1F487BFEEA9CULL,
0x66BE2D0E6C466DE8ULL, 0x6FF69BE39AE97FFCULL, 0x14A08F1F59DA9B1CULL, 0xFC8C9EB963051136ULL,
0xBFC0A7F779191039ULL, 0x406C4D4D87913FE4ULL, 0xAA9FA8A41E5BCBCAULL, 0x5FE04104063BFF82ULL,
0xD9101D98E00FE4CAULL, 0x4466C47615199E9BULL, 0x34EAC7F31126F697ULL, 0x8E22F172C386CE68ULL,
0x36C51951A125DAA2ULL, 0x6159D07CF35852FCULL, 0x0F2E6E25B4019A14ULL, 0x1A3722E7D30E6865ULL,
0xA222EEBCBB03C7EDULL, 0x5A13D0CAACED5360ULL, 0x63AD1371F7414265ULL, 0x32E70C74B228067EULL,
0x4A0924B21572B086ULL, 0x6EC41D2664893EE4ULL, 0x9699B3D30234EF45ULL, 0x12696B2A643AFE07ULL,
0x2C89F5DC2CFC07A8ULL, 0x434FD791B2A7D000ULL, 0x890D1DC12F4535A3ULL, 0xAAC5A237EE8EE05CULL,
0x36744FC434C9FDC5ULL, 0x48F920D7A8BD7994ULL, 0xC08F8BDC90CA4DEBULL, 0x6C08523EB41B2D78ULL,
0xC61BF96BA3B02B7AULL, 0x2866E8F53EE28F4DULL, 0xC03452A593937FEDULL, 0x414CC0F796451A69ULL,
0x7E0ACA6161732AABULL, 0xE8ECD437B0DE9A75ULL, 0x2046AB3E94249D70ULL, 0x2199AA19FF8D2CBAULL,
0x94E81B62093FEEC8ULL, 0xD239EE228FBEBC1FULL, 0x318FE4267BA37C5FULL, 0xD190527D3D34ABACULL,
0x0F65D97CF64AED2AULL, 0x454F231C8CCC3DC3ULL, 0x392F80FBB97FA1A2ULL, 0xB2F4F68ECCD92864ULL,
0x9137E4B00FBC66A1ULL, 0x09D5B9DB4309B130ULL, 0x920612462EC78D97ULL, 0xBF00ECF783019DF2ULL,
0xB234A31C88BD631EULL, 0xCCB3459A840D40EEULL, 0x40B7CE45E0385B31ULL, 0x0897169AAF9DEA41ULL,
0x047BF1AA09B93082ULL, 0xCD11CA0BED6A11FFULL, 0xC73733B783FAA2B8ULL, 0x634374C7A57CA0EDULL,
0x38B0DB44F7DF7593ULL, 0xF49C0A18CB73D800ULL, 0x44FA3FB6401AD133ULL, 0x0C08FEB849B778F5ULL,
0x0D51BF83CFCC2A13ULL, 0xD8273A598E88FCB6ULL, 0x30ACFF882EAA656CULL, 0x71110F56900CD65BULL,
0xF619D1EEC86E0500ULL, 0x5D9D906057C7FBF9ULL, 0x388287807CA6C3A4ULL, 0x75270436092F309DULL,
0xA87A1AB6331D31EFULL, 0x044967B76239D507ULL, 0x161C97D9387D90E3ULL, 0xCC0AE6E7E8145720ULL,
0xFA2D61F84DDF5E91ULL, 0x0C72F5B14D74B237ULL, 0x6300789E255DC6EDULL, 0x4C8D397F2321D471ULL,
0xBED2AE817CEF7160ULL, 0xFB44C4F68EA82811ULL, 0xBAA1D58E2822F1DBULL, 0x55963F689661F171ULL,
0x91A6411820667A63ULL, 0x381B71D38D2EACD2ULL, 0xB703A308230A485DULL, 0xA2E55B774BA41967ULL,
0xB84D354D7B2AAF25ULL, 0xC01260572F7F2942ULL, 0x94EF54FC55148F9AULL, 0x2EB85C434D939FF0ULL,
	},
	{
0x744ACF837A99281DULL, 0xF418E94E8E272EF4ULL, 0x3D3D18865043974AULL, 0x95A2FEC858A6861EULL,
0x13EA3D25F45D2198ULL, 0xB9ACA26B5A1AFD16ULL, 0xB8B41386BE5865C3ULL, 0xCF089DA528CF8B13ULL,
0xC4C042F5CDDFD40FULL, 0xEBD8B28506511432ULL, 0xDAF21E437CB2DEB9ULL, 0xD913AF902D3DB033ULL,
0xC76ADF8CBB0EB1B9ULL, 0x1061E4A6EE034221ULL, 0xDD84EEC1E83565B5ULL, 0xC1E9878B7AC68EE3ULL,
0x2989D8BA9FDD9814ULL, 0x50E416D75DBD1ACAULL, 0xB891E0B5848DD07CULL, 0xF71E1270D8BF387DULL,
0x4E54A27B4637223AULL, 0x68AE70D9D7EDDDEDULL, 0x5DD50F9B03950659ULL, 0x629310E9B497062CULL,
0xFF3B2E6EAC1A8162ULL, 0x07F307B1C0D4A14DULL, 0xEA3165D337724611ULL, 0xD33912BC776A55ADULL,
0x31A5CCD75EF2AC7CULL, 0xA951A6E336F6A045ULL, 0x9ACEE9C00465036CULL, 0x4EA20C51A28433F0ULL,
0xEEBA88209921F7F4ULL, 0x16AFB8871CF3D1B9ULL, 0x92DAD1EEA74E8D73ULL, 0x28629F7C57DE36A1ULL,
0x0A49A3D816C066A0ULL, 0x1A6C851199E22572ULL, 0xBECC2934E5E5EE45ULL, 0xFC4B709133870590ULL,
0x95B82847D68E44C5ULL, 0x19DB43E6951209D9ULL, 0x62490BE4FDA7B598ULL, 0xE87820B79B0A5504ULL,
0x3C13A3733C19DE4DULL, 0x9622B5B1F2471B1AULL, 0x1D96C6FA66759ED7ULL, 0xA42FC683E7BE51EBULL,
0xF42788B648176117ULL, 0xD0624180936C1CA7ULL, 0x77A2624FBDE943F0ULL, 0x5095FDD01114C0F2ULL,
0xB5B5D7D0DBF53C70ULL, 0x0E33CDA264B39E23ULL, 0x399E5ED0705F4DB5ULL, 0x2037E7E2BBD25181ULL,
0x1EB8F4873D978EB0ULL, 0x3B79CD47F82DECAEULL, 0x2930B1BBF4B0D2EFULL, 0x3269B4CCD345E597ULL,
0x35BDD7BC505171FBULL, 0xE68E3BE975D93195ULL, 0xEE3645DCAFA2D710ULL, 0x3F718F171165CF93ULL,
0xB654031438133922ULL, 0xD3B67F77E51BDF6BULL, 0x311B8BD3D40D1987ULL, 0xF29402AE1AF146D4ULL,
0x948FE0195BC2EDAEULL, 0xA4F46A4214BACE7EULL, 0x3EC9E25CD4B6A6BDULL, 0x0EE6381114789449ULL,
0xA49773E6FBCDA009ULL, 0x5329D5AFA63EA9B3ULL, 0xBF23DF983CD7DBAFULL, 0xBBFF9CC5D560B7DEULL,
0x935B9052D1F65AD1ULL, 0x758D8EB101D08CCEULL, 0x4B1AC45F0460CD35ULL, 0x9775D2121DD787D0ULL,
0x9D47EBA66F46CA4CULL, 0x94778CFE378AF510ULL, 0xEF5AA290B4EE43E3ULL, 0x6837FAFB74BC8AE3ULL,
0xB01BC7CD4D43E8FDULL, 0x0481AE1313376542ULL, 0xE87CFF6FF471BD98ULL, 0x90AFC28392820E7EULL,
0xE4D01211C74B4264ULL, 0x06F66CF4E78D5E25ULL, 0x25E0FAF84A8B25A7ULL, 0x9CC6B32E7DF939A9ULL,
0x7E8E245A71319CD9ULL, 0x2C984FB3D5D78C3FULL, 0x60094548359A34ADULL, 0x88AFB8C9C0191DF3ULL,
0xDBBF90EB80011B97ULL, 0x37C203BB97144C12ULL, 0xCF9A6AF9E486A907ULL, 0x9D8FE57A53BC0735ULL,
0x062DA1AA3A0329DFULL, 0xFACD61DC0B8DE5B5ULL, 0xD1DF418B2A2FC8E8ULL, 0x00F5D30F36458B3FULL,
0xCF3A73ECA2EAC043ULL, 0xEFDCD32115D820D1ULL, 0x07EE7CD47FA3DF1BULL, 0x54253992BE4A1A66ULL,
0xA529D9BDD93ED51BULL, 0x86ECCF6686581203ULL, 0xBD5AB66B29F5A365ULL, 0x003E94221D2011FCULL,
0x8E7C69B7D9F40916ULL, 0x67426EAF1C28429FULL, 0xA37C701CD8D9BF89ULL, 0x0C27ED0FB06E919DULL,
0xF86466549F3BE0F1ULL, 0x212B464DE08093D9ULL, 0x2E4DDA6252E7E1F3ULL, 0x99612A3B08A39476ULL,
0x454B65CACF811D57ULL, 0x0D0A0ABA61907E56ULL, 0x1FD867E1049D0F06ULL, 0x649A72BFC9680F5CULL,
0x486AE36771A701DDULL, 0x54C4AF4491C38F19ULL, 0x0F3C76E48709220FULL, 0xE72786D4C90A14CFULL,
0x1B7823725B6F9C27ULL, 0x6479FC74508742D8ULL, 0xF84599E57330AED9ULL, 0xF64222FD13CF3FE7ULL,
0xFB6C12924F155C32ULL, 0x3F90D640E17BA0B8ULL, 0x209648101727B4E8ULL, 0xFD27C77BB846E719ULL,
0x195409B8FD278EC0ULL, 0x7720AAFDD7173567ULL, 0xDF6DFED0E1E0D55AULL, 0x2EFE7CFF8184D7E9ULL,
0x8C3B9F8B5F858AE3ULL, 0xBE9FC41235CA4FA1ULL, 0x14F21D5F9AA8FC63ULL, 0x4D9D6FA404609C7FULL,
0xD12CF05922A1A3B9ULL, 0x5BF57178D4879F10ULL, 0x5E20035CB95CAF79ULL, 0xE21D7929A4958C17ULL,
0x8640059011EB2F3EULL, 0xEFD448F53FC89699ULL, 0x52423B5D7453711BULL, 0x0445F37776E62764ULL,
0x4DC445B3BC723349ULL, 0x536EF21DA4063308ULL, 0x5705BA8E58F7EB3EULL, 0x0DC16C60252A81CBULL,
0x067615DDC6BE89B1ULL, 0x887C381E84A4071FULL, 0xD8157E52841BD162ULL, 0xD63813A93956B886ULL,
	},
	{
0xF692BA40E1BE7960ULL, 0x36D57DC05D212747ULL, 0x17B1C67C2E9E1DB0ULL, 0xCF654E6F0D4F74E7ULL,
0x76331DEC485338B9ULL, 0x1A342F31C27C6E5AULL, 0x06E298D28EB853C7ULL, 0xE7EA85AE66B17FE3ULL,
0x0DAA4711FC5032DDULL, 0xAAEBDE25FFF44724ULL, 0xF3A718DD101CA9E2ULL, 0xB5AA74F5C68C91B9ULL,
0x4AAC54F9D27538E5ULL, 0xA93C204DD1B6376FULL, 0x3C30DBF72471A937ULL, 0xF7D3DEBDB8CFA420ULL,
0xA6E7F41F30A49B58ULL, 0x77EF8F5E6285BF27ULL, 0x9B775E02233B33FEULL, 0x066860B23E98C0F6ULL,
0xBE09BDD746C4DCB7ULL, 0x1EA45384522B7156ULL, 0x4FADFA2A422F5AE8ULL, 0x219AC766D1C33B46ULL,
0x47D10C777BCB5629ULL, 0xBD7366907F617D84ULL, 0xF337E4B69447C540ULL, 0x88F1EF44A668813EULL,
0x033A6D04840E9F48ULL, 0x6EE548F35A2A8A73ULL, 0xD5436ED4247B9CABULL, 0xF7560BCB8F5487FCULL,
0xFFBC1766D5B4CA17ULL, 0xD53D2173C3A00349ULL, 0xDEEF1D6D813A2D8DULL, 0x60DC6E072A701249ULL,
0xF197161A7069C41DULL, 0xD01980AFC03F3814ULL, 0x52085BFD4D8FAD15ULL, 0x0F7123563A1E5333ULL,
0x7E41066E2D3E6D99ULL, 0x1762415F8192F2BBULL, 0xEE54D470AD02D5ECULL, 0x7B5B0568508DAD89ULL,
0xADDA9A3E0BBD37EBULL, 0xB8973E5C8C67614EULL, 0x4A7BB4FE9F234C84ULL, 0x7C81148A31FC9145ULL,
0xEEBA443631395C14ULL, 0xB363D767006876BBULL, 0x6D7E6D129FD0FC11ULL, 0xB199353492F3B7CBULL,
0x5819B7958F49FA5CULL, 0x328E7DBC463322E7ULL, 0xF5C1AA322131DD20ULL, 0x3A1DA9D51772401BULL,
0x18BC247B667AB422ULL, 0x1E40C161A8DE0328ULL, 0x5AAB9DE4B45FD6DAULL, 0x2015E1EEB8116BDAULL,
0x3EC459B31A3690CAULL, 0x049A98409FF46C2EULL, 0x15DBD5A8F5C6ABDFULL, 0x0EBD7763F215FE4AULL,
0x458C35050ADD3ED2ULL, 0x959AD7FECEE5EE3FULL, 0xC0EF2DE3923C23D3ULL, 0x32F6731E677D7E1FULL,
0x16990B0E6B180207ULL, 0x2F621B9DFEE7B4E6ULL, 0x74E0A8D9F9C6E284ULL, 0x629131ECD3F9DB39ULL,
0x6AA0EF974553DFE7ULL, 0x37C58DDC984E62FEULL, 0xF7F332AB95159DB8ULL, 0xE76A82A47BE13947ULL,
0xB7A10772267DDB1CULL, 0x4032515D605A4C23ULL, 0x873A9B5492B9A2A2ULL, 0x8B5BD68D7A17E043ULL,
0x19154CDE22EA4F22ULL, 0x30EA7F9380732C87ULL, 0x48B04FACA100DBF5ULL, 0xC1FF9D0B91E293E1ULL,
0xDF2C6F6E2A77BD0DULL, 0xF894F76E1BDDC02CULL, 0xB2DF9A732994C9A0ULL, 0x0D4B239269BAD2D5ULL,
0xB22AB86CE0D99A79ULL, 0x7D1B74CEF8E1DA80ULL, 0x77257658E3C51B2AULL, 0xF9FC92D9540ABF03ULL,
0x76C71CCD6F25F398ULL, 0xCAE9A9B90266DF5FULL, 0xBB873A0DD286DDB7ULL, 0x50D6E2500AE6AF94ULL,
0x60B9E59F0389F164ULL, 0xBF6E5258A702BE78ULL, 0xB116A75703286EACULL, 0x59BBDAE203B2ADEBULL,
0xE0399802F43B94FBULL, 0xAC047CB15A7DD213ULL, 0xD3EE2629A1BCA3F9ULL, 0x4D9281F03FC45E7EULL,
0x57B2059CBA9D3917ULL, 0xAE1C7D2FBEC74245ULL, 0x61C234BA3834DB08ULL, 0x5405859BBEF0169DULL,
0xC679AE9D3B90AAB2ULL, 0xB9C648E43967CD78ULL, 0xD40455AC2D31DF4FULL, 0xAA118346F90F200BULL,
0xD597DE3B1200E9C8ULL, 0x93922E97FA541769ULL, 0x6A9D052AD785D985ULL, 0xCE6A416A037A6B8DULL,
0xF3AE2ABCD0A4E33DULL, 0x36B52791B94FDF7AULL, 0x14327E11BB73B87DULL, 0xD0B7359F47763350ULL,
0x6CF041FC6FEDB4EEULL, 0x6494392DAEA6BF74ULL, 0x410D581DC692C4A3ULL, 0x209BEFF9EE954E3BULL,
0xAC252B7D5D2F4CDEULL, 0x5A95A0358C7053A5ULL, 0x6D8A48169F724F22ULL, 0x799944976A0D3520ULL,
0x11CC68F8DFF97489ULL, 0xEB51BEF57D3FED65ULL, 0x71228B065DF3ADA3ULL, 0xC8C64C88B9FEFAD5ULL,
0x0E4C9E72CAA5995EULL, 0x780807216D403101ULL, 0xDF06C5704147F3BDULL, 0x295396E759B5B82FULL,
0x6C37AAD4AB1AE35BULL, 0x8780587122D34009ULL, 0x05505F8938B21B01ULL, 0x54EC2341F5D52CDEULL,
0xF7AA5A0EF0C36ACDULL, 0xF7218D0BEB9850FEULL, 0x57C4A77C53FC8AACULL, 0x24E5FE3C51859634ULL,
0xEFB419B2BCB89E32ULL, 0x03792CADE2ECD566ULL, 0x532B42AA70912FFEULL, 0x01409985FF83FCC9ULL,
0xEEDD591E511C2945ULL, 0xA5037F9E16E08F4AULL, 0x263BB6F4B85C9832ULL, 0x5A893802D4357A0AULL,
0x37B87E2354B1EE26ULL, 0xFE4F7A59109A3711ULL, 0xAD1C1503C753BD1DULL, 0x8B7E074335A836A2ULL,
0x929197345F9DE1ADULL, 0xD8773B0E853892BFULL, 0x8C770C9C8CB67573ULL, 0xBF93BF3EAE8722D3ULL,
	},
	{
0x36B639EEBB43E370ULL, 0x95D4AB93B452F3A5ULL, 0xAC943B0F3DC75802ULL, 0x807A3298957A3534ULL,
0xCACC5C77BA1E5161ULL, 0x55A5C393E71CDE38ULL, 0x5CCE1DC5AB52B59DULL, 0x897D21C6803A2025ULL,
0x7F00351BB41177AAULL, 0x7B079FB014611788ULL, 0x94612E9C3F09ADD2ULL, 0x87C34EB4B8EC6701ULL,
0x7893D5A5BAAABEFBULL, 0x5D7A1E2318164894ULL, 0x1A39BD393DF22661ULL, 0x3BE5E4502E058F3BULL,
0x6EF6B94CCAF7C3E2ULL, 0xB0F94C70073CACD5ULL, 0xDF77DEDA7344AD0DULL, 0x1BFD6C5DBB1972DAULL,
0xDF43AD0D5955F97DULL, 0xECBB558CC849EE6DULL, 0x615755CEE9B01344ULL, 0x256E4CD20C5E72B7ULL,
0x3FBBB886AD74AA5DULL, 0x1F4374B8CAF79EACULL, 0x799485F2C75D8873ULL, 0xF2819E829C16ED96ULL,
0x6064304E838B287FULL, 0x2CC6A62EA4972C0AULL, 0x6A77BF30619923F0ULL, 0xB0D536042EF9FD2EULL,
0x65B75ADDA7C53D76ULL, 0xB4EC0E8995CE7672ULL, 0x33656700DD3F0F98ULL, 0xD5A6F7DF7491BA0EULL,
0x0A6150ED80DD2BB1ULL, 0x1CD651F23EC46304ULL, 0x7B13C9F4F0CBC402ULL, 0xACE2D0F7B07E8768ULL,
0x15180265BEF1D1E5ULL, 0x7A88541506D2102EULL, 0x9C409E429D2A0762ULL, 0x201BEC4991C027C2ULL,
0x2F8688C8A389C1A1ULL, 0x5E9C19D8FC988B2CULL, 0xA20B8050F23AA009ULL, 0x5243FEDD9CEB9B85ULL,
0x8B45302397CF59FEULL, 0xB950C5D1338F27F1ULL, 0x40DCF24C33FBEB8CULL, 0xED45C306CE4A0A79ULL,
0x01F5DF860603377AULL, 0x57DFE88AE40EDC6BULL, 0x18DEA7C4F57CCB8DULL, 0x3E68FBE15905391CULL,
0x9D5CC9FDAB1489F4ULL, 0xB73B9D82D2BC4034ULL, 0xCF0E263CFE73992AULL, 0x7E949A1AA82D4AE4ULL,
0xB4A5910CD58021C9ULL, 0x290F2DF1C48011A3ULL, 0xC9E303D31092100EULL, 0xE35CDAF606C1D25FULL,
0x0BAA41B24658451BULL, 0x881B325503DE613CULL, 0x9E814CE7E1856228ULL, 0x55E47A9C93AB703FULL,
0xA159D4ECA9819E38ULL, 0xF8E36BC13CCBC492ULL, 0x7B86D9B5DEB2E505ULL, 0xEC9C52AA66AA823EULL,
0x1A271CC4DA26D429ULL, 0x73B3CDEE33F5317AULL, 0x1E6E9D0E8F9F09CEULL, 0x84CDFE060B36A2F4ULL,
0xF39B46D9685C9E5BULL, 0x14F273131E7E62B6ULL, 0x20803502AC1490E9ULL, 0x18F75AF8B650FB86ULL,
0xEDED5D721500647AULL, 0x70D3727B9F29E6F0ULL, 0xA85C46933AF22A41ULL, 0xB1070488DC54A83EULL,
0x58B5701738C4BB67ULL, 0x674ED2EDAE013B2BULL, 0xCD116D6D4EB7F32EULL, 0x09611C1C0BAFB106ULL,
0x2FB64CA54B705052ULL, 0x357511C5EF6E918DULL, 0x37D3C8A434BD8305ULL, 0x4DBCFC5C319156C8ULL,
0x34AFF1EF005712FBULL, 0xC11CF7DF3FC12591ULL, 0xD13A6D6F2C2D7749ULL, 0x84D3AE60AD98B6AEULL,
0x735224E2AD09B01AULL, 0x5BD2B54178333E98ULL, 0x871C48F2F99BB081ULL, 0x89EA3A15D9620450ULL,
0xDC41D122EF26ACE1ULL, 0x7A2F7C8BB25A41EAULL, 0x77F839FEEC67B0B2ULL, 0xB1232AF3E91FDBB5ULL,
0xE4241E3FC679B4AAULL, 0x1C7C17268F0B750BULL, 0x10F66BE22AC5CC7EULL, 0x73B3E1F04A126C4BULL,
0x53D56257983CE9CBULL, 0xE5A32B3F45BE5181ULL, 0xEB7D3B3A597D1FE5ULL, 0xC0DC8DB8E4027DB6ULL,
0xB69B5B52D0914A85ULL, 0x1D7F2C7C81548AF7ULL, 0x77552DBFF46377AAULL, 0xD0C2E22BE2AB8F86ULL,
0x137D578F172F7B1EULL, 0x1B7630814F6228C7ULL, 0xBE6AC624EC79A063ULL, 0x9619E81AEC1494D6ULL,
0xDEAA37254C4B861DULL, 0xD671202DA6E553E6ULL, 0xCF173CEC60D3CC1DULL, 0x2B9D7E51E8E30CC7ULL,
0x4FEF6E9AC2A463AAULL, 0x9720FEA54B6ABA37ULL, 0x9A0A674D8720FFB7ULL, 0xDA6364DCC3A578E5ULL,
0x8B4774286BD85914ULL, 0x09953F1A11B4A83EULL, 0x50C0551418F3B8D5ULL, 0x9600EB93C403726FULL,
0x487C4083EBDA8175ULL, 0x2B32625CCACC3A3AULL, 0x918C6E8ADABB3D77ULL, 0x0B839CED6AF0DF7FULL,
0xE6DECC20C8AA1081ULL, 0xD1EE552B5A8645A1ULL, 0xEE371B60116C463DULL, 0xA03C7E13F4CF091DULL,
0x1A0CB2072B372076ULL, 0xC9EB484BBE80DC04ULL, 0x9A3A3BA2FBE5F443ULL, 0xFD64BD38E681932FULL,
0x9CD2611EE67C1C2FULL, 0xC65FFB620A918851ULL, 0x4D7CFBA6A4FC43AEULL, 0x058BE7394A769751ULL,
0x971A8505B9CE165CULL, 0xA2D5B3959FA9A77DULL, 0xA8B7CC05A3506BCCULL, 0x50E8FD7882A26390ULL,
0xA3F28F6C035D9EDFULL, 0xB1C056EB222D7D92ULL, 0xA862869A9BBEDDEFULL, 0x8D6E0506D4779E0AULL,
0xA4A88AF157ECE74CULL, 0x155F6574F4BDE81DULL, 0xF337097C9B94D3D2ULL, 0x5FC4E80813C3CE71ULL,
	},
	{
0xD7E98B7728B09A6FULL, 0x9B975C400C92AE6CULL, 0xF0D8CDDE91E06792ULL, 0xC009C102908EB242ULL,
0x652BA5D1541CDEC5ULL, 0xC202ECFDCC7F25B0ULL, 0xAB1A5BF24D3C786FULL, 0x6AB6A4D5C07AE8DDULL,
0x731832AB86520108ULL, 0x220ACBB3D587C207ULL, 0xB791A4F748FF0D5BULL, 0xF9FDE98AF853F95FULL,
0xE7F0FB1FA0AAE53CULL, 0xD634C001C93215EEULL, 0x48F8E0CCB328AA76ULL, 0x2F479E843B7FDB63ULL,
0x299FE4348399B7EAULL, 0x8AB2E65D59D102F8ULL, 0x78EF4A3D8181F328ULL, 0x416AB7DC67B78BC3ULL,
0x9E9C6FE1BD731108ULL, 0x989511E344CFE921ULL, 0x354F052CBBD09BF6ULL, 0x80DFC571C876C80CULL,
0x6AE2CA9BA55DE108ULL, 0x8A517EEAC8779E92ULL, 0x58021DBE04CBC706ULL, 0xBBD2CF41A056BAC3ULL,
0x95F68E5E576EF906ULL, 0x068F8F535A3510BAULL, 0xB67EE98976B1BC3CULL, 0xFF022FFA0D6A99A0ULL,
0x0709A44247103F1DULL, 0x5E5C89AFA241AFD9ULL, 0x35C553C628A52E02ULL, 0x907686DBED8476A2ULL,
0x0427ED8F5C8CDFDDULL, 0x3BA4941201C105E7ULL, 0x3009DD8FF1B27BB3ULL, 0x410219D7A772C509ULL,
0x217C9D56D2CB0DEAULL, 0x2D0B63BE286719E0ULL, 0xB8D55B113E88A2A6ULL, 0x71AA40F4FE345337ULL,
0xCDB06B914A4C20BAULL, 0x0C0B5A857E748079ULL, 0x8CD7B6D50EEDCEE5ULL, 0x69CEB3F6531CBA71ULL,
0xE8570AC2C6512378ULL, 0x7A780AF6683D3B2FULL, 0xBA3143FD6FE3BC7FULL, 0xDB33D34DFBE98589ULL,
0x0F6B8919893B2512ULL, 0xF4485C49A81BC6C6ULL, 0x4E6B688D077B5A82ULL, 0xB0D6454491D68F68ULL,
0x90EA861E051FDA5DULL, 0x32B9C71463D7FA23ULL, 0x96EDA8B98767609BULL, 0x85A080765E985A79ULL,
0x2D7D65E155886369ULL, 0xDDC763C2927E968BULL, 0xC11B5C331B39C859ULL, 0x5FDF1C854C596204ULL,
0x1932EAA7F77444F8ULL, 0xC8F8C3C9D7B7AA4DULL, 0xE6F2967E27555B10ULL, 0x8EA1021BFD99A65DULL,
0xE755DE21B484E710ULL, 0x3879CEAF118326CAULL, 0xD54E0B46ED9AC565ULL, 0xC5DDD325F213F505ULL,
0x4E50B329F65A29BCULL, 0xEB901BC81D774ADCULL, 0x18B3F7BAECC1E17BULL, 0xD668245BDD8AADA5ULL,
0xF0A748FAF734E0E7ULL, 0xE96681BD9A62C2B1ULL, 0x1DB459F10F6928C5ULL, 0x9ED06106959004F4ULL,
0x980538F884B34868ULL, 0x4D22D4D9AB729DF7ULL, 0x71EBFF46FFE07E80ULL, 0x11FA72123B3F067DULL,
0x8F6057EE49D9C121ULL, 0x8E520D1601C47D7BULL, 0x728132C53597C3C6ULL, 0x709E815885E6D649ULL,
0x092D53DFD53E6852ULL, 0x02B44CEEB16D9923ULL, 0xF55414959153E652ULL, 0x1290723653AAF36FULL,
0xBEA8974DD0755A04ULL, 0x964C81F496F57F50ULL, 0xB9A5E3679D075ADFULL, 0x5CE8E866E51D7C87ULL,
0x3535DB111DA6AFA2ULL, 0xF6CA982F5244AEA4ULL, 0xAD63C0EAC46E342FULL, 0xC1EFF61E68C4B703ULL,
0x56D30FABD05C8BACULL, 0xAF4F79351C0A6B28ULL, 0x5407BA431B5147B5ULL, 0xE7ECCA6BBB995A65ULL,
0x4A9D871E3689C398ULL, 0xF17D5012FA926FDEULL, 0xDC031D87868410E4ULL, 0x53C0F8DC83786064ULL,
0xBA65884F66BAF8CDULL, 0x08DBCAEA1B0E5DAEULL, 0xAFC2653D5C95441FULL, 0x3457336308865AEBULL,
0xF267B4E3088431CCULL, 0xB5975369545908BCULL, 0x8F4942DFD3314251ULL, 0x2BEC8F8A728B9101ULL,
0x8803EAA74C1F4476ULL, 0xEB8E76ED18280520ULL, 0x7F5A9164CE3DDE27ULL, 0x3424AFDD4F3F6396ULL,
0x749A897A463BA274ULL, 0xB2B0F77857B11408ULL, 0x1B3838C9E5A223EAULL, 0xF9F76AA0868ABB2EULL,
0xD17346B9250658CFULL, 0x25BC3E6D20C85233ULL, 0x15F94BA4B6CD1508ULL, 0x4E74C6CB21BB7F79ULL,
0xA1BAF732F364539FULL, 0xCC432A03F86D48DAULL, 0xF870E7B3D6E28835ULL, 0x895668438AB159C7ULL,
0x5792F896DF6236E2ULL, 0xCD0C6E8737D141F5ULL, 0x68A7A278FAA89F37ULL, 0xFA6AC45A27F74362ULL,
0x013D237938D25D7CULL, 0xB5C8045FF0C980EDULL, 0x87F18AD129228353ULL, 0xC6CEB7987AD6A0D0ULL,
0x4B516ECA9D28CF55ULL, 0xD5145BD11EC040ABULL, 0x3489089B0DDF5960ULL, 0xCF0255BD245BEAF6ULL,
0xC50CADD6057D3F9DULL, 0x63D54F8B2911980BULL, 0x3BCF2352C0029E7DULL, 0x7ACB0D157651271CULL,
0x13AF11D0ABD56433ULL, 0xFAEB0EF3FBDCA5BAULL, 0xCA12F8BC92F65E69ULL, 0x87ED7603752BAEDAULL,
0x01F957D5FC8D3734ULL, 0x122E793B3C4DA46BULL, 0xA4F06C91C5DFF486ULL, 0x38B967D76FE908E7ULL,
0x98AFCC8208FFF3A8ULL, 0x85CBA2345D58C882ULL, 0xFD485A2E26B34875ULL, 0x7F6B2BE892ECD3CFULL,
	},
	{
0xD9590468C14B2EB5ULL, 0x6CEA93A82CEB2F9BULL, 0xC351CAEFF8F3BEF0ULL, 0xC3EBFA1A4ACAD276ULL,
0xE59228367BB73362ULL, 0x7D6AB4D4AFA87F6FULL, 0x071AEBE5A6C2AFB9ULL, 0x7911300203AA6842ULL,
0x55E19317389C73E6ULL, 0x6FC398402C1FAD08ULL, 0x0B284EED1A054AADULL, 0x9951E802A22EDD6DULL,
0xD9FF7D47B319DE51ULL, 0x1C42B2D4963A55ACULL, 0x3017950DD656FF29ULL, 0x954A14F3B81C3D1EULL,
0x960283AB3248DE1FULL, 0x5D56AE1897A2068FULL, 0x295FBDD1C9E9BB50ULL, 0x7631D687D3FE74B0ULL,
0x40B9D1872AF28F5BULL, 0x2F324DB3BC074F53ULL, 0xC6071C21F8BCC41AULL, 0xA47D7A0794822848ULL,
0xBA0962B7E96927CFULL, 0x34BCF1AC74D2C8FFULL, 0x9FFF7019826BE3FCULL, 0xEA626C578DC52459ULL,
0x466F876DB8A6676FULL, 0x9ED76E74B957F245ULL, 0x7EFE6EEC17C8E142ULL, 0x4F24F64265A26D04ULL,
0xDC8712723B8F20D5ULL, 0xB2FB33AE486C0242ULL, 0x7BF941C835186CFDULL, 0xA836DC02CBE22C5FULL,
0x31AFDAEDED742AEEULL, 0x6E24FABBD087128EULL, 0x3234C4BBB612FBA3ULL, 0xFD3B3914336F00A3ULL,
0x72C27AAAFEC84CC4ULL, 0x01187615833A41BFULL, 0x8ADD8E9F9887384AULL, 0x1BCE314A71726B36ULL,
0xD5DB71EC0300F46DULL, 0x22FABA5BD937AF48ULL, 0xF0400B0D02C4038BULL, 0xF8215027A76B61A3ULL,
0x723719B924B0CA22ULL, 0x77385A348BBA71BDULL, 0xF5942F4CE2A42F08ULL, 0xB777AF791D384170ULL,
0x0B260DB3D4DB7075ULL, 0x83C76DE9086FE87EULL, 0xC04F934CBA5E6696ULL, 0x81693E39F015A7D6ULL,
0xBB11F6712A7302AEULL, 0xF4B6FFC8E4C909C3ULL, 0xC01DF79E6FF9F80BULL, 0x7505C0B0BB8BEE64ULL,
0xAB91DD5D6710224AULL, 0x2A19964E15CD8E0DULL, 0x825F817734866AB1ULL, 0x5EBB62E3A1554D7EULL,
0x47A1731355DDA4A0ULL, 0x4D3FD50DF14F19FCULL, 0xAE4535B3D7FA175AULL, 0x0C29F63B553CE5C8ULL,
0x94DDF14B79B031A8ULL, 0x6A416D5D3DAAC786ULL, 0x767A7BDB1ECE321BULL, 0x5AAC337611E13171ULL,
0xA0DB813F3F6264E8ULL, 0x4AE9D7CDD4E5AF97ULL, 0x0D62B230EE4AF6ACULL, 0x5DD199E09B829E5DULL,
0x2F8E4F99A9544186ULL, 0x0FE58F5DA04C550FULL, 0xE8EF1BBF6481E867ULL, 0x3A95C4C5B5AC523EULL,
0x17CEB6E629270A77ULL, 0xC551C774F183122AULL, 0xE30BB16E310B56F0ULL, 0x947B5035B0E65988ULL,
0xFAE0298B9CAFCFDBULL, 0x6F9CD5A37E07E948ULL, 0x838E9F1AC36A987FULL, 0xA973A5FCF54DC24BULL,
0x4421C43DA30F4279ULL, 0x4DB3C82282265A17ULL, 0x00D375AE2426AACCULL, 0x79964BEFAF2763F7ULL,
0x9DBFB202BF149E5DULL, 0x4D8DE21ED06D1C2AULL, 0xC3DC5B458DA02BA5ULL, 0x97BA8C6E026854FAULL,
0x4788CAADFBBFBD9DULL, 0xF003F6BCD280DFE9ULL, 0x7D06C24B1994DA20ULL, 0x7FD592366A2A4F48ULL,
0xFCC714EC0801A443ULL, 0x1901DBEEC07576EBULL, 0x165770A918501176ULL, 0x9036506B291C84C8ULL,
0x564214C8FEB01656ULL, 0x89086DFF939A04B6ULL, 0x105EDFEBE6A6EE85ULL, 0x0291CFF5EFE2A4A2ULL,
0xD53A0FBA4FAA090AULL, 0xFD04DCF179AA18DEULL, 0x16A63F76578510EBULL, 0x81DFBB0F1E6A1271ULL,
0x0492AF377F330018ULL, 0x31783C91CD84D388ULL, 0xD8BFA1B4065428D4ULL, 0x3A19402D4537905EULL,
0x5CFAAACCB080A832ULL, 0x45FB9059DA4C7557ULL, 0x74D91D5226F5C25CULL, 0x7EB8A515CB9FDD14ULL,
0xD93962B1307D3FA2ULL, 0x3E0ECC13EDFEFBB6ULL, 0x00F3EB78A885FFA4ULL, 0x65172348DFF706A6ULL,
0x678593EA75BF9E06ULL, 0x9C3F823C8082AA8BULL, 0xFFA1CC0BBFC9327FULL, 0xEFA3E6A916BF734EULL,
0xA4F08EE74AB1EC39ULL, 0x54A639347421A44CULL, 0xCD6238EE2E5686CDULL, 0xA6E047695DB7E118ULL,
0x8FEC99AE16F45D59ULL, 0x93B6A028B481F176ULL, 0x538C314CDB672E70ULL, 0xBD42983A27EFDD66ULL,
0x1EE0667D7CEC79F0ULL, 0x165A1CC5B907986BULL, 0x8DCBA5E09369BFEDULL, 0x1AD721C0F7C67567ULL,
0xE7D1C7FEC08ACE49ULL, 0x10716AB1AFB6A6B6ULL, 0xAF39CF4A033CB8ADULL, 0xEDCC244CABDF2065ULL,
0x46210BF5AC490CE3ULL, 0xDE9645C4557A4CABULL, 0xF401F75E442A53E3ULL, 0x9CBFF8DA340F24FFULL,
0xAB5EA577E954F605ULL, 0x00405807C0F06C74ULL, 0x6C9C7E7B8D88271AULL, 0x37E9AA4C9333FA40ULL,
0x082D0FA6FFF2957FULL, 0x1735E476A49A3D7DULL, 0x4FA225EDE11D355AULL, 0xC61B9FF4530965A3ULL,
0x7A3F11E67514A789ULL, 0xE951E786CD8BE544ULL, 0x9F2DE845C7266A05ULL, 0x0A8C325CCEEF56F4ULL,
	},
	{
0x61ED53ABA3D49B99ULL, 0x90A8FCCE9854478EULL, 0x70730B7084A948B3ULL, 0xE0712DB723034A1AULL,
0x74C983D2F324BFC1ULL, 0xA5DBDD2D63DAF290ULL, 0x9E948DE45D20EC09ULL, 0x484EE76C0CE84084ULL,
0x50A57839B6942A4CULL, 0xE5AC89ACA5750370ULL, 0x545785C3B468CE1EULL, 0xB4CBA7304322A5CAULL,
0x5621830E04090D0CULL, 0xAFF80B5C173B9E8BULL, 0xA153D12F2751A160ULL, 0xA320C5542643F509ULL,
0x163AFA2743802C6FULL, 0xD270F9F95B3D1D39ULL, 0xC325E6A6815A9ECAULL, 0x6F8A91632B5254C4ULL,
0x5E06196493AFB2C5ULL, 0xFCADF51529BB9391ULL, 0x19A0E88298D2D41BULL, 0x8E61AC8F3F1D14A5ULL,
0xF68E899BD2D8A5B1ULL, 0x958E060AB2CA767BULL, 0xBD89E98AA19CB4B7ULL, 0x7D062168D7767432ULL,
0x45B6B503C0D0CEB3ULL, 0xEEF2A3B7F870433BULL, 0x86EEAB800BB5DE25ULL, 0x07A411D21766B360ULL,
0x3D3D5229EF3427E0ULL, 0x14C250F22635494FULL, 0x900E60B44266413AULL, 0xC0C71444AB5FAE05ULL,
0x44CBCE6474DD1DB9ULL, 0xB4500ECE2B23F7BBULL, 0x81D3399DE12C20DEULL, 0xC7BE9947424F833AULL,
0x0C1A80CB99823727ULL, 0xD90A1B991B404EB6ULL, 0x36DFC7723357977EULL, 0x3AE3F23CC8BA0995ULL,
0x722FCEBAEE89F49BULL, 0x7B7EB7A41D7956BCULL, 0x82397CCD1357941DULL, 0xF29ED263CAB8114FULL,
0xEEA8AACE8A19F754ULL, 0x1FBAE8CDEAFFBDFFULL, 0x267BD54B7EC08009ULL, 0x62586329A1F6B549ULL,
0x2A1C176B5952C1C1ULL, 0xFFF875CF251EFD46ULL, 0x4AA3ED377407FE36ULL, 0xBC2844B6549C3BF7ULL,
0xB29395C7BEC1A215ULL, 0x809D92520680A524ULL, 0xF9729232EEEA753CULL, 0xB46713C64A324933ULL,
0xF90FAA79F20997F3ULL, 0xEA99F4C634ECB49EULL, 0x785E15E6189254F8ULL, 0x820D4DBC3B7561E9ULL,
0x052BE085D5BA4641ULL, 0xA9094EF8B8751A2FULL, 0x831D6BB7006548D4ULL, 0xF8EAAC04022102B6ULL,
0x8BC9F3FA38614222ULL, 0x873962745D1AC02CULL, 0xB8BF5A7C7292C7B0ULL, 0xDAA94FB02DADCA5CULL,
0x55DE0D02B5C95012ULL, 0xABF929A703E1C599ULL, 0xC75CCB3AC14DB270ULL, 0xBBB3565E81FB7927ULL,
0x24443489AD736025ULL, 0x4F41CEC6A861C456ULL, 0x235C7DE495B9F22EULL, 0x18D9B15FC503C62BULL,
0x7DB16B55033F5A6DULL, 0x672C69771FC045B3ULL, 0x574BAD1E1D97470FULL, 0x7AE1582680634B6EULL,
0x13B00CB59F4C0C7FULL, 0xC949BC42D629C669ULL, 0x39476A052A94B8C0ULL, 0xC4D72EF89BF709F3ULL,
0xABBD65A4E208C921ULL, 0x7D3C6AC00FB1EAFDULL, 0x92FFB8FA185C5992ULL, 0x0A3F3ADDF65146A8ULL,
0xB96BA97981778B1CULL, 0x3DB3619671B3C578ULL, 0x0947B8718E584D3CULL, 0x8A14FBDF6034C139ULL,
0x16A5AD1784AFAC2BULL, 0x64B6692AD99F4D93ULL, 0x50405AC772214442ULL, 0xAB9B06809FFD85CAULL,
0x86FC11A652858118ULL, 0xC0411C29C6406C3DULL, 0xF9137C199FABDCFEULL, 0x1A10358061FBDA8DULL,
0xF312C7C8086E6BF5ULL, 0x0C39BAC1D86F3B89ULL, 0x66415D1B3C209B4EULL, 0x5C1F0CDD3AC70A44ULL,
0x890E145B8E98357EULL, 0x0EB193AF30415BFDULL, 0xB389CBFFB86F67E8ULL, 0x8438271F20880CA6ULL,
0x2F2D7FB81E32BE9BULL, 0x9389FC06ABA5804BULL, 0x9E5D8452D894C84EULL, 0xD6AFC5E400274DA1ULL,
0xF56658772EEC5B0BULL, 0xC4580EBD4B789068ULL, 0xBBEE8EE8548B4068ULL, 0x82BBDEAD53831489ULL,
0x731AB2BE00AA662DULL, 0x99B2AD03440F0507ULL, 0x89CEAAC5E8038EC6ULL, 0xCB3E3CF8DD8E4C28ULL,
0x3DE20D073665E2F1ULL, 0x62BB78557E2D5C7EULL, 0x2622080EE5B7B47AULL, 0x3C699295F165ACABULL,
0xE66E037A374D37EEULL, 0xA019BF598D74CA07ULL, 0xBC69DDFBA388F9A7ULL, 0xCB2D8F43E9588881ULL,
0x2872BABC4B125897ULL, 0xAF29967D614D806DULL, 0xF3DCA4D154425FA6ULL, 0xFB885892B2E6BD10ULL,
0x3AAFEB49A669EC99ULL, 0x029C955835373917ULL, 0xEC58FCDB241B31D3ULL, 0x6AA1FB0794B18856ULL,
0x6C0DB658DCBF465BULL, 0xE555F1D1859CD877ULL, 0x96E58B6AACE1A604ULL, 0x59B4AD829362446EULL,
0x7AC9AD346C2739A2ULL, 0x04AAF20A0E0650E5ULL, 0x76D056DC16DEBD9BULL, 0x16DEFFF01A8149F5ULL,
0x52B3B42758772356ULL, 0x3EEFEE1115DC24D2ULL, 0x18526A9E7B73D841ULL, 0x60B24E35CE467A53ULL,
0x1F8AA9E30A99B376ULL, 0x735C5A4C90812967ULL, 0xC9D3CC3B5E64A945ULL, 0x21A51065AB5632EFULL,
0xE060FC6DE9144A1DULL, 0x504193B6D5F76A88ULL, 0x64BC0A6D52D3809CULL, 0x2050E13DD97CAA3FULL,
	},
	{
0xCC04024CC8469628ULL, 0xF77AB69A3B7339C0ULL, 0x7615CE785412CE31ULL, 0xC8219FDC3067AE1EULL,
0x3FE3FB801B229134ULL, 0xD0EC5D93F058FD5BULL, 0xEB7EB2AB4247D1C1ULL, 0xC23146F11BFC6A88ULL,
0x35C3B32743BBE21CULL, 0x9EAC9F5101228F65ULL, 0x135361C9DA77ACE3ULL, 0x7D4A43775CCB55DBULL,
0x85A43334AAB8E32DULL, 0xE0E822F048E27294ULL, 0xEC371E01ED43B7F3ULL, 0x8FA4583B29A07297ULL,
0x7B1A3E7CCA3436BDULL, 0xAC99B27E0A1E07F6ULL, 0xAD4599F21F5441DBULL, 0x98234BE19AAEE40CULL,
0x1E7AFBCD2554CAA1ULL, 0xC40057D9EEF217D5ULL, 0x35AC3ADCC665E47BULL, 0x39E8AD042CCEA553ULL,
0x6E24D1888004E9C6ULL, 0x0C7DAE5298ACA70EULL, 0xDADE97E158FE07BCULL, 0x4BA61FA1CEB1352FULL,
0xB4DB9ABBCBF12CF6ULL, 0x5EB1221483D4F9B8ULL, 0x62587F4285E4843EULL, 0xD7D60CB9DD0137D1ULL,
0x6A349EC67FAE5BB9ULL, 0xEDF9164E45ACE440ULL, 0x33F20AA4484096ADULL, 0xCABCCD3EB2814F79ULL,
0x4A15F4814D1A8E5DULL, 0xC4422B1F6823CBDCULL, 0x11D28B558D7594C1ULL, 0x6B40A948B115AD09ULL,
0x904F39E26BEB2224ULL, 0x0F271C4F693FF76FULL, 0xE2E9579C41AB14D6ULL, 0xFB994486E8C3196FULL,
0x8543C92DED795091ULL, 0x3B68F1BFA2F411C4ULL, 0x5D07C204D8137931ULL, 0x1ECF50F6C1AF78FBULL,
0xC8A5D4A7CEB77AE0ULL, 0x1BB67AA72076FE38ULL, 0x9B82C3B3A3DA0FE5ULL, 0xE013A0E74DFA0993ULL,
0x074A11C7BD5F7A9BULL, 0x97D44C94A5FB60BEULL, 0xEF7222BD96CD385EULL, 0x78E0F13028AADCD0ULL,
0x090EDCF4C5598858ULL, 0xA105BF2B6FF67A51ULL, 0x76841D873ABE3F8EULL, 0x32FF04BF06724EFDULL,
0x43D1FEC05B4C8996ULL, 0x68D79DAC6EBB3AC2ULL, 0x4559E41EFA8DE3C2ULL, 0x0355EA5A5D807BF9ULL,
0x60807BAD796ED6C6ULL, 0x173C874303A7A8EBULL, 0x328068A20FECB112ULL, 0xBA8985AFC92DF301ULL,
0x5F3B176CC37ECA6DULL, 0x7CF8371284AC0250ULL, 0x8F034FA8AADFA782ULL, 0xE879B4A40EB32A57ULL,
0x478A74AEE6F6AA76ULL, 0x7F652D020B5C3314ULL, 0x598409AA27E0DBBAULL, 0xCF8EA9EAE7C873D4ULL,
0x91A4FA6CAC75BC9EULL, 0x3A8B70615465875DULL, 0xB8F65E7169C3036EULL, 0x04D455DAF8387358ULL,
0xB5D1E7BD6F56970BULL, 0x16886532B47EB718ULL, 0xCBDCF391AC4B1E5EULL, 0x99F8F68B93695825ULL,
0x8ED83F25F081FE00ULL, 0x4D52ED5767CAAD27ULL, 0x192F96D66470AD05ULL, 0xEE07283836E05A19ULL,
0x7C867278B96ADFBEULL, 0x9DC54E6AC0B3AAE6ULL, 0x2FC555CA035D25E4ULL, 0x82150EE2DEA93BCAULL,
0x734CF82F844C3F80ULL, 0x290F9568FB32A923ULL, 0x415CAB2CB1209A76ULL, 0x6EA5723B98C4D28DULL,
0x65E4334E5E8C20A1ULL, 0xB76A711DB98D176FULL, 0xC62C4B7A540FBCC5ULL, 0x56F4E4CEFC7BD55AULL,
0xB61C56C97A61C2E4ULL, 0xE127BC4D6F905AD9ULL, 0x7618597379DDB6A4ULL, 0xF70E4F736AAD739AULL,
0x99A62D6BE49DC0E0ULL, 0xD91430AE412FAD0AULL, 0x24670BA8F76B838DULL, 0xA9BC7A043C1774D2ULL,
0xA003EF4993BAE18FULL, 0xD532FB9819A33CC7ULL, 0x4B200C095446BE24ULL, 0x83476A54427FE23CULL,
0xC6838DAE8511AE04ULL, 0x52C12D83FFFAB0D4ULL, 0x52EC1A7456DA125DULL, 0xDE0AB26C41E77B37ULL,
0xC7531E92DD471C42ULL, 0xB29E3D45EE196E41ULL, 0xE493BB58465CC544ULL, 0x75D9070B46A275A8ULL,
0x90A8509740F6E037ULL, 0xEAF31814AF364314ULL, 0xD10FFB43B768036EULL, 0x6F45B76CFD6D4B36ULL,
0x10F31081DA7933DEULL, 0x4B42774D8ABF5659ULL, 0x5D29908EF84CE708ULL, 0xE7A5DF4C726D946EULL,
0xC532C93DC2012782ULL, 0x8FBF74FFC0BD7E9CULL, 0xFDBAE3F572146690ULL, 0xEAFF6C3BDC2F32CAULL,
0xB654E761BCCBCB26ULL, 0xC0FE98381CA55FBBULL, 0xD16DC94993399D2FULL, 0xECC04F2757904A9BULL,
0xD2A9893D8898C211ULL, 0x9CF4D21923A2F12AULL, 0x6527F11419161DB3ULL, 0x204A7336B9A2CDDAULL,
0xD0708460284F117FULL, 0x865024ADA34E4D90ULL, 0x8FF75C4ECD044135ULL, 0x4E5152D9DC7E98DAULL,
0x067629AFE6DA3B75ULL, 0x3727EC81A5E1ECCDULL, 0x739C5B0B0A2DA25FULL, 0x0414442F0C1161DFULL,
0xE7C270FA0534F6B7ULL, 0xB3F1060610D6A964ULL, 0xEEA6DF37A1183655ULL, 0x3963D59E77D5FC97ULL,
0x0F62751548AA14E6ULL, 0x3BDA47B273023245ULL, 0x0D212C51EDE2B440ULL, 0xCA7FD3C0CE89B27FULL,
0x093F6974DE5367C1ULL, 0x336D09E4C71DCA02ULL, 0x44DB2D2936333C88ULL, 0x62C7D18368CDB121ULL,
	},
	{
0xF138343891991BEBULL, 0x439460975A5F7789ULL, 0x872DD1C59D5E9E44ULL, 0x0B756D7A283AC6DAULL,
0x33FDE58E74BC1099ULL, 0xC3971FC76E238008ULL, 0x27C1442E4E9BEFD3ULL, 0x1646B6E9C313B8A9ULL,
0xAC78E4FCED2CABD1ULL, 0x76DAC050FECFD508ULL, 0x67113315F844AFD5ULL, 0x6547DD472B7D148DULL,
0x4F7F8509254C001BULL, 0x65A2B43A4A3C89E2ULL, 0x31E1BEA8106A4A6DULL, 0x631395D83CE936CFULL,
0x0FEF5C9ED1967DABULL, 0xCF341F0782705DDEULL, 0xA720ADD527BABA8AULL, 0x4FDEA89DF6647E38ULL,
0xB555CAC78B16B611ULL, 0x36C3A6456FB4D84CULL, 0x52EFEF35977B748BULL, 0x4F752E1DEDBFCC37ULL,
0xDE9B36FE06229A02ULL, 0xC9B0C2D8FE19DCFDULL, 0x844162F6DE346B73ULL, 0x2701228028B7A5F7ULL,
0x5DD836FC9A3B0249ULL, 0x1C234C1C7B759A29ULL, 0x8A1336C8C01321D4ULL, 0x47AE26E4C106F74AULL,
0x5A2C0306D02894D8ULL, 0x78F535B68AD3F0B3ULL, 0xE5325CD67FFCF74FULL, 0x032189FAF86AB887ULL,
0xE4B1E1C3EB495705ULL, 0x41F2B9371255B7CEULL, 0xBB92E6B9C65223BEULL, 0x06B9F0E9A1A9F841ULL,
0xED817499A3137DE4ULL, 0x1D65647EA88B7D10ULL, 0x1A464D750A781109ULL, 0x7AB6396E037E09E6ULL,
0xC5D30D8881CA4DC3ULL, 0xEE06C5DF463FA1DFULL, 0xD2FEEF7993FA048FULL, 0x62226E4A9A7DDA47ULL,
0x9C23778A9D6B19D5ULL, 0xD230AF0D41B4F749ULL, 0x02214DA368774941ULL, 0x1899E6E95EF1AAF6ULL,
0x9F78DA7D9FC9B4F6ULL, 0xA77247C7D85A3938ULL, 0x8A77D046BB394B5DULL, 0x0AE2EB5673A6B59CULL,
0xB6B9A38952E1E497ULL, 0xCF72694ECBF50A16ULL, 0x136B1D36B37D56C9ULL, 0x075A757162AA781EULL,
0xF9169B0E265EA6D0ULL, 0x3322FB99D8374FC7ULL, 0x56DF47D89E78E916ULL, 0xC338E8634D03AAB7ULL,
0x5487911863575C91ULL, 0xC14D4D4F05D21316ULL, 0xCB926437E208C828ULL, 0x719ED75FB25B20ECULL,
0x0F5E4951033928FFULL, 0xE5749F891FF84276ULL, 0xF91C4618451F4E7CULL, 0x8985349DB5981668ULL,
0x11E98F7E5EEC16EBULL, 0xB4025E51D156F934ULL, 0x027F751962DC9E1CULL, 0x177881A70372A8BAULL,
0x25339D782B29D574ULL, 0xC8D2BEE92D7C2C06ULL, 0x34499ECE5D61AB2CULL, 0x3824D9D9BFF67EF9ULL,
0x93C93BB477031CCCULL, 0x150ABCD9ABBFDC02ULL, 0xA3500FE725504F1FULL, 0x98C0F0322001E04BULL,
0xD9A44542A1A90C1EULL, 0x194BAEB8D88930F6ULL, 0x28F8FD56EB09D599ULL, 0x1A44596693AABA50ULL,
0x501A785D7C53119EULL, 0x4932EBC542241C23ULL, 0x4A16A67A8E93B3E4ULL, 0xF474BB2EA6A75872ULL,
0x02E9BC710D6B2DB3ULL, 0x952F3B3765F26462ULL, 0xD5649950233E5C17ULL, 0xF5C3B9E2FBA1CD14ULL,
0x1B5546B4A9E8A251ULL, 0x57B2065CA3213CA6ULL, 0x468AA1A6DBF95CDBULL, 0xBD09BD5B077B4DB0ULL,
0x8E59463659DC5F6DULL, 0x22A8867777C9C5E7ULL, 0x3AB42C52F5553ED5ULL, 0x0A08E60A719502CAULL,
0xFAEF007FBD35BD9BULL, 0x2A4D67618D851D6EULL, 0x83CA27707246D0B5ULL, 0x81CCCB653DF60CD8ULL,
0xE56787A9E5B557CEULL, 0x4A5597F15A7FD885ULL, 0xA72EA89DC091D2E5ULL, 0x83DCDC8A2678BEFBULL,
0xBCD67303DB1B153BULL, 0xE26441255BF20E8EULL, 0xD514E24099F433E3ULL, 0xED3A7C2FC7DC50B0ULL,
0x57994336BE81B463ULL, 0x06E01D122F18527DULL, 0xA57230CCB6F84E39ULL, 0xE64430D287DB8755ULL,
0xD3E95AF2C1F1683CULL, 0xC313A6960D943CB1ULL, 0x277B49102882D91BULL, 0x1858822B59261897ULL,
0x0986B51469285884ULL, 0x69A0DAD0724D663AULL, 0x10B8D0856D127CAAULL, 0xE85D5CE8C25BC6CAULL,
0xF974C160C8921634ULL, 0x304E8557EBBEF678ULL, 0x18A8E8A196B93AD8ULL, 0x931015A7CCEF781EULL,
0xE8CC10B2B7785518ULL, 0x9429503C60BA242CULL, 0xCE05762F16BD1DF5ULL, 0x48336438C10AC9B9ULL,
0x13A7B9B62A637B8AULL, 0x42F410CC4C9F4ADDULL, 0x728E2DAB03FADDDAULL, 0xA188F021D35ADFB5ULL,
0x250E9F2C2AB2D954ULL, 0x86EF0A14B80775AFULL, 0xAA6AADA1F0F06CC0ULL, 0x129F476629D77307ULL,
0xE11300A0206296B3ULL, 0x71F11E2FF2E48095ULL, 0x0C263010A6879CAEULL, 0x2E7F5899DC7E5E44ULL,
0xADE9FEBB6310AC80ULL, 0x44D92752551430EAULL, 0xDE399BD358894E9CULL, 0xE01CC924D6FB2A4AULL,
0xE923FC034729767AULL, 0xD051F1A28A67E672ULL, 0x8F2BFF0D28CBDC2BULL, 0xF2A5C0E5C04F5BD3ULL,
0x35F4032C1C52B0B8ULL, 0xCBE18EC42F1FC5B4ULL, 0xB542BB960E13AD07ULL, 0x86A503FF4D6282E4ULL,
	},
	{
0xB61BA8FC9F7E41A6ULL, 0x507967B7BE5E9AE2ULL, 0xCF93AA7EF7A27407ULL, 0xD89DB12E839822C8ULL,
0xF9FC5C78630A0115ULL, 0x69EFFC7B25BCE77EULL, 0x00F6AE5BDAB2D684ULL, 0xE99D60ECFC839978ULL,
0x9C98DF903B5E1944ULL, 0x733668496BF56D39ULL, 0x31063A484D649A30ULL, 0xC08D1DD9AC021F12ULL,
0x340F5130FA9A8FA8ULL, 0x337137F65A755D5BULL, 0xF8C1196133D4B7C9ULL, 0x06D19AB7A79AF711ULL,
0xE6403663EED0FD51ULL, 0x8635F29A08D146EEULL, 0xCC3C121734923763ULL, 0x6B936E209FDD7560ULL,
0x1CE0E6C66F75A2C3ULL, 0xACE9ADCFF0C7560CULL, 0x511EB5CC078C412EULL, 0x142EDA0B1384D7AFULL,
0xA19A4181E30261F2ULL, 0xF5776EB449BE378AULL, 0x8BB285688FA734E6ULL, 0x386AB48AC4826BB6ULL,
0x4F4FD3C2B1CB6F63ULL, 0xB35410B070A58207ULL, 0xAF8DB400D415B8E5ULL, 0x87894ADBD40D0357ULL,
0xC55FD9C6DB08CB6DULL, 0xC7D8AB04615CC564ULL, 0xA0BE10732E51F1D7ULL, 0x333457AF2A8FF7A3ULL,
0xCA0BC3582116D4A6ULL, 0x36F2AE128685A19CULL, 0x72A4DF1641E05418ULL, 0xBD2B65BA109D3BC9ULL,
0x48EE24DB01E5846BULL, 0x8525317264C88600ULL, 0x7145AC5D92B7BFAFULL, 0xE4D7378B1DCE40E2ULL,
0x1A863DDCF0A42691ULL, 0xDBE42BCCE692F9DAULL, 0x8246618BCF5DD7F1ULL, 0x51A90DA3E29BABA5ULL,
0x01CE7E1E85979D39ULL, 0x31398D6C4D418F71ULL, 0xEA74246623C3C7C6ULL, 0xD752E3D2F2211CFFULL,
0x8CF6B235992581CBULL, 0xEFC576A90CCDE270ULL, 0xC4DDCAF129C7E395ULL, 0x70C6FED430DF8E8CULL,
0xC622C09A7F1FB40DULL, 0xDC1502FE16D742B9ULL, 0xB881EC214C72D9D2ULL, 0x4F1C633D8D6B03F8ULL,
0xE149204ED7302866ULL, 0x344661F95A3DEC90ULL, 0xB995D6A4B2E9632DULL, 0x99420E9A88149241ULL,
0x542371F7A78D0643ULL, 0x46FE36DF7C12EF31ULL, 0xE35CF6A00814A36BULL, 0xB97A0BE22E7DFDDEULL,
0x0526E489B6CF679CULL, 0xFEC278210F1722CDULL, 0xB793737CB3EFABE1ULL, 0x55BCBC25702870CBULL,
0x7E9F4E6D5A084AA4ULL, 0x1E924788CE9FCEE4ULL, 0x50700EAB5B9FD08EULL, 0x4FDBEC81F0FB0977ULL,
0x52DE24302C098694ULL, 0x2CE17C31A1E9E204ULL, 0x52358C7CBD2BC0E0ULL, 0x6A8B925BBEB24398ULL,
0x1E6FB5B362DAD4A4ULL, 0x49E3D7436CF5DBF5ULL, 0xA95A2FED3BF49519ULL, 0x703246D98E4B7BE2ULL,
0xD56E5AE5B86C3E22ULL, 0x6E281C71F3C2CB39ULL, 0x62461286B2DF415DULL, 0xF894DAA766600FA0ULL,
0x48F078F71B7880A9ULL, 0xCE94873C5507FF01ULL, 0x27A1612D612C1F57ULL, 0x2A4F9AF9DB7BD936ULL,
0x1176891B9D98398AULL, 0x629D55F7E15E4E79ULL, 0x343AC70D070B7F95ULL, 0x152920D1435B0A83ULL,
0x4B8089C8538EE947ULL, 0xC9F0639653E4167FULL, 0xC5768F7786DF7377ULL, 0x8239C391842DA627ULL,
0xD330837F1CC62043ULL, 0x0E580937B14E4EBDULL, 0x5B6947C7A03440CFULL, 0x56DE07C764B918B1ULL,
0xEBF80A1087066586ULL, 0xFF06C07A526B5724ULL, 0x5368EA55996F3018ULL, 0xE78AA3468282B2A7ULL,
0x816FE36F4355A8B6ULL, 0x22243F95DF245ECEULL, 0xAA48DB60ED2CA65EULL, 0xD767EF7852DF0485ULL,
0x6E243D00E1155023ULL, 0x79C1082D3EEC8544ULL, 0xF32041015053BBC3ULL, 0x61C7E303D4015D87ULL,
0x7597186EC4533404ULL, 0x9913A1F8C39E1724ULL, 0xCFA67F27A5E1BFA5ULL, 0x2A70EBA1D2F2EE6DULL,
0xDE3CD9048C4617D1ULL, 0xC705FA1E13D98733ULL, 0x771DE090B5625B72ULL, 0xF1BA414AEB855118ULL,
0xD8961A8F5F0872C5ULL, 0x2B1FA05D99CA04CAULL, 0x18DEB5C8B9244515ULL, 0xC97A8B9DA73B760AULL,
0x20623AB8CF7F987EULL, 0x41C4DAF97B6CD0AAULL, 0x276B732D191AB210ULL, 0xA7CDF289602138D1ULL,
0x84DF3DEF527D92CAULL, 0x14BDCA656139B13CULL, 0xD91C96F7E773FC33ULL, 0x74AEF33FCC951C50ULL,
0x451BF8D4780F3D90ULL, 0xF51E15BA90532726ULL, 0x6B5F6044F3EB28FCULL, 0xEF6492685911EFEFULL,
0x6D64A7225E0875E1ULL, 0xB37CD8EA1D214351ULL, 0xF58CA0268AC44497ULL, 0x08C1C49CB4D65EABULL,
0xA2C3592310B76D2BULL, 0x9377CDBE3B593F4CULL, 0xD84F2DB93482C189ULL, 0x8F37261E369FA913ULL,
0x098FE0A6CED87195ULL, 0x779BE892F08A3915ULL, 0x169FC6360B4D4DF2ULL, 0x49C35AE0FE380B1EULL,
0x3412267465B4BC74ULL, 0x0291E1D8AE0FB347ULL, 0x255062157B13CF83ULL, 0xDEA9AFC2F8118EECULL,
0x463F11541A7B17F2ULL, 0xAAA6655F977ABAAEULL, 0xFE3A48288152770BULL, 0x2303D62127C34D68ULL,
	},
	{
0xD5F8FC83E0224217ULL, 0xFAB9930E23A3A11EULL, 0x77C25DF2E4979D98ULL, 0xFB3EE7FFE534E94EULL,
0x324D2FAB2CECBEDAULL, 0x0EE6F817ECE49810ULL, 0x8C2727D819196E2DULL, 0xC68B448980871A7EULL,
0xDA50463B23E3AC64ULL, 0x69719424719CA058ULL, 0x78EBA14956B1B051ULL, 0xA3FDFBF5E15BFBA2ULL,
0x68DDA2589BE0E8D1ULL, 0x961F81B71698F174ULL, 0x005760420F266D39ULL, 0x95284C80B3B6FFD2ULL,
0x618B844112CBFC04ULL, 0x0DDA989F760876BCULL, 0xD7FD28E83FC6E633ULL, 0xF4CFABA1AB5AA4C3ULL,
0x122D6F723DFD0BAFULL, 0x1C84D5E5B572C1DEULL, 0x6A9F1BD531445B9CULL, 0x99C2273C46D5354DULL,
0x18646450AED1217EULL, 0x1814DC7F7F18CDB7ULL, 0x2CB645611E41C681ULL, 0xA18AB414B08184E1ULL,
0xB84E1756006A9468ULL, 0xE60E47C863D4729BULL, 0x507FD6F1D58D75DCULL, 0x7FE842852278A4D6ULL,
0x71408EC643AEA623ULL, 0x0C51C8B8AA67ACF0ULL, 0xE6A8934DAD1BC081ULL, 0x302BB27E7281D4A4ULL,
0x7D9ACFDE9E74A5BEULL, 0xCA3446E2D13F1741ULL, 0xB88936F55AAB3CA3ULL, 0xA558FFC5AAE72DFEULL,
0x2AAA849252E62858ULL, 0xF6F67E3C47A938A4ULL, 0x68F3E57E87242E03ULL, 0xD62A3F7CD553CDD0ULL,
0x35ACC2CCA4182905ULL, 0xA28BD2A023838890ULL, 0xA896E4F131A51BC3ULL, 0x01DE47E45C887B22ULL,
0x9ACF5E2A4CD420D0ULL, 0xB5B05219D853490EULL, 0x8AF9302E374BBEDDULL, 0x0ADA1B70AA250CE2ULL,
0x835E6D457D9267E1ULL, 0x0E5F1EEF34E49854ULL, 0x4904A95594A6BA3AULL, 0x04287012E54A0F8AULL,
0x3FF2EB7B96B270CFULL, 0xD58EBA7F2C455AC4ULL, 0xFE20F53235E9CD73ULL, 0x4EBDEBD0F7426BB5ULL,
0x7BBFA03B13DEAF0AULL, 0x0B4AE9CB2F49DE48ULL, 0x2CEC48AA6AC97332ULL, 0xE3A2EF9C3B100E8DULL,
0x15EEB4D95DA53972ULL, 0x861E2CDA1B74581CULL, 0x1886B12F530F1C36ULL, 0xA7E109757CFED525ULL,
0x4E11A1E3764A7A0FULL, 0xE2D201D404609DF5ULL, 0x3F62A13CD8E37802ULL, 0xE75266C02F173BB3ULL,
0x30A85CF8B6C57BEBULL, 0x21826CE35C94BB8EULL, 0x84C0C9C90DC77C26ULL, 0x5339DFF3F79C91AFULL,
0x70BEF02710FBA815ULL, 0xED007DDD42CD4599ULL, 0xD5A989D2FF4A1B34ULL, 0x21B1767BFE66B3D6ULL,
0x1B91E3D48C2902C4ULL, 0xC991CCADF8C38B14ULL, 0x568E7CD65869DC54ULL, 0x2AF95DE89E3E8D12ULL,
0xD3572417F07C399DULL, 0xA7FB2581C8530603ULL, 0x666EF15E64A6C480ULL, 0x2184E95E5F31DF44ULL,
0x7E174AABD6EE1422ULL, 0x99E9DDBEDC31AC8DULL, 0x049B508E49DB4264ULL, 0x41EEF64B5ECA14F5ULL,
0x958C765A92431742ULL, 0xA4A28AB3D0FB037BULL, 0x6607BFAD8DB30DD8ULL, 0x17B6AD5E8B4B1CE5ULL,
0x852818EDA6466D09ULL, 0xEF11131A03CD1320ULL, 0xC73384C03BE22C11ULL, 0x33D7B2C556D59085ULL,
0xC32464A4C23B617EULL, 0xC8275450E3429F9FULL, 0xC7A6F71C420F8961ULL, 0xF2321EA9C788A655ULL,
0x91A5422C737C059BULL, 0x428CD45CC7EC459DULL, 0xDBFE0505D66AD9ACULL, 0xAAC5D6FC098FB11BULL,
0x94F9F8220553C96CULL, 0x62A739B2193F5C4AULL, 0xA3979749FE03B078ULL, 0xEBC02375E82C2D0EULL,
0xABE1ED0F43031E58ULL, 0x1BF881C2C3F3BDDEULL, 0x2EBD5BEB87CC01A0ULL, 0x996B94E9D2AB9BD8ULL,
0xB6F52CF211057286ULL, 0x9AC72F4146D3D76EULL, 0x827BC0C3114F7BB5ULL, 0x10DB98D25255B085ULL,
0x3C189B45127C1667ULL, 0x9725E942DB06A12CULL, 0xE6FD2730EA1F6CF4ULL, 0xAA815229164B8C4EULL,
0x1304FA90CFDDDD6CULL, 0xAE4844077CCB6001ULL, 0xCD8099C0EAF223EEULL, 0x398C907EFA610D4FULL,
0x87E8327613C48AD2ULL, 0xFF31AC9ED9AA519DULL, 0x5ADA8CED957DFCCCULL, 0x651AFE51ADE6701DULL,
0xA1177D4D73095BA3ULL, 0x87AAB03F6912A3D6ULL, 0xE39873CC11F48C36ULL, 0xF845DFB6DF5EC540ULL,
0x74D0663634FB3ECAULL, 0xFE9F186F3475587BULL, 0xE6B031CDDF4E98E9ULL, 0x85FEFA3A1237FB96ULL,
0xBC18C0BB10DE8C59ULL, 0x28BF94E813D3F682ULL, 0x53BCB27A4B30D4E0ULL, 0xFDBD7F08836E8090ULL,
0x0FA502F4758F4CE9ULL, 0xE477EC4063B729A0ULL, 0x29DC303B06948731ULL, 0x0E05105AC225B75FULL,
0x7BE5AB2550666224ULL, 0x6A45EC5979ACB13FULL, 0xBC1BF31B6C209783ULL, 0x71C33B25E134C7FBULL,
0x590E99F088452173ULL, 0x7E5793985C223FDDULL, 0x287290974D32AC2CULL, 0x8571FE1266AA8714ULL,
0x944C89FDA1E531C9ULL, 0x90852BD282CF2BCCULL, 0xCE5CF56B5AA34BF8ULL, 0xC12036B35E4077E4ULL,
	},
	{
0xEE9527DBE1EECCB5ULL, 0x27B0D094E71465B1ULL, 0x68943A5A9A5662D8ULL, 0x1C329624BF17ED74ULL,
0xF0AA14433ECFBDE4ULL, 0xD40CBF77C45A9840ULL, 0x79913AC2D00B8DF8ULL, 0xCC698C115B032AF9ULL,
0x11E76E973B2885FEULL, 0xE7A8EECC22194101ULL, 0x1078B40878067E76ULL, 0x054EC0AE5A82EC3DULL,
0x345B460486876C7EULL, 0x87B39CA3F74EE0F1ULL, 0x54F579F90855DCDBULL, 0xE9050EB72386D75EULL,
0x030A160C9BE81914ULL, 0x5A71C1A4A4D2673FULL, 0xA9695FA02CE31AC7ULL, 0x29931DC145B34384ULL,
0x50D8345F2504F7D7ULL, 0x51835CA75D3A66F5ULL, 0x284AD440C843801DULL, 0x2E216D1D9D557499ULL,
0x57929F2F0DD55BA7ULL, 0xC171231C8C344905ULL, 0x7010ED51F72F16D1ULL, 0x5C1F17FF705A7BEFULL,
0x04095513BD4B2FA6ULL, 0xC3964F2F02525BBAULL, 0x8AB9267A2BB5665BULL, 0x212F2BE1EA30BEBEULL,
0xBC3C9F63283548E0ULL, 0x1F5C84B2EA43E08EULL, 0xFDE3609DB5192FCBULL, 0x9AEEAA359BA3638AULL,
0x4C9CF823B364A917ULL, 0x37C605CDCC8D7963ULL, 0x5075E8D549769B86ULL, 0xF98C8E53E3A82775ULL,
0xE964746919F643A4ULL, 0xBA55B07126B1961DULL, 0x92E1908A660089A1ULL, 0xFA3770AE66205C65ULL,
0x70FEDC4CCCE41595ULL, 0x0C427D8D5AC7C3A9ULL, 0xB6F71F7A9B0BF5E5ULL, 0x165EA04BF58A111FULL,
0x5C84D95680B7A1D3ULL, 0xB3027B09FC8FFD5BULL, 0xC44DA8D318BEA073ULL, 0x44C4CB8094B0A438ULL,
0x0B53E475DE792288ULL, 0x352D7985C0F161BDULL, 0x36398C43117A6C12ULL, 0x696990F4754542F4ULL,
0x56ACDC7E8CD4008DULL, 0x30A9E6DA94F7EBBAULL, 0x10642C1BC6F62319ULL, 0xD14B91E318701504ULL,
0x9A746E21066E6218ULL, 0xA3368E65A137112CULL, 0x76EBA16957139403ULL, 0x56EEDEA5F6591628ULL,
0x9FFBB66FF26EE173ULL, 0xA247380D3EB267D6ULL, 0xD71AF71F9D5B36A4ULL, 0x0CCBD67F519EDEB7ULL,
0x17E5C8E0F43CBCEEULL, 0xFF325F102229B1BBULL, 0xEDB4B539BE3DCB05ULL, 0x8A81D3AF1BBFDC0AULL,
0x901A01DA277610E8ULL, 0x94AF799E42E4F1DAULL, 0x37D4C4E830F8A2E0ULL, 0x39E53CC30F85B9CBULL,
0x12D34EC3BD11ECFAULL, 0x3AB58A2741EB6A51ULL, 0x9B65F6C35D3E86C4ULL, 0x40E4D4316652FD28ULL,
0xDBB6D48D6EB75554ULL, 0x9DA0F37856B7A4E0ULL, 0x5422B3FC218167D8ULL, 0xE5355F32CD6A12EBULL,
0xD00A9DCFBD57812DULL, 0x75AFC89C0658E6D3ULL, 0x7238A391D7054F48ULL, 0x86E4FCE780375172ULL,
0xA6FA395F2FE2E766ULL, 0xDBDE117D2A06B151ULL, 0x77754C91A8943C54ULL, 0x8EADC6B7AC73AF93ULL,
0xEEF1726C0745EA44ULL, 0xB903BD490A322F0AULL, 0xE009FE5350F5E1FDULL, 0xED2F92FF854F315AULL,
0x5D078B241C933358ULL, 0x8C513B9F9302B04DULL, 0xA3E087BF960A7560ULL, 0x07EDF2F8AA904BB4ULL,
0x1384A2D7DE631085ULL, 0x0622F57CE7469681ULL, 0xFD8D869415AEFDAEULL, 0x312EC4EBC898BFF6ULL,
0xCC7330A1A260632CULL, 0x341B1EEED6E05004ULL, 0x03CC57B2393DD6C9ULL, 0x07A1F3A59669B051ULL,
0x154FBB98C014F27FULL, 0x3BA59A8BFD9D456BULL, 0xE292F16C64D8578BULL, 0x5AE43C31969BEE22ULL,
0x08BE397B29DF31F2ULL, 0xDFB3E7AD8F85D923ULL, 0xC0B730DBB755CCA4ULL, 0x71D712CF4044C329ULL,
0x3366BCEE7926CCD3ULL, 0x4EE7546A179FDA81ULL, 0x9F316334EFEC392CULL, 0xCFC3003D74D6B6A5ULL,
0x90CE5C2BA2B48808ULL, 0xF6FFEC61AE290D2AULL, 0xBEE714244E908DCBULL, 0xD55A103567F20F52ULL,
0xCD5E7947C8544AEFULL, 0x5AA0DD366B42A5E8ULL, 0x5A106A3283FF478FULL, 0xDA872A385E28134FULL,
0x3A68D4EEDC98605FULL, 0x266E49E61B09DDDAULL, 0xBE2D9A1F068BA762ULL, 0x9E0F6D98E7B646DFULL,
0x214C14AD0DD740D5ULL, 0x027DC5CC7831FD11ULL, 0x13963A51608BF31FULL, 0x2810E9D07C352B1CULL,
0x62ADA5BA2D6376BAULL, 0xDD12F07E72097D8DULL, 0x5F977F3C4D8F7159ULL, 0x7C4A4C0F9C343D7FULL,
0x8EBA253E87EC6DD9ULL, 0xABBCEB5A42F8279BULL, 0x8E28A9D1BB3A10B2ULL, 0xB93F5B15DDD53958ULL,
0xE38FB72CE41A3EEFULL, 0xDFBBA1E65C67489EULL, 0x903030F602D9EBEDULL, 0x812B5A538953DC22ULL,
0xDEA3F4959C5DC866ULL, 0x0AC41DEE6D2D6534ULL, 0xDB636EF8F0AE1B8CULL, 0xC9CCAD44AA7FADC0ULL,
0x4E505A8008F2A52EULL, 0x710F6066075E07C8ULL, 0xD8B4DC0A6DE5862AULL, 0x6FFA5419BC308D9AULL,
0x106D6246AF11D2BFULL, 0x85C1780EAA9A8C7DULL, 0x0E541EC4E24DA063ULL, 0x2C211A9C52AD05A2ULL,
	},
	{
0xCBEF41F065469472ULL, 0x0D4941E8F4035CEEULL, 0x4F04EF940D1FAC29ULL, 0x414A2BBD386400ABULL,
0x77D315CFAC6C48B9ULL, 0x694B64ACB59C7B7FULL, 0x885F8D6E5339D29FULL, 0x9F58214CC1421E9CULL,
0xF37D813E26365475ULL, 0x5C253DF146D4C6CFULL, 0x7727593DE603DF83ULL, 0x1ACA4C24F827A167ULL,
0x89A59D44A5E5A43EULL, 0x4830E8360EA2A7A4ULL, 0xA37D2A8C0D6CB485ULL, 0x6DBDB77DE75E2097ULL,
0x756E53BBA7C59B87ULL, 0x2014301B1F95D38CULL, 0x06E9077F92D8B5B1ULL, 0xBC17D34D5A17F76EULL,
0x0EC6E5D4576C7909ULL, 0x6571D3AA81A255B5ULL, 0x95284074D2DCACCBULL, 0x0B4438D42F4D89D3ULL,
0x12D95F20E231E54AULL, 0x70E9726ED76FC02FULL, 0xCF8604B0EDA47747ULL, 0x59BDF47582ABDA22ULL,
0x359F1E228ACD7C54ULL, 0x0072E743240F6689ULL, 0x2FD8B9122B176FF3ULL, 0xF36B2DCE106470DBULL,
0x6978DB5C33366383ULL, 0x490404F9B62EC2D6ULL, 0x780099C3E7ADC535ULL, 0xDFDF471078F4D73AULL,
0x89DBD7E751B23C82ULL, 0x0894EEAC7DB96618ULL, 0x330C6FED9EF42CFCULL, 0x8756CCA849E625B6ULL,
0x56221C8B86130662ULL, 0x556C84EA50F0150DULL, 0xF4E16479E8CCA74AULL, 0xEB99CE1AF081675BULL,
0xE95EF25F4430BDDDULL, 0x27CBA096E5F5F25DULL, 0x258538CF7E5C4067ULL, 0x11AC7931FB6DD312ULL,
0x1C48FDE74893CDBBULL, 0xDAE9149885CAD734ULL, 0x64F06E989BB103B7ULL, 0x79551068504E1BC1ULL,
0x7E41A5BDCC4FA058ULL, 0x223BAF48BDC43B35ULL, 0xD47D278353189035ULL, 0xBF72959B3A53585EULL,
0xD26BADB8AD1BE351ULL, 0x301EB49E94744CDFULL, 0xD2EAC616A72CFF91ULL, 0xC828C1FC76B044D9ULL,
0x3DCD2F9BFE934E53ULL, 0x0ACC8A3007011B46ULL, 0xF7E8987B809610EEULL, 0x0DE2244CA41CDCF2ULL,
0x93985A47B9B2FE11ULL, 0x4CA48DE6D3F6F23CULL, 0x5C431652D47DC851ULL, 0xF2287E56BA3691ECULL,
0x6C73A06F7F86B45BULL, 0xCCCC507AD88849DAULL, 0x7BA37A8B90B6F3A0ULL, 0x2D47BAB16DE39C2EULL,
0xF5E43FD1A40A8E5AULL, 0xED22ACBD854BEA6FULL, 0x3CD8C24122994658ULL, 0xB9CB13C4A79E29BBULL,
0xA6C749F9F64401EEULL, 0x8A84749C2F6125CAULL, 0xEDBB5998AD95FCDEULL, 0xD8D6451070BF6A9CULL,
0x45E09779FA8B3338ULL, 0xCC68ACE8431446F9ULL, 0x3FACFFA346743872ULL, 0x0C3FDFBAFCB5BC22ULL,
0xEF794EB88C06F33BULL, 0x50D190EA9CEC9959ULL, 0x919AAA48C85384CAULL, 0x238B1B5DB3327414ULL,
0x071AE7371A5EF8ACULL, 0x718BD6B18E38A818ULL, 0x14A57332184F3853ULL, 0xB8C0BC1D604B0CBCULL,
0x4252D25EF8A623E4ULL, 0x9FC4ED2B52079716ULL, 0x984DD6B7ECE2A010ULL, 0xB9FEE703EF8FB2DBULL,
0x399332CF7274DEEEULL, 0x12F92CFDF798B628ULL, 0x0B40CDD76DFE2820ULL, 0xDCF9FD9857127682ULL,
0x2C294B3B9C30EAC3ULL, 0x48343526073DAFC3ULL, 0xFDB48C2842CCF1EAULL, 0x1940D9C397679FC8ULL,
0xE4398DBD13952AA8ULL, 0x0E9CEC5C66B2F408ULL, 0xB252EADAE23388EAULL, 0x865A02EFF592E870ULL,
0xE7E174B625683EA9ULL, 0x1E5EE03841E94134ULL, 0x8AC2C9B53AFFA724ULL, 0x3AB6B578D3F09B64ULL,
0x64638E2E0D63FE41ULL, 0x76EBFB1CFD4C6A78ULL, 0xDCBCEF1708CA3A37ULL, 0x0871D551CF0DDB25ULL,
0x806462BC45532420ULL, 0x017FC9E47669BE2FULL, 0x7CB630046A951A1BULL, 0x34F024F70372900DULL,
0x024820EC186BBC19ULL, 0x350BCA591821AC7EULL, 0x8B27E92B9011227EULL, 0x884859A6A16ABF85ULL,
0x77983631EFC8242FULL, 0xB8687B6687408F53ULL, 0x515411F892A19FC2ULL, 0x5184E5D433B14D16ULL,
0x4A7E3E520D2CB1CDULL, 0x3FE42813EC8AB4C9ULL, 0x3AC072A9CF1140AAULL, 0x3CBA92E73E22665EULL,
0x725CF264A8EF4C1BULL, 0x231FA64421430CF5ULL, 0x381FC66354F8FDA0ULL, 0x17EC433E19521AEEULL,
0xAC6D0040A81E8C7BULL, 0x683F823B43241C0EULL, 0x18EED24E40DBA6A2ULL, 0xE3D1756C3025E106ULL,
0x6983F3825FD43628ULL, 0x41754FE074C51204ULL, 0xA892BAB715F808D6ULL, 0xCD5961CA044D083BULL,
0xDDD1990A1AC315FEULL, 0x39DC1AC9CF802870ULL, 0x9C111F2F6CCFDCC2ULL, 0xED1ECB3E9EC95AFDULL,
0xDFCD860255F09B5CULL, 0x8EA22E0CCBC0A7EEULL, 0x9D5EC6B88B57EE20ULL, 0xE993DC4C514F7002ULL,
0x832BAB6AE9A9BB37ULL, 0x7190ACCDA4CA35DCULL, 0x0138E4EDBBEB2E63ULL, 0xD915A96BEDB06C95ULL,
0x9CE01F2093ACEE42ULL, 0x31DDB4997CFA4B7BULL, 0xF4A0413177E9A2D4ULL, 0x00CE31A0D82A38C7ULL,
	},
	{
0xF3FE80512E481E7AULL, 0xB9BC8909F1F28EC5ULL, 0xDFF2E7EA3914E92FULL, 0x8D0B299753128587ULL,
0x3553470BF2857F28ULL, 0x04AD5BBAF0A88CECULL, 0x3A71EB2CBD89B532ULL, 0x97FD824227B77053ULL,
0x9ECBDA894C71828BULL, 0x7D1F0EC66E01A91DULL, 0xFDF3CB28CFCA43BAULL, 0xFB139A42F2712CECULL,
0xE43DAD7CF4FAA10EULL, 0x355974FE05BD2D2EULL, 0xCD247C1BAE47547BULL, 0x2EC7C4501356BDB3ULL,
0xD8A2FE25A4FA00E3ULL, 0x1A69C51A0E2B7295ULL, 0xA2076E6FC5BBCB05ULL, 0x5289120077CC27B1ULL,
0xB7E485868E626A99ULL, 0x7737DCB893EE4E70ULL, 0xB232390EA3D4F854ULL, 0x46E7E204ED6B50B1ULL,
0xC8C59F25BDA2D3DDULL, 0xBD03801D0D32D1F4ULL, 0x199FC8C124929AF7ULL, 0xE38BBFB126CBDA3FULL,
0x83D8123ED8395155ULL, 0x8E214FB98958403CULL, 0x190C5D88EF5386E9ULL, 0xE60C6CC4D74AFA90ULL,
0xAC93E590ED8380A6ULL, 0x481E6C7962175A7EULL, 0xF4F6DF09989C2601ULL, 0x76902E768AC7943FULL,
0x0968E6984EB5BB9FULL, 0x8A2703CEB30E63A6ULL, 0xC22450ECFD8D4210ULL, 0x5F49B6C31E4E0E02ULL,
0xA806CD64A312A57EULL, 0x74D03C831CC87C52ULL, 0xACC6704EAE10C99EULL, 0x53BF4306FEB9AB34ULL,
0xDA9825D8AD50E368ULL, 0xA0293D5498403832ULL, 0x8729C3307AB9804CULL, 0xE4F1C8CE92466648ULL,
0x5B2D6787773210F7ULL, 0x052A46475FC68DCFULL, 0xAD02A2E77B5ACBD9ULL, 0xFF4A49FC72218E23ULL,
0x421FE504D85641F7ULL, 0x577115CB326B81B3ULL, 0x88430A94234A0ECEULL, 0x0F6DA92458DFA752ULL,
0xBCA37BBD8D39A23EULL, 0x8C55129D76D32DF5ULL, 0x449232A6386441CBULL, 0x2ACC972EEAF15231ULL,
0xB05C2D57536A04ADULL, 0x8C4DF3690281072EULL, 0x7E494250C1B4BC77ULL, 0xD91C7343BE0A36E4ULL,
0xB90C0B93BFF87255ULL, 0x4BABDD3B8A997FC8ULL, 0xFA0DA01342DF5F1DULL, 0x5B9B35F844763848ULL,
0x2D541FB1C5110AC1ULL, 0xC7AA31A903116ABDULL, 0xB1FFAA45D9398DDCULL, 0x8F27C0BD816A6EB5ULL,
0x178D365A1BCDC65CULL, 0xA4D185C77157BEB0ULL, 0xC573E0990F92AE8EULL, 0xC62B2A95AB44ABB6ULL,
0x4FADB90C073EEC08ULL, 0x6BAC7ADEF7709A70ULL, 0x184EC7B27DB41A44ULL, 0x375FE30A20BE8795ULL,
0x2348FE1025A44ACEULL, 0xA0D271E71C86ABDDULL, 0xAEE50FB7889DB370ULL, 0xDE60C46D561D39D4ULL,
0x38A3B7EB44DC88B7ULL, 0x354952C897EA5A2FULL, 0x137EC6E6D86091ADULL, 0xEB156E569F48BD8AULL,
0x99D56D596F0617C6ULL, 0x0C35E056238A54A7ULL, 0x5260A13458C7742FULL, 0x1CED8167FBDD02A0ULL,
0x150522CDA456A21EULL, 0x92E352201AE2669CULL, 0x59729DEED9A3EBD0ULL, 0xA6F395584A382CF6ULL,
0x5EB99E6EF722FE3FULL, 0xA81F2CF4EB56B1F2ULL, 0xC8789454A3CA6DCDULL, 0x79AE023F86662267ULL,
0xA332EFA1FF21FC72ULL, 0x4FE493319B06B0F5ULL, 0x7EDD704B97D9C01DULL, 0x0FDBD623FA19E8B8ULL,
0x73E6230ED8D89E57ULL, 0xF06385D8EB17A090ULL, 0x74122803AB98706CULL, 0x1AFE8FD282849463ULL,
0x3E0B4C342648898DULL, 0x1554CF64DA7033F6ULL, 0xA783B3A5DB1F46C1ULL, 0xACBC77F65136C94DULL,
0xB7304D73C5C1C691ULL, 0xF6A591638DE3B2A0ULL, 0x351C900CE2A8E4C6ULL, 0xBA15B174CCDE0E5CULL,
0xECF507A733F51CADULL, 0x3F76ADD6E2D7E1BCULL, 0xDB6C9577561A02AAULL, 0x156B5A0E770B74F2ULL,
0xE4CBDA40CE399C18ULL, 0xD26E8551315C59F4ULL, 0x804A2B49EB40FAB8ULL, 0x3C605442FBDB554EULL,
0xF8D09CDE69FB2737ULL, 0x8861C2E702B62AA5ULL, 0x812321C70BC19484ULL, 0x96849379D0A620CAULL,
0x5EBF7B77F66C0BFEULL, 0x26492ECDC15EEB70ULL, 0xDBCCBAD903BD40C0ULL, 0x01DD0371068E8B07ULL,
0x85EF5DF51D60FE7CULL, 0x0799C0D0A7749D35ULL, 0x7CF0AAD6622B36BCULL, 0xCA3D63EB36178AF7ULL,
0x396AC469185D0582ULL, 0x39DB6B8070A8FB6EULL, 0x410D1A4B5FE1247FULL, 0x6872B1A4A8A0F4CBULL,
0xB31640AF2EE62A78ULL, 0x06AB593094931EF4ULL, 0x750CF1D062566288ULL, 0xA643F58A24DBADC7ULL,
0x0CF3F6A892F1FD4DULL, 0x28FF93A50E88931FULL, 0xE367F8D6EF18DC3AULL, 0x0448933B0339BAF7ULL,
0xBD6FCBE990973D94ULL, 0x2AC74FA1F7D63E53ULL, 0xBAE49081A4F01DE1ULL, 0x7E936FC46F42ABCDULL,
0x0BC82FF945F839BBULL, 0xA7DF551B7980BEECULL, 0xDBE513870FC53960ULL, 0x0D2989A6FAEB219FULL,
0xA989A60D584DB56CULL, 0x73573D4BDA6B1D8EULL, 0x594C24076C247287ULL, 0x7D56DB20E8DA7509ULL,
	},
	{
0x727277EB168ED0F5ULL, 0xDB4C551EB254D183ULL, 0x5BDAE0CAABF93791ULL, 0x3E6E85ED51B34285ULL,
0xFD3CB2A6F8AB950BULL, 0x9A1AB75A29BB3A13ULL, 0xC8168D026AD1E1D1ULL, 0x3341D5F597BAC4FFULL,
0x4EE4AB53C958A618ULL, 0xF07AA2C33865F9C1ULL, 0x2B199051C8C13783ULL, 0x7CDF87811EC0349EULL,
0x63D2711E60329A13ULL, 0xE26CA15D5AA58FBCULL, 0xBB2E679B76578635ULL, 0x2782CEC8150E3303ULL,
0x4D8B2FBE24DBCBE3ULL, 0x9465CD1C639BF1EBULL, 0x5B2B37C020808918ULL, 0x46C97B40F7F18FA5ULL,
0xE9EB175ECB1F702AULL, 0xA2DD268FFAE2EC26ULL, 0x2A1516A81424A8B6ULL, 0x024C5F8DB6884F1DULL,
0x2E7C49019342AC31ULL, 0xBB3334562DB9FFCEULL, 0x9564E54B3871DD55ULL, 0x3A09D6B662845B53ULL,
0x34E6F07483867FF5ULL, 0x72E3A459D89DA4D3ULL, 0xBAD703C474DA24F3ULL, 0x5FA83F9BD3E0DD96ULL,
0x7565F4BE4FE8945DULL, 0x9A10E7C1EE5C0D19ULL, 0x26DB6861D7CDBDF2ULL, 0x618C87B9E487838BULL,
0xDC5FE817E50E3E94ULL, 0x866502B4E192CB3EULL, 0x3C84E2BA131B9760ULL, 0xC4C01E2128F43010ULL,
0xA809205ECB674980ULL, 0x134708DEB5A9FDC9ULL, 0xD42393D42314A7E2ULL, 0x4AAFE7C24AC2D8F6ULL,
0x3B22211BD7835668ULL, 0x5458FFB37C3BDFBBULL, 0xDD62E43535561C4AULL, 0xBFB90DF46A3192A7ULL,
0x51BEBFFEDC9DE5B3ULL, 0x375A1F7843F8DF84ULL, 0x1204811224548ECDULL, 0xCF95C03D2BA10AAAULL,
0x452AACE3565A58D3ULL, 0x9256AC16BDF69D5BULL, 0x062B29711C8DB7D9ULL, 0xFC8D426855FCF213ULL,
0x4BE146613EB97E52ULL, 0x5B21DEAC1E7A71FCULL, 0x233A545640774999ULL, 0x1685DFD6271C18CDULL,
0xE297E3D0853C78FEULL, 0x053798E1FE325ECBULL, 0x5A47F8F26023E712ULL, 0xCEE39D1BC31C3ACDULL,
0xCB55FDE4DC421340ULL, 0x42E0DB0440E68855ULL, 0x9B2701D6198C67EAULL, 0x463FC0D363A5C030ULL,
0x4FABDEB8D193CF94ULL, 0xA6B135E846999C3BULL, 0x5D04342FF6A5D9D6ULL, 0xB0EC8CCB2C26F12CULL,
0xB2F8C27167254724ULL, 0xE260B185EC22C381ULL, 0xC59393FA5E10F0A2ULL, 0x6F59C060C80E5EF9ULL,
0x01C29153A110A789ULL, 0x9FEBE1642038023CULL, 0x3BD38E4B6B93D5E8ULL, 0x373CBD2837E6828BULL,
0xAB239C6CBDBC60AFULL, 0x320E1FC211EE25A7ULL, 0x7366728B05388963ULL, 0x2A9A66E37275D241ULL,
0x914D05B10D3953DDULL, 0x991B28853DABA1A2ULL, 0x3D7F03C3C22942EDULL, 0xF9A217A5BEC6CF6AULL,
0x7E1FBCAC9CD914DFULL, 0x99118CEBDD8DFE84ULL, 0xAC5E2AE6783C8717ULL, 0x6C52414FEC2ECCB6ULL,
0x28CD38A82BF00E59ULL, 0xDE1FB9038247B868ULL, 0x56681320852EDF6FULL, 0xF1039547CD3E6E8DULL,
0x39A059661ED19A3BULL, 0x6C6583E4D96EB0CAULL, 0xC5CC392C289F6768ULL, 0x0CB5CB739AAE263FULL,
0xF8C9174B64FE5F56ULL, 0xD81983B1E6409393ULL, 0x61C036A983B69EDFULL, 0xCA39617D23392925ULL,
0x9543EC238784851BULL, 0x02F59E5431D8D086ULL, 0x5E4F5278137D334BULL, 0x8532EB52ED71A49CULL,
0x30CF1D58549B8E7BULL, 0x5C03900EB7DB0A0FULL, 0x7FBF1F18BAF4B093ULL, 0xADE2CDEFB0822FEAULL,
0x1E0250B4DD68ECE8ULL, 0xDEB560B894941A7EULL, 0xBE89B00EB1D14A7EULL, 0x62D27D6CC8E9BD06ULL,
0xFD6714AABAFE9C83ULL, 0x4E5200D8B98E1097ULL, 0x18E22F49ECFE2FD0ULL, 0xFD47974E8E298942ULL,
0xA6B2451DCF925A5FULL, 0x6ABC87722D95C497ULL, 0x1EDFDB8ED5C01808ULL, 0xED907219AE65CED8ULL,
0x0B0F75AFF8DF45FBULL, 0x1B86C99D9D34E691ULL, 0x0624B8EB649BFCC3ULL, 0x842AFB2BF4F63862ULL,
0x7D7ACA8F68C3FECFULL, 0xCE5F44E040A4A734ULL, 0x52307C25F4E42FC0ULL, 0x84B1FBD520FA572AULL,
0x0E38E8D499088F07ULL, 0x85CE954F5C2F5BF5ULL, 0x5E357A36660B3E8BULL, 0x9FAB1EC2B0CB9D6EULL,
0xE653E7540F6EB460ULL, 0x5549F06CE008BF9BULL, 0x558EA4C15F9654CCULL, 0x30214E95C7729D77ULL,
0xD03D68FE66DA5823ULL, 0x47995DD2EC97B02EULL, 0x67BADC99CCD20E36ULL, 0xDA1746D4910F8EA0ULL,
0x5A7949C352C64752ULL, 0xEC96A69B40338B52ULL, 0x44FB2341E537E921ULL, 0xE6CA7017CB30593CULL,
0x415D86F591DA7BE5ULL, 0x0B363492D36089FAULL, 0x307E74715680CAC3ULL, 0x7BCC6073561DAA63ULL,
0x0CEC4C3504C48840ULL, 0x34EE5A232869BC88ULL, 0x351F50A7657A460CULL, 0x09F09935F41DD09DULL,
0x0FB94DDC5E39F5BDULL, 0x376CBC141388884DULL, 0x49B741B31A7E9628ULL, 0x910C5AD69BA9627AULL,
	},
	{
0xE4769DCC5EEF41C2ULL, 0xC80D2F31DE494495ULL, 0x529DC38E4EF6C9B9ULL, 0xF0A251235D2C74C8ULL,
0x85ED8BFE52F65108ULL, 0x5315A5B93713BDB1ULL, 0x53CFA26EB19BCE6FULL, 0xC2144125454C2E36ULL,
0x45F3D9B59E452ED2ULL, 0x33891C65E7133FD1ULL, 0x5DD6B44B72512A25ULL, 0x56B9D5A475696513ULL,
0x27FB686BE722CB5CULL, 0x6FE4F64DDE032ECBULL, 0x72B4BD9C865F731EULL, 0xD2F2415B296E49A9ULL,
0xC1C79D5FED38933FULL, 0x300A8CBF4BDC307FULL, 0xC562F4EB8EC25F42ULL, 0xA63070E1633A1186ULL,
0xB019923158A63467ULL, 0x3945A99F707F0F44ULL, 0x44EBFA8FFCB98A05ULL, 0xD9FA5C4BAD61B7F9ULL,
0xDB7ED5F7A943D131ULL, 0xA79B968ADACC48B4ULL, 0x661E6D62A8FDC8F8ULL, 0x74C8421547DC1370ULL,
0xBA22E7DDBB1372AAULL, 0xE17279BFDC2929DFULL, 0xF8CB6586F2B2FFFBULL, 0x8DB9A44523AC40BCULL,
0xFBBFD44694F0CAF6ULL, 0x028BF9C3358799DAULL, 0x15A55E24BB0EA611ULL, 0xEE1120D95278A536ULL,
0x4CA39D72766C98D3ULL, 0x3B5260D642D0F3C2ULL, 0x71A55739D2AE6BDCULL, 0x5D997E7ACF1608CBULL,
0x1CBF58A659E03D4AULL, 0xE181B92229D2910FULL, 0xA40D385BADA4B4BBULL, 0xF6C4866EC40F88EEULL,
0x97D928DC5FB3547AULL, 0x2F159AB4D19AE55CULL, 0x2BFEBD8E7339D389ULL, 0x1FB884D2B5126567ULL,
0x3BC17FF2D7D76292ULL, 0xEC9BA433A7404C88ULL, 0x429C7715BE5B3C08ULL, 0x051C8815305FE80BULL,
0xB9AB4F62DE71E5E5ULL, 0x83CCD7647531EC41ULL, 0xC6CCA54AA3CF19E7ULL, 0xB3C7B8BCED24E858ULL,
0x0F8E1178C0C35F26ULL, 0x37845266D1DD49F2ULL, 0xCF83F979D305FE72ULL, 0x2E3562607BD0ABF4ULL,
0x06A2D4149F3D20CBULL, 0x7E051EBEEAEA7612ULL, 0xB1AD84C1E6AB95E4ULL, 0x1AE086FEED542511ULL,
0x83ECADEA01CAF68DULL, 0xBA930F1EB1D2EDD9ULL, 0x869E5DF639F4955DULL, 0xE86015801660CFB2ULL,
0x57E34745534DF614ULL, 0xD363E4F7AEF3945BULL, 0x8024C78BD78B527AULL, 0x84641C8C538FAED4ULL,
0x7A1F5F53795209C0ULL, 0x60E036C800186402ULL, 0x9724DE7A5744B598ULL, 0x0280929DF3882A85ULL,
0xDE2B76F3FCF9069BULL, 0x733BD0374776B974ULL, 0x61CF1B36BF7B77AFULL, 0xCFCF8C56AC15CFCFULL,
0x4E5C0A077A0A5E6EULL, 0x2B6084EA901958D3ULL, 0x1E6A2D9DBF27DCDFULL, 0x5064FA23BF2A3392ULL,
0xF9C700444949BEF4ULL, 0xA42AAF266CC98E69ULL, 0x3FA6FCF3D5A45C95ULL, 0x03984618B4E37941ULL,
0xA2463E949AF42F3CULL, 0xE900D334D6610BB4ULL, 0x0797D4DA3D2EE85EULL, 0x8C216B17CF793E7DULL,
0x979081ED767E7C27ULL, 0xF6B220828E9961D6ULL, 0xFE310851AD10C252ULL, 0x39085E349E1FEC9CULL,
0xEC6AECB75472050AULL, 0x03BDC9950C453A6DULL, 0x506393BB488F1432ULL, 0xEC6BE36753E5B10EULL,
0x92E3EFAD479B3979ULL, 0x8CD46BB0360CAFCBULL, 0x64C386E44F78B81BULL, 0x7D15267BC77D9DA8ULL,
0x4CB3774BEA4E5931ULL, 0xE2C2FF4B708B658FULL, 0x32CC400F6575E3EBULL, 0xEFEFB13F4102B1D3ULL,
0x9C9C86B984F34729ULL, 0x36A60A4AC4F442AEULL, 0x29B4C102850AA83CULL, 0x263C98057AABCDA1ULL,
0x25ECA93D22C180C7ULL, 0x617A0CF62519EDD0ULL, 0xB3D3A71CF3497410ULL, 0xDDAFF5587975CFC1ULL,
0x270FE33189AB8A35ULL, 0xE3F462BA11F46D1EULL, 0xA39E8F6DC9390E16ULL, 0x1F570E0122BF5F5DULL,
0xFC330B7C4A8360E1ULL, 0xDBB50FA9299A8A6FULL, 0x1736EFCEE7F6B49DULL, 0x7A59B64AB3DD22D8ULL,
0xD704B6915E4EC51AULL, 0xEAD333C261ABDCD5ULL, 0x9F90AE076C805522ULL, 0xA780D186809B646EULL,
0x18781BEF05D16BD6ULL, 0x4EB61CFCF32C9897ULL, 0xB828FDECF83C0C89ULL, 0x72A404E09DBB65C2ULL,
0xF9B09F25E04F6998ULL, 0xA34131143CDF8687ULL, 0xDC504F87633160F5ULL, 0x06E2F6675C5BE340ULL,
0x70F1E5616E78677EULL, 0x0F5828202107C3BFULL, 0xC70D5647ACF2E647ULL, 0xFAA8B169BB5F8877ULL,
0x7FADA07776967371ULL, 0xD7B950E4A3A52AC6ULL, 0xAA8F7228413E3E40ULL, 0xB897090433BD5640ULL,
0x569D7878FEDF7C78ULL, 0x9521D7EECE28870FULL, 0x6C3403EFE555A546ULL, 0x2238120984D03BDFULL,
0xFCF8BCC5D30ACC2FULL, 0x8AD14A761D8EF3E7ULL, 0x3227755BE3017CD0ULL, 0x89830D1A658D63FAULL,
0x67B5C5A6CA100E67ULL, 0xDA5ECDFCFFFC07BFULL, 0xCF90FE6546518474ULL, 0x5E3D5A0E3FB8F675ULL,
0x2DE72F6F411EB7E3ULL, 0x91D5C5B426CDACDFULL, 0xDC54707B430AB296ULL, 0x2C2A4D9B5A0B503DULL,
	},
	{
0xC46C07E2413AC53DULL, 0xC59D86EFE4620B47ULL, 0xA73CBE3670578D91ULL, 0x1ACE9A8E6A7D22D9ULL,
0x23CA9FE0C3CBCB4CULL, 0x467F2D37EEA90A6DULL, 0x5E0E1A28DCE79191ULL, 0x592C7B0C64D5AD06ULL,
0xF8FD21CB242E5506ULL, 0xC2CAEBEC29309262ULL, 0xB229406E65A7748CULL, 0x7EC1707DD77A246BULL,
0xEBF66A37FE4E94A5ULL, 0x233A441870DDF5E6ULL, 0x685C4F056E36DB53ULL, 0xFB7E4C1B1264F261ULL,
0xFB6B16FE4A1B506AULL, 0xEE260D85D993B95DULL, 0xEA18FE53567F649DULL, 0x7149B9E017B3C938ULL,
0xFEFB10860D87E7C5ULL, 0x37F124CE9FC88867ULL, 0x1C04578CF0338522ULL, 0x957D8BD6CE5CADDFULL,
0x35652F8ACAB732A1ULL, 0xCCCAFA2FE58503DFULL, 0x2F17141F82F3DE5AULL, 0xA232BAAD7ACC0270ULL,
0x0BD028651F6C0BD6ULL, 0x90C8BA1AFFEA493BULL, 0x394CEF25743400DCULL, 0xF461F48FE27A92A8ULL,
0x8B2D24E74A9E97BAULL, 0x534D08975A155451ULL, 0xA2EE71D6E7CDCB66ULL, 0xB3D5D341BF73E33DULL,
0x18A2B5A98D4797DAULL, 0x92CE885D328D9C80ULL, 0xB56F0400EE46D788ULL, 0xA1F8128368D74518ULL,
0x761503E89B665CD7ULL, 0xEDDEA6B7B8128E3CULL, 0xD8DC497F15D2A4F1ULL, 0x6C6E5FB2D5476D71ULL,
0x2FC46CDF92362767ULL, 0x3E97652C4AEEC203ULL, 0x4CDB15C572FC7462ULL, 0x20859BB35C5193D9ULL,
0xE3F5EFAD289C0976ULL, 0x9D5A19E6E7B211ADULL, 0x6A4B7E5276120341ULL, 0x9C7CA81FDBC2571CULL,
0x11B316B80EBE9870ULL, 0xC7D45FE40069ED28ULL, 0xBA69D547223698D6ULL, 0x1B9718B225F9EA0DULL,
0x5BA84597B1DA01ADULL, 0xA96CAFEA49418F94ULL, 0x709194EA7B2F162BULL, 0x3A146202DE244937ULL,
0x6C07947FD94D5202ULL, 0x01EF5B393DA3F5C6ULL, 0x139585373EE9F987ULL, 0x0DE45E7627797A6CULL,
0xE685A236D1CA0173ULL, 0x67A3E10B62C6B72BULL, 0x63A2A4773FA8869BULL, 0x31434284CC5D1741ULL,
0x157105881BCB140BULL, 0x21A2D7CC8CB12210ULL, 0xC9BE9BD3F3EF844AULL, 0xDC21592FC282A366ULL,
0x3ED6473ED23260DAULL, 0x978EE323AAB23C53ULL, 0xDDD3C8F311214116ULL, 0x695F21CF30F76FE5ULL,
0xCEB78DA23E20D014ULL, 0x53966FB7E0478970ULL, 0xD05A259B45CBCF31ULL, 0xE4DFA8165D300C46ULL,
0xC35962794CFFA156ULL, 0xD3D32DB5EF83B6F9ULL, 0xC48C965168AFA937ULL, 0x7F692F5E23FE8696ULL,
0x08AA3C8EDDC00B0CULL, 0xA7F7832639DD906DULL, 0x68326901B1773085ULL, 0x05638A3CE37CFB53ULL,
0xAFB3B5B81A4CC3FFULL, 0x984E6EF9DC77DB77ULL, 0x56060CAED023B638ULL, 0xB561B750FAEE3638ULL,
0x2F24966A52304805ULL, 0xD31495E3ACDCFD8DULL, 0x0F9F4B1BF82AFFCEULL, 0x13819C61459E64F3ULL,
0x19EE1FC50B70E8D2ULL, 0x5D2571F01B2D8BF7ULL, 0x9C048D86344F786EULL, 0x96A4F8B9359A1CBCULL,
0xF8FC3D283E99FBF5ULL, 0x42F4DDEB3EC62735ULL, 0x17BFF55998277FD0ULL, 0x4C75E7C5737C33CEULL,
0x34F18654F305B6F0ULL, 0x46E77578925542D1ULL, 0xC39051E7245887CDULL, 0xD1458CF828152FC8ULL,
0x3D083AFEB04B8A7BULL, 0x09F483012464BA8DULL, 0x5EB23C2F7284F191ULL, 0x38BEC1F7551449EDULL,
0x57FCA0F879F20DE7ULL, 0xEBA3745C415955F5ULL, 0xD9AFE19D7DF7DB6EULL, 0xC466E003E1A04A51ULL,
0xCC106DD64A48CBA2ULL, 0x1E5C0F3EDBEB9B60ULL, 0xAED246D01DF45059ULL, 0x84F8FDAA3FE4BADEULL,
0x4B1F251441777FECULL, 0xAD05DE6739069345ULL, 0x6D200B6906CB8A09ULL, 0x439239BED0913346ULL,
0xCFCB93C6FDCF9A9EULL, 0x6EFF90A1A4295D01ULL, 0x42F1F7D9669136B4ULL, 0x4FB4EC876953BED5ULL,
0x58B8D2CAD2381524ULL, 0x276C42743134B5FAULL, 0x9514DE34729CF37DULL, 0x0F18D849A33C9D2BULL,
0x2EDC787CCFE7ED92ULL, 0x4CD1EBA7D0ADD429ULL, 0xEF8E97087AA76C76ULL, 0x6C56B1FCD61FDED1ULL,
0xA3E9E2F1D840D7E1ULL, 0x360769833B743506ULL, 0xDCE7233C56ADD352ULL, 0x81659B56E5E19EBEULL,
0x75C4C3B32BE8F651ULL, 0xA982DED87AF341DCULL, 0x71123BEA447D9DB8ULL, 0x1AEA671146C3D9B9ULL,
0x441556042C15A9E7ULL, 0x0BED62C912B9EA79ULL, 0x94DFD94989FDBC37ULL, 0xF15DC078DD94249BULL,
0xC4E5E8A44305CC1FULL, 0xAB18375A108F974CULL, 0x5F0B798F7121BAE0ULL, 0xB5028F38A0E4C281ULL,
0xA559A41728B9E2ACULL, 0xE23A00C2880013DEULL, 0x07DE30E072987C88ULL, 0x49B630762024DBD8ULL,
0x4376B677F8D51E75ULL, 0x148AB6843E5352B6ULL, 0x4462CB3DA42E81A2ULL, 0xCF8F5E2355BAD74EULL,
	},
	{
0xF5B26DBCC1FD3CFCULL, 0x90E9FF6B265D4781ULL, 0xD3999C2C0D4B1348ULL, 0xCFCA952A607BAF65ULL,
0xC503054DFD9C6C51ULL, 0x7057292C43FAF5A2ULL, 0x78F6AADE65E4F90EULL, 0x00C0A22440E5F4B3ULL,
0x7BA2766FBD63485DULL, 0x81AB7C1C29ADF347ULL, 0x2494F49B5D71A004ULL, 0xCA6EF2A814778508ULL,
0xE26EB4A430E2D811ULL, 0x3EA6FF1D0258E767ULL, 0x141F55D646868C61ULL, 0xCAB419750CA6683CULL,
0xE4C948729F8AEE4FULL, 0x76172A97F3D67E71ULL, 0x4CDC8C0121D6FEC6ULL, 0x1B9767292E7F5F05ULL,
0x70214156CD9AFF44ULL, 0x00BEDA38027B0319ULL, 0x0D9EBA9E34A47686ULL, 0x17283F43C546C5DBULL,
0x9BA0D03EB9463BE2ULL, 0xAB7C6B7D1C0CFB83ULL, 0xF75BA56349D59A97ULL, 0x2744EE66F70824B0ULL,
0x44DEB3882509C484ULL, 0x53DAC1F10F2AABD5ULL, 0xB94EE852B2CA7A22ULL, 0x3E24DAE5E01E6C96ULL,
0x8EB1DD81A43303ABULL, 0x73E32A3A74319F2CULL, 0x4DAFB6E15CDB55BBULL, 0xD4BF288BDAAA2447ULL,
0xEF13FE6D1EA281EDULL, 0x9A5754EACC8F97F5ULL, 0x13FFEB1F90986237ULL, 0x8C0728AED700048EULL,
0xB90FDB1000BCC3FEULL, 0x8C28E20D5D8688A9ULL, 0x55E66DE42FAE3630ULL, 0xCDF22F86EA0BC597ULL,
0x4FD598B98C8D03DFULL, 0x0C5536858B6875F0ULL, 0x03AB40FA868ED322ULL, 0x0B5FA7C076A11E23ULL,
0x6FD167D80127D636ULL, 0x87139421BA4C6325ULL, 0xB539B45506BB7B33ULL, 0x73C47D5D96CA359EULL,
0x3ADD36118D2E0CC0ULL, 0x1D4CAD7AF92BAA3EULL, 0x3CB98F4B7ED6C49DULL, 0x43C038D7AA020A18ULL,
0xF48B50D4419C66F3ULL, 0xCD742E9BFC79601CULL, 0x57C536CDA55A9BBEULL, 0x0770637E2D668B28ULL,
0x9B7A217F79B6E1BCULL, 0xB6ABF3622D32A639ULL, 0x4C2C19A70B0C24C5ULL, 0x6DA40E2642DB6AAEULL,
0xCCC96BFA6D34B761ULL, 0xB33CE4AED1580ABEULL, 0x7D46EBC5CA1FAE0EULL, 0x88E193108C2AE479ULL,
0x9E94B8E3E1A5608CULL, 0xC76BB54D92E757FFULL, 0x46E5797A870B2417ULL, 0x9B3EEC1F3F06FDD0ULL,
0x5E8BD4312FFD2775ULL, 0x2196F7AEEA3A7451ULL, 0xAAD01BCB981DB823ULL, 0xCA0C36479717FDE7ULL,
0x619F8966135C1E32ULL, 0xA8B0455630E93353ULL, 0x9DDB16BF68B4AA77ULL, 0x565A3B4A0AE6202CULL,
0x51BA063FF608892FULL, 0x5605711E621A398FULL, 0x01896AB26D366944ULL, 0x37491AB3E8CDC181ULL,
0xA6988CEAB19F0EC0ULL, 0xD75FFD30CD3D5383ULL, 0x9751E1AF3CBA752EULL, 0x33346B1640D38958ULL,
0x36A75EBFF7733CE2ULL, 0x36774DC7404DE10FULL, 0x7A6461C6A562BC7CULL, 0xD4AE6C9640794FB1ULL,
0x0D02087FD6263617ULL, 0x82BA51BB6E723645ULL, 0xED17CD74D06D5DEBULL, 0xD85225AC6584C0F9ULL,
0xF18179121171966EULL, 0xBA6699C59828129FULL, 0x86D9FAFCCAF90422ULL, 0xF06983342CB600DAULL,
0x4FD98BD14123E1A9ULL, 0x6FF81795B9CD8F9BULL, 0x0FBE8BDA08804ACDULL, 0xFB60D4BF217ACCDCULL,
0x6AD2EF4EEC540B89ULL, 0xE8EFFD9EC5AB27AFULL, 0x96A1AD24B3FEDE59ULL, 0x0A193E257382DFFEULL,
0x0892919F15CCEB3EULL, 0xB2E178AFAE74B6B5ULL, 0x8ED60A02E4D64759ULL, 0xD307F75F77659820ULL,
0x04F8FB33EE9AAAFCULL, 0xEBEA3C4F472D94AAULL, 0x0271791D0C67928DULL, 0x6F2873A5B7201E60ULL,
0x77114127A3E784B3ULL, 0xBB661ADA3D972BD6ULL, 0x26252E16314E4688ULL, 0x7DC9C8CC77979352ULL,
0x569D781E7CF35CE8ULL, 0xB8082263B402AB5EULL, 0xDBB07805CD695800ULL, 0x0C27EFEAD8050022ULL,
0xCEA7D09EBE520CBBULL, 0x383DF75C3F9BB730ULL, 0xEFE255F663860DC0ULL, 0xDDDBB845F0640D93ULL,
0xAA35C5F6074F6C05ULL, 0xC9EA66015029365BULL, 0x21346A6C21C4053FULL, 0xF325857593C2C1EBULL,
0x8809089F1E906CA5ULL, 0x4E7A63834641A0C9ULL, 0x3BF116ED25AEC8D9ULL, 0x69FE31DE9B92C6BAULL,
0xC2760D2562E4D7E8ULL, 0x783EF7FFBCF16D58ULL, 0xD8FBC8873706A8AEULL, 0x170CAE5FE0EDF789ULL,
0x384A689B554E7F1DULL, 0xA628CA33CBD58160ULL, 0x8C1BBE640E49C723ULL, 0x735B384F48C43A70ULL,
0x63CF6384F13BF043ULL, 0x5AD445F746ABC292ULL, 0x8EE7D35D7BDE8A07ULL, 0xBBF83EB4880DE38EULL,
0x6CD76C50C7F2FFE9ULL, 0xCBE6967D3F532C49ULL, 0x354613920500E161ULL, 0x60594FC884DF245DULL,
0x22E852501438B924ULL, 0x46BEED534F4B0930ULL, 0xB8752702CB5E14D9ULL, 0x1C96A7BC798247F9ULL,
0x0C7072373B2384B3ULL, 0x677ECF2C6D953255ULL, 0x25B4DA30D46508CFULL, 0x5C7C39C03E77BD3FULL,
	},
	{
0x905B6947C23D268DULL, 0x25EAFBDC66EA548BULL, 0x6C385F005BA3B40DULL, 0xBDE6FC627D93AC03ULL,
0x2D510E32A4A32B9AULL, 0xE978869FA5BFA213ULL, 0x3C1B1BF86DB7E0D0ULL, 0x245250DE8FF06D76ULL,
0x2BD7A1FBC7519E9AULL, 0x62441F00DD0BE9CFULL, 0xF5D63FFC9FA4ECFCULL, 0xCE4B6A4E301C7857ULL,
0xD1353DE6027898EEULL, 0x18D9DC92CD7AE734ULL, 0xC5091DE70A8B180AULL, 0x190842F405729361ULL,
0x1829BA323B451814ULL, 0x9D85DD7F83E9D345ULL, 0x2F1D0E6648CCC89AULL, 0x4B4FF854A19A9A5DULL,
0x3DEA18C74BC6332DULL, 0x51A98BEBFEDA3093ULL, 0x70AAD3BFFD5244F7ULL, 0x8BD039E10313CA33ULL,
0xD33D2457DEF702ADULL, 0x625A5C335758C794ULL, 0x4D79BE9A21A7BE2CULL, 0x5F5004F715B965D6ULL,
0x7EA16D12B60C0B28ULL, 0xF15CBCDB3254B467ULL, 0x2018DCD62FB49ECFULL, 0x4BAD870D9633B517ULL,
0xDC8A0BD40BE83C47ULL, 0xA966314B7F76A6F9ULL, 0x3603BB567C2F4E5EULL, 0x7CAF3F39FD649E5CULL,
0x2AB6D4DE0BCED4DFULL, 0x3AC8D04ECA5EB68DULL, 0xC55E83E156CBDA52ULL, 0x87B5B7E858C55C3DULL,
0xAB8EE30A9043BD2FULL, 0x7D5A9F55A35B69ACULL, 0x09457FF3C51135C4ULL, 0xAB2C71EB34B31001ULL,
0xEEA6A48E9F232840ULL, 0x34C1837DE49AD370ULL, 0x51B049A6ECEF00C7ULL, 0x26E6D9BAFDBA3203ULL,
0x6B45D23B57EB8D67ULL, 0xB410C158D8C0E73FULL, 0x13EC339183FE0859ULL, 0x8A3D60027DCD20F5ULL,
0x1A0CFA43493B4AEEULL, 0xDDAF447E880263E3ULL, 0x48A4B0B0D87AF000ULL, 0x15070E775A6F5111ULL,
0xFAA78783628382E0ULL, 0x3CA527DFB0A9F703ULL, 0xA486C54E48EEB606ULL, 0x886A31E6B8DADC23ULL,
0xB29A6E50F6ED02FCULL, 0x342B37D9300F7A0AULL, 0x7870C9FA3F96035CULL, 0x0479F28F6D107380ULL,
0xB21EE7C8867648C4ULL, 0x82956713E10E6966ULL, 0x463C097406717820ULL, 0xCFA8F3C358E8F4D8ULL,
0x8C13E4A8423DF2B7ULL, 0x94976F1934E4F737ULL, 0x571E02A9090965C7ULL, 0x251753C1E00922F7ULL,
0x6E0420A881052FAFULL, 0x65D115C40B885A58ULL, 0xE08C57AE58F2A7EBULL, 0x66B0A4E095D94361ULL,
0xE543FF5498EAFD60ULL, 0xEBBBD05C90783AD0ULL, 0x84CBB2BC89F98CBEULL, 0x5011B8EF8A69A1D3ULL,
0x5E179B71D34E46FBULL, 0x47DCBD8320F75CABULL, 0x3C012A383B08FE1FULL, 0x075A57ECDB493AAEULL,
0x09FDB1E26FF434F5ULL, 0x3E5B2EE680C1EA2FULL, 0xF2E1ECB8E0BD5C52ULL, 0x28C03AEC6D540D42ULL,
0x19FB5110EC563EF8ULL, 0xADE33BAEE231FE79ULL, 0x6BEE3E12A6B9BB63ULL, 0x29FBE453F478D6F8ULL,
0x7A1175D90429D0EFULL, 0x05D614B786DD5182ULL, 0x304D0E647CA07426ULL, 0xB2862E4FAE65386BULL,
0x7AAEFF0220179438ULL, 0xF7DA1387FDA72680ULL, 0x9D2AB432A3CA39D8ULL, 0xC5B7A890753A855BULL,
0x1549A02A27AEAE03ULL, 0xE1B9BD14433CDDB2ULL, 0x5ABB927352B02574ULL, 0xDBA41E4A0F1EC08DULL,
0xB904BD48EB8383C8ULL, 0xAC9231414A12CA89ULL, 0xC9C7B3B543056794ULL, 0x45E3DD7CDFD88482ULL,
0xCC6357A39C88D6E9ULL, 0x1E60C025AECB2F40ULL, 0x34D2A3393F88920EULL, 0x7D179874614EDA21ULL,
0x511F755805964877ULL, 0xDAD69E169E1C7EC8ULL, 0xD1CF0D140686AA26ULL, 0x345AFAA208033E3EULL,
0x5706AC5F7C299618ULL, 0x908DEF7A311B462AULL, 0xE16CEE5C16167464ULL, 0x4F7049A1787F56FFULL,
0x2AEFBA10BD582116ULL, 0x0F85A557C50A5E3EULL, 0x78F95E513701AB18ULL, 0x18D8AB9332B61A32ULL,
0x6EC550392BF5908DULL, 0x4600E3A9138F46CDULL, 0xC3D0398ADB68107CULL, 0x54ADEBB2185B657BULL,
0x87A480A724ED9FBEULL, 0x60AAEA7F1067CC19ULL, 0xC969382CA6118D75ULL, 0x0D58D6347327496EULL,
0x0F0E70415ED2698AULL, 0x8B16BAD7D18557C4ULL, 0x04EC3823AF77CE00ULL, 0x37188466601A888AULL,
0x342D3A9E899EC20CULL, 0x0D96F04406AD8E1CULL, 0x5B68C4585D7E0C43ULL, 0x87663214C4AB0B16ULL,
0x3A2F2F28A3AC6F59ULL, 0xC55E8850C57D18CEULL, 0x3D9021F4E2EDFB38ULL, 0x1D1B752E32EC48E5ULL,
0x80B2D0B6B8E05266ULL, 0x33FE90AAAEEFBFFBULL, 0x021B6CA5BB89020BULL, 0xD680F0BA61A4E9FFULL,
0xC34840B70105D10EULL, 0xA335F514B34732AEULL, 0xC5A78AE2B9F4390FULL, 0x721DDBFE1D5E1F28ULL,
0x7D0CFEDB9261123FULL, 0x1A10E614F9821FBEULL, 0x5D40033A7C35D95BULL, 0xD76DF6FAD76A7355ULL,
0x9D49263F1D79DD49ULL, 0x2062916CAF2A800BULL, 0x2870FBA15BFB1013ULL, 0x245CC51E37CD16F8ULL,
	},
	{
0xECF8F794513DEA3AULL, 0xC7686C5C776641CAULL, 0xE3FE172D9394F8D2ULL, 0x6EA6B8CEFD89EBEEULL,
0x71B5782F90A70E74ULL, 0x5F5CC1109BB22AB6ULL, 0x7844CE567739C992ULL, 0x4264F26D0A167740ULL,
0x9DAE270DCC3F025AULL, 0x4D1D3AA38F1C5D8BULL, 0x4EB279C3A73319C7ULL, 0xFDB85DE5E81C4188ULL,
0x6D06450010D2DA77ULL, 0x74C6AF3FD6E7C583ULL, 0xB4F5EDA831D8CB01ULL, 0xFD9285FF104CABCDULL,
0xAB8F1217668947DAULL, 0x3028CAECE301A7C2ULL, 0x13ECC71E5B06B8FCULL, 0xD91FC064B1953496ULL,
0x7F3AC0F20BBBBDD6ULL, 0x7C89B8AA4563327CULL, 0x8889BE9DE4773850ULL, 0xDA92C5FF139FBD22ULL,
0xB29F2A993FECB5D6ULL, 0x55BB9053C8EF6883ULL, 0xAB3DC77638B1D3BAULL, 0x7BBF64A1D33FD38FULL,
0xEC996BDF1401E263ULL, 0x3B7E42462CB24A38ULL, 0x530145518DC43913ULL, 0x838D22EC5DDB02D4ULL,
0x41EDD542F4B36244ULL, 0x1E3CF9CF88AC5CE2ULL, 0x60E7E0B354A186E0ULL, 0xA139EF7C50C269AEULL,
0xCE14D64CE42444C9ULL, 0x301A2F53A0FCF163ULL, 0xE14CC3858A3C6B90ULL, 0xA274345BA17D196BULL,
0x4009CD8397B5F035ULL, 0x5759E347AC8FCB59ULL, 0x0F9346A1BF53C75BULL, 0xA14AE7B1B40BFD96ULL,
0x8838E5D3EF0F3B50ULL, 0x3F0CBAE55433099EULL, 0x097C595DEBF3C1C1ULL, 0xC6E472C4C41D4D8BULL,
0x147D6A7F79594B17ULL, 0x4326F7A4EF2D712AULL, 0x3F0B2C2263A583B2ULL, 0x8021882B4637C8EEULL,
0x472E3A9AFDA8859AULL, 0xB4D4827C42397B63ULL, 0xEC04E7067F5D0757ULL, 0x40F7425725D7400AULL,
0x164A44FB3BA22AF5ULL, 0x343683E44602C8C1ULL, 0x27F87561D216AE81ULL, 0x33BA2353057C2909ULL,
0xFFAE35C15954656FULL, 0x1C5F4197BA0FD8E6ULL, 0x59EEAF72FD1D90BAULL, 0x7123CECDE5B6431EULL,
0xBF62BE51B33AE1BEULL, 0x3EB63B26891D2912ULL, 0x1C986B01791AB1FEULL, 0x9E3B9765D8158886ULL,
0x74FF20DA03814073ULL, 0x6A9FBE4043F919F8ULL, 0xE01B3C04E8C8930FULL, 0x0D12383AA31EF077ULL,
0x2520E8631579F181ULL, 0x7E856BC637C43E01ULL, 0xD678EE50CA5DCC7AULL, 0xBD4A53C27C29C1EEULL,
0xC3EFF6547A364AF1ULL, 0xFF2866A3E4AFF0E7ULL, 0xF77601449CB3A534ULL, 0xD97C90DF3C367863ULL,
0x35C24E8CF372EBB4ULL, 0x724F2566DA2759C0ULL, 0x2932AE7ECD11D5E3ULL, 0x8E686F40B4B97B5EULL,
0xF2CC4AF18996BB9AULL, 0xF9C51F9F3D7F3862ULL, 0xDA33449102BEE9C8ULL, 0x59032BFC095229F4ULL,
0x3AE41F9181FD1972ULL, 0xEBA8D00480021F32ULL, 0x9A22DEC59D35EE49ULL, 0x284E4F7C3384FB23ULL,
0x065FD839AA6D0846ULL, 0x6517C456097FFA58ULL, 0x7E07C2D27A1B6229ULL, 0xF00BBDA1155AB41BULL,
0x20FB3898AEBF6CC2ULL, 0x1425B40DDC4B054EULL, 0x5D24EDA557E1955AULL, 0x8941612FBFFAF55EULL,
0x1BE627E86DBCABB8ULL, 0xB62ED6C377B18FDFULL, 0x3362982A6A1BEA79ULL, 0xFD94CB82D33A9FCFULL,
0x03CD911282343AD1ULL, 0x0775F36B7DDB3380ULL, 0x364CBD11F48FAAEAULL, 0x9A72617E1B1CD2A3ULL,
0x080EE063753FF45CULL, 0x2120E146E22F5A12ULL, 0x69A9E8A701F45E9CULL, 0x6915EEC9D046832FULL,
0x7FEC87B44EBB3F3EULL, 0x827E739DA51A3709ULL, 0xC09FDBA08B67D870ULL, 0xE856B84A206CEFA2ULL,
0xFAEC322A78F95C10ULL, 0x42A7093E625793F4ULL, 0x1872C9F7A590683FULL, 0x255766E5E3AA6DA0ULL,
0x493090652CA06854ULL, 0x277238C136A51167ULL, 0x99D03EC38885E38CULL, 0x8FFE6385A3D855C1ULL,
0xA8F9E648D9C0E8DEULL, 0x9EB75291C1F2BD51ULL, 0x4DBAEE1A875475D5ULL, 0x284A7D605ACD0CF4ULL,
0x8630C3324322EC50ULL, 0xD6EFB1B04AFB1FAFULL, 0xF2F7FDF44C486987ULL, 0xE173F3848C9E6CC5ULL,
0x790B8DC840C316C5ULL, 0x741C1449495F1EA4ULL, 0x61238F10EEE85A9CULL, 0x57E73AACA2C20B88ULL,
0x70BECC3D5E8427A0ULL, 0x9E147505DB275AF6ULL, 0x064E8EE7B89983D6ULL, 0x3711184FAD3C256CULL,
0x374C5223CC15CA76ULL, 0x65111E1DEABEE5F3ULL, 0x4C2D1B90AD0617A1ULL, 0xEC01EBFCEEAC2769ULL,
0xBB5FBCB6530FC429ULL, 0xB9A0EF380A6771B0ULL, 0xF1E702C02B33D59BULL, 0x81DD3FF5D8581D19ULL,
0xCD3BE6B7483CCD19ULL, 0x74DC0F084A185CB7ULL, 0xA76D24B63C424DBCULL, 0xC528FA0F5B2C8273ULL,
0x3BC63CC3AD22A986ULL, 0x2E0581AC8CDA3A10ULL, 0x776AC44264F28226ULL, 0x0AE3C5DBB2A93A6CULL,
0x7E9F1B34F6B3510CULL, 0xDA655CD8228CB6B8ULL, 0xCCCA0CB90ED0D896ULL, 0x387C91070ECBAB77ULL,
	},
	{
0xF05139913E3C69C8ULL, 0x46B7DAAB259F8D82ULL, 0x8FF1FCD3F978410CULL, 0xC684C4F1FF38D6C7ULL,
0xB43BDD524EBCE6B7ULL, 0xCBD79F31A44C8D6DULL, 0xAB27850F60B2AFA3ULL, 0xDC41577B3EDBEC76ULL,
0xC712613EF51021D5ULL, 0x48E9B5D7B0C0B106ULL, 0x23AE59EA0DDA6958ULL, 0x0AAA10EE79E12851ULL,
0xF547228675A0BE8DULL, 0x195A8440AAA28999ULL, 0x5C4F2EE08A0FE3ABULL, 0x9DCFB8981CC01C15ULL,
0x3C769418B7CE157CULL, 0xF7820F7487FF02EFULL, 0x83BAA1AAE991898EULL, 0x0FE88A898B59EBABULL,
0xA33FCA9EA3B6DA5CULL, 0xDED618AA6E9645AAULL, 0xB8CD8B63A4FF903EULL, 0x549009A4336C1B99ULL,
0x0D455507AC1F4C0BULL, 0x17634AE288A82201ULL, 0x19792AB2713FF6C4ULL, 0xA3CEB6F354F3104BULL,
0x382E8A9CF9A3BFBEULL, 0x67AE3234DA2EE3E0ULL, 0x89326FFC2B1FA113ULL, 0x61F88740E57F3F4AULL,
0x4ECBB789EC069855ULL, 0xA9D9F5EE1B8CB170ULL, 0x3BF9F4992BADBFD1ULL, 0x01662FF1337B5355ULL,
0xBF40D0F9E6C9FAD2ULL, 0x41220E73DEAFD4FDULL, 0x52F666069A37F5BEULL, 0xFB00A42B2E6AC455ULL,
0x415199A99DE9D0F5ULL, 0x2CB96FDD83AC9343ULL, 0x17AB6E289112EBC8ULL, 0x3A925B33791BA441ULL,
0x39BA600E57D5EAFEULL, 0xB4E3E263C1C16F22ULL, 0xA2B461862A0044B5ULL, 0x9C063918AAD0A1E4ULL,
0xE79ABEEFD99C518EULL, 0xEF798184C9E0FBB2ULL, 0xFB213C8CC75D217FULL, 0x566132A0644E827BULL,
0x08F8098DF24618B2ULL, 0x98B29AF647999DB8ULL, 0xFB61B8D92EF2A74DULL, 0x71A3057A1DF79349ULL,
0xE3594C51DA6B450EULL, 0xFD496657C586DD8AULL, 0x88C483824B81380FULL, 0xA46D9DAED3C1D402ULL,
0xDD650AF0DCF7942BULL, 0xF2F54EA63A252A4BULL, 0xEA89DD6BAA0A4EC3ULL, 0x3688015AF431DB1DULL,
0x16AC2528FE2438EFULL, 0x1C31C67BC2282F91ULL, 0x4D8E2E9007BB3057ULL, 0xC534DBAE3742B50EULL,
0xAA728AEB95ABDD33ULL, 0xF459E007CD361E70ULL, 0xC18455658599E239ULL, 0x0655002942433F60ULL,
0x8A99A91F1122797DULL, 0x612421D842268AE5ULL, 0x3CC7BB3056DF177DULL, 0xE7707F233DA8C0B1ULL,
0x1F96B7DC5396D3E3ULL, 0xC663515C5FA7BEA8ULL, 0x73B87664FF0B05B8ULL, 0xA5772490C1D0BE9DULL,
0x1A8453286754B711ULL, 0xD9212C2E5E63A260ULL, 0x90BD040A74A45270ULL, 0xBA747A11BFBE5279ULL,
0x2643074376E73269ULL, 0xAF0F4924198C9E3DULL, 0x19C96124BDB18A37ULL, 0xBDFDA5434AC57E0CULL,
0x64ADB96B424B7459ULL, 0xC7499A2242EB12F6ULL, 0x907E8D1EDAE8D26AULL, 0x9583BB51682D4111ULL,
0xE4E3162D85520FC3ULL, 0x096B47AFE7574C29ULL, 0x99DEBE38168CC695ULL, 0x917562D349C270B4ULL,
0x7FA66E380440BD97ULL, 0xF7FBDF5248A30D1FULL, 0xBA93D0FD0C00B275ULL, 0x542FDCE2986591E3ULL,
0xC6CFAAAD3399EB88ULL, 0x932C0DB0520518F6ULL, 0xF4D0BBB9FD1599A3ULL, 0x9FC8CE81B383378CULL,
0xF4CF41FDB022A8E6ULL, 0xA8EC5D6B2BEB5730ULL, 0xD4B90EF649FEBDE6ULL, 0x67AB633A0A8AA5BBULL,
0x094D5646FC18C2A4ULL, 0x8F4EB3CEB44875A1ULL, 0xB86DCBF921099520ULL, 0xC30EA20DF54BBA9DULL,
0x7FD16634369C1F77ULL, 0x86438434E04F28C4ULL, 0x609B1A49BAFD5FE7ULL, 0x9D2D0D99B0585E69ULL,
0x4D873964C24EAD20ULL, 0x3DA9F3374CAE6B78ULL, 0x16ADA535B934D1BEULL, 0x406EE88D624DFB27ULL,
0x1315F15510226FD8ULL, 0x3CB062A5812D5F1AULL, 0xF58CAA5C7A6A7BF5ULL, 0x1943B75C4F13BD63ULL,
0xAF8467CB036684E0ULL, 0x278E1F32ACD0AD03ULL, 0x21EE02457B39EC25ULL, 0x4DF5D8399E179EBEULL,
0xA14143CBA3FA2933ULL, 0x208B28F8DF618A76ULL, 0xFF42ABEA174FAF60ULL, 0x082F4A4E586F7B67ULL,
0xE2286E0913C21563ULL, 0xC1604FB00577BFE1ULL, 0xAE2BA453405AAAF1ULL, 0x8D70FD4283FDB371ULL,
0x2BB1CDE4FC46BF90ULL, 0x69EA1BB92BEC548AULL, 0x618F1333FF9D7BD2ULL, 0x834141F98079191AULL,
0xD02577E7E987548CULL, 0xE12E3CDDCFC9BFA8ULL, 0x573C1587D747CDB8ULL, 0xFC4835A10B7F2CE7ULL,
0x95F0B6C3470C791AULL, 0x85BA77DB3FA4BFCFULL, 0x811DAF365874DACEULL, 0x2B2F3FFA9082E8AFULL,
0x41FE97DEF421245DULL, 0x8A4D4BB5537339CFULL, 0x2C09ACBD82E5850AULL, 0xD85AFDEAA9B99A86ULL,
0xBE34E452A446245DULL, 0xFBDFC7C7FFD6BFEDULL, 0x31237DD9C36FBA30ULL, 0xF7733151F7079088ULL,
0x08F9AF8680D61DBDULL, 0x8DF34B9689D1A288ULL, 0x7ECA5235A6181372ULL, 0xF9CF8F20AFC89691ULL,
	},
	{
0x972674CDEA32CF34ULL, 0x8B77B6EC69911F95ULL, 0xEAF8C87E278AA972ULL, 0xC4AF51F9AA54FB57ULL,
0x1FB764DDE2FD5186ULL, 0x6CDF2FA85283D5C9ULL, 0xB32D6E349DA321A4ULL, 0xA5B88AF1AAEAE4B6ULL,
0x6B84E5EBBB01DD9CULL, 0xE24AA4F3E5A51C8DULL, 0x58CDB1F3B5D5EA05ULL, 0x856C08B7A84D6BB1ULL,
0x0FC5595D683BE47EULL, 0xA940FFC759CFFC87ULL, 0x05D7D77150A708E0ULL, 0x3D62FE1EEC20A422ULL,
0x3B93E30EA485C54FULL, 0x02A64C4DF536BDAFULL, 0x101B4C3690985D75ULL, 0x2C817EE02DE7D501ULL,
0x2D339E043E3D8368ULL, 0x99615A59D8AEACDFULL, 0xF8FC0770144A5B01ULL, 0xA4B09B5725635FFEULL,
0xDF84A9A8312A7294ULL, 0x8E43BAAB626795BBULL, 0x13BCCED04B5DDA6EULL, 0x54502D87AEE40602ULL,
0x1C733885FC94AA6EULL, 0xA658D1F9ED10D204ULL, 0x9F64A969FAFFF3A6ULL, 0x48893065E6918990ULL,
0x618B098CEB8E51E5ULL, 0xD87EFAB4F07E0F4CULL, 0x6136099447320F86ULL, 0x6575BA61DF9BF00DULL,
0x4395F4D5447013E9ULL, 0xB754EE9EC8BB2C12ULL, 0x0CBC76D6D5C0A37AULL, 0x7115F43CDC72E2EBULL,
0x3E5274E994904E2EULL, 0x747BF116A88DCD3BULL, 0x066BC0CEDFED47BDULL, 0x0E1EA5172CE0F1B6ULL,
0x1D4055948D22CB26ULL, 0x7A3273327C748CF6ULL, 0x4DCE042447D31936ULL, 0x439C2CCF1722B60EULL,
0x6A7BF1322659180FULL, 0xD83A2A98C318E400ULL, 0x9C580A7B06799802ULL, 0x6E64059870EE1A73ULL,
0x90ABA588FDAEC82BULL, 0x011AD41FA02C2E4CULL, 0x05B9CE6A879A739EULL, 0xB95F25DECD76450BULL,
0x9D11691A24673620ULL, 0x94B01B2DAEC56C13ULL, 0xA6D12C77C820F5B3ULL, 0x79A5DB6B6553E73AULL,
0xCE99AA0BD34D9473ULL, 0x35185EE45828A042ULL, 0x30300A164C59FC89ULL, 0x0B70F8CB1D6FF327ULL,
0x5F0BDF7EB8955E31ULL, 0xA2E64E07B403ED51ULL, 0x59357BAE42D5B61FULL, 0x0CDF6DFF51D9F824ULL,
0x3350767CD4FE78B4ULL, 0x9DB692A93729D17BULL, 0x88B1B2A069038CE0ULL, 0x1390A5694999A6FAULL,
0x5FC1035C1D25978FULL, 0x460F06A4B5B3235BULL, 0x402DBC52867BF707ULL, 0x3A0A3E02786D3F13ULL,
0xAD96E0B3540BB3A0ULL, 0xFD9729CB7D9CAFEFULL, 0x16BD5B3F9401199FULL, 0x2204FBD3F37FE593ULL,
0x8E64A4C3D3CEA641ULL, 0x02A2D2E78ED39AF9ULL, 0x5064830AE3357025ULL, 0x487207AFBE0F274DULL,
0x2AAB1672399739A5ULL, 0x440E547335BDE2CEULL, 0x5F174096DBFEE9D9ULL, 0xC873D739D310269BULL,
0x787E8AC329BF3F4FULL, 0x2A768E248D2AA87DULL, 0xDA43172324A92DA7ULL, 0xEA0E562110B73623ULL,
0x873FD3D7A1237DB4ULL, 0x53BBA428ACC51D64ULL, 0xB9FA1B6B49B1F5BBULL, 0x19BE29B46B07E175ULL,
0x6D682A6688B08600ULL, 0x7DDC553788EE3724ULL, 0xE2A655C83A4FB3B7ULL, 0x25DF27A40A41A493ULL,
0x8571BACE801EC2FDULL, 0x1E26285EC9148AF8ULL, 0x4E5534572EA6EE8BULL, 0xDEDC591A3A5AD35EULL,
0xE6C4BE9814E75220ULL, 0x61B6EB921973F176ULL, 0x609B162ACCBA0AF7ULL, 0x7747230A505671E6ULL,
0x47C74B86DA6A77B7ULL, 0x94533C09BD59D3AEULL, 0x32043875A1086FAAULL, 0x40B16CCCEAA2FE96ULL,
0xB5F941231846BF3FULL, 0x2A95115066CF42AEULL, 0xE01B8EBE3FE1360AULL, 0xA264DDF931596F56ULL,
0xD126FDDC03E918DBULL, 0xEC65842F98BE3A6CULL, 0x2F0A4F19A46CD89BULL, 0x66EA8C8AFB84E27CULL,
0x76AAC498BA5184F3ULL, 0xFCD04A491889B115ULL, 0x09C43B63A2699010ULL, 0xBD69B43FFE4BC4B0ULL,
0x09CFFBD56F051EEEULL, 0xBC2F9F7E341253BAULL, 0xADCCF0807F9B4FFDULL, 0x8BD650466B1B6CAFULL,
0xC635AF49853C981CULL, 0xC19F9620E1411168ULL, 0x8F8EC49F09F0942CULL, 0xEEF9B027A1BD6DF2ULL,
0xC958FD0A883C73BCULL, 0x68D406D8FBF1D5A1ULL, 0x444AFD81BF596F96ULL, 0x054360F6DB642337ULL,
0xC026573537EF9526ULL, 0xB136995B275B133AULL, 0xFE8F67C7DC568E03ULL, 0x617F03C5F3B231F1ULL,
0x65A6C31C1EA8F11DULL, 0x6B5F9EE617EF0096ULL, 0x6A59983F6635194CULL, 0xC251EA61B4A6079FULL,
0x3FB77EFC651A7346ULL, 0xF1DEB7704AA6A653ULL, 0xF5AC60398608B340ULL, 0xEB8C934C4A8E91FBULL,
0x46E5B729D98A68B9ULL, 0xEA5C7AAF6EC32150ULL, 0xD2DD3DDDC94DF52FULL, 0xBE565DFAC4DDB31CULL,
0x664933D35F3300C4ULL, 0xCC0D9DD7070AB918ULL, 0x4157D1891D492616ULL, 0xED2C105EC9003274ULL,
0x008728393AD6B4C6ULL, 0x28744F23076FABB5ULL, 0xEA06A12E9A1A1875ULL, 0xE8AF06AADC232BB0ULL,
	},
};

