# 遺跡・第一階層

@name = _("第一階層")
@bgm = :Dungeon1



in_region(:Entrance){
	treasure_level 1
	appearing_enemy 40, :SmallVine
	appearing_enemy 35, :Bandit
	appearing_enemy 10, :SmallVine, :Bandit
	appearing_enemy 10, :SmallVine, :SmallVine
	appearing_enemy 5, :Bandit, :Bandit

	set_wall(10, 1, DIR_N, Area::EXIT_DOOR)
	set_tereport_point(10, 2)

	set_locked_door(20, 14, DIR_S, 'grave_s', :KeyOfGraveKeeper)
	set_locked_door(20, 10, DIR_N, 'grave_n', :KeyOfGraveKeeper)
	set_locked_door(23, 23, DIR_E, 'wizard_zone', :KeyOfWizard)

	
}

# 西の離れ
in_region(:WestAnnex){
	treasure_level 1
	appearing_enemy 30, :SmallVine
	appearing_enemy 20, :SmallVine, :SmallVine
	appearing_enemy 30, :SpiritHead
	appearing_enemy 20, :SpiritHead, :SmallVine


}

in_region(:KeyOfGraveKeeperRoom){
}


# 東の離れ
in_region(:EastAnnex){
	treasure_level 2
	appearing_enemy 30, :Bandit, :SmallVine
	appearing_enemy 35, :Bandit
	appearing_enemy 15, :StraySorcerer
	appearing_enemy 15, :Imp

}

in_region(:CompassRoom){
}

# 第二階層へ向かう道
in_region(:RouteTo2F){
	treasure_level 2
	appearing_enemy 30, :Bandit
	appearing_enemy 30, :StraySorcerer
	appearing_enemy 10, :StraySorcerer, :StraySorcerer
	appearing_enemy 10, :Bandit, :SmallVine
	appearing_enemy 10, :Bandit, :StraySorcerer
	appearing_enemy 5, :SpiritHead
	appearing_enemy 5, :Bandit, :Bandit
	set_stair(23, 27, DIR_S, '2', 24, 24, DIR_S)
}

in_region(:GlimRoom){
}



def on_move(party)
	if party.is_position?(23, 19, DIR_S) then
		show_special_action(:special_detect, _("[A] 祭壇を調べる"), 'A')
	elsif party.is_position?(23, 16) then
		if GS.switch[:GetCompass] then
			unless GS.switch[:BusterImp] then
				BGM.fade_out
				message(_("部屋を出ようとした%{party}の耳に\n翼のはためく音が聞こえてきた……\n\nどうやら、この羅針盤を持ち帰るためには\n目の前の魔物たちを撃退しなくてはならないようだ！").evaluate(:party => party.name))
				
				troop = BossTroop.new
				troop.add_enemies('Imp', 4)
				re = Game.battle(troop)
				GS.switch[:BusterImp] = true if re

			end
		end
	end

end

def on_special_action(party, action_id)
	case action_id
	when :special_detect
		if GS.switch[:GetCompass] then
			holder = party.find_item_holder('CompassOfSpell')
			if holder then
				msg = _("%{holder}の持っている羅針盤を、元の位置に戻しますか？")
				if Game.ask(msg.evaluate(:holder => holder.name)) then
					holder.lose_item('CompassOfSpell')
					GS.switch[:GetCompass] = false
					
					msg = _("%{hold\er}は$c[item]%{item}$cを元に戻した")
					Game.message(msg.evaluate(:holder => holder.name, :item => DB.find_item('CompassOfSpell').name))
					Game.save(FQ_BIG_CHANGE, "呪われた羅針盤返還")
				end
			else
				message(_("祭壇の上には何も置かれていない"))
			end
		else
			message _("祭壇の上に置いてあるのは、古めかしい羅針盤だった\n\n方角を示す針以外にも、いくつかの針がはめ込んであり\n呪文の力で動作しているようだ")

			Game.ask_about_item_recieving(Item.new('CompassOfSpell'), _("羅針盤を持っていきますか？")) do
				GS.switch[:GetCompass] = true
			end
		end
	end
end

def on_enter_region(party, old_region)
	case party.region
	when :KeyOfGraveKeeperRoom
		$phase.hide_sub_windows

		BGM.fade_out
		message(_("部屋に踏み込むと、中には一人の年老いた男が腰掛けていた\n\n筆を執り、羊皮紙に何かを書き記している"))
		BGM.play(:NPC1)
		message(_("老人はこちらに気付くと、静かに語りだした……\n\n「ようこそ、冒険者よ。\n私は墓守のカロン。何か聞きたいことがあれば答えよう」"))
		
		loop do
			selects = []
			selects << SelectItem.new(:who_are_you, _("あなたは何者？"))
			selects << SelectItem.new(:rabyrinth, _("この迷宮について聞く"))
			selects << SelectItem.new(:treasure, _("財宝はあるか？"))
			unless party.find_item_holder('KeyOfGraveKeeper') then
				selects << SelectItem.new(:please_key, _("扉の鍵が欲しい"))
			end
			selects << SelectItem.new(:cancel, _("話をやめる"))
			
			id = Game.select(selects)
			
			case id
			when :who_are_you
				message _("「私はここで、この墳墓を守っている。\n盗掘者たちが、みだりに奥に踏み込まぬように。\nまた、邪霊や魔物たちが、奥から這い出してこぬように。\n\nここの墓守を続けて、もう362年ほどになるか……」")
			when :rabyrinth
				message _("「この迷宮は、ある王家のために作られた巨大な墳墓だ」")
				message _("「はるか昔、この地で力を奮った国があった。\nここにはその国で暮らしていた\n兵士や宦官、王家の者たちが眠っている。」")
				message _("「王国が滅び、人が去り……\n三百年あまりの間は、この墳墓もずっと静かなものだった。\n\nだが、ここ数年でその静穏も乱されつつある。\n君たちも見ただろう、魔物や邪霊、盗賊のはびこる今の状況を」")
				message _("「君たちには、この迷宮の深部に潜り\n魔物たちが現れた原因を探ってもらいたい。\n\nそして願わくば、この墳墓に再び安息を取り戻してほしい」")
			when :treasure
				message _("「いくつかの部屋には宝物が隠されているはずだ。\n奥に進めば、希少な宝石や魔法の道具も眠っているだろう。\n\n見つけたものは君たちの好きにしていい」")
				message _("「ただし、奥に進むほど危険は増す。\n財宝目当てに深部を目指すのは構わないが\nそのために道半ばで倒れられては困る」")
			when :please_key
				key = Item.new('KeyOfGraveKeeper')
				getter = party.get_item(key)
				
				if getter then
					message _("「いいだろう、少し待ちなさい」\n\nカロンは奥にかけられている鍵束の内から\n一つを取り出し、%{party}に差し出した").evaluate(:party => GS.party.name)
					message _("「この鍵があれば、迷宮の奥に通じる扉を開くことができる。\n$c[em]先に進むなら、南東の区画を目指しなさい。$c\n\n君たちは迷宮に入るとき、北側の扉から入ってきたはずだ。\nそれを考えればおおよその位置は分かるだろう」")
				  message _("「北東の区画は行き止まりだが\n奥の部屋に、探索に役立つ道具がある。\n寄り道するのもいいだろう。\n\nただしあそこには、強力な魔物が徘徊している。気をつけたまえ」")
				
					SE.coin
					message _("#{getter.name}は$c[item]%{item}$cを手に入れた").evaluate(:getter => getter.name, :item => key.name)
					Game.save(FQ_BIG_CHANGE, "墓守の鍵入手")
				else
					message _("「鍵を持てる者がいないようだが……？」")
				end
			when :cancel
				message _("「%{party}の前途に幸運があらんことを！」").evaluate(:party => GS.party.name)
				break
			end
		end
		BGM.play(:Dungeon1)
		$phase.show_sub_windows
		DUNGEON_WINDOW.update
	when :CompassRoom
		if GS.switch[:GetCompass] then
			dungeon_message _("この部屋の床には、一面によく分からない図形が描かれており\nその図形を囲うようにして呪文が描かれている\n\n部屋の奥には、簡単なつくりの祭壇があり\nその壇上には何も置かれていない")
		else
			dungeon_message _("この部屋の床には、一面によく分からない図形が描かれており\nその図形を囲うようにして呪文が描かれている\n\n部屋の奥には、簡単なつくりの祭壇があり\nその壇上に何か、道具のようなものが置いてある")
		end
	when :GlimRoom
		if (holder = GS.party.find_item_holder('GlimWand')) then
			message(_("%{holder}の持っている灯の杖が、急に赤く輝きはじめた……") % {:holder => holder.name})
		end

	end
end

def on_detect(party)
	if party.region_id == :GlimRoom then
		msg = _("%{detector}は辺りを調べた\n\nよく見ると、床に一つだけ色の違う石がある\n触れてみますか？").evaluate(:detector => GS.party.members.first.name)
		if Game.ask(msg) then
			if party.on?(18, 20) then
				shoot('3', 16, 25, DIR_E)
			elsif party.on?(13, 20) then
				shoot('2', 35, 14, nil)
			else
				raise 'shoot target unspecified'
			end
		end
		
		return true
	end
end


=begin
イベント発生条件：指定位置に進入(PointEvent)、指定リージョンに進入(RegionEvent)


on_walk = proc do
end

on_detect = proc do
end

on_action = proc do |action_id|
end


=end
