	
special_action :VineBind do
	@effect = AttackEffect.new
	@effect.state_data = [[VineState, 1, 70]]
	@effect.messages = ["%{actor}はツルを足に絡みつかせてきた！"]
	@effect.shield_guardable = false
end
	
special_action 'VineShot' do
	@effect = AttackEffect.new
	@effect.attack_number = 4
	@effect.fixed_damage = 16
	@effect.hitting_border_base = 50
	@effect.hitting_type = :weapon_hitting
	@effect.damage_types = [DT_THRUST]
	@effect.messages = ["%{actor}は、無数の種を弾丸のように撃ち出してきた！"]
end


special_action 'ImpFire' do
	@effect = AttackEffect.new
	@effect.damage_types = [DT_HEAT]
	@effect.messages = ["%{actor}は口から火の玉を吐き出した！"]
	@effect.fixed_damage = 30
	@effect.hitting_border_base = 60
	@effect.hitting_type = :weapon_hitting
	
end

special_action 'SpiritFire' do
	@effect = AttackEffect.new
	@effect.damage_types = [DT_HEAT]
	@effect.fixed_damage = 20
	@effect.hitting_border_base = 70
	@effect.messages = ["%{actor}は鬼火を放った！"]
end


special_action 'SpiritCurse' do
	@effect = AttackEffect.new
	@effect.messages = ["%{actor}は強い怨念を放った！"]
	@effect.state_data = [[CurseState, 5, 65]]
end

special_action 'PixieFlying' do
	@effect = Effect.new
	@effect.messages = [
		"%{actor}は気ままに飛び回っている",
		"%{actor}は羽をはためかせている",
	]
end

special_action 'Sleepy' do
	@effect = Effect.new
	@effect.messages = [
		"%{actor}は眠そうにしている……",
	]
end

special_action 'FeatherSlasher' do
	@effect = GroupAttackEffect.new
	@effect.damage_types = [DT_SLASH]
	@effect.messages = ["%{actor}は翼を大きくはためかせた！\n巻き起こった風が%{target}を切り裂く！"]
	@effect.fixed_damage = 30
	@effect.attack_number = 3
	@effect.hitting_border_base = 60
	@effect.hitting_type = :weapon_hitting
end


special_action 'KoboltLeaderImperium' do
	@effect = SpecialEffect.new
	@effect.messages = ["%{actor}は攻撃命令を出した！\nコボルトワーカー達が一斉に襲い掛かってくる！"]
	@effect.proc = proc do
		$battle.characters.each do |chara|
			if chara.respond_to?(:data_id) and chara.data_id == 'KoboltWorker' then
				chara.add_state(ImperiumState.new(5))
			end
		end
	end
end

special_action 'FeatherSlasher' do
	@effect = GroupAttackEffect.new
	@effect.damage_types = [DT_SLASH]
	@effect.messages = ["%{actor}は翼を大きくはためかせた！\n巻き起こった風が%{target}を切り裂く！"]
	@effect.fixed_damage = 20
	@effect.attack_number = 3
	@effect.hitting_border_base = 60
	@effect.hitting_type = :weapon_hitting
end

special_action 'SlimePoison' do
	@effect = AttackEffect.new
	@effect.damage_types = []
	@effect.messages = ["%{actor}は紫色の毒液を飛ばしてきた！"]
	@effect.fixed_damage = 30
	@effect.hitting_border_base = 50
	@effect.hitting_type = :weapon_hitting
	@effect.state_data = [[PoisonState, 1, 70]]
	
end

special_action 'SlimeCorrosion' do
	@effect = AttackEffect.new
	@effect.damage_types = []
	@effect.messages = ["%{actor}は透明な酸を飛ばしてきた！"]
	@effect.fixed_damage = 30
	@effect.hitting_border_base = 50
	@effect.hitting_type = :weapon_hitting
end

special_action 'GhostHand' do
	@effect = AttackEffect.new
	@effect.damage_types = [DT_COLD]
	@effect.messages = ["%{actor}は、%{target}に向けて誘うように手を伸ばしてきた……"]
	@effect.fixed_damage = 30
	@effect.hitting_border_base = 99
	@effect.hitting_type = :magic_control
	@effect.state_data = [[SleepState, 1, 50], [CurseState, 4, 50], [TerrorState, 1, 50]]
	
end


special_action 'GhostEye' do
	@effect = Effect.new
	@effect.messages = [
		"%{actor}は誘うようにこちらを見ている……",
		"%{actor}は何かを訴えるようにこちらを見ている……",
		"%{actor}は恨めしい表情でこちらを見ている……",
		"%{actor}は笑いながらこちらを見ている……",
		"%{actor}は無表情でこちらを見ている……",
	]
end




special_action 'HeatBless' do
	@effect = GroupAttackEffect.new
	@effect.damage_types = [DT_HEAT]
	@effect.messages = ["%{actor}は口から炎を吐いた！"]
	@effect.fixed_damage = 50
	@effect.hitting_border_base = 60
	@effect.hitting_type = :weapon_hitting
end

special_action 'ColdBless' do
	@effect = GroupAttackEffect.new
	@effect.damage_types = [DT_COLD]
	@effect.messages = ["%{actor}は口から冷気を吐いた！"]
	@effect.fixed_damage = 50
	@effect.hitting_border_base = 60
	@effect.hitting_type = :weapon_hitting
end

special_action 'LostArmorCurse' do
	@effect = GroupAttackEffect.new
	@effect.messages = ["%{actor}は自らの兜を取り外した！\n空っぽの鎧から、凄まじい怨念が放たれる！"]
	@effect.state_data = [[CurseState, 5, 65]]
end

