# メッセージクラス
module DarkHall


	class Message
	
		module Effect
			MEMBER_DAMAGE = :member_damage
			ENEMY_DAMAGE = :enemy_damage
		end
		

		attr_reader :lines
		attr_accessor :effect_type, :target_window
		bool_attr_accessor :clean_hit, :shield_guard
	
	
		def initialize(body = [], effect_type = nil)
			case body
			when Array
				@lines = body
			else
				@lines = body.to_s.split("\n")
			end
			@effect_type = effect_type
			@target_window = nil
			
			@clean_hit, @shield_guard = false, false
		end
		
		def shaking_level
			(@clean_hit ? 2 : 1)
		end
		
		
		def play_se
			case @effect_type
			when Effect::MEMBER_DAMAGE, Effect::ENEMY_DAMAGE
				if @clean_hit then
					SE.clean_hit
				else
					SE.hit
				end
			else
				#MEMO: おそらくここでの再生はしないほうがよい
				#      (Window#select_seにまかせるべき)
				SE.select
			end
		end
		
		def <<(line)
			@lines << line
		end
		
		def +(other)
			case other
			when Message
				Message.new(@lines + other.lines, @effect_type)
			when String
				Message.new(@lines + [other], @effect_type)
			else
				Message.new(@lines + other, @effect_type)
			end
		end
		
	end

	

end
	
