# 音管理

module DarkHall
	
	BGM_FILE_NAMES = {
		:Town => 'town.ogg',
		:Camp => 'camp.ogg',
		:NPC1 => 'npc_key.ogg',
		:NPC2 => 'npc_sub.ogg',
		:Dungeon1 => 'dungeon1.ogg',
		:Dungeon2 => 'dungeon2.ogg',
		:Battle => 'battle1.ogg',
		:BossBattle => 'battle2.ogg',
		:BossBattle2 => 'battle7b.mp3',
	}
	
	BGM_TITLES = {
		:Town => _('冒険者達の故郷'),
		:Camp => _('探索の光'),
		:NPC1 => _('古よりの使者'),
		:NPC2 => _('さくせん：ふざけろ'),
		:Dungeon1 => _('恐怖に負けるな'),
		:Dungeon2 => _('闇の中、彷徨うのは誰？'),
		:Battle => _('襲い来る魔の手'),
		:BossBattle => _('生死を分かつ時'),
		:BossBattle2 => _('（ボス戦曲/曲名未定）'),
	}
	
	class BGMControl
		DIR_PATH = Pathname.new('./res/bgm')

		def initialize
			@musics = {}
			@playing = nil
			@main_key = nil
		end
		
		def get_file_path(key)
			BGM_FILE_NAMES[key.to_sym]

		end
		
		def on_every_frame
			if @main_key and not SDL::Mixer.play_music? then
				play(@main_key)
				@main_key = nil
			end
		end
		
		def play(key, loop = -1)
			if key == @playing then
				# 同じBGMならそのまま演奏継続
				return false
			end
		
#			unless @musics[key] then
#				load(key)
#			end
			load(key) unless @musics[key]
			SDL::Mixer.play_music(@musics[key], loop)
			GS.found_bgms[key.to_s] = true
			
			@playing = key
			
			return true
		end
		
		def play_in_loop(intro_key, main_key)
			@main_key = main_key
			play(intro_key, 1)
		end
		
		def load(*keys)
			# ロード済みの音楽は読まない
			keys -= @musics.keys
			
			keys.each do |key|
				path = get_file_path(key)
				@musics[key] = Res.load_bgm(path)
			end

			return self
		end
		
		def stop
			SDL::Mixer.halt_music
			@playing = nil
			@main_key = nil
			
			return self
		end
		alias halt stop
		
		def fade_out
			SDL::Mixer.fade_out_music(1000)
			@playing = nil
			@main_key = nil
			
			return self
		end
		
		def clear
			load()
			
			return self
		end
		alias release clear

	end
	
	BGM = BGMControl.new

	class SEControl
		CHANNEL_1 = 2
		CHANNEL_2 = 3
		CHANNEL_3 = 4
		STEP_CHANNEL = 5


		
		def initialize
			@channel = CHANNEL_1
			@sounds = {}
		end
		
		def load
			@sounds.clear
			@sounds[:cursor_move] = Res.load_se('osa/pi77.wav')
			#@sounds[:select] = Res.load_se('select.wav')
			@sounds[:select] = Res.load_se('crefac/decide.wav')
			#@sounds[:select] = Res.load_se('utm/mokin.wav')
			#@sounds[:cancel] = Res.load_se('kizi020.wav')
			@sounds[:cancel] = Res.load_se('crefac/select.wav')
			@sounds[:equip] = Res.load_se('eucalyptus_tree/katana1.wav')
			@sounds[:encount] = Res.load_se('eucalyptus_tree/ect4.wav')
			@sounds[:coin] = Res.load_se('osa/bell04.wav')
			@sounds[:step] = Res.load_se('osa/step05.wav')
			@sounds[:door] = Res.load_se('osa/door01.wav')
			@sounds[:sonar] = Res.load_se('osa/cursor34.wav')
			@sounds[:remove_trap] = Res.load_se('osa/chari13_a.wav')
			@sounds[:unlock] = Res.load_se('osa/chari13_b.wav')
			@sounds[:trap_switch] = Res.load_se('osa/kachi05.wav')
			@sounds[:open_box] = Res.load_se('osa/open45.wav')
			@sounds[:hit] = Res.load_se('osa/hit10_b.wav')
			@sounds[:clean_hit] = Res.load_se('osa/hit14_b.wav')
			@sounds[:perfect_guard] = Res.load_se('osa/metal45_a.wav')
		end

		def flip_channel
			case @channel
			when CHANNEL_1
				@channel = CHANNEL_2
			when CHANNEL_2
				@channel = CHANNEL_3
			when CHANNEL_3
				@channel = CHANNEL_1
			end
		end

		def cursor_move
			SDL::Mixer.play_channel(@channel, @sounds[:cursor_move], 0)
			flip_channel
		end
		
		def select
			SDL::Mixer.play_channel(@channel, @sounds[:select], 0)
			flip_channel
			#puts(caller + [''])
		end
	
		def cancel
			SDL::Mixer.play_channel(@channel, @sounds[:cancel], 0)
			flip_channel
		end
		
		def step
			SDL::Mixer.play_channel(STEP_CHANNEL, @sounds[:step], 0)
			flip_channel
		end
		
		def door
			SDL::Mixer.play_channel(@channel, @sounds[:door], 0)
			flip_channel
		end
	
	
	
		def equip
			SDL::Mixer.play_channel(@channel, @sounds[:equip], 0)
			flip_channel
		end
		
		def coin
			SDL::Mixer.play_channel(@channel, @sounds[:coin], 0)
			flip_channel
		end
		
		def encount
			SDL::Mixer.play_channel(@channel, @sounds[:encount], 0)
			flip_channel
		end
		
		def remove_trap
			SDL::Mixer.play_channel(@channel, @sounds[:remove_trap], 0)
			flip_channel
		end
		
		def sonar
			SDL::Mixer.play_channel(@channel, @sounds[:sonar], 0)
			flip_channel
		end


		def unlock
			SDL::Mixer.play_channel(@channel, @sounds[:unlock], 0)
			flip_channel
		end
		
		def trap_switch
			SDL::Mixer.play_channel(@channel, @sounds[:trap_switch], 0)
			flip_channel
		end


		def open_box
			SDL::Mixer.play_channel(@channel, @sounds[:open_box], 0)
			flip_channel
		end
		
		def hit
			SDL::Mixer.play_channel(@channel, @sounds[:hit], 0)
			flip_channel
		end
		
		def clean_hit
			SDL::Mixer.play_channel(@channel, @sounds[:clean_hit], 0)
			flip_channel
		end
		
		def perfect_guard
			SDL::Mixer.play_channel(@channel, @sounds[:perfect_guard], 0)
			flip_channel
		end


		
	end
		
	SE = SEControl.new
		
		
		
	

end

