/*
 * Decompiled with CFR 0.152.
 */
package daruma.sql;

import daruma.geometry.DrmGeometry;
import daruma.global_switch.ImplementationSwitches;
import daruma.sql.DatabaseCalendarConfig;
import daruma.sql.DatabaseConnection;
import daruma.sql.DatabaseConnectionException;
import daruma.sql.SQLTimeFormatConverter;
import daruma.sql.TableColumn;
import daruma.storage_manager.type_definition.ColumnNameFactory;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.util.ISO8601DateFormat;
import daruma.util.LogWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementInserter {
    private ElementInserter() {
    }

    public static void executeInsert(DatabaseConnection db, String tableName, List<TableColumn> columns, long transactionSN) throws DatabaseConnectionException {
        PreparedStatement st = ElementInserter.getPreparedStatement(db, tableName, columns);
        long objectID = db.getMaxLongValueFromTable(tableName, "_id_");
        ElementInserter.setValuesToPreparedStatement(st, transactionSN, ++objectID, columns);
        try {
            db.executeUpdate(st);
            st.close();
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException(e.getMessage(), e);
        }
        ElementInserter.executeInsertToSubTable(db, columns, objectID);
    }

    public static void executeBulkInsert(DatabaseConnection db, String tableName, List<TypedInstance> objs, long transactionSN) throws DatabaseConnectionException {
        PreparedStatement st = ElementInserter.getPreparedStatement(db, tableName, objs.get(0).getColumns());
        long objectID = db.getMaxLongValueFromTable(tableName, "_id_");
        ++objectID;
        for (TypedInstance obj : objs) {
            List<TableColumn> columns = obj.getColumns();
            ElementInserter.setValuesToPreparedStatement(st, transactionSN, objectID, columns);
            try {
                st.addBatch();
                st.clearParameters();
            }
            catch (SQLException e) {
                LogWriter.qwrite("DEBUG", "add batch failed, ", e.getMessage());
                if (e.getNextException() != null) {
                    LogWriter.qwrite("DEBUG", "detailed exception is [", e.getNextException().getMessage(), "]");
                }
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
            ElementInserter.executeInsertToSubTable(db, columns, objectID);
            ++objectID;
        }
        try {
            st.executeBatch();
            st.close();
        }
        catch (SQLException e) {
            LogWriter.qwrite("DEBUG", "insert failed, ", e.getMessage());
            if (e.getNextException() != null) {
                LogWriter.qwrite("DEBUG", "detailed exception is [", e.getNextException().getMessage(), "]");
            }
            throw new DatabaseConnectionException(e.getMessage(), e);
        }
    }

    private static PreparedStatement getPreparedStatement(DatabaseConnection db, String tableName, List<TableColumn> columns) throws DatabaseConnectionException {
        StringBuilder s = new StringBuilder();
        s.append("INSERT INTO " + tableName + " (");
        s.append("_transaction_id_");
        s.append(",");
        s.append("_create_time_");
        s.append(",");
        s.append("_update_time_");
        s.append(",");
        s.append("_id_");
        for (TableColumn c : columns) {
            s.append(",");
            s.append(c.getDefinition().getColumnName());
        }
        s.append(") ");
        s.append("VALUES (");
        int wildcardCount = 0;
        s.append("?");
        ++wildcardCount;
        s.append(",");
        s.append("NULL");
        s.append(",");
        s.append("NULL");
        s.append(",");
        s.append("?");
        ++wildcardCount;
        for (TableColumn c : columns) {
            s.append(",");
            Class javaClass = c.getDefinition().getSQLDataType().getJavaClass();
            if (DrmGeometry.class.isAssignableFrom(javaClass)) {
                ++wildcardCount;
                s.append("GeomFromText(?)");
                continue;
            }
            if (Date.class.isAssignableFrom(javaClass)) {
                ++wildcardCount;
                s.append("?");
                continue;
            }
            ++wildcardCount;
            s.append("?");
        }
        s.append(")");
        LogWriter.qwrite("DEBUG", "#", s);
        PreparedStatement st = null;
        st = db.prepareStatement(s.toString());
        return st;
    }

    private static void setValuesToPreparedStatement(PreparedStatement st, long transactionSerialNumber, long objectID, List<TableColumn> columns) throws DatabaseConnectionException {
        try {
            int wildcardIndex = 1;
            st.setLong(wildcardIndex, new Long(transactionSerialNumber));
            st.setLong(++wildcardIndex, new Long(objectID));
            ++wildcardIndex;
            for (int i = 0; i < columns.size(); ++i) {
                int value;
                TableColumn col = columns.get(i);
                if (col.isEmptyColumn() || col.getValue() == null) {
                    st.setNull(wildcardIndex, 0);
                    ++wildcardIndex;
                    continue;
                }
                Class c = col.getDefinition().getSQLDataType().getJavaClass();
                if (c.equals(String.class)) {
                    st.setString(wildcardIndex, col.getValue());
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Boolean.class)) {
                    value = Boolean.parseBoolean(col.getValue());
                    st.setBoolean(wildcardIndex, value != 0);
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Double.class)) {
                    double value2 = Double.parseDouble(col.getValue());
                    st.setDouble(wildcardIndex, value2);
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Float.class)) {
                    float value3 = Float.parseFloat(col.getValue());
                    st.setFloat(wildcardIndex, value3);
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Long.class)) {
                    long value4 = Long.parseLong(col.getValue());
                    st.setLong(wildcardIndex, value4);
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Integer.class)) {
                    value = Integer.parseInt(col.getValue());
                    st.setInt(wildcardIndex, value);
                    ++wildcardIndex;
                    continue;
                }
                if (Date.class.isAssignableFrom(c)) {
                    Date dateTime;
                    ISO8601DateFormat f = new ISO8601DateFormat();
                    try {
                        dateTime = f.parse(col.getValue());
                    }
                    catch (ParseException e) {
                        throw new DatabaseConnectionException(e);
                    }
                    if (ImplementationSwitches.instance().isMySQLBackend()) {
                        st.setString(wildcardIndex, SQLTimeFormatConverter.convertDateToString(dateTime));
                    } else {
                        st.setTimestamp(wildcardIndex, new Timestamp(dateTime.getTime()), DatabaseCalendarConfig.getCalendar());
                    }
                    ++wildcardIndex;
                    continue;
                }
                if (DrmGeometry.class.isAssignableFrom(c)) {
                    st.setString(wildcardIndex, col.getValue());
                    ++wildcardIndex;
                    continue;
                }
                st.setString(wildcardIndex, col.getValue());
                ++wildcardIndex;
            }
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException(e.getMessage(), e);
        }
    }

    private static void executeInsertToSubTable(DatabaseConnection db, List<TableColumn> columns, long parentID) throws DatabaseConnectionException {
        for (TableColumn c : columns) {
            if (c.isEmptyColumn() || !c.getDefinition().isExternalTable()) continue;
            String tableName = c.getValue();
            LogWriter.qwrite("DEBUG", "tableName = [", tableName, "]");
            long id = db.getMaxLongValueFromTable(tableName, "_id_");
            ++id;
            for (String v : c.getSubValues()) {
                LogWriter.qwrite("DEBUG", "value = [", v, "]");
                String sql = "INSERT INTO " + c.getValue() + " (_id_,_parent_id_, " + ColumnNameFactory.getTopLevelElementColumnName() + ") VALUES (" + id + "," + parentID + ",?)";
                PreparedStatement st = null;
                st = db.prepareStatement(sql);
                LogWriter.qwrite("DEBUG", "#", sql);
                try {
                    st.setString(1, v);
                    db.executeUpdate(st);
                    st.close();
                }
                catch (SQLException e) {
                    throw new DatabaseConnectionException(e.getMessage(), e);
                }
            }
        }
    }
}

