/*
 * Decompiled with CFR 0.152.
 */
package daruma.sql;

import daruma.sql.SQLDataType;
import daruma.sql.TableColumnDefinition;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDefinition {
    private static final boolean ALL_INDEXED = false;
    private List<TableColumnDefinition> columns;

    public TableDefinition(List<TableColumnDefinition> columns) {
        this.columns = columns;
    }

    public String getTableDefinitionString() {
        StringBuilder s = new StringBuilder();
        for (TableColumnDefinition c : this.columns) {
            if (s.length() != 0) {
                s.append(", ");
            }
            SQLDataType t = c.getSQLDataType();
            s.append(c.getColumnName());
            s.append(" ");
            s.append(t.getSQLBaseDataTypeString());
        }
        return s.toString();
    }

    public String getCommaSeparatedColumnNamesForRawSQLString() {
        StringBuilder s = new StringBuilder();
        for (TableColumnDefinition c : this.columns) {
            if (s.length() != 0) {
                s.append(",");
            }
            s.append(c.getSQLDataType().getSQLRetrieveColumnStringForRawSQLString(c.getColumnName()));
        }
        return s.toString();
    }

    public List<String> getSubTables(String tableName) {
        ArrayList<String> ret = new ArrayList<String>();
        for (TableColumnDefinition c : this.columns) {
            if (!c.isExternalTable()) continue;
            ret.add(tableName + "$" + c.getColumnName());
        }
        return ret;
    }
}

