/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs;

import daruma.auth.AuthenticationInfo;
import daruma.storage_manager.StorageManager;
import daruma.util.CloseIgnoreInputStream;
import daruma.util.CountOutputStream;
import daruma.util.FatalException;
import daruma.util.LogWriter;
import daruma.wfs.ResponseInfo;
import daruma.wfs.SOAPFaultDocumentBuilder;
import daruma.wfs.SOAPHandler;
import daruma.xml.util.EndOfDocumentException;
import daruma.xml.util.XMLFormatConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SOAPWFSProcessor {
    private String debugTag = "";

    public void setDebugTag(String debugTag) {
        this.debugTag = debugTag;
    }

    public void process(InputStream in, OutputStream out, AuthenticationInfo authInfo, StorageManager storage) throws FatalException {
        SOAPHandler h;
        XMLReader parser;
        LogWriter.qwrite("DEBUG", "debugTag = [", this.debugTag, "]");
        CountOutputStream cOut = new CountOutputStream(out);
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setNamespaceAware(true);
        try {
            parser = f.newSAXParser().getXMLReader();
            h = new SOAPHandler(cOut, parser, true, authInfo, storage);
            h.setThrowEODWithEndOfTopLevelElement(true);
            parser.setContentHandler(h);
            parser.setErrorHandler(h);
        }
        catch (ParserConfigurationException e) {
            throw new FatalException("Can't create SAX parser", e);
        }
        catch (SAXException e) {
            throw new FatalException("Can't create SAX parser", e);
        }
        try {
            PrintWriter w = new PrintWriter(cOut);
            LogWriter.qwrite("DEBUG", "parse start");
            try {
                parser.parse(new InputSource(new CloseIgnoreInputStream(in)));
            }
            catch (EndOfDocumentException e) {
                LogWriter.qwrite("DEBUG", "end of document");
            }
            LogWriter.qwrite("DEBUG", "parse succeeded");
            w.flush();
            cOut.flush();
        }
        catch (SAXParseException e) {
            LogWriter.qwrite("DEBUG", "failed: ", e);
            SOAPWFSProcessor.sendSOAPError(cOut, e, h.getResponse(), cOut.getByteCount() == 0L);
            SOAPWFSProcessor.notifyParseError(e.getMessage());
        }
        catch (SAXException e) {
            LogWriter.qwrite("DEBUG", "failed: ", e);
            SOAPWFSProcessor.sendSOAPError(cOut, new SAXParseException(e.getMessage(), h.getLocator(), e), h.getResponse(), cOut.getByteCount() == 0L);
            SOAPWFSProcessor.notifyParseError(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private static void notifyParseError(String errorMessage) {
        LogWriter.qwrite("INFO", "xml parse error: ", errorMessage);
    }

    private static void sendSOAPError(OutputStream out, SAXParseException exception, ResponseInfo response, boolean forceWrite) {
        PrintWriter w = new PrintWriter(out);
        try {
            if (forceWrite) {
                if (response != null) {
                    XMLFormatConverter.print(response.document, out);
                } else {
                    XMLFormatConverter.print(new SOAPFaultDocumentBuilder(exception).newDocument(), out);
                }
            } else if (response != null && response.headerIsOutputedP) {
                w.print(response.tailerStr);
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        try {
            w.flush();
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

