#ifndef	   ADJUST_SLEEP_H_INCLUDED
#define	   ADJUST_SLEEP_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Apr  7 2000
// Created:		Apr  7 2000
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Apr  7 2000	call raw usleep(), not adjusted.
//
//

extern "C"
{
#if defined(HAVE_CONFIG_H)
#    include "config.h"
#endif

#ifndef USE_NANOSLEEP
#    include  <unistd.h>
#    ifdef __osf__
	void	usleep( unsigned int  useconds );
#    endif
#else
#    include  "posix_compat_sys_time.h"
#    include  <cstddef>
#endif
}

class  Adjust_Sleep
{
protected:
	static	void	internal_usleep( unsigned long  microseconds )
	{
		// XXX: not adjusted yet

		#ifndef USE_NANOSLEEP
			::usleep( microseconds );
		#else
			struct timespec	t;
			t.tv_sec  = microseconds / 1000;
			t.tv_nsec = (microseconds % 1000) * 1000;

			::nanosleep( &t , NULL );
		#endif
	}

public:
	static	void	usleep( unsigned long  microseconds )
	{
		Adjust_Sleep::internal_usleep( microseconds );
	}

	static	void	sleep( unsigned long  seconds )
	{
		Adjust_Sleep::usleep( seconds * 1000 * 1000 );
	}
};


#endif	/* ADJUST_SLEEP_H_INCLUDED */
