#include  "base64_decoder.h"
#include  "base64_table.h"


bool   Base64_Decoder::decode( std::string *  buffer ,
			       const std::string &  src ,
			       std::string *  error_message )
{
	if ( buffer == static_cast<std::string *>(0) )
	{
		return( true );
	}

	buffer -> erase();

	if ( src.length() % 4 != 0 )
	{
		if ( error_message != static_cast<std::string *>(0) )
		{
			*error_message = "invalid source length";
		}

		return( false );
	}


	struct  Internal_Func
	{
		static	unsigned char	get_output_bin_0
					( unsigned char  input_0 ,
					  unsigned char  input_1 )
		{
			return( static_cast<unsigned char>
				((input_0 << 2) | (input_1 >> 4)) );
		}

		static	unsigned char	get_output_bin_1
					( unsigned char  input_1 ,
					  unsigned char  input_2 )
		{
			return( static_cast<unsigned char>
				( ((input_1 & 0x0f) << 4) | (input_2 >> 2)) );
		}

		static	unsigned char	get_output_bin_2
					( unsigned char  input_2 ,
					  unsigned char  input_3 )
		{
			return( static_cast<unsigned char>
				(((input_2 & 0x03) << 6) | input_3) );
		}
	};


	Base64_Table	table;

	for ( size_t  offset = 0  ;  offset + 3 < src.length()  ;
	      offset += 4 )
	{
		unsigned char	n[4];

		int	data_length = 4;

		for ( int  d = 3  ;  d >= 0  ;  d -- )
		{
			if ( src[offset + d] == Base64_Table::padding )
			{
				data_length --;
			}
		}

		if ( data_length <= 1 )
		{
			if ( error_message != static_cast<std::string *>(0) )
			{
				*error_message
					= "invalid base data of 4 bytes";
			}

			return( false );
		}

		for ( int  i = 0  ;  i < data_length  ;  i ++ )
		{
			if ( ! table.char_to_index( &n[i] , src[offset + i] ) )
			{
				if ( error_message
				     != static_cast<std::string *>(0) )
				{
					*error_message = "invalid character";
				}

				return( false );
			}
		}

		(*buffer) += Internal_Func::get_output_bin_0( n[0] , n[1] );

		if ( data_length >= 3 )
		{
			(*buffer) += Internal_Func
					::get_output_bin_1( n[1] , n[2] );
		}

		if ( data_length >= 4 )
		{
			(*buffer) += Internal_Func
					::get_output_bin_2( n[2] , n[3] );
		}
	}


	return( true );
}
