#include  "test_environment.h"
#include  "binary_reader.h"
#include  "compat_stringstream.h"


int    main( void )
{
	Test_Environment	t;

	{
		compat_stringstream	buf( "\x12\x34" );

		Binary_Reader		r( buf );

		unsigned short	x = 0;
		bool		result = false;
		result = r.read_2_bytes_unsigned_int_in_little_endian( &x );

		t.Assert( result );
		t.Assert_Equals( static_cast<unsigned short>( 0x3412 ) , x );

		// EOF check
		result = r.read_2_bytes_unsigned_int_in_little_endian( &x );
		t.Assert( ! result );
	}

	{
		compat_stringstream	buf( "\xfe\xfe" );

		Binary_Reader		r( buf );

		short		x = 0;
		bool		result = false;
		result = r.read_2_bytes_signed_int_in_little_endian( &x );

		t.Assert( result );
		t.Assert_Equals( static_cast<short>( -258 ) , x );

		// EOF check
		result = r.read_2_bytes_signed_int_in_little_endian( &x );
		t.Assert( ! result );
	}

	{
		compat_stringstream	buf( "123\xff" "567890" );

		Binary_Reader		r( buf );

		size_t		count = 0;
		bool		result = false;

		result = r.skip( 2 , &count );
		t.Assert( result );
		t.Assert_Equals( size_t(2) , count );

		result = r.skip( 2 , &count );
		t.Assert( result );
		t.Assert_Equals( size_t(2) , count );

		result = r.skip( 6 , &count );
		t.Assert( result );
		t.Assert_Equals( size_t(6) , count );

		// expect failure
		result = r.skip( 1 , &count );
		t.Assert( ! result );
	}


	{
		compat_stringstream	buf( "123\xff" "567890" );

		Binary_Reader		r( buf );

		bool		result = false;

		std::string	data;

		result = r.read_bytes( 10, &data );
		t.Assert( result );
		t.Assert_Equals( "123\xff" "567890" , data );

		// expect failure
		result = r.read_bytes( 1 , &data );
		t.Assert( ! result );
	}

	{
		compat_stringstream	buf;

		static	const	size_t	N = 10000;

		for ( size_t  i = 0  ;  i < N  ;  i ++ )
		{
			buf << static_cast<unsigned char>( i  % 0xff );
		}


		Binary_Reader		r( buf );

		bool		result = false;
		std::string	data;

		result = r.read_bytes( N , &data );
		t.Assert( result );

		for ( size_t  i = 0  ;  i < N  ;  i ++ )
		{
			t.Assert_Equals
				( static_cast<unsigned char>( i  % 0xff ) ,
				  static_cast<unsigned char>( data[i] ) );
		}


		// expect failure
		result = r.read_bytes( 1 , &data );
		t.Assert( ! result );
	}


	return( t.exit_status() );
}
