#ifndef	   BINARY_WRITER_H_INCLUDED
#define	   BINARY_WRITER_H_INCLUDED

// Author:		H. Shimora
// Created:		May 25 2004
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May 25 2004    base version.
//
//

#include  "ostream_compat_wrapper.h"


class  Binary_Writer
{
private:
	std::ostream &	out;

public:
	Binary_Writer( std::ostream &  out )
		: out( out )
	{
	}

	bool	write_2_bytes_unsigned_int_in_little_endian
						( unsigned short  x )
	{
		out.put( static_cast<unsigned char>( x        & 0xff ) );
		out.put( static_cast<unsigned char>( (x >> 8) & 0xff ) );

		return( true );
	}

	bool	write_4_bytes_unsigned_int_in_little_endian
						( unsigned long  x )
	{
		out.put( static_cast<unsigned char>( x         & 0xff ) );
		out.put( static_cast<unsigned char>( (x >>  8) & 0xff ) );
		out.put( static_cast<unsigned char>( (x >> 16) & 0xff ) );
		out.put( static_cast<unsigned char>( (x >> 24) & 0xff ) );

		return( true );
	}

	bool	write_2_bytes_signed_int_in_little_endian( short  x )
	{
		// XXX
		out.put( static_cast<unsigned char>( x        & 0xff ) );
		out.put( static_cast<unsigned char>( (x >> 8) & 0xff ) );

		return( true );
	}

	bool	write_4_bytes_signed_int_in_little_endian( long  x )
	{
		// XXX
		out.put( static_cast<unsigned char>( x         & 0xff ) );
		out.put( static_cast<unsigned char>( (x >>  8) & 0xff ) );
		out.put( static_cast<unsigned char>( (x >> 16) & 0xff ) );
		out.put( static_cast<unsigned char>( (x >> 24) & 0xff ) );

		return( true );
	}
};


#endif	/* BINARY_WRITER_H_INCLUDED */
