#include  "comstream.h"
#include  <string>
#include  <cmath>
#include  <cctype>
#include  <unistd.h> // for sleep()

#include  "test_environment.h"


int    main( void )
{
	Test_Environment	t;

#if ! defined( TENTATIVE_HACK_FOR_ONLY_MINGW_COMPILE )
	// grep
	{
		comstream	com( "grep" , "^a" , static_cast<char *>(0) );

		t.Assert( com );

		com << "abcdefg" << std::endl;
		com << "abc" << std::endl;
		com << "def" << std::endl;
		com << "ghi" << std::endl;
		com << "aaa" << std::endl;
		com.close( std::ios::in );

		std::string	result;

		for(;;)
		{
			char	ch;

			com.get( ch );

			if ( ! com )
			{
				break;
			}

			result += static_cast<unsigned char>(ch);
		}

		t.Assert_Equals( "abcdefg\n" "abc\n" "aaa\n" , result );
	}


	// get double test
	{
		icomstream	com( "echo" , "3.14 2.7" ,
				     static_cast<char *>(0) );

		t.Assert( com );

		double	a = 0.0;
		com >> a;

		t.Assert( ! com.eof() );

		double	b = 0.0;
		com >> b;

		t.Assert_Nearly_Equals( 3.14 , a );
		t.Assert_Nearly_Equals( 2.7  , b );
	}


	// read test
	{
		std::string	input = "abcdefghij";

		icomstream	com( "echo" ,
				     "-n" ,
				     input.c_str() ,
				     static_cast<char *>(0) );

		t.Assert( com );

		std::string	result;

		while( com )
		{
			char	buf[4];

			if ( result.length() < input.length() )
			{
				t.Assert( ! com.eof() );
			}

			com.read( buf , sizeof(buf) );

			if ( com.gcount() > 0 )
			{
				result.append( buf , com.gcount() );
			}
		}

		t.Assert_Equals( input , result );
	}


	// binary read test
	{
		std::string	input = "abcd\xff" "efghij";

		icomstream	com( "echo" ,
				     "-n" ,
				     input.c_str() ,
				     static_cast<char *>(0) );

		t.Assert( com );

		std::string	result;

		while( com )
		{
			char	buf[4];

			if ( result.length() < input.length() )
			{
				t.Assert( ! com.eof() );
			}

			com.read( buf , sizeof(buf) );

			if ( com.gcount() > 0 )
			{
				result.append( buf , com.gcount() );
			}
		}

		t.Assert_Equals( input , result );
	}


	// eof test
	{
		std::string	input = "1234567890";

		icomstream	com( "echo" ,
				     "-n" ,
				     input.c_str() ,
				     static_cast<char *>(0) );

		t.Assert( com );

		std::string	result;
		for ( size_t  i = 0  ;  i < input.size()  ;  i ++ )
		{
			int c = com.get();
			t.Assert( com );
                        if ( ! com.eof() )
                        {
				result += static_cast<unsigned char>( c );
                        }
		}

		t.Assert( ! com.eof() );
		com.get();
		t.Assert( com.eof() );

		t.Assert_Equals( input , result );
	}

	// large input test
	{
		comstream	com( "cat" ,
				     static_cast<char *>(0) );

		t.Assert( com );

		const int	N = 10000;

		for ( int  i = 0  ;  i < N  ;  i ++ )
		{
			com.put( 'a' );

			int	ch = com.get();

			t.Assert_Equals( static_cast<int>
					 ( static_cast<unsigned char>('a') ) ,
					 ch );

			t.Assert( com );
		}

		com.close( std::ios::in );

		t.Assert( ! com.eof() );
		com.get();
		t.Assert( com.eof() );
	}


	// large double input test
	{
		comstream	com( "cat" ,
				     static_cast<char *>(0) );

		t.Assert( com );

		const int	N = 10000;

		for ( int  i = 0  ;  i < N  ;  i ++ )
		{
			com << i + i * 0.1 << std::endl;

			double	value;
			com >> value;

			t.Assert_Nearly_Equals( i + i * 0.1 , value );

			t.Assert( com );
		}
		com.close( std::ios::in );

		t.Assert( ! com.eof() );
		double	value;
		com >> value;
		t.Assert( com.eof() );
	}


	// function command input test
	{
		struct  Sample
		{
			static	int	func()
			{
				std::cout << "hello" << std::endl;

				return( 0 );
			}
		};


		icomstream	com( &(Sample::func) );

		std::string	line;

		std::getline( com , line );

		t.Assert_Equals( "hello" , line );
	}


	// function command input, output test
	{
		struct  Sample
		{
			static	int	func()
			{
				for(;;)
				{
					int	ch = std::cin.get();

					if ( ! std::cin )
					{
						break;
					}

					std::cout.put
                                            ( static_cast< unsigned char>
                                              ( std::toupper(ch) ) );
				}

				std::cout.flush();

				return( 0 );
			}
		};


		comstream	com( &(Sample::func) );

		com << "hello" << std::endl;

		std::string	line;
		com.close( std::ios::in );

		std::getline( com , line );

		t.Assert_Equals( "HELLO" , line );
	}


	// poll test
	{
		comstream	com1( "true" , static_cast<char *>(0) );
		comstream	com2( "echo" , "-n" , "a" ,
				      static_cast<char *>(0) );

		t.Assert( com1 );
		t.Assert( com2 );

		t.Assert_Equals( false , static_cast<bool>( com1.poll() ) );
		while( ! com2.poll() )
		{
			::usleep( 1000 );
		}
		t.Assert_Equals( true , static_cast<bool>( com2.poll() ) );

		t.Assert_Equals( false , static_cast<bool>( com1.eof() ) );
		t.Assert_Equals( false , static_cast<bool>( com2.eof() ) );

		char	ch;
		com1.get( ch );
		com2.get( ch );
		t.Assert_Equals( 'a' , ch );

		t.Assert_Equals( true  , static_cast<bool>( com1.eof() ) );
		t.Assert_Equals( false , static_cast<bool>( com2.eof() ) );

		t.Assert_Equals( false , static_cast<bool>( com1.poll() ) );
	}


	// exit status test
	{
		comstream	com_0    ( "true"  , static_cast<char *>(0) );
		comstream	com_non_0( "false" , static_cast<char *>(0) );

		t.Assert( com_0 );
		t.Assert( com_non_0 );

		com_0    .wait();
		com_non_0.wait();

		t.Assert_Equals    ( 0 , com_0    .exit_status() );
		t.Assert_Not_Equals( 0 , com_non_0.exit_status() );
	}

#endif // ! defined( TENTATIVE_HACK_FOR_ONLY_MINGW_COMPILE )

	return( t.exit_status() );
}


#if 0
#include  "comstream.h"
#include  <iostream>
#include  <string>

using namespace std;

int    main( void )
{
	comstream	com( "grep" , "^a" , static_cast<char *>(0) );

	if ( com )
	{
		com << "abcdefg" << endl;
		com << "abc" << endl;
		com << "def" << endl;
		com << "ghi" << endl;
		com << "aaa" << endl;
		com.close( ios::in );

		for(;;)
		{
			string	line;

			getline( com , line );

			if ( ! com )
			{
				break;
			}

			cout << line << endl;
		}
	}

	return( 0 );
}
#endif
