#ifndef	   D2_REGION_H_INCLUDED
#define	   D2_REGION_H_INCLUDED

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif


#include  "d2_vector.h"
#include  "ref_count_ptr.h"
#include  "float_traits.h"

#include  <exception>

class  D2_Region_Entity;

class  D2_Region
{
public:
	class  No_Region_Error : public std::exception
	{
	public:
		 No_Region_Error() throw() {}
		 No_Region_Error( const No_Region_Error & ) throw()
			 : std::exception() {}
		~No_Region_Error() throw() {}
		No_Region_Error &  operator=
		  ( const No_Region_Error & ) throw() { return( *this ); }
	};

	class  Cannot_Calculate : public std::exception
	{
	public:
		 Cannot_Calculate() throw() {}
		 Cannot_Calculate( const Cannot_Calculate & ) throw()
			 : std::exception() {}
		~Cannot_Calculate() throw() {}
		Cannot_Calculate &  operator=
		  ( const Cannot_Calculate & ) throw() { return( *this ); }
	};

	class  Cannot_Calculate_Logically : public Cannot_Calculate
	{
	public:
		 Cannot_Calculate_Logically() throw() {}
		 Cannot_Calculate_Logically
		   ( const Cannot_Calculate_Logically & ) throw()
			   : Cannot_Calculate() {}
		~Cannot_Calculate_Logically() throw() {}
		Cannot_Calculate_Logically &  operator=
		  ( const Cannot_Calculate_Logically & ) throw()
			{ return( *this ); }
	};

	class  Cannot_Calculate_No_Imprementation : public Cannot_Calculate
	{
	public:
		 Cannot_Calculate_No_Imprementation() throw() {}
		 Cannot_Calculate_No_Imprementation
		   ( const Cannot_Calculate_No_Imprementation & ) throw()
			   : Cannot_Calculate() {}
		~Cannot_Calculate_No_Imprementation() throw() {}
		Cannot_Calculate_No_Imprementation &  operator=
		  ( const Cannot_Calculate_No_Imprementation & ) throw()
			{ return( *this ); }
	};

protected:
	ref_count_ptr<const D2_Region_Entity>	ent;

public:
	 D2_Region();
	 D2_Region( const ref_count_ptr<const D2_Region_Entity> &  e );
	 D2_Region( const D2_Region_Entity &  e );
	 D2_Region( const D2_Vector &  v );
	~D2_Region();

	const ref_count_ptr<const D2_Region_Entity> &	entity() const;

	D2_Region  operator & ( const D2_Region &  region ) const;
	D2_Region  operator | ( const D2_Region &  region ) const;
	D2_Region  operator ! () const;

	bool		in_region( const D2_Vector & ) const;
	bool		in_region( FLOAT  x ,  FLOAT y ) const;

	D2_Vector	barycenter() const
			  /* throw( Cannot_Calculate , std::exception )*/;

	FLOAT		area() const
			  /* throw( Cannot_Calculate , std::exception )*/;

	bool	operator==( const D2_Region & ) const;

	void	set( const D2_Region & );


	void	operator = ( const ref_count_ptr<const D2_Region_Entity> & );

private:
	static	ref_count_ptr<const D2_Region_Entity>	emp_region_entity;
	static	ref_count_ptr<const D2_Region_Entity>	univ_region_entity;

public:
	static	D2_Region	empty_region();
	static	D2_Region	universal_region();
};


class  D2_Region_Entity
{
protected:
	virtual	D2_Region  default_and ( const D2_Region &  region ) const;
	virtual	D2_Region  default_or  ( const D2_Region &  region ) const;
	virtual	D2_Region  default_not () const;

public:
		 D2_Region_Entity();
	virtual	~D2_Region_Entity();

	virtual	D2_Region  operator & ( const D2_Region &  region ) const;
	virtual	D2_Region  operator | ( const D2_Region &  region ) const;
	virtual	D2_Region  operator ! () const;

	virtual	bool		in_region( const D2_Vector & ) const = 0;

	virtual	ref_count_ptr<const D2_Region_Entity>	copy() const = 0;

	virtual	D2_Vector	barycenter() const
					/* throw( D2_Region::Cannot_Calculate ,
					   std::exception ) */;

	virtual	FLOAT		area() const
					/* throw( D2_Region::Cannot_Calculate ,
					   std::exception ) */;
};


#endif	/* D2_REGION_H_INCLUDED */
