#ifndef	   D2_COMPOSITE_REGION_H_INCLUDED
#define	   D2_COMPOSITE_REGION_H_INCLUDED

#include  "d2_region.h"
#include  <vector>

class  D2_Composite_Region : public D2_Region_Entity
{
public:
	typedef  enum{ And , Or , Not } Type;

protected:
	Type			type;
	std::vector<D2_Region>	regions;

public:
		 D2_Composite_Region( Type , const D2_Region & );
		 D2_Composite_Region( Type , const D2_Region & ,
					     const D2_Region & );
	virtual	~D2_Composite_Region();

	virtual	D2_Region  operator & ( const D2_Region &  region ) const;
	virtual	D2_Region  operator | ( const D2_Region &  region ) const;
	virtual	D2_Region  operator ! () const;
	virtual	bool	   in_region( const D2_Vector &  vec ) const;
	virtual	ref_count_ptr<const D2_Region_Entity>	copy() const;
};


#endif	/* D2_COMPOSITE_REGION_H_INCLUDED */
