#ifdef    D2_VECTOR_TEST
#include  "d2_vector.h"
#include  <iostream>
#include  <cmath>

int    main( void )
{
	D2_Vector	vec1( D2_Vector::Pole , 2.0 , Degree( 30.0 + 180.0 ) );
	D2_Vector	vec2( D2_Vector::XY   , 3.0 , 3.0 );

	cout << "vec1(x,y)     = "
	     << vec1.x() << "," << vec1.y() << endl;
	cout << "vec1(r,theta) = "
	     << vec1.r() << "," << vec1.theta().radian() << endl;
	cout << endl;

	cout << "vec2(x,y)     = "
	     << vec2.x() << "," << vec2.y() << endl;
	cout << "vec2(r,theta) = "
	     << vec2.r() << "," << vec2.theta().radian() << endl;
	cout << endl;

	D2_Vector	vec3 = vec1 + vec2;
	cout << "vec3 = vec1 + vec2" << endl;
	cout << "vec3(x,y)     = "
	     << vec3.x() << "," << vec3.y() << endl;
	cout << "vec3(r,theta) = " << vec3.r()
	     << "," << vec3.theta().radian() << endl;
	cout << endl;

	cout << "vec3.rotate( 45.0 degree )" << endl;
	vec3 = vec3.rotate( Degree( 45.0 ) );
	cout << "vec3(x,y)     = "
	     << vec3.x() << "," << vec3.y() << endl;
	cout << "vec3(r,theta) = "
	     << vec3.r() << "," << vec3.theta().radian() << endl;
	cout << endl;

	cout << "vec3.normalize()" << endl;
	vec3 = vec3.normalize();
	cout << "vec3(x,y)     = "
	     << vec3.x() << "," << vec3.y() << endl;
	cout << "vec3(r,theta) = "
	     << vec3.r() << "," << vec3.theta().radian() << endl;

	return( 0 );
}
#endif // D2_VECTOR_TEST


#include  "d2_vector.h"
#include  <iostream>

const FLOAT  D2_Vector::EPSILON = FLOAT( 1.0e-100 );

std::ostream &  operator << ( std::ostream &  ostr , const D2_Vector &  vec )
{
	ostr << vec.x() << "," << vec.y();

	return( ostr );
}

void   D2_Vector::divided_by_zero_notify() const
{
	std::cerr << "Divided by zero." << std::endl;
}
