#ifndef	   FLOAT_TRAITS_H_INCLUDED
#define	   FLOAT_TRAITS_H_INCLUDED

// Author:		H. Shimora
// Created:		Jan 11 2004
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Jan 11 2004    base version.
//
//

#include  <cfloat>
#include  <cmath>
#include  "math_extension.h"

#ifndef DEFAULT_FLOAT_TYPE
#  define	DEFAULT_FLOAT_TYPE float
#endif

typedef DEFAULT_FLOAT_TYPE	FLOAT;

#ifdef HAVE_CONFIG_H
#  include  "config.h"
#else
#  if defined(__FreeBSD__) || defined(__NetBSD__ ) || defined(__APPLE__)
#    define HAVE_SINF   1
#    define HAVE_COSF   1
#    define HAVE_ASINF  1
#    define HAVE_ACOSF  1
#    define HAVE_ATAN2F 1
#    define HAVE_FABSF  1
#  endif
#endif


template<typename T>
class float_traits
{
public:
	typedef	T float_type;

#if 1
	static	float_type	PI();

	static	float_type	sin( const float_type & );
	static	float_type	cos( const float_type & );
	static	float_type	atan2( const float_type & ,
				       const float_type & );
	static	float_type	asin( const float_type &  x );
	static	float_type	acos( const float_type &  x );
	static	float_type	fabs( const float_type &  x );
#else
	static	float_type	PI()
	{
		return( static_cast<float_type>
			( Math_Extension::PI ) );
	}

	static	float_type	sin( const float_type &  x )
	{
		return( static_cast<float_type>
			( std::sin( static_cast<double>( x ) ) ) );
	}

	static	float_type	cos( const float_type &  x )
	{
		return( static_cast<float_type>
			( std::cos( static_cast<double>( x ) ) ) );
	}

	static	float_type	asin( const float_type &  x )
	{
		return( static_cast<float_type>
			( std::asin( static_cast<double>( x ) ) ) );
	}

	static	float_type	acos( const float_type &  x )
	{
		return( static_cast<float_type>
			( std::acos( static_cast<double>( x ) ) ) );
	}

	static	float_type	atan2( const float_type &  y ,
				       const float_type &  x )
	{
		return( static_cast<float_type>
			( std::atan2( static_cast<double>( y ) ,
				      static_cast<double>( x ) ) ) );
	}

	static	float_type	fabs( const float_type &  x )
	{
		return( static_cast<float_type>
			( std::fabs( static_cast<double>( x ) ) ) );
	}
#endif
};


template<>
class float_traits<double>
{
public:
	typedef	double float_type;

	static	float_type	PI()
	{
		return( static_cast<float_type>
			( Math_Extension::PI ) );
	}

	static	float_type	min()
	{
		return( - DBL_MAX );
	}

	static	float_type	max()
	{
		return( + DBL_MAX );
	}

	static	float_type	sin( const float_type &  x )
	{
		return( std::sin( x ) );
	}

	static	float_type	cos( const float_type &  x )
	{
		return( std::cos( x ) );
	}

	static	float_type	atan2( const float_type &   y ,
				       const float_type &   x )
	{
		return( std::atan2( y , x ) );
	}

	static	float_type	asin( const float_type &  x )
	{
		return( std::asin( x ) );
	}

	static	float_type	acos( const float_type &  x )
	{
		return( std::acos( x ) );
	}

	static	float_type	fabs( const float_type &  x )
	{
		return( std::fabs( x ) );
	}
};


// sinf(), cosf(), atan2f() and fabsf are not conformed to ANSI standard
template<>
class float_traits<float>
{
public:
	typedef	float float_type;

	static	float_type	PI()
	{
		return( static_cast<float_type>
			( Math_Extension::PI ) );
	}

	static	float_type	min()
	{
		return( - FLT_MAX );
	}

	static	float_type	max()
	{
		return( + FLT_MAX );
	}

#ifdef HAVE_SINF
	static	float_type	sin( const float_type &  x )
	{
		return( sinf( x ) );
	}
#else
	static	float_type	sin( const float_type &  x )
	{
		return( static_cast<float_type>( std::sin( x ) ) );
	}
#endif

#ifdef HAVE_COSF
	static	float_type	cos( const float_type &  x )
	{
		return( cosf( x ) );
	}
#else
	static	float_type	cos( const float_type &  x )
	{
		return( static_cast<float_type>( std::cos( x ) ) );
	}
#endif

#ifdef HAVE_ATAN2F
	static	float_type	atan2( const float_type &  y ,
				       const float_type &  x )
	{
		return( atan2f( y , x ) );
	}
#else
	static	float_type	atan2( const float_type &  y ,
				       const float_type &  x )
	{
		return( static_cast<float_type>( std::atan2( y , x ) ) );
	}
#endif

#ifdef HAVE_ASINF
	static	float_type	asin( const float_type &  x )
	{
		return( asinf( x ) );
	}
#else
	static	float_type	asin( const float_type &  x )
	{
		return( static_cast<float_type>( std::asin( x ) ) );
	}
#endif

#ifdef HAVE_ACOSF
	static	float_type	acos( const float_type &  x )
	{
		return( acosf( x ) );
	}
#else
	static	float_type	acos( const float_type &  x )
	{
		return( static_cast<float_type>( std::acos( x ) ) );
	}
#endif

#ifdef HAVE_FABSF
	static	float_type	fabs( const float_type &  x )
	{
		return( ::fabsf( x ) );
	}
#else
	static	float_type	fabs( const float_type &  x )
	{
		return( static_cast<float_type>( std::acos( x ) ) );
	}
#endif
};


#endif	/* FLOAT_TRAITS_H_INCLUDED */
