#ifndef	   GENERAL_SERVER_OPTION_ANALYZER_H_INCLUDED
#define	   GENERAL_SERVER_OPTION_ANALYZER_H_INCLUDED

// Author:		H. Shimora
// Created:		Aug 16 2002
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Aug 16 2002    base version.
//
//

#include  "option_analyzer.h"
#include  "ip_address.h"
#include  <iostream>

class  General_Server_Option_Analyzer : public Option_Analyzer
{
private:
	bool		help_;

	port_number_t	port_;

	int		bind_fd_;

	int		nice_;

	bool		debug_;


public:
	General_Server_Option_Analyzer( const port_number_t &  default_port ,
					int  default_nice = 0 ,
					bool  default_debug = false )
		: help_( false ) ,
		  port_( default_port ) ,
		  bind_fd_( -1 ) ,
		  nice_( default_nice ) ,
		  debug_( default_debug )
	{
		add_long_option_flag_on(       "--help"    , &help_ );
		add_option_port_number ( 'p' , "--port"    , &port_ );
		add_long_option_integer(       "--bind-fd" , &bind_fd_ );
		add_long_option_integer(       "--nice"    , &nice_ );
		add_long_option_flag_on(       "--debug"   , &debug_ );
	}

	virtual	~General_Server_Option_Analyzer()
	{
	}

	virtual	void	usage( std::ostream *  ostr = &std::cerr ) const
	{
		(*ostr)
		   << "Usage: "
		   << this -> program_name() << " [option ...]" << std::endl
		   << "Possible options are:" << std::endl
		   << "      --help"       << std::endl
		   << "  -p, --port PORT"  << std::endl
		   << "      --bind-fd FD" << std::endl
		   << "      --nice NICE"  << std::endl
		   << "      --debug"      << std::endl;
	}

	virtual	bool	help() const
	{
		return( help_ );
	}

	virtual	port_number_t	port() const
	{
		return( port_ );
	}

	virtual	int	bind_fd() const
	{
		return( bind_fd_ );
	}

	virtual	int	nice() const
	{
		return( nice_ );
	}

	virtual	bool	debug() const
	{
		return( debug_ );
	}
};


#endif	/* GENERAL_SERVER_OPTION_ANALYZER_H_INCLUDED */
