#ifndef	   GENERAL_SERVER_H_INCLUDED
#define	   GENERAL_SERVER_H_INCLUDED

// Author:		H. Shimora
// Created:		Aug 16 2002
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Aug 16 2002    base version.
//
//

#include  "general_server_interpreter.h"
#include  "general_server_default_action.h"

#include  "stream_socket.h"
#include  "ip_address.h"
#include  "ref_count_ptr.h"
#include  <vector>
#include  <string>
#include  <map>


class  General_Server
{
public:
	enum Status { Running , Sleeping , Shutdown };


protected:
	const ref_count_ptr<const General_Server_Interpreter_Factory>
							interpreter_factory;

	const ref_count_ptr<const General_Server_Default_Action>
							default_action;

	const port_number_t		port;
	const std::vector<std::string>  argv;
	const bool			with_bind_fd;


	Stream_Socket	socket;
	Status		internal_status;

	typedef std::map< int, ref_count_ptr<General_Server_Interpreter> >
		Client_Map_Type;

	Client_Map_Type	client_map;


public:
		 General_Server( const ref_count_ptr
				 <const General_Server_Interpreter_Factory> &
							  interpreter_factory ,
				 const ref_count_ptr
				 <const General_Server_Default_Action> &
							  default_action ,
				 const port_number_t &  port ,
				 const std::vector<std::string> &  argv ,
				 SOCKET_FD_TYTE  bind_fd );
	virtual	~General_Server();

	virtual	Status	status() const;

	virtual	bool	run();
	virtual	void	shutdown();
	virtual	void	reboot();
};


#endif	/* GENERAL_SERVER_H_INCLUDED */
