#include  "sample_interpreter.h"
#include  "general_server.h"
#include  <string>
#include  <iostream>


Sample_Interpreter::Sample_Interpreter( int  fd )
	: socket( new Stream_Socket( Stream_Socket::Opened_Socket , fd ) ) ,
	  quit_flag( false )
{
	this -> socket.set_close_on_exec();
}

Sample_Interpreter::~Sample_Interpreter()
{
}

bool   Sample_Interpreter::valid() const
{
	return( (! this -> quit_flag) && this -> socket.valid() );
}

void   Sample_Interpreter::interpret( General_Server &  server )
{
	if ( ! (this -> socket.line_completed()) )
	{
		return;
	}

	std::string	command = this -> socket.get_line();

	std::cout << "%[" << command << "]" << std::endl;


	if ( command == "shutdown" )
	{
		server.shutdown();
	}
	else if ( command == "quit" )
	{
		this -> quit_flag = true;
	}
	else if ( command == "reboot" )
	{
		server.reboot();
	}
	else if ( command == "status" )
	{
		std::string	status_str;

		switch( server.status() )
		{
		case General_Server::Running:
			status_str = "running";
			break;

		case General_Server::Sleeping:
			status_str = "sleeping";
			break;

		case General_Server::Shutdown:
			status_str = "shutting down";
			break;
		}

		this -> socket.send_message( status_str + '\n' );
	}
	else
	{
		this -> socket.send_message( std::string( "unknown command: " )
					     + command + '\n' );
	}
}
