#include  "load_average.h"
#include  <cstdlib>
#include  <cstdio>

#if ! defined(NO_GETLOADAVG) && ! defined(HAVE_GETLOADAVG)
  #if defined(__FreeBSD__) || defined(__NetBSD__) || defined(__linux)
    #define HAVE_GETLOADAVG 1
  #endif
#endif

Load_Average::Load_Average()
{
	this -> load_average[0] = 0.0;
	this -> load_average[1] = 0.0;
	this -> load_average[2] = 0.0;
}

bool   Load_Average::investigate()
{
#ifdef HAVE_GETLOADAVG
	if ( ::getloadavg( this -> load_average , 3 ) != 3 )
	{
		std::perror( "getloadavg" );

		return( false );
	}

	return( true );
#else
	return( false );
#endif
}

double  Load_Average::get_load_average_1() const
{
	return( this -> load_average[0] );
}

double  Load_Average::get_load_average_5() const
{
	return( this -> load_average[1] );
}

double  Load_Average::get_load_average_15() const
{
	return( this -> load_average[2] );
}
