#include  "memorystream.h"
#include  "test_environment.h"
#include  <iostream>

int    main( void )
{
	Test_Environment	t;


	{
		std::string	buf = "3.14 2.72";

		imemorystream	s( buf.data() , buf.size() );
		double	value = 0.0;
		s >> value;

		t.Assert_Nearly_Equals( 3.14 , value );
		t.Assert_Equals( true , static_cast<bool>( s ) );

		s >> value;
		t.Assert_Nearly_Equals( 2.72 , value );
		t.Assert_Equals( true , static_cast<bool>( s ) );

		s >> value;
		t.Assert_Equals( false , static_cast<bool>( s ) );
	}

	{
		std::string	buf = "1abc";

		imemorystream	s( buf.data() , buf.size() );
		int	i = 0;

		s >> i;
		t.Assert_Equals( 1 , i );

		char	ch = '\0';
		s >> ch;
		t.Assert_Equals( 'a' , ch );
	}


	{
		std::string	buf = "\xfe";

		imemorystream	s( buf.data() , buf.size() );
		char	ch = '\0';

		s.get( ch );
		t.Assert( s );

		t.Assert_Equals( static_cast<char>(0xfe) , ch );
	}


	{
		std::string	buf = "\xff";
		imemorystream	s( buf.data() , buf.size() );
		char	ch = '\0';

		s.get( ch );
		t.Assert( s );

		t.Assert_Equals( static_cast<char>(0xff) , ch );
	}


	return( t.exit_status() );
}
