#include  "posix_compat_socket_headers.h"
#include  <string>

bool Socket_System_Environment::initialized = false;

#if defined(MINGW)
bool   initialize_socket_system( std::string *  error_message )
{
#ifdef USE_WINSOCK_VERSION_1
	static	const	int	major_version = 1;
	static	const	int	minor_version = 1;
#else
	static	const	int	major_version = 2;
	static	const	int	minor_version = 0;
#endif

	WSADATA	wsa_data;

	int	err;
	if ( (err = WSAStartup( MAKEWORD( major_version , minor_version ) ,
				&wsa_data )) != 0
	  && error_message != static_cast<std::string *>(0) )
	{
		*error_message = "socket system initialize failed";
		return( false );
	}

	return( true );
}

bool   finalize_socket_system( std::string *  error_message )
{
	if ( ! Socket_System_Environment::initialized )
	{
		return( true );
	}

	int	err;
	if ( (err = WSACleanup()) == SOCKET_ERROR
	  && error_message != static_cast<std::string *>(0) )
	{
		*error_message = "socket system finalize failed";
		return( false );
	}

	return( true );
}
#else
bool   initialize_socket_system( std::string * )
{
	return( true );
}

bool   finalize_socket_system( std::string * )
{
	return( true );
}
#endif


bool	Socket_System_Environment::initialize( std::string *  error_message )
{
	if ( initialize_socket_system( error_message ) )
	{
		Socket_System_Environment::initialized = true;
		return( true );
	}
	else
	{
		return( false );
	}
}

bool	Socket_System_Environment::finalize( std::string *  error_message )
{
	return( finalize_socket_system( error_message ) );
}
