#ifdef    PROF_STOPWATCH_TEST
#include  "prof_stopwatch.h"
#include  <iostream>
#include  <unistd.h>

int    main( void )
{
	Prof_Stopwatch	s;

	s.start();

	int	sum = 0;
	for( int  i = 0  ;  i <= 100000 ;  i ++ )
	{
		sum += i;
		getpid();
	}

	s.stop();

	std::cout << s.real().usec() << std::endl;
	std::cout << s.user().usec() << std::endl;
	std::cout << s.sys() .usec() << std::endl;

	std::cout << s;

	return( 0 );
}
#endif // PROF_STOPWATCH_TEST


#include  "prof_stopwatch.h"
#include  <cstdio>
#include  <iostream>
#include  <string>

Prof_Stopwatch::Prof_Stopwatch()
{
#ifdef HAVE_SYS_RESOURCE_H
	ru_start.ru_utime.tv_sec  = 0;
	ru_start.ru_utime.tv_usec = 0;
	ru_start.ru_stime.tv_sec  = 0;
	ru_start.ru_stime.tv_usec = 0;

	ru_stop.ru_utime.tv_sec   = 0;
	ru_stop.ru_utime.tv_usec  = 0;
	ru_stop.ru_stime.tv_sec   = 0;
	ru_stop.ru_stime.tv_usec  = 0;
#endif
}

Prof_Stopwatch::~Prof_Stopwatch()
{
}

bool	Prof_Stopwatch::valid()
{
#ifdef HAVE_SYS_RESOURCE_H
	return( true );
#else
	return( false );
#endif
}

int    Prof_Stopwatch::start()
{
	int	ret = 0;

	if ( ts_start.set_current_time() == -1 )
	{
		ret = -1;
	}

#ifdef HAVE_SYS_RESOURCE_H
	if ( ::getrusage( RUSAGE_SELF , &ru_start ) == -1 )
	{
		std::perror( "getrusage" );
		ret = -1;
	}
#else
	ret = -1;
#endif

	return( ret );
}

int    Prof_Stopwatch::stop()
{
	int	ret = 0;

#ifdef HAVE_SYS_RESOURCE_H
	if ( ::getrusage( RUSAGE_SELF , &ru_stop ) == -1 )
	{
		std::perror( "getrusage" );
		ret = -1;
	}
#else
	ret = -1;
#endif

	if ( ts_stop.set_current_time() == -1 )
	{
		ret = -1;
	}

	return( ret );
}

Time_Stamp::Time_Diff  Prof_Stopwatch::real() const
{
	return( ts_stop - ts_start );
}

Time_Stamp::Time_Diff  Prof_Stopwatch::user() const
{
#ifdef HAVE_SYS_RESOURCE_H
	Time_Stamp	start_user_time = ru_start.ru_utime;
	Time_Stamp	stop_user_time  = ru_stop .ru_utime;

	return( stop_user_time - start_user_time );
#else
	return( Time_Stamp::Time_Diff( static_cast<time_t>(0) ) );
#endif
}

Time_Stamp::Time_Diff  Prof_Stopwatch::sys() const
{
#ifdef HAVE_SYS_RESOURCE_H
	Time_Stamp	start_system_time = ru_start.ru_stime;
	Time_Stamp	stop_system_time  = ru_stop .ru_stime;

	return( stop_system_time - start_system_time );
#else
	return( Time_Stamp::Time_Diff( static_cast<time_t>(0) ) );
#endif
}

void   Prof_Stopwatch::print_with_indent
			( std::ostream &  ostrm ,
			  size_t  indent_level ,
			  const std::string &  indent_str ) const
{
	std::string	s;

	for ( size_t  i = 0  ;  i < indent_level  ;  i ++ )
	{
		s += indent_str;
	}

	ostrm << s << "real " << this -> real().sec_real() << std::endl;
	ostrm << s << "user " << this -> user().sec_real() << std::endl;
	ostrm << s << "sys  " << this -> sys() .sec_real() << std::endl;
}

std::ostream &  operator << ( std::ostream &  ostrm ,
			      const Prof_Stopwatch &  s )
{
	s.print_with_indent( ostrm , 0 );

	return( ostrm );
}
