#ifndef	   RANDOM_RANDOM_GENERATOR_H_INCLUDED
#define	   RANDOM_RANDOM_GENERATOR_H_INCLUDED

#include  "random_generator.h"
#include  <cstdlib>

class  Random_Random_Generator : public Random_Generator
{
private:
	static const long BUFFER_SIZE = 256;

private:
	char state_buffer[BUFFER_SIZE];

public:
	Random_Random_Generator( unsigned int  seed = 1 )
	{
		::initstate( seed , state_buffer , BUFFER_SIZE );
	}

	unsigned long	max() const
	{
		return( RAND_MAX );
	}

	unsigned long	random()
	{
		char * old_buffer = ::setstate( this -> state_buffer );

		unsigned long value = ::random();

		::setstate( old_buffer );

		return( value );
	}
};

#endif	/* RANDOM_RANDOM_GENERATOR_H_INCLUDED */
