#ifndef	   XML_DATA_TREE_H_INCLUDED
#define	   XML_DATA_TREE_H_INCLUDED

// Author:		H. Shimora
// Created:		Aug 30 2009
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Aug 30 2009    base version.
//
//

#include <map>
#include <string>
#include <vector>

#include "universal_name.h"
#include "ref_count_ptr.h"

namespace fuse_xml {


struct PathElement
{
    Universal_Name name;
    int nth;

public:
    PathElement( const Universal_Name & name, int nth )
        : name( name ), nth( nth )
    {
    }

    std::string toPathString() const;
};

struct XMLDataNode
{
public:
    enum DataType { ELEMENT, TEXT };

private:
    DataType type;
    std::string value;
    std::vector<PathElement> child_elements;

public:
    XMLDataNode( const std::string & value )
        : type( TEXT ),
          value( value ),
          child_elements()
    {
    }

    XMLDataNode( const std::vector<PathElement> & child_elements )
        : type( ELEMENT ),
          value(),
          child_elements( child_elements )
    {
    }

    DataType getType() const;
    bool isElement() const;
    bool isText() const;

    const std::string & getValue() const
    {
        return this -> value;
    }

    const std::vector<PathElement> & getChildElements() const
    {
        return this -> child_elements;
    }
};

class XMLDataTree
{
private:
    std::map<std::string, ref_count_ptr<XMLDataNode> > files;

public:
    static XMLDataTree * parse( const char * path );

public:
    const std::map<std::string, ref_count_ptr<XMLDataNode> > & getFiles() const
    {
        return this -> files;
    }
};

#if 0
class XMLDataTreeReader
{
public:
    static XMLDataTree * parse( const char * path );
};
#endif


} // end of namespace fuse_xml

#endif	/* XML_DATA_TREE_H_INCLUDED */
