/*
 * Decompiled with CFR 0.152.
 */
package daruma.server;

import daruma.server.ConnectionInfoHolder;
import daruma.server.DarumaDaemon;
import daruma.util.ISO8601DateFormat;
import daruma.util.Itk;
import daruma.util.LogWriter;
import daruma.util.PropertyReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;

public class DarumaDaemonAdministrator
implements Runnable {
    private final DarumaDaemon daemon;
    private final int adminPort;
    private final boolean printGreetingUsage;
    private ServerSocket adminSocket;
    private boolean isShuttingDown;
    private static final boolean LOCALHOST_ONLY = PropertyReader.getProperty("daruma.serv.admin_port_localhost_only", true);

    DarumaDaemonAdministrator(DarumaDaemon daemon, int adminPort, boolean printGreetingUsage) {
        this.daemon = daemon;
        this.adminPort = adminPort;
        this.isShuttingDown = false;
        this.printGreetingUsage = printGreetingUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.adminSocket = new ServerSocket(this.adminPort);
            this.adminSocket.setReuseAddress(true);
            LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Admin Port Listen:", this.adminSocket);
            while (true) {
                Socket adminConnection;
                block22: {
                    if (this.isShuttingDown) {
                        break;
                    }
                    adminConnection = null;
                    try {
                        adminConnection = this.adminSocket.accept();
                    }
                    catch (SocketException e) {
                        if (this.isShuttingDown) break block22;
                        throw e;
                    }
                }
                if (this.isShuttingDown) {
                    if (adminConnection != null) {
                        try {
                            adminConnection.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    break;
                }
                if (LOCALHOST_ONLY && !adminConnection.getInetAddress().isLoopbackAddress()) {
                    LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "blocked administration connection ", adminConnection, ",", " administration connection", " not allowed except from localhost.");
                    adminConnection.close();
                    continue;
                }
                Thread clientThread = new Thread(new AdminClientHandler(adminConnection, this, this.daemon, this.printGreetingUsage));
                clientThread.start();
            }
        }
        catch (IOException e) {
            if (!this.isShuttingDown) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                this.adminSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void shutdown() {
        this.isShuttingDown = true;
        try {
            this.adminSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class AdminClientHandler
    implements Runnable {
        Socket adminSocket;
        DarumaDaemonAdministrator admin;
        DarumaDaemon daemon;
        boolean printGreetingUsage;
        boolean isShuttingDown;

        AdminClientHandler(Socket adminSocket, DarumaDaemonAdministrator admin, DarumaDaemon daemon, boolean printGreetingUsage) {
            this.adminSocket = adminSocket;
            this.admin = admin;
            this.daemon = daemon;
            this.printGreetingUsage = printGreetingUsage;
            this.isShuttingDown = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block18: {
                try {
                    LogWriter.qwrite("INFO", new Object[]{"[" + Itk.getCurrentTimeStr() + "] ", "Admin Port Open :", this.adminSocket});
                    in = new BufferedReader(new InputStreamReader(this.adminSocket.getInputStream()));
                    out = new PrintStream(this.adminSocket.getOutputStream());
                    if (this.printGreetingUsage) {
                        out.println("type \"help\" to get command list.");
                        out.flush();
                    }
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            AdminClientHandler.this.finalizeConnection();
                        }
                    });
                    while (true) lbl-1000:
                    // 7 sources

                    {
                        if ((command = in.readLine()) == null) {
                            break block18;
                        }
                        try {
                            if (command.equals("")) ** GOTO lbl-1000
                            if (command.equals("help")) {
                                this.printUsage(out);
                            }
                            if (command.equals("quit")) {
                                break block18;
                            }
                            LogWriter.qwrite("INFO", new Object[]{"[" + Itk.getCurrentTimeStr() + "] ", "received admin command [", command, "]"});
                            if (command.equals("list")) {
                                this.printClientList(out);
                            }
                            if (command.equals("force-disconnect-client")) {
                                this.forceDisconnectClient(out);
                            }
                            if (command.equals("shutdown")) {
                                this.admin.shutdown();
                                this.daemon.shutdown();
                                break block18;
                            }
                            LogWriter.qwrite("INFO", new Object[]{"[" + Itk.getCurrentTimeStr() + "] ", "admin: no such command"});
                            out.println("no such command.");
                            out.println("type \"help\" to get valid command list.");
                            out.flush();
                        }
                        catch (SocketException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
                catch (SocketException e) {
                    break block18;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block18;
                }
                finally {
                    this.finalizeConnection();
                }
                ** GOTO lbl-1000
            }
        }

        public void finalizeConnection() {
            if (this.isShuttingDown) {
                return;
            }
            this.isShuttingDown = true;
            LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Admin Port Close :", this.adminSocket);
            try {
                this.adminSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void printUsage(PrintStream out) throws IOException {
            out.println("================================================================");
            out.println(" help                     : print this message");
            out.println(" list                     : get connecting client list");
            out.println(" force-disconnect-client  : disconnect client connection");
            out.println(" shutdown                 : shutdown the server");
            out.println(" quit                     : close this administrator connection");
            out.println("================================================================");
        }

        public ConnectionInfoHolder.DisconnectResult forceDisconnectClient(PrintStream out) throws IOException {
            ConnectionInfoHolder.DisconnectResult result = this.daemon.getConnectionInfoHolder().forceDisconnectClient();
            String message = !result.getSuccess() ? "failed" : (result.getDone() ? "ok, disconnected" : "no client found");
            LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "admin: ", message);
            out.println(message);
            out.flush();
            return result;
        }

        public void printClientList(PrintStream out) {
            Set<ConnectionInfoHolder.ConnectionInfo> cs = this.daemon.getConnectionInfoHolder().getClientSocketSet();
            for (ConnectionInfoHolder.ConnectionInfo c : cs) {
                String statusString;
                switch (c.getStatus()) {
                    case Running: {
                        statusString = "Running";
                        break;
                    }
                    case Waiting: {
                        statusString = "Waiting";
                        break;
                    }
                    default: {
                        statusString = "Unknown";
                    }
                }
                String connectedDateString = ISO8601DateFormat.getISO8601Instance().format(c.getConnectedDate());
                out.print(c.getConnectionID() + " ");
                out.print(statusString + " ");
                out.print(c.getSocket().getInetAddress().getHostAddress() + ":" + c.getSocket().getPort() + " ");
                out.print(connectedDateString);
                out.println();
            }
            out.println("(" + cs.size() + " client" + (cs.size() != 1 ? "s" : "") + ")");
            out.flush();
        }
    }
}

