package daruma.util;

public class Pair<T1, T2>
{
	private	T1	value1;
	private	T2	value2;

	public	Pair( T1  value1 ,  T2  value2 )
	{
		this.value1 = value1;
		this.value2 = value2;
	}

	public	T1	getFirst()
	{
		return( this.value1 );
	}

	public	T2	getSecond()
	{
		return( this.value2 );
	}
    
	@Override
	public boolean equals( Object obj )
	{
		if ( ! (obj instanceof Pair) )
		{
			return false;
		}

		Pair	p = (Pair)obj;

		return p.getFirst().equals( this.getFirst() )
		    && p.getSecond().equals( this.getSecond() );
	}

	@Override
	public int hashCode()
	{
		if ( this.value1 == null )
		{
			if ( this.value2 == null )
			{
				return 0;
			}
			else
			{
				return value2.hashCode();
			}
		}
		else
		{
			if ( this.value2 == null )
			{
				return this.value1.hashCode();
			}
			else
			{
				return this.value1.hashCode()
				     ^ this.value2.hashCode();
			}
		}
	}
}
