/*
 * Decompiled with CFR 0.152.
 */
package daruma.geometry;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.LinearRing;
import daruma.geometry.CoordinateSystemTransformation;
import daruma.geometry.DrmGeometry;
import daruma.geometry.DrmPoint;
import daruma.geometry.OgcGeometryFactory;
import daruma.geometry.TransformationException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrmLinearRing
extends DrmGeometry {
    private List<DrmPoint> points = new ArrayList<DrmPoint>();

    public DrmLinearRing() {
    }

    public DrmLinearRing(List<DrmPoint> points) {
        this();
        for (DrmPoint p : points) {
            this.add(p);
        }
    }

    public void add(DrmPoint point) {
        this.points.add(point);
    }

    public List<DrmPoint> getPoints() {
        return this.points;
    }

    public DrmPoint get(int index) {
        return this.points.get(index);
    }

    public boolean closed() {
        if (this.getPoints().size() == 0) {
            return false;
        }
        return this.points.get(0).equals(this.points.get(this.points.size() - 1));
    }

    @Override
    public DrmLinearRing transform(CoordinateSystemTransformation trans) throws TransformationException {
        DrmLinearRing ret = new DrmLinearRing();
        for (DrmPoint p : this.points) {
            ret.add(trans.transform(p));
        }
        return ret;
    }

    public LinearRing genGeometry(OgcGeometryFactory geoFactory) {
        CoordinateSequence coords = geoFactory.newCoords(this.points.size(), 2);
        int i = 0;
        for (DrmPoint point : this.points) {
            if (point.getDimension() == 3) {
                OgcGeometryFactory.setCoordinate3D(coords, i, point.getX(), point.getY(), point.getZ());
            } else {
                OgcGeometryFactory.setCoordinate2D(coords, i, point.getX(), point.getY());
            }
            ++i;
        }
        return geoFactory.createLinearRing(coords);
    }
}

