/*
 * Decompiled with CFR 0.152.
 */
package daruma.sql;

import daruma.global_switch.ImplementationSwitches;
import daruma.sql.SQLDataTypeConstant;

public class SQLDataType {
    private static final int INDEX_LENGTH = 128;
    private String sqlBaseDataTypeName;
    private String sqlBaseDataTypeOption;
    private String sqlRetrieveFunction;
    private Class javaClass;

    public SQLDataType(String sqlBaseDataTypeName, String sqlBaseDataTypeOption, String sqlRetrieveFunction, Class javaClass) {
        this.sqlBaseDataTypeName = sqlBaseDataTypeName;
        this.sqlBaseDataTypeOption = sqlBaseDataTypeOption;
        this.sqlRetrieveFunction = sqlRetrieveFunction;
        this.javaClass = javaClass;
    }

    public SQLDataType(String sqlBaseDataTypeName, String sqlRetrieveFunction, Class javaClass) {
        this.sqlBaseDataTypeName = sqlBaseDataTypeName;
        this.sqlBaseDataTypeOption = null;
        this.sqlRetrieveFunction = sqlRetrieveFunction;
        this.javaClass = javaClass;
    }

    public SQLDataType(String sqlBaseDataTypeName, Class javaClass) {
        this.sqlBaseDataTypeName = sqlBaseDataTypeName;
        this.sqlBaseDataTypeOption = null;
        this.sqlRetrieveFunction = null;
        this.javaClass = javaClass;
    }

    public String getSQLBaseDataTypeString() {
        return this.sqlBaseDataTypeName;
    }

    public String getSQLBaseDataTypeOptionString() {
        return this.sqlBaseDataTypeOption;
    }

    public String getSQLRetrieveColumnString(String columnName) {
        if (this.sqlRetrieveFunction != null) {
            return this.sqlRetrieveFunction + "_" + columnName;
        }
        return columnName;
    }

    public String getSQLRetrieveColumnStringForRawSQLString(String columnName) {
        if (this.sqlRetrieveFunction != null) {
            return this.sqlRetrieveFunction + "(" + columnName + ")" + " AS " + this.sqlRetrieveFunction + "_" + columnName;
        }
        return columnName;
    }

    public String getIndexString(String columnName) {
        if (this.isSpatialType()) {
            if (ImplementationSwitches.instance().getCreateGeometryIndex()) {
                return "SPATIAL INDEX(" + columnName + ")";
            }
            return null;
        }
        if (this.needsIndexLength()) {
            return "INDEX(" + columnName + "(" + 128 + "))";
        }
        return "INDEX(" + columnName + ")";
    }

    private boolean needsIndexLength() {
        return this.sqlBaseDataTypeName.equals("blob") || this.sqlBaseDataTypeName.equals(SQLDataTypeConstant.BLOB.getSQLBaseDataTypeString());
    }

    public boolean isTimeFamilyType() {
        return this.sqlBaseDataTypeName.equals("timestamp") || this.sqlBaseDataTypeName.equals("datetime");
    }

    private boolean isSpatialType() {
        return this.sqlBaseDataTypeName.equals("geometry");
    }

    public Class getJavaClass() {
        return this.javaClass;
    }
}

