/*
 * Decompiled with CFR 0.152.
 */
package mispClient.commands;

import daruma.storage_manager.type_definition.ElementName;
import daruma.xml.URI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import mispClient.MispCommand;
import mispClient.MispCommandException;
import util.StreamPipe;

public class DarumaDumpMispCommand
extends MispCommand {
    private static final String GET_FEATURE_ELEMENT_NAME = "GetFeature";
    private static final String QUERY_ELEMENT_NAME = "Query";
    private static final String FILTER_ELEMENT_NAME = "Filter";
    private static final String TRUE_ELEMENT_NAME = "True";
    private static final String MISP_PREFIX = "misp";
    private final ElementName featureName;
    private OutputStream out;

    public DarumaDumpMispCommand(ElementName featureName, OutputStream out) {
        this.featureName = featureName;
        this.out = out;
    }

    public InputStream getInputStream() throws MispCommandException {
        StringBuilder buf = new StringBuilder();
        buf.append("<misp:GetFeature xmlns:misp=\"" + URI.MISP + "\"" + " xmlns=\"" + this.featureName.getNamespace() + "\">\n");
        String localName = this.featureName.getLocalName();
        buf.append("  <misp:Query typeName=\"" + localName + "\">\n");
        buf.append("    <misp:Filter>\n");
        buf.append("      <misp:True/>\n");
        buf.append("    </misp:Filter>\n");
        buf.append("  </misp:Query>\n");
        buf.append("</misp:GetFeature>\n");
        try {
            return new ByteArrayInputStream(buf.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new MispCommandException(e);
        }
        catch (IOException e) {
            throw new MispCommandException(e);
        }
    }

    public void processResponse(InputStream in) throws MispCommandException {
        try {
            StreamPipe.connect(in, this.out);
        }
        catch (IOException e) {
            throw new MispCommandException(e);
        }
    }
}

