package mispClient.commands;

import daruma.wfs.SAXExceptionObserver;
import daruma.wfs.SOAPFaultDocumentBuilder;
import daruma.wfs.filter.FilterHandler;

import daruma.xml.handler.XSAXDefaultHandler;
import daruma.xml.XMLTag;
import daruma.xml.URI;
import daruma.xml.util.XMLFormatConverter;

import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.Attributes;
import org.w3c.dom.Document;
import javax.xml.transform.TransformerException;
import javax.xml.parsers.ParserConfigurationException;

import java.io.OutputStream;
import java.io.PrintWriter;


public class GetFeatureResponseHandler extends XSAXDefaultHandler
				       implements SAXExceptionObserver
{
	private	boolean		filterTagFound;
	private	boolean		queryTagFound;
	private	long		tagCount;

	public	GetFeatureResponseHandler( OutputStream  out ,
					   XMLReader  parser ,
					   boolean  isTopLevelHandler )
	{
		super( out , parser , isTopLevelHandler );

		this.queryTagFound        = false;
		this.filterTagFound       = false;
		this.tagCount             = 0;
	}


	public	void	xStartElement( String uri ,
				       String localName ,
				       String qName ,
				       Attributes  attrs ) throws SAXException
	{
		XMLTag	t = new XMLTag( uri , localName );
		this.tagCount ++;

		final SAXParseException	mispNamespaceException
					 = new SAXParseException
					       ( t.getLocalName() + " tag "
						 + "should be in namespace "
						 + URI.MISP ,
						 super.getLocator() );

		// <GetFeature>
		if ( super.getCurrentLevel() == 1 )
		{
			if ( ! t.getURI().equals( URI.MISP ) )
			{
				this.throwError( mispNamespaceException );

				throw mispNamespaceException;
			}

			if ( ! t.getLocalName().equals( "GetFeature" ) )
			{
				this.throwError( new SAXParseException
						 ( "unknown tag "
						   + t.getLocalName() + "." ,
						   super.getLocator() ) );

			}


			return;
		}
		// <GetFeature>/<Query>
		else if ( super.getCurrentLevel() == 2 )
		{
			if ( ! t.getURI().equals( URI.MISP ) )
			{
				this.throwError( mispNamespaceException );

				throw mispNamespaceException;
			}

			if ( ! t.getLocalName().equals( "Query" ) )
			{
				this.throwError( new SAXParseException
						 ( "unexpected tag \""
						   + t.getLocalName()
						   + "\" found, "
						   + "Query tag expected." ,
						   super.getLocator() ) );
			}

			this.queryTagFound = true;

			String	typeNameString = attrs.getValue
							( "" , "typeName" );

			if ( typeNameString == null )
			{
				this.throwError( new SAXParseException
						 ( "typeName attribute"
						   + " not found in "
						   + t.getLocalName()
						   + " tag." ,
						   super.getLocator() ) );
			}

			return;
		}
		// <GetFeature>/<Query>/<Filter>
		else if ( super.getCurrentLevel() == 3 )
		{
			if ( ! t.getURI().equals( URI.MISP ) )
			{
				this.throwError( mispNamespaceException );

				throw mispNamespaceException;
			}

			if ( ! t.getLocalName().equals( "Filter" ) )
			{
				SAXParseException
					e = new SAXParseException
						( "unexpected tag \""
						  + t.getLocalName()
						  + "\" found, "
						  + "Filter tag expected ." ,
						  super.getLocator() );

				this.throwError( e );
			}


			this.filterTagFound = true;

			/*
			this.filter = new FilterHandler
					  ( super.getOutputStream() ,
					    super.getParser() ,
					    false ,
					    this.specifiedElementType ,
					    this.storage ,
					    this );

			super.setContentHandlerDelegator
				( this.filter ,
				  uri , localName , qName , attrs );
			*/

			return;
		}
	}


	public	void  xEndDocument() throws SAXException
	{
		if ( ! this.filterTagFound )
		{
			this.throwError( new SAXParseException
					 ( "Filter tag not found" ,
					   super.getLocator() ) );
		}

		if ( ! this.queryTagFound )
		{
			this.throwError( new SAXParseException
					 ( "Query tag not found" ,
					   super.getLocator() ) );
		}

		if ( this.tagCount < 3 )
		{
			this.throwError( new SAXParseException
					 ( "too few tags found" ,
					   super.getLocator() ) );
		}

		if ( this.tagCount > 3 )
		{
			this.throwError( new SAXParseException
					 ( "too many tags found" ,
					   super.getLocator() ) );
		}


		//
		// main process of this class
		//
		this.outputResult();
	}


	public	void	outputResult() throws SAXException
	{
		PrintWriter	out = super.getPrintWriter();

		out.println( "<misp:GetFeatureResponse"
			     + " xmlns:misp=\"" + URI.MISP + "\""
			     + " xmlns:gml=\"" + URI.GML + "\">" );

		out.println( "  <misp:FeatureCollection>" );
		out.flush();

		try
		{
			this.getOutputStream().flush();
		}
		catch( java.io.IOException  e )
		{
			e.printStackTrace();

			throw new SAXException( e );
		}

		out.println( "  </misp:FeatureCollection>" );
		out.println( "</misp:GetFeatureResponse>" );
		out.flush();
	}


	public	void	notifyError( SAXParseException  e ) throws SAXException
	{
		this.throwError( e );
	}

	public	void	throwError( SAXParseException  e ) throws SAXException
	{
		Document	doc;

		try
		{
			XMLFormatConverter
				.print( new SOAPFaultDocumentBuilder(e)
							      .newDocument() ,
					this.getOutputStream() );
		}
		catch( ParserConfigurationException  pe )
		{
			throw new SAXException( pe );
		}
		catch( TransformerException  te )
		{
			throw new SAXException( te );
		}

		throw e;
	}
}
